/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PolicyHelper {
    private static final int SERIAL_NUMBER_UPDATION_DELAY = 10000;

    private PolicyHelper() {
    }

    public static void addTreeItem(TreeItem treeItem, JTree tree) {
        int parentItemType;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode parentNode = PolicyHelper.findParentNode(root, parentItemType = PolicyHelper.getParentItemType(treeItem));
        if (parentNode != null) {
            try {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(PolicyHelper.getTreeNodeUserObject(treeItem));
                DefaultMutableTreeNode curSelctNode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                parentNode.add(newNode);
                int[] childArray = new int[]{parentNode.getChildCount() - 1};
                ((DefaultTreeModel)tree.getModel()).nodesWereInserted(parentNode, childArray);
                TreePath treePath = new TreePath(newNode.getPath());
                if (parentNode.isNodeChild(curSelctNode)) {
                    tree.setSelectionPath(treePath);
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }

    private static int getParentItemType(TreeItem treeItem) {
        int parentItemType = -1;
        int type = treeItem.getItemType();
        switch (type) {
            case 313: {
                parentItemType = 314;
                break;
            }
            case 43: {
                parentItemType = 57;
                break;
            }
            case 128: {
                parentItemType = 136;
                break;
            }
            case 309: {
                parentItemType = 310;
                break;
            }
            case 56: {
                parentItemType = 58;
                break;
            }
            case 60: {
                parentItemType = 61;
                break;
            }
            case 63: {
                parentItemType = 64;
                break;
            }
            case 65: {
                parentItemType = 66;
                break;
            }
            case 129: {
                parentItemType = 142;
                break;
            }
            case 144: {
                parentItemType = 145;
                break;
            }
            case 148: {
                parentItemType = 149;
                break;
            }
        }
        return parentItemType;
    }

    public static void handleEdit(TreeItem treeItem, JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode editNode = PolicyHelper.findNode(root, treeItem.getId());
        if (editNode != null) {
            editNode.setUserObject(PolicyHelper.getTreeNodeUserObject(treeItem));
            ((DefaultTreeModel)tree.getModel()).nodeChanged(editNode);
        }
    }

    public static void selectTreeItem(TreeItem treeItem, JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode selctNode = PolicyHelper.findNode(root, treeItem.getId());
        if (selctNode != null) {
            TreePath treePath = new TreePath(selctNode.getPath());
            tree.setSelectionPath(treePath);
        }
    }

    public static void deleteTreeItem(TreeItem treeItem, JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode node = PolicyHelper.findNode(root, treeItem.getId());
        boolean updateSelection = false;
        if (node != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode curSelctNode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            int index = parentNode.getIndex(node);
            int[] indexArray = new int[]{index};
            Object[] objArray = new Object[]{node};
            DefaultMutableTreeNode selctNode = node.getPreviousSibling();
            if (selctNode == null) {
                selctNode = node.getNextSibling();
            }
            if (parentNode.isNodeChild(curSelctNode)) {
                updateSelection = true;
            }
            parentNode.remove(node);
            ((DefaultTreeModel)tree.getModel()).nodesWereRemoved(parentNode, indexArray, objArray);
            if (updateSelection) {
                if (selctNode == null) {
                    selctNode = parentNode;
                }
                TreePath treePath = new TreePath(selctNode.getPath());
                tree.setSelectionPath(treePath);
            }
        }
    }

    public static ObjInfoObject createObjInfoObject(AppliablePolicy policyObj) {
        ObjInfo info = new ObjInfo(true);
        info.setId(policyObj.getId());
        info.setOptName(policyObj.getName());
        info.setOptDescription(policyObj.getDescription());
        if (policyObj instanceof ServerListObject) {
            return new ObjInfoObject(policyObj.getItemType(), info, ((ServerListObject)policyObj).isDefaultList());
        }
        if (policyObj instanceof IdsLibraryObject) {
            return new ObjInfoObject(policyObj.getItemType(), info, ((IdsLibraryObject)policyObj).getTargetType());
        }
        return new ObjInfoObject(policyObj.getItemType(), info, policyObj.getTargetType());
    }

    public static TreeItem getPolicyObject(ObjInfoObject infoObj) {
        try {
            switch (infoObj.getItemType()) {
                case 129: {
                    return new AdminDefinedScanObject(DataobjectManager.getInstance().getAdminDefinedScan(infoObj.getId()));
                }
                case 400: {
                    return new MacAdminDefinedScanObject(DataobjectManager.getInstance().getMacAdminDefinedScan(infoObj.getId()));
                }
                case 406: {
                    return new LinuxAdminDefinedScanObject(DataobjectManager.getInstance().getLinuxAdminDefinedScan(infoObj.getId()));
                }
                case 134: {
                    return new AvPolicyObject((TopLevelObject)DataobjectManager.getInstance().getAvPolicy(infoObj.getId()));
                }
                case 128: {
                    return new OverridePolicyObject((TopLevelObject)DataobjectManager.getInstance().getPolicyOverride(infoObj.getId()));
                }
                case 309: {
                    return new UpgradePolicyObject((TopLevelObject)DataobjectManager.getInstance().getUpgradePolicy(infoObj.getId()));
                }
                case 43: {
                    return new FirewallPolicyObject((TopLevelObject)DataobjectManager.getInstance().getFwFirewallPolicy(infoObj.getId()));
                }
                case 56: {
                    return new HostIntegrityObject((TopLevelObject)DataobjectManager.getInstance().getHiHostIntegrityPolicy(infoObj.getId()));
                }
                case 63: {
                    return new AppProtectionPolicyObject((TopLevelObject)DataobjectManager.getInstance().getOpAppProtectionPolicy(infoObj.getId()));
                }
                case 60: {
                    return PolicyHelper.getServerListObject(infoObj);
                }
                case 65: {
                    return PolicyHelper.getIdsLibraryObject(infoObj);
                }
                case 144: {
                    return new LiveUpdateObject((TopLevelObject)DataobjectManager.getInstance().getLuPolicy(infoObj.getId()));
                }
                case 148: {
                    return new LiveUpdateContentObject((TopLevelObject)DataobjectManager.getInstance().getLuContentPolicy(infoObj.getId()));
                }
                case 143: {
                    return new IdsPolicyObject(DataobjectManager.getInstance().getIdsPolicy(infoObj.getId()));
                }
                case 169: {
                    return new MemPolicyObject((TopLevelObject)DataobjectManager.getInstance().getMemPolicy(infoObj.getId()));
                }
                case 171: {
                    return new NtrPolicyObject((TopLevelObject)DataobjectManager.getInstance().getNtrPolicy(infoObj.getId()));
                }
                case 313: {
                    return new AdaptivePolicyObject((TopLevelObject)DataobjectManager.getInstance().getAdaptivePolicy(infoObj.getId()));
                }
            }
        }
        catch (ConsoleException ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public static ServerListObject getServerListObject(ObjInfoObject infoObj) throws ConsoleException {
        String id = infoObj.getId();
        if (infoObj.isDefaultServerList()) {
            SemServerList list = GUIManager.getDefaultServerList(id);
            return new ServerListObject(list, true);
        }
        SemServerList list = DataobjectManager.getInstance().getSemServerList(id);
        return new ServerListObject(list);
    }

    public static TreeItem getIdsLibraryObject(ObjInfoObject infoObj) throws ConsoleException {
        String id = infoObj.getId();
        String type = infoObj.getTargetType();
        if (type.equals("FwIdsLibrary")) {
            FwIdsLibrary idsLib = (FwIdsLibrary)DataobjectManager.getInstance().getObjectByGUID(type, id);
            IdsLibraryObject idsLibObj = new IdsLibraryObject(idsLib);
            return idsLibObj;
        }
        IdsPolicy idsLib = (IdsPolicy)DataobjectManager.getInstance().getObjectByGUID(type, id);
        IdsPolicyObject idsLibObj = new IdsPolicyObject(idsLib);
        return idsLibObj;
    }

    public static void refreshSerialNumber() {
        Thread th = new Thread(){

            @Override
            public void run() {
                PolicyHelper.refreshSerialNumberNonThreaded(10000L);
            }
        };
        th.start();
    }

    protected static void refreshSerialNumberNonThreaded(long sleepMilliseconds) {
        try {
            Thread.sleep(sleepMilliseconds);
            Manager.getFrame().getMainPanel().refreshClientPanel();
        }
        catch (ConsoleException ce) {
            if (ce.needRelogin()) {
                LoggerUtilities.log((String)"Console session is no longer valid (most likely has timed out).");
            } else {
                LoggerUtilities.logException((Throwable)ce);
            }
        }
        catch (InterruptedException e) {
            LoggerUtilities.logException((Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static DefaultMutableTreeNode findNode(DefaultMutableTreeNode nodeParent, String id) {
        String strId;
        if (nodeParent == null) {
            return null;
        }
        Object value = nodeParent.getUserObject();
        if (value instanceof TreeItem && (strId = ((TreeItem)value).getId()) != null && strId.equals(id)) {
            return nodeParent;
        }
        if (nodeParent.getChildCount() == 0) {
            return null;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            DefaultMutableTreeNode node = PolicyHelper.findNode(nodeChild, id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static DefaultMutableTreeNode findParentNode(DefaultMutableTreeNode nodeParent, int treeItemType) {
        TreeItem treeItem;
        if (nodeParent == null) {
            return null;
        }
        Object value = nodeParent.getUserObject();
        if (value instanceof TreeItem && (treeItem = (TreeItem)value).getItemType() == treeItemType) {
            return nodeParent;
        }
        if (nodeParent.getChildCount() == 0) {
            return null;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            DefaultMutableTreeNode node = PolicyHelper.findParentNode(nodeChild, treeItemType);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static TreeItem getTreeNodeUserObject(TreeItem item) {
        switch (item.getItemType()) {
            case 43: {
                return PolicyHelper.createObjInfoObject((FirewallPolicyObject)item);
            }
            case 128: {
                return PolicyHelper.createObjInfoObject((OverridePolicyObject)item);
            }
            case 56: {
                return PolicyHelper.createObjInfoObject((HostIntegrityObject)item);
            }
            case 63: {
                return PolicyHelper.createObjInfoObject((AppProtectionPolicyObject)item);
            }
            case 60: {
                return PolicyHelper.createObjInfoObject((ServerListObject)item);
            }
            case 65: {
                return PolicyHelper.createObjInfoObject((IdsLibraryObject)item);
            }
            case 129: {
                return PolicyHelper.createObjInfoObject((AdminDefinedScanObject)item);
            }
        }
        return item;
    }
}

