/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.ConsoleOptions;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.explorer.common.LocationPanel;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class OverviewPane
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_ENABLE_POLICY = "EnablePolicy";
    private static final MessageResourcesFile resourceAvOverview = new MessageResourcesFile("com.sygate.scm.console.ui.policy.av.overview.avoverview");
    private JTextField nameTxtField;
    private JTextArea descTxtArea;
    private JPanel policyNamePane;
    private JPanel groupsPane;
    private JLabel policyCreator = new JLabel();
    private JLabel policyModDate = new JLabel();
    private JLabel externalSources = new JLabel();
    private JLabel readOnlyReason = new JLabel(resourceAvOverview.getString("OverviewPane.label.policy.exclusiveEditReason"));
    private JLabel externalSourcesLabel = new JLabel(resourceAvOverview.getString("OverviewPane.label.policy.externalSources"));
    private JLabel readOnlyReasonLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("lock.png"))));
    private LocationPanel locationPanel;
    private String locationName;
    private String groupName;
    private JPanel locationTextPane;
    private boolean isLocal = false;
    private BasePolicyDialog parentFrame = null;
    private boolean canDisable = false;
    JPanel usedByPanel = null;
    private JCheckBox enablePolicyBox = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "BasePolicyDialog.chkBoxEnableThisPolicy"));

    public OverviewPane(BasePolicyDialog parentFrame, String locationName, String gpName, boolean isLocal, boolean canDisableCheckbox) {
        this.canDisable = canDisableCheckbox;
        this.locationName = locationName;
        this.groupName = gpName;
        this.isLocal = isLocal;
        this.parentFrame = parentFrame;
        this.setLayout(new GridBagLayout());
        final JTabbedPane tabbedPane = new JTabbedPane();
        JPanel namePanel = this.getPolicyNamePane();
        if (this.isLocal || !this.isPolicyLocationCountingEnabled()) {
            this.add((Component)namePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
            this.add((Component)this.getLocationTextPane(this.isPolicyLocationCountingEnabled()), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 20, 0, 0), 0, 0));
        } else {
            this.usedByPanel = new JPanel(new GridBagLayout());
            this.usedByPanel.add((Component)this.getGroupsPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 20, 0, 0), 0, 0));
            JPanel overviewNorthNamepanel = new JPanel(new BorderLayout());
            overviewNorthNamepanel.add((Component)namePanel, "North");
            tabbedPane.add(resourceAvOverview.getString("OverviewPane.label.policyName"), overviewNorthNamepanel);
            tabbedPane.add(resourceAvOverview.getString("OverviewPane.label.policy.usedBy"), this.usedByPanel);
            tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    if (tabbedPane.getSelectedIndex() == 1 && OverviewPane.this.locationPanel != null && !OverviewPane.this.isNewPolicy()) {
                        OverviewPane.this.locationPanel.refresh();
                    }
                }
            });
            this.add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 20, 0, 0), 0, 0));
        }
        if (LicenseObject.getInstance().isSBProduct()) {
            this.enablePolicyBox.setSelected(true);
            this.enablePolicyBox.setVisible(false);
        }
    }

    private void hideLocationPanel() {
        if (this.usedByPanel != null && this.usedByPanel.getParent() != null) {
            this.usedByPanel.getParent().remove(this.usedByPanel);
        }
    }

    private boolean isPolicyLocationCountingEnabled() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return true;
        }
        return ConsoleOptions.getInstance().isPolicyLocationCountingEnabled();
    }

    public void setReadOnly() {
        this.getPolicyNameField().setEditable(false);
        this.getPolicyDescArea().setEditable(false);
        this.enablePolicyBox.setEnabled(false);
    }

    public void setObject(PolicyObjectBase policyObj) {
        String sources;
        this.getPolicyNameField().setText(policyObj.getName());
        this.getPolicyNameField().setCaretPosition(0);
        this.getPolicyDescArea().setText(policyObj.getDescription());
        this.getPolicyDescArea().setCaretPosition(0);
        String creator = policyObj.getCreator();
        this.policyCreator.setText(creator == null ? "" : creator);
        long modDate = policyObj.getLastModifiedTime();
        this.policyModDate.setText(modDate < 1L ? "" : Utility.getLongDateTimeString((long)modDate, null));
        if (!this.isLocal && this.isPolicyLocationCountingEnabled() && !this.isNewPolicy()) {
            this.locationPanel.setObject(policyObj);
        }
        if (LicenseObject.getInstance().isSBProduct() || this.isNewPolicy() && !this.isLocal) {
            this.hideLocationPanel();
        }
        if ((sources = policyObj.handleSources()) != null && sources.length() > 0) {
            this.externalSourcesLabel.setVisible(true);
            this.externalSources.setVisible(true);
            this.externalSources.setText(sources);
        }
        if (policyObj.isExclusiveEdit() || policyObj instanceof MemPolicyObject && CloudUtil.isCloudMemPolicyInUse()) {
            this.setReadOnly();
            this.readOnlyReasonLabel.setVisible(true);
            this.readOnlyReason.setVisible(true);
            this.readOnlyReason.setText(policyObj.isExclusiveEdit() ? resourceAvOverview.getString("OverviewPane.label.policy.exclusiveEditReason") : resourceAvOverview.getString("OverviewPane.label.policy.managedByCloudReason"));
        }
    }

    public boolean isNewPolicy() {
        boolean newPolicy = false;
        if (this.parentFrame != null) {
            newPolicy = this.parentFrame.isNewPolicy();
        }
        return newPolicy;
    }

    public void setPolicyEnabled(boolean bool) {
        this.enablePolicyBox.setSelected(bool);
    }

    public boolean isPolicyEnabled() {
        return this.enablePolicyBox.isSelected();
    }

    public String getPolicyName() {
        return this.nameTxtField.getText().trim();
    }

    public String getPolicyDesc() {
        return this.descTxtArea.getText().trim();
    }

    public JTextField getPolicyNameField() {
        if (this.nameTxtField == null) {
            this.nameTxtField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator("/\\*?<>|:\"", false);
            this.nameTxtField.setDocument(doc);
        }
        return this.nameTxtField;
    }

    public JTextField getNameTextField() {
        return this.nameTxtField;
    }

    public boolean isValidName() {
        try {
            String name = this.getPolicyNameField().getText();
            if (name == null || name.trim().length() == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "FirewallPolicySettingDialog.nameIsARequirementFiled"), this.nameTxtField);
            }
            return true;
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "FirewallPolicySettingDialog.invalidName"), 2);
            this.getPolicyNameField().requestFocus();
            return false;
        }
    }

    public JTextArea getPolicyDescArea() {
        if (this.descTxtArea == null) {
            this.descTxtArea = new JTextArea(4, 40);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descTxtArea.setDocument(doc);
            this.descTxtArea.setLineWrap(true);
            this.descTxtArea.setWrapStyleWord(true);
        }
        return this.descTxtArea;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_overview";
    }

    private JPanel getPolicyNamePane() {
        if (this.policyNamePane == null) {
            JLabel nameLabel = new JLabel(resourceAvOverview.getString("OverviewPane.label.policy.name"));
            this.policyNamePane = new JPanel();
            this.policyNamePane.setLayout(new GridBagLayout());
            int y = 0;
            JTextField policyField = this.getPolicyNameField();
            JTextArea policyDescription = this.getPolicyDescArea();
            this.policyNamePane.add((Component)UiUtilities.setupAlignedLabel((JLabel)nameLabel, (JTextComponent)policyField), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 10, 0, 0), 0, 0));
            this.policyNamePane.add((Component)policyField, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 5, 0, 25), 0, 0));
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)policyDescription);
            JLabel descLabel = new JLabel(resourceAvOverview.getString("OverviewPane.label.policy.desc"));
            this.policyNamePane.add((Component)UiUtilities.setupAlignedLabel((JLabel)descLabel, (JScrollPane)scrollPane), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.policyNamePane.add((Component)scrollPane, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 25), 0, 0));
            UIUtilities.setName(this.enablePolicyBox, "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_ENABLE_POLICY);
            this.policyNamePane.add((Component)this.enablePolicyBox, new GridBagConstraints(1, ++y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 1, 0, 25), 0, 0));
            if (!this.canDisable) {
                this.enablePolicyBox.setSelected(true);
            }
            this.enablePolicyBox.setEnabled(this.canDisable);
            JLabel creatorLabel = new JLabel(resourceAvOverview.getString("OverviewPane.label.policy.creator"));
            this.policyNamePane.add((Component)creatorLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.policyNamePane.add((Component)this.policyCreator, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            JLabel modDateLabel = new JLabel(resourceAvOverview.getString("OverviewPane.label.policy.modDate"));
            this.policyNamePane.add((Component)modDateLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.policyNamePane.add((Component)this.policyModDate, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.policyNamePane.add((Component)this.externalSourcesLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.policyNamePane.add((Component)this.externalSources, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.policyNamePane.add((Component)this.readOnlyReasonLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 0, 10), 0, 0));
            this.policyNamePane.add((Component)this.readOnlyReason, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.externalSourcesLabel.setVisible(false);
            this.externalSources.setVisible(false);
            this.readOnlyReasonLabel.setVisible(false);
            this.readOnlyReason.setVisible(false);
        }
        return this.policyNamePane;
    }

    private JPanel getGroupsPane() {
        if (this.groupsPane == null) {
            this.locationPanel = new LocationPanel(null);
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.overview.avoverview", "OverviewPane.label.policy.grpForPolicy");
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.overview.avoverview", "OverviewPane.label.policy.grpForPolicyDesc");
            this.groupsPane = new JPanel(new GridBagLayout());
            this.groupsPane.add((Component)new AvTemplatePane(title, desc, false, this.locationPanel.getTopPanel()), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.groupsPane.add((Component)this.locationPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        }
        return this.groupsPane;
    }

    private JPanel getLocationTextPane(boolean isLocationCountingEnabled) {
        if (this.locationTextPane == null) {
            MessageResourcesFile msg = new MessageResourcesFile("com.sygate.scm.console.ui.policy.av.overview.avoverview");
            String title = msg.getString("OverviewPane.label.policy.grpForPolicy");
            String desc = "";
            this.locationTextPane = new JPanel(new GridBagLayout());
            this.locationTextPane.add((Component)new AvTemplatePane(title, desc, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            String resLabelString = msg.getString("OverviewPane.label.policy.appliedTo");
            HtmlEnabledJLabel locLabel = new HtmlEnabledJLabel();
            Object[] obj = new Object[]{"<b>" + this.locationName + "</b>", "<b>" + this.groupName + "</b>"};
            if (isLocationCountingEnabled) {
                locLabel.setText("<html>" + MessageFormat.format(resLabelString, obj) + "</html>");
            } else {
                locLabel.setText(msg.getString("OverviewPane.label.policy.locationCountingDisabled"));
            }
            this.locationTextPane.add((Component)locLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 20, 0, 20), 0, 0));
        }
        return this.locationTextPane;
    }
}

