/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParentPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.OSObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.OSType;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.ChkListCellRenderer;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OSPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int OS_TYPE = 0;
    public static final int PACK_TYPE = 1;
    public static final int LANGUAGE_TYPE = 2;
    public static final int MAC_OS_TYPE = 3;
    public static final OSType[] OS_TYPES = new OSType[]{new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINXPHome"), "0x240"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINXPProfessional"), "0x241"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINXPProfessional64"), "0x242"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINXPEmbeddedFundamentalsForLegacyPCs"), "0x243"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003WebServer"), "0x250"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003WebServer64"), "0x255"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003StandardServer"), "0x251"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003StandardServer64"), "0x256"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003EnterpriseServer"), "0x252"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003EnterpriseServer64"), "0x257"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003DatacenterServer"), "0x254"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2003DatacenterServer64"), "0x258"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINVistaHome"), "0x259"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINVistaHome64"), "0x260"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINVistaBusinessUltimateEnterprise"), "0x261"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WINVistaBusinessUltimateEnterprise64"), "0x262"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008StandardServer"), "0x263"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008StandardServer64"), "0x264"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008EnterpriseServer"), "0x265"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008EnterpriseServer64"), "0x266"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008DatacenterServer"), "0x267"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008DatacenterServer64"), "0x268"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008WebServer"), "0x269"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008WebServer64"), "0x270"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008SmallBusinessServer64"), "0x271"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008EssentialBusinessServer64"), "0x272"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008StandardServerR2"), "0x273"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008EnterpriseServerR2"), "0x274"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008DatacenterServerR2"), "0x275"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008WebServerR2"), "0x276"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN7StarterHomeBasicHomePremium"), "0x277"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN7StarterHomeBasicHomePremium64"), "0x278"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN7ProfessionalUltimateEnterprise"), "0x279"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN7ProfessionalUltimateEnterprise64"), "0x27A"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN7Embedded"), "0x27B"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN8WorkStation"), "0x27C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN8WorkStation64"), "0x27D"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN8Embedded"), "0x27E"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2012StandardServer"), "0x280"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2012DatacenterServer"), "0x281"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN8.1WorkStation"), "0x282"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN8.1WorkStation64"), "0x283"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN8.1Embedded"), "0x284"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2012R2StandardServer"), "0x285"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2012R2DatacenterServer"), "0x286"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN10WorkStation"), "0x287"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN10WorkStation64"), "0x288"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2015StandardServer"), "0x289"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2015DatacenterServer"), "0x28A"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2019StandardServer"), "0x28B"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2019DatacenterServer"), "0x28C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN11WorkStation64"), "0x28D"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2022StandardServer"), "0x28E"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2022DatacenterServer"), "0x28F"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2025StandardServer"), "0x290"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2025DatacenterServer"), "0x291")};
    public static final OSType[] MAC_OS_TYPES = new OSType[]{new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX105"), "0x100A0500"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX106"), "0x100A0600"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX107"), "0x100A0700"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX108"), "0x100A0800"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX109"), "0x100A0900"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1010"), "0x100A0A00"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1011"), "0x100A0B00"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1012"), "0x100A0C00"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1013"), "0x100A0D00"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1014"), "0x100A0E00"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1015"), "0x100A0F00"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MacOSX1016"), "0x100A1000")};
    private static final OSType[] LANGUAGE_TYPES = new OSType[]{new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Albanian"), "0x041C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Arabic"), "0x0401"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Bahasa"), "0x0421"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.BelgianDutch"), "0x0813"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.BelgianFrench"), "0x080C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Bulgarian"), "0x0402"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Czech"), "0x0405"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.CanadianFrench"), "0x0C0C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.CastilianSpanish"), "0x040A"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Catalian"), "0x0403"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.CroatoSerbianLatin"), "0x041A"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Danish"), "0x0406"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Dutch"), "0x0413"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Finnish"), "0x040B"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.French"), "0x040C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.German"), "0x0407"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Greek"), "0x0408"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Hebrew"), "0x040D"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Hungarian"), "0x040E"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Icelandic"), "0x040F"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Italian"), "0x0410"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Japanese"), "0x0411"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Korean"), "0x0412"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.MexicanSpanish"), "0x080A"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.NorwegianBokmal"), "0x0414"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.NorwegianNynorsk"), "0x0814"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.PortuguesePortugal"), "0x0816"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Russian"), "0x0419"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.SerboCroatianCyrillic"), "0x081A"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.SimplifiedChinese"), "0x0804"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Slovak"), "0x041B"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Swedish"), "0x041D"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.SwissFrench"), "0x100C"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.SwissGerman"), "0x0807"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.SwissItalian"), "0x0810"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Thai"), "0x041E"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.TraditionalChinese"), "0x0404"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Turkish"), "0x041F"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.UKEnglish"), "0x0809"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.USEnglish"), "0x0409"), new OSType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.Urdu"), "0x0420")};
    private String title;
    private JList<JCheckBox> jLType = new JList();
    private DefaultListModel<JCheckBox> osListModel = new DefaultListModel();
    private JButton jBSelectAll = new JButton(UIText.get(4614));
    private JScrollPane scrollPane;
    private int type;
    private Map<JCheckBox, OSType> matchMap = new HashMap<JCheckBox, OSType>();
    private OSType[] osType;
    private OSObject osObj;
    private HiParentPanelInt parent;
    private boolean needButton = true;

    public OSPanel(String title, int type) {
        this(title, type, true);
    }

    public OSPanel(String title, int type, boolean needButton) {
        this.title = title;
        this.type = type;
        this.needButton = needButton;
        this.osType = this.getOSType(type);
        this.jBSelectAll.setVisible(type != 2);
        this.initialize();
    }

    public void setObject(OSObject osObj) {
        this.setObject(osObj, null);
    }

    public void setObject(OSObject osObj, HiParentPanelInt parent) {
        this.osObj = osObj;
        this.retainStandardOSType();
        this.parent = parent;
        this.updatePanel();
    }

    public OSObject getOSObject() {
        return this.osObj;
    }

    public String getNonStandardOSType(String osMask) {
        if (this.type == 2) {
            try {
                IntegerSet osSet = new IntegerSet(osMask, 16);
                for (int i = 0; i < this.osType.length; ++i) {
                    osSet.delete(this.osType[i].getValue());
                }
                return osSet.toString(16);
            }
            catch (BadFormatException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return "";
    }

    private void initialize() {
        this.jLType.setVisibleRowCount(-1);
        this.jLType.setLayoutOrientation(2);
        this.jLType.setCellRenderer(new ChkListCellRenderer());
        this.jLType.setPrototypeCellValue(new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "OSPanel.WIN2008EssentialBusinessServer64") + "   "));
        this.osListModel = new DefaultListModel();
        for (int i = 0; i < this.osType.length; ++i) {
            JCheckBox cBox = new JCheckBox(this.osType[i].toString());
            cBox.setBackground(this.jLType.getBackground());
            this.osListModel.addElement(cBox);
            cBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSPanel.this.osChanged(e);
                }
            });
            this.matchMap.put(cBox, this.osType[i]);
        }
        this.jLType.setModel(this.osListModel);
        this.jLType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = OSPanel.this.jLType.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox cBox = OSPanel.this.jLType.getModel().getElementAt(index);
                    cBox.doClick();
                    OSPanel.this.jLType.updateUI();
                }
            }
        });
        this.scrollPane = new JScrollPane(this.jLType);
        Dimension size = this.jLType.getPreferredScrollableViewportSize();
        this.scrollPane.setPreferredSize(new Dimension(size.width, size.height / 2));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(this.title), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.needButton) {
            this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private JComponent getButtonPanel() {
        this.jBSelectAll.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPanel.this.selectAll();
            }
        });
        JButton clearAll = new JButton(UIText.get(517));
        clearAll.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OSPanel.this.clearAll();
            }
        });
        JPanel panel = new JPanel();
        UIUtilities.layoutButtonPanel(panel, new JButton[]{this.jBSelectAll, clearAll}, 0, 4, true, false, 3);
        return panel;
    }

    private void updatePanel() {
        IntegerSet osSet = this.osObj.getOSSet();
        Object[] list = this.osListModel.toArray();
        for (int i = 0; i < list.length; ++i) {
            JCheckBox cBox = (JCheckBox)list[i];
            OSType osType = this.matchMap.get(cBox);
            cBox.setSelected(osSet.contains(osType.getValue()));
        }
    }

    public String getOperatingSystemCodes() {
        StringBuffer sb = new StringBuffer();
        IntegerSet osSet = this.osObj.getOSSet();
        Object[] list = this.osListModel.toArray();
        for (int i = 0; i < list.length; ++i) {
            JCheckBox cBox = (JCheckBox)list[i];
            OSType osType = this.matchMap.get(cBox);
            if (!osSet.contains(osType.getValue())) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(osType.getValue().toString(16));
        }
        return sb.toString();
    }

    public String getOperatingSystemNames() {
        StringBuffer sb = new StringBuffer();
        IntegerSet osSet = this.osObj.getOSSet();
        Object[] list = this.osListModel.toArray();
        for (int i = 0; i < list.length; ++i) {
            JCheckBox cBox = (JCheckBox)list[i];
            OSType osType = this.matchMap.get(cBox);
            if (!osSet.contains(osType.getValue())) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(osType.getDescription());
        }
        return sb.toString();
    }

    public String getOperatingSystemNamesFromCode(String code) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(code, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            Object[] list = this.osListModel.toArray();
            for (int i = 0; i < list.length; ++i) {
                JCheckBox cBox = (JCheckBox)list[i];
                OSType osType = this.matchMap.get(cBox);
                if (!token.equals(osType.getValue().toString(16))) continue;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(osType.getDescription());
            }
        }
        return sb.toString();
    }

    public void setObjestByNames(String names) {
        IntegerSet osSet = this.osObj.getOSSet();
        osSet.getRangeList().clear();
        boolean first = false;
        StringTokenizer tokens = new StringTokenizer(names, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            Object[] list = this.osListModel.toArray();
            for (int i = 0; i < list.length; ++i) {
                JCheckBox cBox = (JCheckBox)list[i];
                OSType osType = this.matchMap.get(cBox);
                if (!token.equals(osType.getValue().toString(16))) continue;
                if (!first) {
                    first = true;
                    Rectangle rect = this.jLType.getCellBounds(i, i + 1);
                    if (this.scrollPane != null) {
                        this.scrollPane.getViewport().scrollRectToVisible(rect);
                    }
                }
                this.osObj.addOS(osType.getValue());
                cBox.setSelected(true);
            }
        }
    }

    private void osChanged(ActionEvent e) {
        JCheckBox curBox = (JCheckBox)e.getSource();
        OSType thisType = this.matchMap.get(curBox);
        if (curBox.isSelected()) {
            this.osObj.addOS(thisType.getValue());
        } else {
            this.osObj.deleteOS(thisType.getValue());
        }
        if (this.parent != null) {
            this.parent.saveData();
        }
    }

    private void selectAll() {
        this.selectAll(true);
    }

    private void clearAll() {
        this.selectAll(false);
    }

    private void selectAll(boolean select) {
        Object[] list = this.osListModel.toArray();
        for (int i = 0; i < list.length; ++i) {
            JCheckBox cBox = (JCheckBox)list[i];
            OSType thisType = this.matchMap.get(cBox);
            cBox.setSelected(select);
            if (select) {
                this.osObj.addOS(thisType.getValue());
                continue;
            }
            this.osObj.deleteOS(thisType.getValue());
        }
        if (this.parent != null) {
            this.parent.saveData();
        }
        this.updateUI();
    }

    private OSType[] getOSType(int type) {
        switch (type) {
            case 0: {
                return OS_TYPES;
            }
            case 1: {
                return OS_TYPES;
            }
            case 3: {
                return MAC_OS_TYPES;
            }
        }
        return LANGUAGE_TYPES;
    }

    private void retainStandardOSType() {
        if (this.type == 2) {
            try {
                String nonStdType = this.getNonStandardOSType(this.osObj.getOSString());
                IntegerSet osSet = new IntegerSet(nonStdType, 16);
                this.osObj.deleteOS(osSet);
            }
            catch (BadFormatException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }
}

