/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.configobject.table.ServerPolicyLog;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerLogHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.TimeTableRow;
import com.sygate.scm.console.ui.monitoring.logviewer.LogUtilities;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;

public class HistoryPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private static final String[] COL_NAMES = new String[]{MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.descriptionLabel"), MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.timeLabel"), MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.adminLabel")};
    private static final float[] COL_SIZE = new float[]{0.6f, 0.3f, 0.1f};
    private SortableTableModel hisModel = new SortableTableModel();
    private JTable jTHistory = new StripesTable(false, false);
    private boolean policyPool = false;
    private List<String> ownerId;

    public HistoryPane(boolean policyPool) {
        this.policyPool = policyPool;
        this.initialize();
    }

    public HistoryPane() {
        this.initialize();
    }

    public void setObject(List<String> ownerIdList) {
        this.ownerId = ownerIdList;
        this.updatePanel();
    }

    public void updatePanel() {
        this.hisModel.removeAll();
        if (this.ownerId.size() > 0) {
            String text = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.loadingMsg");
            this.hisModel.addRow(new HistoryTableRow(text, text, text, null));
            SwingWorker<List<ServerPolicyLog>, Void> swingWorkerHistory = new SwingWorker<List<ServerPolicyLog>, Void>(){

                @Override
                protected List<ServerPolicyLog> doInBackground() throws Exception {
                    return ServerLogHandler.getServerPolicyLog(HistoryPane.this.policyPool, 0, 100, HistoryPane.this.ownerId);
                }

                @Override
                protected void done() {
                    try {
                        HistoryPane.this.hisModel.removeAll();
                        for (ServerPolicyLog log : (List)this.get()) {
                            HistoryPane.this.hisModel.addRow(new HistoryTableRow(log));
                        }
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    catch (CancellationException ce) {
                        return;
                    }
                    catch (Exception e) {
                        LoggerUtilities.logException((Throwable)e);
                        String errorText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.policyHistoryErrorMsg");
                        JOptionPane.showMessageDialog(Manager.getFrame(), errorText, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.errorMsg"), 0);
                        return;
                    }
                }
            };
            SwingWorkerExecutor.getInstance().execute(swingWorkerHistory);
        }
    }

    private void initialize() {
        this.hisModel.setColumnNames(COL_NAMES);
        this.hisModel.setEditMode(false);
        this.jTHistory.setModel(this.hisModel);
        this.hisModel.addMouseListenerToHeaderInTable(this.jTHistory);
        JScrollPane pane = UIUtilities.createScrollPaneWithoutBoard(this.jTHistory);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(MSG_RES.getString("com.sygate.scm.console.ui.policy.policy", "HistoryPane.changeHistoryLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        UIUtilities.setTableColumnWidth(this.jTHistory, COL_SIZE, (int)this.jTHistory.getPreferredScrollableViewportSize().getWidth());
    }

    private static class HistoryTableRow
    implements TimeTableRow,
    TableRow {
        String eventTime;
        String adminName;
        String desc;
        Date eventDate;

        public HistoryTableRow(String eventTime, String adminName, String desc, Date eventDate) {
            this.eventTime = eventTime;
            this.adminName = adminName;
            this.desc = desc;
            this.eventDate = eventDate;
        }

        public HistoryTableRow(ServerPolicyLog oneLog) {
            long time = oneLog.getTimeStamp();
            this.eventTime = UIUtilities.formatDate(time);
            this.adminName = LogUtilities.getValueForID(oneLog.getAdminId());
            this.desc = oneLog.getOptEventDesc();
            this.eventDate = new Date(time);
        }

        @Override
        public Object getValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.desc;
                }
                case 1: {
                    return this.eventTime;
                }
                case 2: {
                    return this.adminName;
                }
            }
            return "";
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Date.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int index) {
        }

        @Override
        public Object getSortValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.desc;
                }
                case 1: {
                    return this.eventDate;
                }
                case 2: {
                    return this.adminName;
                }
            }
            return "";
        }
    }
}

