/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.GroupPolicyPermission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.OverviewPane;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.adaptive.AdaptivePolicyDialog;
import com.sygate.scm.console.ui.policy.adaptive.QuarantineAdaptivePolicyDialog;
import com.sygate.scm.console.ui.policy.av.AvPolicyDialog;
import com.sygate.scm.console.ui.policy.av.QuarantineAvPolicyDialog;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.AbsPolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantineOSPPolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.QuarantinePolicyEditorDlg;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FwPolicyDialog;
import com.sygate.scm.console.ui.policy.hi.HiPolicyDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsPolicyDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.QuarantineIdsPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.LuPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.QuarantineLuPolicyDialog;
import com.sygate.scm.console.ui.policy.mem.MemPolicyDialog;
import com.sygate.scm.console.ui.policy.mem.QuarantineMemPolicyDialog;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicyDialog;
import com.sygate.scm.console.ui.policy.ntr.QuarantineNtrPolicyDialog;
import com.sygate.scm.console.ui.policy.osprotect.dialog.OspPolicyDialog;
import com.sygate.scm.console.ui.policy.override.OverridePolicyDialog;
import com.sygate.scm.console.ui.policy.override.QuarantineOverridePolicyDialog;
import com.sygate.scm.console.ui.policy.up.QuarantineUpgradePolicyDialog;
import com.sygate.scm.console.ui.policy.up.UpgradePolicyDialog;
import com.sygate.scm.console.ui.util.AlwaysEnabledDescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public abstract class BasePolicyDialog
extends DialogBase
implements AbsPolicyEditorDlg {
    private static final long serialVersionUID = 1L;
    public static final int READ_ONLY_NO = 0;
    public static final int READ_ONLY_GROUP_INHERIT = 1;
    private static final int READ_ONLY_ADMIN_POLICY_ENFORCEMENT = 2;
    public static final int READ_ONLY_GROUP_READONLY = 3;
    public static final int READ_ONLY_CLOUD_GROUP_INHERIT = 4;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String POLICY = "com.sygate.scm.console.ui.policy.policy";
    protected AppliablePolicyPool policyPool;
    protected PolicyTabPanel tabPanel;
    protected JPanel subTitlePanel;
    protected JPanel topPanel;
    protected JPanel rightPanel;
    protected JPanel buttonPanel;
    protected JPanel mainPanel;
    protected OverviewPane overviewPanel;
    protected JPanel readOnlyPanel;
    protected JCheckBox enablePolicyBox;
    protected int policyType;
    protected ArrayList<?> tabButtonList;
    protected GroupPolicyObject groupPolicyObject;
    protected String locationName;
    protected int readOnlyReason = 0;
    protected boolean localPolicy;
    private static final int Default_Width = 950;
    private static final int Default_Height = 860;
    private boolean canDisable = false;
    private boolean newPolicy = false;
    private JLabel subTitle;
    private boolean isPolicyNonShared;
    private static final int BORDER_WIDTH = 2;

    protected BasePolicyDialog(int policyType, String locaitonName, GroupPolicyObject gpObj, String policyTypeName) {
        this(policyType, locaitonName, gpObj, policyTypeName, true, new Boolean[0]);
    }

    protected BasePolicyDialog(int policyType, String locaitonName, GroupPolicyObject gpObj, String policyTypeName, boolean hasDisableBox, Boolean ... localPolicy) {
        super(Manager.getFrame(), "", true);
        this.policyType = policyType;
        this.locationName = locaitonName;
        this.groupPolicyObject = gpObj;
        this.localPolicy = localPolicy[0] == null ? false : localPolicy[0];
        this.canDisable = hasDisableBox;
        this.init(policyTypeName, this.locationName, false, hasDisableBox);
    }

    protected BasePolicyDialog(int policyType, AbstractUIObject policyPool, String policyTypeName, boolean isCheckPolicyEnforcement) {
        this(policyType, policyPool, policyTypeName, isCheckPolicyEnforcement, true);
    }

    protected BasePolicyDialog(int policyType, AbstractUIObject policyPool, String policyTypeName, boolean isCheckPolicyEnforcement, boolean hasDisableBox) {
        super(Manager.getFrame(), "", true);
        this.policyType = policyType;
        this.policyPool = (AppliablePolicyPool)policyPool;
        this.canDisable = hasDisableBox;
        this.init(policyTypeName, MSGRES.getString(POLICY, "BasePolicyDialog.policyLibrary"), isCheckPolicyEnforcement, hasDisableBox);
    }

    protected void initReadOnly(boolean isCheckPolicyEnforcement, GroupPolicyObject groupPolicyObject) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        boolean readOnly = this.localPolicy ? AdminACLUtils.isNonSharedPolicyReadOnly((PrivilegeContext)context, (SemClientGroup)groupPolicyObject.getClientGroup(), (GroupPolicyPermission.GroupPolicyMode)groupPolicyObject.getGroupPolicyMode()) : AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context);
        this.setReadOnly(readOnly);
        if (this.isReadOnly()) {
            int reason = 0;
            if (groupPolicyObject != null && groupPolicyObject.isInherit()) {
                reason = 1;
            } else if (isCheckPolicyEnforcement && !this.localPolicy && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
                reason = 2;
            }
            this.setReadOnlyReason(reason);
        }
    }

    protected void makeWider(int increase) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int width = size.width + increase;
        if (screenDimension.width < width) {
            width = screenDimension.width;
        }
        this.setSize(width, size.height);
    }

    public static AbsPolicyEditorDlg getEditor(String locationName, String policyTargetName, GroupPolicyObject gpObj, boolean locPolicy) {
        BasePolicyDialog dlg = null;
        Cursor curCursor = Manager.getFrame().getCursor();
        Manager.getFrame().setCursor(new Cursor(3));
        if (policyTargetName.equals("AvPolicyApplied")) {
            dlg = new AvPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("FirewallPolicyApplied")) {
            dlg = new FwPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("HostIntegrityApplied")) {
            dlg = new HiPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("OpAppProtectionPolicyApplied")) {
            dlg = new OspPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("MemPolicyApplied")) {
            dlg = new MemPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("PolicyOverrideApplied")) {
            dlg = new OverridePolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("LuPolicyApplied")) {
            dlg = new LuPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("IdsPolicyApplied")) {
            dlg = new IdsPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("NtrPolicyApplied")) {
            dlg = new NtrPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineAvPolicyApplied")) {
            dlg = new QuarantineAvPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineFWPolicyApplied")) {
            dlg = new QuarantinePolicyEditorDlg(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineOSPPolicyApplied")) {
            dlg = new QuarantineOSPPolicyEditorDlg(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineCePolicyApplied")) {
            dlg = new QuarantineOverridePolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineLuPolicyApplied")) {
            dlg = new QuarantineLuPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineIdsPolicyApplied")) {
            dlg = new QuarantineIdsPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineMemPolicyApplied")) {
            dlg = new QuarantineMemPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineNtrPolicyApplied")) {
            dlg = new QuarantineNtrPolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("UpgradePolicyApplied")) {
            dlg = new UpgradePolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineUpgradePolicyApplied")) {
            dlg = new QuarantineUpgradePolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("AdaptivePolicyApplied")) {
            dlg = new AdaptivePolicyDialog(locationName, gpObj, locPolicy);
        } else if (policyTargetName.equals("QuarantineAdaptivePolicyApplied")) {
            dlg = new QuarantineAdaptivePolicyDialog(locationName, gpObj, locPolicy);
        }
        Manager.getFrame().setCursor(curCursor);
        return dlg;
    }

    public static AbsPolicyEditorDlg getEditor(AbstractUIObject pool, String policyTargetName) {
        BasePolicyDialog dlg = null;
        Cursor curCursor = Manager.getFrame().getCursor();
        Manager.getFrame().setCursor(new Cursor(3));
        if (policyTargetName.equals("AvPolicyApplied")) {
            dlg = new AvPolicyDialog(pool, true);
        } else if (policyTargetName.equals("FirewallPolicyApplied")) {
            dlg = new FwPolicyDialog(pool, true);
        } else if (policyTargetName.equals("HostIntegrityApplied")) {
            dlg = new HiPolicyDialog(pool, true);
        } else if (policyTargetName.equals("OpAppProtectionPolicyApplied")) {
            dlg = new OspPolicyDialog(pool, true);
        } else if (policyTargetName.equals("MemPolicyApplied")) {
            dlg = new MemPolicyDialog(pool, true);
        } else if (policyTargetName.equals("NtrPolicyApplied")) {
            dlg = new NtrPolicyDialog(pool, true);
        } else if (policyTargetName.equals("PolicyOverrideApplied")) {
            dlg = new OverridePolicyDialog(pool, true);
        } else if (policyTargetName.equals("CloudWhiteListPolicyOverrideApplied")) {
            dlg = new OverridePolicyDialog(pool, true, true, MSGRES.getString("com.sygate.scm.console.handler.handler", "PolicyTemp.AllowList"));
        } else if (policyTargetName.equals("CloudBlackListPolicyOverrideApplied")) {
            dlg = new OverridePolicyDialog(pool, true, true, MSGRES.getString("com.sygate.scm.console.handler.handler", "PolicyTemp.DenyList"));
        } else if (policyTargetName.equals("LuPolicyApplied")) {
            dlg = new LuPolicyDialog(pool, true);
        } else if (policyTargetName.equals("IdsPolicyApplied")) {
            dlg = new IdsPolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineAvPolicyApplied")) {
            dlg = new QuarantineAvPolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineFWPolicyApplied")) {
            dlg = new QuarantinePolicyEditorDlg(pool, true);
        } else if (policyTargetName.equals("QuarantineOSPPolicyApplied")) {
            dlg = new QuarantineOSPPolicyEditorDlg(pool, true);
        } else if (policyTargetName.equals("QuarantineCePolicyApplied")) {
            dlg = new QuarantineOverridePolicyDialog(pool, true, new Boolean[0]);
        } else if (policyTargetName.equals("QuarantineLuPolicyApplied")) {
            dlg = new QuarantineLuPolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineIdsPolicyApplied")) {
            dlg = new QuarantineIdsPolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineMemPolicyApplied")) {
            dlg = new QuarantineMemPolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineNtrPolicyApplied")) {
            dlg = new QuarantineNtrPolicyDialog(pool, true);
        } else if (policyTargetName.equals("UpgradePolicyApplied")) {
            dlg = new UpgradePolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineUpgradePolicyApplied")) {
            dlg = new QuarantineUpgradePolicyDialog(pool, true);
        } else if (policyTargetName.equals("AdaptivePolicyApplied")) {
            dlg = new AdaptivePolicyDialog(pool, true);
        } else if (policyTargetName.equals("QuarantineAdaptivePolicyApplied")) {
            dlg = new QuarantineAdaptivePolicyDialog(pool, true);
        }
        Manager.getFrame().setCursor(curCursor);
        return dlg;
    }

    @Override
    public abstract PolicyInt createNewPolicy(AppliablePolicyPool var1);

    @Override
    public WizardPanel getNextPanel() {
        return null;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return null;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setObject(PolicyInt policy) {
    }

    @Override
    public boolean isDataChange() {
        return this.isOk;
    }

    @Override
    public void setReadOnlyReason(int reason) {
        this.readOnlyReason = reason;
        if (this.readOnlyReason != 0) {
            this.setReadOnly(true);
            this.addOrUpdateReadOnlyPanel();
        }
    }

    public void setPolicyEditorPane(String selectedTabName) throws ConsoleException {
        try {
            if (selectedTabName == null) {
                return;
            }
            CardLayout cd = (CardLayout)this.mainPanel.getLayout();
            cd.show(this.mainPanel, selectedTabName);
            this.setSubTitle(selectedTabName);
            this.updateSubTitle();
            this.subTitlePanel.invalidate();
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    protected abstract PolicyTabPanel createTabPanel();

    protected boolean isValidName(TopLevelObject policy, String nameError, String poolNameError, String guiError) {
        JTextField nameField = this.getOverviewPanel().getPolicyNameField();
        try {
            String name = this.getOverviewPanel().getPolicyName();
            if (name == null || name.trim().length() == 0) {
                throw new GUICheckException(nameError, nameField);
            }
            if (this.policyPool != null && !this.policyPool.checkNewName(policy, name)) {
                throw new GUICheckException(poolNameError, nameField);
            }
            return true;
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), guiError, 2);
            nameField.requestFocus();
            return false;
        }
    }

    @Override
    public void setPolicyIsNonShared(boolean isPolicyNonShared) {
        this.isPolicyNonShared = isPolicyNonShared;
    }

    @Override
    public boolean isPolicyNonShared() {
        return this.isPolicyNonShared;
    }

    protected JPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.rightPanel = new JPanel(new BorderLayout());
            this.rightPanel.add((Component)this.getMainPanel(), "Center");
            this.rightPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, UIColorUtilities.CONTROL_BACKGROUND));
        }
        return this.rightPanel;
    }

    protected PolicyTabPanel getTabPanel() {
        if (this.tabPanel == null) {
            this.tabPanel = this.createTabPanel();
        }
        return this.tabPanel;
    }

    protected void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.invalidate();
    }

    protected JPanel getButtonPanel(boolean hasDisableBox) {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            JPanel panel = this.getButtonPanel();
            this.buttonPanel.add((Component)panel, "East");
            this.buttonPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UIColorUtilities.CONTROL_BACKGROUND));
        }
        return this.buttonPanel;
    }

    protected JPanel getSubTitlePanel() {
        if (this.subTitlePanel == null) {
            this.subTitlePanel = new JPanel();
            this.subTitlePanel.setLayout(new BorderLayout());
            this.subTitle = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Overview"));
            this.subTitle.putClientProperty("cssClass", "basePolicyDialogsubTitle");
            this.subTitle.setFont(UIFontUtilities.HEADING_FONT);
            this.subTitle.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.subTitlePanel.add((Component)this.subTitle, "West");
            this.subTitlePanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, UIColorUtilities.CONTROL_BACKGROUND));
        }
        this.subTitlePanel.putClientProperty("cssClass", "basePolicyDialogsubTitlePanel");
        return this.subTitlePanel;
    }

    protected void setSubTitle(String text) {
        this.subTitle.setText(text);
    }

    public String getSubTitle() {
        return this.subTitle.getText();
    }

    public boolean isNewPolicy() {
        return this.newPolicy;
    }

    public void setNewPolicy(boolean newPolicy) {
        this.newPolicy = newPolicy;
    }

    protected void updateSubTitle() {
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Component curComp = null;
        for (int i = 0; i < this.mainPanel.getComponentCount(); ++i) {
            Component comp = this.mainPanel.getComponent(i);
            if (!comp.isVisible()) continue;
            curComp = comp;
        }
        return HelpUtil.getContentSensitiveHelpToken(curComp);
    }

    protected OverviewPane getOverviewPanel() {
        if (this.overviewPanel == null) {
            String grpName = this.groupPolicyObject == null ? null : this.groupPolicyObject.getGroupName();
            this.overviewPanel = new OverviewPane(this, this.locationName, grpName, this.localPolicy, this.canDisable);
        }
        return this.overviewPanel;
    }

    protected void addPolicyEditorPanels(JPanel mainPanel) {
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getOverviewPanel()), MSGRES.getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyTabPanel.Overview"));
    }

    protected AbstractUIObject getPool() {
        return this.policyPool;
    }

    protected void addOrUpdateReadOnlyPanel() {
        this.jBOk.setEnabled(false);
        this.jBOk.setToolTipText(this.getReadOnlyOkButtonToolTip());
        AlwaysEnabledDescriptionTextArea descArea = new AlwaysEnabledDescriptionTextArea(true);
        descArea.setText(this.getReadOnlyPanelMessage());
        descArea.setBorder(BorderFactory.createEmptyBorder(3, 4, 5, 4));
        this.readOnlyPanel = new JPanel(new BorderLayout());
        this.readOnlyPanel.setBackground(UIColorUtilities.WARNING_BACKGROUND);
        this.readOnlyPanel.add(descArea);
        this.getContentPane().add((Component)this.readOnlyPanel, "North");
    }

    private void init(String policyTypeName, String policyLocName, boolean isCheckPolicyEnforcement, boolean hasDisableBox) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int taskBarHeight = scnMax.bottom;
        int width = 950;
        int height = 860;
        int availableScreenHeight = screenDimension.height - taskBarHeight;
        if (screenDimension.width < width) {
            width = screenDimension.width;
        }
        if (availableScreenHeight < height) {
            height = availableScreenHeight;
        }
        this.setSize(width, height);
        PolicyTabPanel policyTabPanel = this.getTabPanel();
        JScrollPane scrollpane = new JScrollPane(policyTabPanel, 20, 31);
        JPanel cpanel = new JPanel(new BorderLayout());
        cpanel.add((Component)scrollpane, "West");
        cpanel.add((Component)this.getTopPanel(), "Center");
        cpanel.add((Component)policyTabPanel.getTopLabelPanel(), "North");
        cpanel.add((Component)this.getButtonPanel(hasDisableBox), "South");
        this.getContentPane().add(cpanel);
        this.setTitle(this.createTitle(policyTypeName, policyLocName));
        UiUtilities.centerComponent((Component)this);
        this.initReadOnly(isCheckPolicyEnforcement, this.groupPolicyObject);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new CardLayout());
            this.addPolicyEditorPanels(this.mainPanel);
        }
        return this.mainPanel;
    }

    private String getReadOnlyOkButtonToolTip() {
        switch (this.readOnlyReason) {
            case 1: {
                return MSGRES.getString(POLICY, "BasePolicyDialog.tooltip.policyInherited");
            }
            case 2: {
                return MSGRES.getString(POLICY, "BasePolicyDialog.tooltip.adminPolicyEnforcement");
            }
            case 4: {
                return MSGRES.getString(POLICY, "BasePolicyDialog.tooltip.cloudGroupInherit");
            }
        }
        return MSGRES.getString(POLICY, "BasePolicyDialog.tooltip.groupReadOnly");
    }

    private String getReadOnlyPanelMessage() {
        switch (this.readOnlyReason) {
            case 1: {
                return MSGRES.getString(POLICY, "BasePolicyDialog.groupInherit");
            }
            case 4: {
                return MSGRES.getString(POLICY, "BasePolicyDialog.cloudGroupInherit");
            }
            case 2: {
                return MSGRES.getString(POLICY, "BasePolicyDialog.adminPolicyEnforcement");
            }
        }
        return MSGRES.getString(POLICY, "BasePolicyDialog.groupReadOnly");
    }

    private String createTitle(String policyTypeName, String policyLocName) {
        Object[] obj = new Object[]{policyTypeName, policyLocName};
        String str = this.readOnlyReason != 0 ? MSGRES.getString(POLICY, "BasePolicyDialog.readOnlyTitle") : MSGRES.getString(POLICY, "BasePolicyDialog.title");
        return MessageFormat.format(str, obj);
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel(new BorderLayout());
            this.topPanel.add((Component)this.getSubTitlePanel(), "North");
            this.topPanel.add((Component)this.getRightPanel(), "Center");
        }
        this.topPanel.putClientProperty("cssClass", "basePolicyDialogTopPanel");
        return this.topPanel;
    }
}

