/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.overview;

import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.ReportingAccessDeniedPanel;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.overview.CloudBanner;
import com.sygate.scm.console.ui.util.PagePanel;
import java.awt.BorderLayout;
import java.awt.Component;

public class OverviewPanel
extends PagePanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private Browser browser = null;
    private boolean isAccessDeniedPanelInitialized;
    private boolean isNeedPanelRefresh = false;
    private CloudBanner cloudBanner = null;

    public OverviewPanel(String tabName, MainPanel mainPanel) {
        this.setName(tabName);
        this.setLayout(new BorderLayout());
        if (mainPanel.isCloudTabEnabled()) {
            this.cloudBanner = new CloudBanner(mainPanel);
            this.add((Component)this.cloudBanner, "North");
        }
    }

    @Override
    public void initPanel() {
        if (this.hasInitialized()) {
            return;
        }
        this.browser = new Browser(1);
        this.add((Component)this.browser, "Center");
        this.isInitialized = true;
    }

    public void checkIfInitiated() {
        if (!this.isInitialized) {
            this.initPanel();
        }
    }

    @Override
    public void switchIn() {
        if (AdminPrivilegeObject.isCurrentAdminHasReportPrivilege()) {
            this.browser.startAutoRefresh();
            if (this.cloudBanner != null) {
                this.cloudBanner.doRefresh();
            }
        } else {
            this.checkIfInitiated();
            if (!this.isAccessDeniedPanelInitialized) {
                ReportingAccessDeniedPanel accessDeniedPanel = new ReportingAccessDeniedPanel();
                accessDeniedPanel.load();
                this.add((Component)accessDeniedPanel, "Center");
                this.isAccessDeniedPanelInitialized = true;
            }
        }
    }

    @Override
    public void switchOut() {
        if (AdminPrivilegeObject.isCurrentAdminHasReportPrivilege() && this.browser != null) {
            this.browser.stopAutoRefresh();
        }
    }

    public void doRefresh() {
        if (AdminPrivilegeObject.isCurrentAdminHasReportPrivilege()) {
            if (this.browser != null) {
                this.browser.doRefresh();
            }
            if (this.cloudBanner != null) {
                this.cloudBanner.doRefresh();
            }
        } else {
            this.checkIfInitiated();
        }
    }

    public boolean doLogout() {
        boolean ret = false;
        if (AdminPrivilegeObject.isCurrentAdminHasReportPrivilege() && this.browser != null) {
            ret = this.browser.doLogout();
        }
        return ret;
    }

    public void disposeBrowser() {
        if (this.browser != null) {
            this.browser.dispose();
        }
    }

    @Override
    public void refreshTaskBarViews() {
    }

    public int getContextHelpId() {
        return 1000;
    }

    @Override
    public void selectItemIndex(int index) {
    }

    public boolean isNeedPanelRefresh() {
        return this.isNeedPanelRefresh;
    }

    public void setNeedPanelRefresh(boolean isNeedPanelRefresh) {
        this.isNeedPanelRefresh = isNeedPanelRefresh;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_home_dashboard";
    }

    @Override
    public Component getCurrentTaskPanel() {
        return this;
    }
}

