/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.overview;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.SsoLoginUtil;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CloudBanner
extends JPanel {
    private static final long serialVersionUID = -3893935656857019843L;
    private static final int ENROLL = 1;
    private static final int MIN_MESSAGE_SIZE = 130;
    private static final int LOGIN_TO_CLOUD = 2;
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private static final String DEFAULT_ICON_NAME = "icon_Banner_32.png";
    private static final Logger logger = Logger.getLogger(CloudBanner.class.getName());
    private JLabel messageLabel = null;
    private JButton actionButton = null;
    private int actionType = 1;
    private MainPanel mainPanel = null;

    public CloudBanner(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.initPanel();
    }

    public boolean needsTobeShown() {
        return CloudUtil.isCloudFullEnrollment(Manager.getCurrentDomainId());
    }

    private void initPanel() {
        this.setFont(UIFontUtilities.STANDARD_FONT);
        this.messageLabel = new JLabel();
        Image defaultImage = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(DEFAULT_ICON_NAME));
        ImageIcon imgIcon = new ImageIcon(defaultImage);
        this.messageLabel.setIcon(imgIcon);
        this.actionButton = new JButton();
        this.actionButton.setBackground(UIColorUtilities.DEFAULT_BUTTON_BACKGROUND);
        this.actionButton.setForeground(Color.BLACK);
        this.actionButton.putClientProperty("isCustomButton", Boolean.TRUE);
        this.setLayout(new GridBagLayout());
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)this.messageLabel, "Center");
        container.add((Component)this.actionButton, "East");
        this.add((Component)container, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, -1, new Insets(5, 15, 5, 0), 0, 0));
        this.updateEnrollmentStatus();
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (CloudBanner.this.actionType == 2) {
                    new SsoLoginUtil().openLink();
                } else {
                    logger.log(Level.INFO, "***** Navigate to security cloud tab. *****");
                    CloudBanner.this.mainPanel.setCurrentPanel("5ee0505f9a5149f492f399e91f93c95b", 0);
                }
            }
        });
    }

    public void doRefresh() {
        logger.log(Level.INFO, "CloudBanner >> doRefresh >> Refresh enrollment status!");
        if (this.needsTobeShown()) {
            this.updateEnrollmentStatus();
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    private void updateEnrollmentStatus() {
        String message = "";
        if (CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) {
            logger.log(Level.INFO, "SAEP cloud was enrolled.");
            message = MSG_RES.getString("com.sygate.scm.console.ui.ui", "CloudBanner.label.enrolled.message");
            this.actionButton.setText(UIText.get(2822));
            this.actionType = 2;
        } else {
            logger.log(Level.INFO, "***** SAEP cloud was not enrolled yet! *****");
            message = MSG_RES.getString("com.sygate.scm.console.ui.ui", "CloudBanner.label.unenrolled.message");
            this.actionButton.setText(UIText.get(1033));
            this.actionType = 1;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(message);
        while (buf.length() < 130) {
            buf.append(" ");
        }
        this.messageLabel.setText(buf.toString());
    }
}

