/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.ServerSystemLog;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.ErrorMsg;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ServerSystemLogAdapter
extends LogAdapterBase<ServerSystemLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, SITE_NAME, SERVER_NAME, SEVERITY, DESCRIPTION, ERROR_MSG};

    public ServerSystemLogAdapter(Vector<ServerSystemLog> serverSystemLogRows) {
        super(columnNames, serverSystemLogRows);
    }

    public ServerSystemLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(ServerSystemLog logRow) {
        ImageIcon icon = null;
        Integer severityObj = logRow.getSeverity();
        if (severityObj != null) {
            int severity = severityObj;
            if (severity == Level.SEVERE.intValue()) {
                icon = ConsoleMain.systemErrorIcon;
            } else if (severity == Level.WARNING.intValue()) {
                icon = ConsoleMain.systemWarningIcon;
            } else if (severity == Level.INFO.intValue()) {
                icon = ConsoleMain.systemInfoIcon;
            } else if (severity == Level.CONFIG.intValue()) {
                icon = ConsoleMain.systemInfoIcon;
            } else if (severity == Level.FINE.intValue()) {
                icon = ConsoleMain.systemInfoIcon;
            } else if (severity == Level.FINER.intValue()) {
                icon = ConsoleMain.systemInfoIcon;
            } else if (severity == Level.FINEST.intValue()) {
                icon = ConsoleMain.systemInfoIcon;
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(ServerSystemLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getTimeStamp()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"ServerSystemLog", (Integer)logRow.getEventId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(LogSeverityDescription.getDescription((String)"ServerSystemLog", (Integer)logRow.getSeverity()));
        rowData.add(logRow.getOptEventDesc());
        String msg = ErrorMsg.getMessage((int)logRow.getOptMsgId());
        if (msg == null) {
            msg = "";
        }
        rowData.add(msg);
        return rowData;
    }

    @Override
    protected ServerSystemLog getLog(String[] input) {
        ServerSystemLog log = new ServerSystemLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setUSN(Long.valueOf(input[1]));
        log.setOptDomainId(input[2]);
        log.setSiteId(input[3]);
        log.setServerId(input[4]);
        log.setTimeStamp(Long.valueOf(input[5]));
        log.setSeverity(Integer.valueOf(input[6]));
        log.setOptEventDesc(input[7]);
        log.setOptMsgId(Integer.valueOf(input[8]));
        log.setOptErrorCode(Integer.valueOf(input[9]));
        log.setOptStackTrace(input[10]);
        return log;
    }
}

