/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.ServerPolicyLog;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ServerPolicyLogAdapter
extends LogAdapterBase<ServerPolicyLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, POLICY_NAME, DOMAIN_NAME, SITE_NAME, SERVER_NAME, ADMIN_NAME, DESCRIPTION};

    public ServerPolicyLogAdapter(Vector<ServerPolicyLog> serverPolicyLogRows) {
        super(columnNames, serverPolicyLogRows);
    }

    public ServerPolicyLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(ServerPolicyLog logRow) {
        ImageIcon icon = null;
        Integer eventIdObj = logRow.getEventId();
        if (eventIdObj != null) {
            int eventId = eventIdObj;
            switch (eventId) {
                case 0: {
                    icon = ConsoleMain.policyAddIcon;
                    break;
                }
                case 2: {
                    icon = ConsoleMain.policyEditIcon;
                    break;
                }
                case 1: {
                    icon = ConsoleMain.policyDeleteIcon;
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(ServerPolicyLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getTimeStamp()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"ServerPolicyLog", (Integer)logRow.getEventId()));
        rowData.add(this.getValueForID(logRow.getObjectId()));
        rowData.add(this.getValueForID(logRow.getOptDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(this.getValueForID(logRow.getAdminId()));
        rowData.add(logRow.getOptEventDesc());
        return rowData;
    }

    @Override
    protected ServerPolicyLog getLog(String[] input) {
        ServerPolicyLog log = new ServerPolicyLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setUSN(Long.valueOf(input[1]));
        log.setOptDomainId(input[2]);
        log.setSiteId(input[3]);
        log.setServerId(input[4]);
        log.setTimeStamp(Long.valueOf(input[5]));
        log.setObjectId(input[6]);
        log.setAdminId(input[7]);
        log.setOptEventDesc(input[8]);
        return log;
    }
}

