/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.ServerEnforcerLog;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ServerEnforcerLogAdapter
extends LogAdapterBase<ServerEnforcerLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, ENFORCER_NAME, SITE_NAME, SERVER_NAME};

    public ServerEnforcerLogAdapter(Vector<ServerEnforcerLog> serverEnforcerLogRows) {
        super(columnNames, serverEnforcerLogRows);
    }

    public ServerEnforcerLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(ServerEnforcerLog logRow) {
        ImageIcon icon = null;
        Integer eventIdObj = logRow.getEventId();
        if (eventIdObj != null) {
            int eventId = eventIdObj;
            switch (eventId) {
                case 1: {
                    icon = ConsoleMain.enforcerActivityAuthIcon;
                    break;
                }
                case 2: {
                    icon = ConsoleMain.enforcerActivityErrorIcon;
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 12: {
                    icon = ConsoleMain.enforcerActivityDownpolIcon;
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(ServerEnforcerLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getTimeStamp()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"ServerEnforcerLog", (Integer)logRow.getEventId()));
        rowData.add(this.getValueForID(logRow.getEnforcerId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        return rowData;
    }

    @Override
    protected ServerEnforcerLog getLog(String[] input) {
        ServerEnforcerLog log = new ServerEnforcerLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setUSN(Long.valueOf(input[1]));
        log.setSiteId(input[2]);
        log.setServerId(input[3]);
        log.setTimeStamp(Long.valueOf(input[4]));
        log.setEnforcerId(input[5]);
        return log;
    }
}

