/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.ServerClientLog;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ServerClientLogAdapter
extends LogAdapterBase<ServerClientLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, DOMAIN_NAME, SITE_NAME, SERVER_NAME, HOST_NAME, USER_NAME, USER_DOMAIN_NAME};

    public ServerClientLogAdapter(Vector<ServerClientLog> serverClientLogRows) {
        super(columnNames, serverClientLogRows);
    }

    public ServerClientLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(ServerClientLog logRow) {
        ImageIcon icon = null;
        Integer eventIdObj = logRow.getEventId();
        if (eventIdObj != null) {
            int eventId = eventIdObj;
            switch (eventId) {
                case 1: 
                case 14: {
                    icon = ConsoleMain.clientActivityAuthenticateIcon;
                    break;
                }
                case 2: 
                case 10: 
                case 13: {
                    icon = ConsoleMain.clientActivityErrorIcon;
                    break;
                }
                case 3: {
                    icon = ConsoleMain.clientActivityConnectIcon;
                    break;
                }
                case 4: {
                    icon = ConsoleMain.clientActivityDisconnectIcon;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 15: {
                    icon = ConsoleMain.clientActivityDownloadpolIcon;
                    break;
                }
                case 8: {
                    icon = ConsoleMain.clientActivityUpdateagentIcon;
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(ServerClientLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getTimeStamp()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"ServerClientLog", (Integer)logRow.getEventId()));
        rowData.add(this.getValueForID(logRow.getOptDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(logRow.getOptHostName());
        rowData.add(logRow.getOptUserName());
        rowData.add(logRow.getOptDomainName());
        return rowData;
    }

    @Override
    protected ServerClientLog getLog(String[] input) {
        ServerClientLog log = new ServerClientLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setUSN(Long.valueOf(input[1]));
        log.setOptDomainId(input[2]);
        log.setSiteId(input[3]);
        log.setServerId(input[4]);
        log.setTimeStamp(Long.valueOf(input[5]));
        log.setAgentId(input[6]);
        log.setOptHostName(input[7]);
        log.setOptUserName(input[8]);
        log.setOptDomainName(input[9]);
        return log;
    }
}

