/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.ServerAdminLog;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.ErrorMsg;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ServerAdminLogAdapter
extends LogAdapterBase<ServerAdminLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, DOMAIN_NAME, SITE_NAME, SERVER_NAME, SEVERITY, ADMIN_NAME, DESCRIPTION, ERROR_MSG};

    public ServerAdminLogAdapter(Vector<ServerAdminLog> serverAdminLogRows) {
        super(columnNames, serverAdminLogRows);
    }

    public ServerAdminLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(ServerAdminLog logRow) {
        ImageIcon icon = null;
        Integer eventIdObj = logRow.getEventId();
        if (eventIdObj != null) {
            int eventId = eventIdObj;
            switch (eventId) {
                case 4097: {
                    icon = ConsoleMain.adminConnectIcon;
                    break;
                }
                case 4098: {
                    icon = ConsoleMain.adminErrorIcon;
                    break;
                }
                case 4099: {
                    icon = ConsoleMain.adminDisconnectIcon;
                    break;
                }
                default: {
                    icon = ConsoleMain.adminConfigIcon;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(ServerAdminLog row) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(row.getTimeStamp()), this.getLogIcon(row)));
        rowData.add(LogEventDescription.getDescription((String)"ServerAdminLog", (Integer)row.getEventId()));
        rowData.add(this.getValueForID(row.getOptDomainId()));
        rowData.add(this.getValueForID(row.getSiteId()));
        rowData.add(this.getValueForID(row.getServerId()));
        rowData.add(LogSeverityDescription.getDescription((String)"ServerAdminLog", (Integer)row.getSeverity()));
        rowData.add(row.getAdminName());
        rowData.add(row.getOptEventDesc());
        String msg = ErrorMsg.getMessage((int)row.getOptMsgId());
        if (msg == null) {
            msg = "";
        }
        rowData.add(msg);
        return rowData;
    }

    @Override
    protected ServerAdminLog getLog(String[] input) {
        ServerAdminLog log = new ServerAdminLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setUSN(Long.valueOf(input[1]));
        log.setOptDomainId(input[2]);
        log.setSiteId(input[3]);
        log.setServerId(input[4]);
        log.setTimeStamp(Long.valueOf(input[5]));
        log.setSeverity(Integer.valueOf(input[6]));
        log.setAdminName(input[7]);
        log.setOptEventDesc(input[8]);
        log.setOptMsgId(Integer.valueOf(input[9]));
        log.setOptErrorCode(Integer.valueOf(input[10]));
        log.setOptStackTrace(input[11]);
        return log;
    }
}

