/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableColumnHeader;
import com.sygate.scm.common.configobject.table.SemTableHeader;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class LogUtilities {
    private static Hashtable<String, String> nameHash = new Hashtable();
    private static String domainId;
    private static Hashtable<String, String> conditionHash;

    public static String getValueForID(String id) {
        if (id == null || id.trim().length() == 0) {
            return id;
        }
        if (nameHash != null && nameHash.containsKey(id)) {
            return nameHash.get(id);
        }
        SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
        String currentDomainId = loginInfo.getOptDomainGUID();
        if (!LogUtilities.areSame(domainId, currentDomainId)) {
            LogUtilities.initialize();
        }
        if (nameHash != null && nameHash.containsKey(id)) {
            return nameHash.get(id);
        }
        return LogUtilities.getValueForIDFromDatabase(id);
    }

    public static void resetIDNameMap() {
        domainId = null;
        nameHash.clear();
    }

    public static List<String> getIDForValue(String value, boolean isEqual) {
        ArrayList<String> ids = new ArrayList<String>();
        if (value == null || value.trim().length() == 0) {
            return ids;
        }
        value = value.trim();
        return LogUtilities.getIDForValueFromDatabase(value, isEqual);
    }

    public static List<String> getIDForValue(String idType, String operator, String value) {
        if (conditionHash.isEmpty()) {
            LogUtilities.initConditionHash();
        }
        if (value == null || value.trim().length() == 0) {
            return new ArrayList<String>();
        }
        return LogUtilities.getIDForValueFromDatabase(idType, operator, value);
    }

    private static boolean areSame(String one, String two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    private static String getValueForIDFromDatabase(String id) {
        String name = null;
        if (id == null) {
            return name;
        }
        try {
            RpcData rpc = new RpcData();
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)Utility.escapeSqlString((String)id.trim()));
            SemTable semTable = GUIManager.getSemTable(402, rpc, 0, 1);
            int rowCount = semTable.getSemTableRowCount();
            for (int i = 0; i < rowCount && (name = semTable.getSemTableRow(i).getSemTableValue(0).getValue()) == null; ++i) {
            }
            if (name == null) {
                name = id;
            }
            nameHash.put(id, name);
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return name;
    }

    private static List<String> getIDForValueFromDatabase(String value, boolean isEqual) {
        ArrayList<String> ids = new ArrayList<String>();
        return ids;
    }

    private static List<String> getIDForValueFromDatabase(String idType, String operator, String value) {
        ArrayList<String> ids = new ArrayList<String>();
        String id = null;
        try {
            RpcData rpc = LogUtilities.getIDQueryString(idType, operator, value);
            SemTable semTable = GUIManager.getSemTable(300, rpc, 0, 1000);
            for (int i = 0; i < semTable.getSemTableRowCount(); ++i) {
                id = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                ids.add(id);
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return ids;
    }

    private static RpcData getIDQueryString(String idType, String operator, String value) {
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"TABLE_NAME", (String)idType);
        value = value == null ? null : value.trim();
        String op = "LIKE";
        if (operator.equals("=") || operator.equals("!=")) {
            op = operator;
        }
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"TABLE_COLUMN_VALUE", (Integer)24, (String)op, (String)(value == null ? null : value.trim()));
        return rpc;
    }

    private static void initialize() {
        nameHash.clear();
        try {
            SemTable semTable;
            SemTableHeader header;
            SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
            domainId = loginInfo.getOptDomainGUID();
            RpcData rpc = new RpcData();
            int sqlType = 400;
            if (domainId != null && domainId.trim().length() > 0) {
                sqlType = 401;
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)domainId);
            }
            if ((header = (semTable = GUIManager.getSemTable(sqlType, rpc, 0, 1000)).getOptSemTableHeader()) != null) {
                SemTableColumnHeader columnOneHeader = header.getSemTableColumnHeader(0);
                String columnOneName = columnOneHeader.getColumnName();
                boolean idIndex = false;
                if (columnOneName == null || !columnOneName.equalsIgnoreCase("ID")) {
                    idIndex = true;
                }
                int rowCount = semTable.getSemTableRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    String name;
                    String id;
                    if (!idIndex) {
                        id = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                        name = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
                        if (id != null) {
                            nameHash.put(id, name);
                        }
                    }
                    if (!idIndex) continue;
                    id = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
                    name = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                    if (id == null) continue;
                    nameHash.put(id, name);
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private static void initConditionHash() {
        conditionHash.put("DOMAIN_ID", "SemDomain");
        conditionHash.put("SITE_ID", "SemSite");
        conditionHash.put("SERVER_ID", "SemServer");
        conditionHash.put("GROUP_ID", "SemClientGroup");
        conditionHash.put("ENFORCER_ID", "SemEnforcer");
        conditionHash.put("ADMIN_ID", "SemAdministrator");
        conditionHash.put("OBJECT_ID", "FwFirewallPolicy HiHostIntegrityPolicy OpAppProtectionPolicy SemAgentPolicy FwIdsLibrary SemServerList");
    }

    static {
        conditionHash = new Hashtable();
    }
}

