/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.LogTableColumnName;
import com.sygate.scm.console.ui.monitoring.logviewer.LogUtilities;
import com.sygate.scm.util.CSVReader;
import com.sygate.scm.util.LoggerUtilities;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class LogAdapterBase<T>
implements LogAdapter,
LogTableColumnName {
    protected int viewType = 0;
    private Vector<T> logRows;
    private String[] columnNames;
    private String[] lrViewColumnNames;
    private String[] sdViewColumnNames;
    private List<List<Object>> data = new ArrayList<List<Object>>();
    private CSVReader csvReader;

    protected LogAdapterBase(String[] columnNames, Vector<T> logRows) {
        this(columnNames, columnNames, logRows);
    }

    protected LogAdapterBase(String[] lrViewColumnNames, String[] sdViewColumnNames, Vector<T> logRows) {
        this.initialize(lrViewColumnNames, sdViewColumnNames, logRows);
    }

    protected LogAdapterBase(String[] lrViewColumnNames, String[] sdViewColumnNames, InputStream inputStream) {
        try {
            this.csvReader = new CSVReader(inputStream, "", '`', false, null, true);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.columnNames = lrViewColumnNames;
        this.logRows = new Vector();
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames == null ? null : (String[])this.columnNames.clone();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        List<Object> rowData = this.data.get(row);
        return rowData.get(column);
    }

    @Override
    public List<List<Object>> getLogData() {
        return this.data;
    }

    @Override
    public void setViewType(int viewType) {
        if (this.viewType != viewType) {
            this.viewTypeChanged(viewType);
        }
    }

    @Override
    public Object[] getExportLogData(boolean isColumnNames, boolean isFirstRow) {
        if (this.csvReader == null) {
            return null;
        }
        if (isColumnNames) {
            return this.getColumnNames();
        }
        if (isFirstRow) {
            T log = this.getLog(this.csvReader.getColumnNames());
            return this.initData(log).toArray();
        }
        try {
            while (this.csvReader.next()) {
                List<String> input = this.getLine();
                try {
                    T log = this.getLog(this.toStringArray(input));
                    return this.initData(log).toArray();
                }
                catch (Exception e) {
                    this.csvReader.next();
                    List<String> new_input = this.getLine();
                    try {
                        T log = this.getLog(this.toStringArray(new_input));
                        return this.initData(log).toArray();
                    }
                    catch (Exception e1) {
                        try {
                            String strTmp = input.remove(input.size() - 1) + new_input.remove(0);
                            input.add(strTmp);
                            input.addAll(new_input);
                            T log = this.getLog(this.toStringArray(input));
                            return this.initData(log).toArray();
                        }
                        catch (Exception e2) {
                        }
                    }
                }
            }
        }
        catch (SQLException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.csvReader.close();
        return null;
    }

    private List<String> getLine() {
        String str;
        ArrayList<String> input = new ArrayList<String>();
        int index = 0;
        while ((str = this.csvReader.getValueByColumnIndex(index++)) != null) {
            input.add(str);
        }
        return input;
    }

    protected String getValueForID(String ID) {
        return LogUtilities.getValueForID(ID);
    }

    protected void viewTypeChanged(int viewType) {
        this.viewType = viewType;
        this.resetColumnNames(viewType);
        this.resetData();
    }

    protected abstract List<Object> initData(T var1);

    protected abstract T getLog(String[] var1);

    private void initialize(String[] lrViewColumnNames, String[] sdViewColumnNames, Vector<T> logRows) {
        this.lrViewColumnNames = lrViewColumnNames;
        this.sdViewColumnNames = sdViewColumnNames;
        this.logRows = logRows;
        this.viewTypeChanged(this.viewType);
    }

    private void resetColumnNames(int viewType) {
        this.columnNames = viewType == 0 ? this.lrViewColumnNames : this.sdViewColumnNames;
    }

    private void resetData() {
        this.data.clear();
        for (int i = 0; i < this.logRows.size(); ++i) {
            this.data.add(this.initData(this.logRows.get(i)));
        }
    }

    private String[] toStringArray(List<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }
}

