/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.EnforcerTrafficLog;
import com.sygate.scm.common.log.LogActionDescription;
import com.sygate.scm.common.log.LogAlertDescription;
import com.sygate.scm.common.log.LogEnforcerTypeDescription;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogNetworkProtocolDescription;
import com.sygate.scm.common.log.LogTrafficDirectionDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EnforcerTrafficLogAdapter
extends LogAdapterBase<EnforcerTrafficLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, ENFORCER_NAME, ENFORCER_TYPE, SITE_NAME, LOCAL_HOST_IP, REMOTE_HOST_IP, NETWORK_PROTOCOL, LOCAL_PORT, REMOTE_PORT, TRAFFIC_DIRECTION, BLOCKED, REPETITION, ALERT};

    public EnforcerTrafficLogAdapter(Vector<EnforcerTrafficLog> enforcerTrafficLogRows) {
        super(columnNames, enforcerTrafficLogRows);
    }

    public EnforcerTrafficLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(EnforcerTrafficLog logRow) {
        ImageIcon icon = null;
        Integer blockedObj = logRow.getBlocked();
        Integer directionObj = logRow.getTrafficDirection();
        if (blockedObj != null && directionObj != null) {
            int blocked = blockedObj;
            int direction = directionObj;
            block0 : switch (blocked) {
                case 0: {
                    switch (direction) {
                        case 0: {
                            icon = ConsoleMain.trafficAllowedUnknownIcon;
                            break block0;
                        }
                        case 1: {
                            icon = ConsoleMain.trafficAllowedIncomingIcon;
                            break block0;
                        }
                        case 2: {
                            icon = ConsoleMain.trafficAllowedOutgoingIcon;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (direction) {
                        case 0: {
                            icon = ConsoleMain.trafficBlockedUnknownIcon;
                            break block0;
                        }
                        case 1: {
                            icon = ConsoleMain.trafficBlockedIncomingIcon;
                            break block0;
                        }
                        case 2: {
                            icon = ConsoleMain.trafficBlockedOutgoingIcon;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(EnforcerTrafficLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"EnforcerTrafficLog", (Integer)logRow.getOptEventId()));
        rowData.add(this.getValueForID(logRow.getEnforcerId()));
        rowData.add(LogEnforcerTypeDescription.getDescription((Integer)logRow.getEnforcerType()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(Utility.getIPString((long)logRow.getLocalHostIP()));
        rowData.add(Utility.getIPString((long)logRow.getRemoteHostIP()));
        rowData.add(LogNetworkProtocolDescription.getDescription((Integer)logRow.getNetworkProtocol()));
        rowData.add(logRow.getLocalPort());
        rowData.add(logRow.getRemotePort());
        rowData.add(LogTrafficDirectionDescription.getDescription((Integer)logRow.getTrafficDirection()));
        rowData.add(LogActionDescription.getDescription((boolean)false, (Integer)logRow.getBlocked()));
        rowData.add(logRow.getOptRepetition());
        rowData.add(LogAlertDescription.getDescription((Integer)logRow.getAlert()));
        return rowData;
    }

    @Override
    protected EnforcerTrafficLog getLog(String[] input) {
        EnforcerTrafficLog log = new EnforcerTrafficLog();
        log.setUSN(Long.valueOf(input[0]));
        log.setDomainId(input[1]);
        log.setSiteId(input[2]);
        log.setTimeStamp(Long.valueOf(input[3]));
        log.setOptEventId(Integer.valueOf(input[4]));
        log.setEventTime(Long.valueOf(input[5]));
        log.setEnforcerId(input[6]);
        log.setEnforcerType(Integer.valueOf(input[7]));
        log.setOptClientId(input[8]);
        log.setLocalHostIP(Long.valueOf(input[9]));
        log.setRemoteHostIP(Long.valueOf(input[10]));
        log.setNetworkProtocol(Integer.valueOf(input[11]));
        log.setLocalPort(Integer.valueOf(input[12]));
        log.setRemotePort(Integer.valueOf(input[13]));
        log.setTrafficDirection(Integer.valueOf(input[14]));
        log.setOptBeginTime(Long.valueOf(input[15]));
        log.setOptEndTime(Long.valueOf(input[16]));
        log.setBlocked(Integer.valueOf(input[17]));
        log.setTotalBytes(Integer.valueOf(input[18]));
        log.setOptRepetition(Integer.valueOf(input[19]));
        log.setAlert(Integer.valueOf(input[20]));
        return log;
    }
}

