/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.EnforcerSystemLog;
import com.sygate.scm.common.log.LogEnforcerTypeDescription;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EnforcerSystemLogAdapter
extends LogAdapterBase<EnforcerSystemLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, ENFORCER_NAME, ENFORCER_TYPE, SITE_NAME, SEVERITY, DESCRIPTION};

    public EnforcerSystemLogAdapter(Vector<EnforcerSystemLog> enforcerSystemLogRows) {
        super(columnNames, enforcerSystemLogRows);
    }

    public EnforcerSystemLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(EnforcerSystemLog logRow) {
        ImageIcon icon = null;
        Integer severityObj = logRow.getSeverity();
        if (severityObj != null) {
            int severity = severityObj;
            switch (severity) {
                case 1: {
                    icon = ConsoleMain.systemWarningIcon;
                    break;
                }
                case 2: {
                    icon = ConsoleMain.systemErrorIcon;
                    break;
                }
                case 3: {
                    icon = ConsoleMain.systemFatalIcon;
                    break;
                }
                case 0: {
                    icon = ConsoleMain.systemInfoIcon;
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(EnforcerSystemLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"EnforcerSystemLog", (Integer)logRow.getOptEventId()));
        rowData.add(this.getValueForID(logRow.getEnforcerId()));
        rowData.add(LogEnforcerTypeDescription.getDescription((Integer)logRow.getEnforcerType()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(LogSeverityDescription.getDescription((String)"EnforcerSystemLog", (Integer)logRow.getSeverity()));
        rowData.add(logRow.getOptEventDesc());
        return rowData;
    }

    @Override
    protected EnforcerSystemLog getLog(String[] input) {
        EnforcerSystemLog log = new EnforcerSystemLog();
        log.setUSN(Long.valueOf(input[0]));
        log.setSiteId(input[1]);
        log.setTimeStamp(Long.valueOf(input[2]));
        log.setOptEventId(Integer.valueOf(input[3]));
        log.setEventTime(Long.valueOf(input[4]));
        log.setEnforcerId(input[5]);
        log.setEnforcerType(Integer.valueOf(input[6]));
        log.setSeverity(Integer.valueOf(input[7]));
        log.setOptEventDesc(input[8]);
        return log;
    }
}

