/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.EnforcerClientLog;
import com.sygate.scm.common.log.LogEnforcerTypeDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EnforcerClientLogAdapter
extends LogAdapterBase<EnforcerClientLog> {
    private static final String[] columnNames = new String[]{TIME, ENFORCER_NAME, ENFORCER_TYPE, SITE_NAME, CLIENT_NAME, DESCRIPTION, ACTION_NAME, REMOTE_MAC, REMOTE_INFO, EXTENDED_INFO};

    public EnforcerClientLogAdapter(Vector<EnforcerClientLog> enforcerClientLogRows) {
        super(columnNames, enforcerClientLogRows);
    }

    public EnforcerClientLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(EnforcerClientLog logRow) {
        ImageIcon icon = null;
        String action = logRow.getOptAction();
        if ("Authenticated".equalsIgnoreCase(action)) {
            icon = ConsoleMain.enforcerClactivityAuthIcon;
        } else if ("Rejected".equalsIgnoreCase(action)) {
            icon = ConsoleMain.enforcerClactivityRejectIcon;
        } else if ("Disconnected".equalsIgnoreCase(action)) {
            icon = ConsoleMain.enforcerClactivityDisconnIcon;
        } else if ("Passed".equalsIgnoreCase(action)) {
            icon = ConsoleMain.enforcerClactivityPassedIcon;
        } else if ("Failed".equalsIgnoreCase(action)) {
            icon = ConsoleMain.enforcerClactivityFailedIcon;
        }
        return icon;
    }

    protected ArrayList<Object> initData(EnforcerClientLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(this.getValueForID(logRow.getEnforcerId()));
        rowData.add(LogEnforcerTypeDescription.getDescription((Integer)logRow.getEnforcerType()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(logRow.getOptRemoteHost());
        rowData.add(logRow.getOptEventDesc());
        rowData.add(logRow.getOptAction());
        rowData.add(logRow.getOptRemoteHostMac());
        rowData.add(logRow.getOptRemoteHostInfo());
        rowData.add(logRow.getOptExtendedInfo());
        return rowData;
    }

    @Override
    protected EnforcerClientLog getLog(String[] input) {
        EnforcerClientLog log = new EnforcerClientLog();
        log.setUSN(Long.valueOf(input[0]));
        log.setDomainId(input[1]);
        log.setSiteId(input[2]);
        log.setTimeStamp(Long.valueOf(input[3]));
        log.setEventId(Integer.valueOf(input[4]));
        log.setEventTime(Long.valueOf(input[5]));
        log.setEnforcerId(input[6]);
        log.setEnforcerType(Integer.valueOf(input[7]));
        log.setOptClientId(input[8]);
        log.setOptRemoteHost(input[9]);
        log.setOptAction(input[10]);
        log.setPeriod(Integer.valueOf(input[11]));
        log.setOptEventDesc(input[12]);
        log.setOptRemoteHostMac(input[13]);
        log.setOptRemoteHostInfo(input[14]);
        log.setOptExtendedInfo(input[15]);
        return log;
    }
}

