/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.AgentTrafficLog;
import com.sygate.scm.common.log.LogActionDescription;
import com.sygate.scm.common.log.LogAlertDescription;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogNetworkProtocolDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.common.log.LogTrafficDirectionDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AgentTrafficLogAdapter
extends LogAdapterBase<AgentTrafficLog> {
    private static final String[] localRemoteColumnNames = new String[]{TIME, EVENT_TYPE, BLOCKED, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, SEVERITY, TRAFFIC_DIRECTION, NETWORK_PROTOCOL, LOCAL_HOST_NAME, LOCAL_HOST_IP, LOCAL_MAC, LOCAL_PORT, REMOTE_HOST_NAME, REMOTE_HOST_IP, REMOTE_MAC, REMOTE_PORT, APP_NAME, USER_NAME, USER_DOMAIN_NAME, LOCATION_NAME, REPETITION, BEGIN_TIME, END_TIME, RULE_NAME, ALERT};
    private static final String[] sourceDestinationColumnNames = new String[]{TIME, EVENT_TYPE, BLOCKED, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, SEVERITY, TRAFFIC_DIRECTION, NETWORK_PROTOCOL, SOURCE_HOST_NAME, SOURCE_HOST_IP, SOURCE_MAC, SOURCE_PORT, DESTINATION_HOST_NAME, DESTINATION_HOST_IP, DESTINATION_MAC, DESTINATION_PORT, APP_NAME, USER_NAME, USER_DOMAIN_NAME, LOCATION_NAME, REPETITION, BEGIN_TIME, END_TIME, RULE_NAME, ALERT};

    public AgentTrafficLogAdapter(Vector<AgentTrafficLog> agentTrafficLogRows) {
        super(localRemoteColumnNames, sourceDestinationColumnNames, agentTrafficLogRows);
    }

    public AgentTrafficLogAdapter(InputStream inputStream) {
        super(localRemoteColumnNames, sourceDestinationColumnNames, inputStream);
    }

    protected Icon getLogIcon(AgentTrafficLog logRow) {
        ImageIcon icon = null;
        Integer blockedObj = logRow.getOptBlocked();
        Integer directionObj = logRow.getOptTrafficDirection();
        if (blockedObj != null && directionObj != null) {
            int blocked = blockedObj;
            int direction = directionObj;
            block0 : switch (blocked) {
                case 0: {
                    switch (direction) {
                        case 0: {
                            icon = ConsoleMain.trafficAllowedUnknownIcon;
                            break block0;
                        }
                        case 1: {
                            icon = ConsoleMain.trafficAllowedIncomingIcon;
                            break block0;
                        }
                        case 2: {
                            icon = ConsoleMain.trafficAllowedOutgoingIcon;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (direction) {
                        case 0: {
                            icon = ConsoleMain.trafficBlockedUnknownIcon;
                            break block0;
                        }
                        case 1: {
                            icon = ConsoleMain.trafficBlockedIncomingIcon;
                            break block0;
                        }
                        case 2: {
                            icon = ConsoleMain.trafficBlockedOutgoingIcon;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(AgentTrafficLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"AgentTrafficLog", (Integer)logRow.getEventId()));
        rowData.add(LogActionDescription.getDescription((boolean)true, (Integer)logRow.getOptBlocked()));
        rowData.add(this.getValueForID(logRow.getDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(this.getValueForID(logRow.getGroupId()));
        rowData.add(LogSeverityDescription.getDescription((String)"AgentSecurityLog", (Integer)logRow.getSeverity()));
        String trafficDirection = LogTrafficDirectionDescription.getDescription((Integer)logRow.getOptTrafficDirection());
        rowData.add(trafficDirection);
        rowData.add(LogNetworkProtocolDescription.getDescription((Integer)logRow.getOptNetworkProtocol()));
        if (this.viewType == 1 && trafficDirection.equals("Inbound")) {
            rowData.add(logRow.getOptRemoteHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptRemoteHostIP()));
            rowData.add(logRow.getOptRemoteHostMac());
            rowData.add(logRow.getOptRemotePort());
            rowData.add(logRow.getOptHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptLocalHostIP()));
            rowData.add(logRow.getOptLocalHostMac());
            rowData.add(logRow.getOptLocalPort());
        } else {
            rowData.add(logRow.getOptHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptLocalHostIP()));
            rowData.add(logRow.getOptLocalHostMac());
            rowData.add(logRow.getOptLocalPort());
            rowData.add(logRow.getOptRemoteHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptRemoteHostIP()));
            rowData.add(logRow.getOptRemoteHostMac());
            rowData.add(logRow.getOptRemotePort());
        }
        rowData.add(logRow.getOptAppName());
        rowData.add(logRow.getOptUserName());
        rowData.add(logRow.getOptDomainName());
        rowData.add(logRow.getOptLocationName());
        rowData.add(logRow.getOptRepetition());
        rowData.add(UIUtilities.formatDate(logRow.getOptBeginTime()));
        rowData.add(UIUtilities.formatDate(logRow.getOptEndTime()));
        rowData.add(logRow.getOptRuleName());
        rowData.add(LogAlertDescription.getDescription((Integer)logRow.getOptAlert()));
        return rowData;
    }

    @Override
    protected AgentTrafficLog getLog(String[] input) {
        AgentTrafficLog log = new AgentTrafficLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setEventTime(Long.valueOf(input[1]));
        log.setUSN(Long.valueOf(input[2]));
        log.setDomainId(input[3]);
        log.setSiteId(input[4]);
        log.setServerId(input[5]);
        log.setGroupId(input[6]);
        log.setComputerId(input[7]);
        log.setTimeStamp(Long.valueOf(input[8]));
        log.setSeverity(Integer.valueOf(input[9]));
        log.setOptAgentId(input[10]);
        log.setOptHardwareKey(input[11]);
        log.setOptHostName(input[12]);
        log.setOptLocalHostIP(Long.valueOf(input[13]));
        log.setOptRemoteHostIP(Long.valueOf(input[14]));
        log.setOptRemoteHostName(input[15]);
        log.setOptNetworkProtocol(Integer.valueOf(input[16]));
        log.setOptLocalPort(Integer.valueOf(input[17]));
        log.setOptRemotePort(Integer.valueOf(input[18]));
        log.setOptTrafficDirection(Integer.valueOf(input[19]));
        log.setOptBeginTime(Long.valueOf(input[20]));
        log.setOptEndTime(Long.valueOf(input[21]));
        log.setOptRepetition(Integer.valueOf(input[22]));
        log.setOptAppName(input[23]);
        log.setOptBlocked(Integer.valueOf(input[24]));
        log.setOptRuleId(input[25]);
        log.setOptRuleName(input[26]);
        log.setOptAlert(Integer.valueOf(input[27]));
        log.setOptSendSnmpTrap(Integer.valueOf(input[28]));
        log.setOptLocalHostMac(input[29]);
        log.setOptRemoteHostMac(input[30]);
        log.setOptLocationName(input[31]);
        log.setOptUserName(input[32]);
        log.setOptDomainName(input[33]);
        return log;
    }
}

