/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.AgentSystemLog;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AgentSystemLogAdapter
extends LogAdapterBase<AgentSystemLog> {
    private static final String[] columnNames = new String[]{TIME, EVENT_TYPE, SUMMARY, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, SEVERITY, HOST_NAME, EVENT_SOURCE};

    public AgentSystemLogAdapter(Vector<AgentSystemLog> agentSystemLogRows) {
        super(columnNames, agentSystemLogRows);
    }

    public AgentSystemLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(AgentSystemLog logRow) {
        ImageIcon icon = null;
        Integer severityObj = logRow.getSeverity();
        if (severityObj != null) {
            int severity = severityObj;
            switch (severity) {
                case 1: {
                    icon = ConsoleMain.systemWarningIcon;
                    break;
                }
                case 2: {
                    icon = ConsoleMain.systemErrorIcon;
                    break;
                }
                case 3: {
                    icon = ConsoleMain.systemFatalIcon;
                    break;
                }
                case 0: {
                    icon = ConsoleMain.systemInfoIcon;
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(AgentSystemLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"AgentSystemLog", (Integer)logRow.getEventId()));
        rowData.add(logRow.getOptEventDesc());
        rowData.add(this.getValueForID(logRow.getDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(this.getValueForID(logRow.getGroupId()));
        rowData.add(LogSeverityDescription.getDescription((String)"AgentSystemLog", (Integer)logRow.getSeverity()));
        rowData.add(logRow.getOptHostName());
        rowData.add(logRow.getEventSource());
        return rowData;
    }

    @Override
    protected AgentSystemLog getLog(String[] input) {
        AgentSystemLog log = new AgentSystemLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setEventTime(Long.valueOf(input[1]));
        log.setUSN(Long.valueOf(input[2]));
        log.setDomainId(input[3]);
        log.setSiteId(input[4]);
        log.setServerId(input[5]);
        log.setGroupId(input[6]);
        log.setComputerId(input[7]);
        log.setTimeStamp(Long.valueOf(input[8]));
        log.setSeverity(Integer.valueOf(input[9]));
        log.setOptAgentId(input[10]);
        log.setOptHardwareKey(input[11]);
        log.setOptHostName(input[12]);
        log.setOptCategory(Integer.valueOf(input[13]));
        log.setEventSource(input[14]);
        log.setOptEventDesc(input[15]);
        log.setOptSendSnmpTrap(Integer.valueOf(input[16]));
        return log;
    }
}

