/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.AgentSecurityLog;
import com.sygate.scm.common.log.HackTypeDescription;
import com.sygate.scm.common.log.LogAlertDescription;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogNetworkProtocolDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.common.log.LogTrafficDirectionDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AgentSecurityLogAdapter
extends LogAdapterBase<AgentSecurityLog> {
    private static final String[] localRemoteColumnNames = new String[]{TIME, EVENT_TYPE, DESCRIPTION, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, SEVERITY, TRAFFIC_DIRECTION, NETWORK_PROTOCOL, LOCAL_HOST_NAME, LOCAL_HOST_IP, LOCAL_MAC, REMOTE_HOST_NAME, REMOTE_HOST_IP, REMOTE_MAC, APP_NAME, USER_NAME, USER_DOMAIN_NAME, LOCATION_NAME, REPETITION, HACK_TYPE, BEGIN_TIME, END_TIME, ALERT};
    private static final String[] sourceDestinationColumnNames = new String[]{TIME, EVENT_TYPE, DESCRIPTION, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, SEVERITY, TRAFFIC_DIRECTION, NETWORK_PROTOCOL, SOURCE_HOST_NAME, SOURCE_HOST_IP, SOURCE_MAC, DESTINATION_HOST_NAME, DESTINATION_HOST_IP, DESTINATION_MAC, APP_NAME, USER_NAME, USER_DOMAIN_NAME, LOCATION_NAME, REPETITION, HACK_TYPE, BEGIN_TIME, END_TIME, ALERT};

    public AgentSecurityLogAdapter(Vector<AgentSecurityLog> agentSecurityLogVector) {
        super(localRemoteColumnNames, sourceDestinationColumnNames, agentSecurityLogVector);
    }

    public AgentSecurityLogAdapter(InputStream inputStream) {
        super(localRemoteColumnNames, sourceDestinationColumnNames, inputStream);
    }

    protected Icon getLogIcon(AgentSecurityLog logRow) {
        ImageIcon icon = null;
        Integer severityObj = logRow.getSeverity();
        if (severityObj != null) {
            int severity = severityObj;
            if (severity >= 0 && severity <= 3) {
                icon = ConsoleMain.securityCriticalIcon;
            } else if (severity >= 4 && severity <= 7) {
                icon = ConsoleMain.securityMajorIcon;
            } else if (severity >= 8 && severity <= 11) {
                icon = ConsoleMain.securityMinorIcon;
            } else if (severity >= 12 && severity <= 15) {
                icon = ConsoleMain.securityInfoIcon;
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(AgentSecurityLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"AgentSecurityLog", (Integer)logRow.getEventId()));
        rowData.add(logRow.getOptEventDesc());
        rowData.add(this.getValueForID(logRow.getDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(this.getValueForID(logRow.getGroupId()));
        rowData.add(LogSeverityDescription.getDescription((String)"AgentSecurityLog", (Integer)logRow.getSeverity()));
        String trafficDirection = LogTrafficDirectionDescription.getDescription((Integer)logRow.getOptTrafficDirection());
        rowData.add(trafficDirection);
        rowData.add(LogNetworkProtocolDescription.getDescription((Integer)logRow.getOptNetworkProtocol()));
        if (this.viewType == 1 && trafficDirection.equals("Inbound")) {
            rowData.add(logRow.getOptRemoteHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptRemoteHostIP()));
            rowData.add(logRow.getOptRemoteHostMac());
            rowData.add(logRow.getOptHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptLocalHostIP()));
            rowData.add(logRow.getOptLocalHostMac());
        } else {
            rowData.add(logRow.getOptHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptLocalHostIP()));
            rowData.add(logRow.getOptLocalHostMac());
            rowData.add(logRow.getOptRemoteHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptRemoteHostIP()));
            rowData.add(logRow.getOptRemoteHostMac());
        }
        rowData.add(logRow.getOptAppName());
        rowData.add(logRow.getOptUserName());
        rowData.add(logRow.getOptDomainName());
        rowData.add(logRow.getOptLocationName());
        rowData.add(logRow.getOptRepetition());
        rowData.add(HackTypeDescription.getDescription((Integer)logRow.getOptHackingType(), (Integer)logRow.getEventId()));
        rowData.add(UIUtilities.formatDate(logRow.getOptBeginTime()));
        rowData.add(UIUtilities.formatDate(logRow.getOptEndTime()));
        rowData.add(LogAlertDescription.getDescription((Integer)logRow.getOptAlert()));
        return rowData;
    }

    @Override
    protected AgentSecurityLog getLog(String[] input) {
        AgentSecurityLog log = new AgentSecurityLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setEventTime(Long.valueOf(input[1]));
        log.setUSN(Long.valueOf(input[2]));
        log.setDomainId(input[3]);
        log.setSiteId(input[4]);
        log.setServerId(input[5]);
        log.setGroupId(input[6]);
        log.setComputerId(input[7]);
        log.setTimeStamp(Long.valueOf(input[8]));
        log.setSeverity(Integer.valueOf(input[9]));
        log.setOptAgentId(input[10]);
        log.setOptHardwareKey(input[11]);
        log.setOptHostName(input[12]);
        log.setOptLocalHostIP(Long.valueOf(input[13]));
        log.setOptRemoteHostIP(Long.valueOf(input[14]));
        log.setOptRemoteHostName(input[15]);
        log.setOptTrafficDirection(Integer.valueOf(input[16]));
        log.setOptNetworkProtocol(Integer.valueOf(input[17]));
        log.setOptHackingType(Integer.valueOf(input[18]));
        log.setOptBeginTime(Long.valueOf(input[19]));
        log.setOptEndTime(Long.valueOf(input[20]));
        log.setOptRepetition(Integer.valueOf(input[21]));
        log.setOptAppName(input[22]);
        log.setOptEventDesc(input[23]);
        log.setOptAlert(Integer.valueOf(input[24]));
        log.setOptSendSnmpTrap(Integer.valueOf(input[25]));
        log.setOptLocalHostMac(input[26]);
        log.setOptRemoteHostMac(input[27]);
        log.setOptLocationName(input[28]);
        log.setOptUserName(input[29]);
        log.setOptDomainName(input[30]);
        return log;
    }
}

