/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.AgentPacketLog;
import com.sygate.scm.common.log.LogActionDescription;
import com.sygate.scm.common.log.LogAlertDescription;
import com.sygate.scm.common.log.LogEventDescription;
import com.sygate.scm.common.log.LogTrafficDirectionDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;

public class AgentPacketLogAdapter
extends LogAdapterBase<AgentPacketLog> {
    private static final String[] localRemoteColumnNames = new String[]{TIME, EVENT_TYPE, BLOCKED, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, LOCAL_HOST_NAME, LOCAL_HOST_IP, LOCAL_PORT, REMOTE_HOST_NAME, REMOTE_HOST_IP, REMOTE_PORT, TRAFFIC_DIRECTION, APP_NAME, ALERT};
    private static final String[] sourceDestinationColumnNames = new String[]{TIME, EVENT_TYPE, BLOCKED, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, SOURCE_HOST_NAME, SOURCE_HOST_IP, SOURCE_PORT, DESTINATION_HOST_NAME, DESTINATION_HOST_IP, DESTINATION_PORT, TRAFFIC_DIRECTION, APP_NAME, ALERT};

    public AgentPacketLogAdapter(Vector<AgentPacketLog> agentPacketLogVector) {
        super(localRemoteColumnNames, sourceDestinationColumnNames, agentPacketLogVector);
    }

    public AgentPacketLogAdapter(InputStream inputStream) {
        super(localRemoteColumnNames, sourceDestinationColumnNames, inputStream);
    }

    protected Icon getLogIcon(AgentPacketLog logRow) {
        return ConsoleMain.packetIcon;
    }

    protected ArrayList<Object> initData(AgentPacketLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(LogEventDescription.getDescription((String)"AgentPacketLog", (Integer)logRow.getEventId()));
        rowData.add(LogActionDescription.getDescription((boolean)true, (Integer)logRow.getBlocked()));
        rowData.add(this.getValueForID(logRow.getDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(this.getValueForID(logRow.getGroupId()));
        String trafficDirection = LogTrafficDirectionDescription.getDescription((Integer)logRow.getOptTrafficDirection());
        if (this.viewType == 1 && trafficDirection.equals("Inbound")) {
            rowData.add(logRow.getOptRemoteHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptRemoteHostIP()));
            rowData.add(logRow.getOptRemotePort());
            rowData.add(logRow.getOptHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptLocalHostIP()));
            rowData.add(logRow.getOptLocalPort());
        } else {
            rowData.add(logRow.getOptHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptLocalHostIP()));
            rowData.add(logRow.getOptLocalPort());
            rowData.add(logRow.getOptRemoteHostName());
            rowData.add(Utility.getIPString((long)logRow.getOptRemoteHostIP()));
            rowData.add(logRow.getOptRemotePort());
        }
        rowData.add(trafficDirection);
        rowData.add(logRow.getOptAppName());
        rowData.add(LogAlertDescription.getDescription((Integer)logRow.getOptAlert()));
        return rowData;
    }

    @Override
    protected AgentPacketLog getLog(String[] input) {
        AgentPacketLog log = new AgentPacketLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setEventTime(Long.valueOf(input[1]));
        log.setUSN(Long.valueOf(input[2]));
        log.setDomainId(input[3]);
        log.setSiteId(input[4]);
        log.setServerId(input[5]);
        log.setGroupId(input[6]);
        log.setComputerId(input[7]);
        log.setTimeStamp(Long.valueOf(input[8]));
        log.setOptAgentId(input[9]);
        log.setOptHardwareKey(input[10]);
        log.setOptHostName(input[11]);
        log.setOptLocalHostIP(Long.valueOf(input[12]));
        log.setOptRemoteHostIP(Long.valueOf(input[13]));
        log.setOptRemoteHostName(input[14]);
        log.setOptLocalPort(Integer.valueOf(input[15]));
        log.setOptRemotePort(Integer.valueOf(input[16]));
        log.setOptTrafficDirection(Integer.valueOf(input[17]));
        log.setBlocked(Integer.valueOf(input[18]));
        log.setOptAppName(input[19]);
        log.setOptAlert(Integer.valueOf(input[20]));
        log.setOptSendSnmpTrap(Integer.valueOf(input[21]));
        return log;
    }
}

