/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.logviewer;

import com.sygate.scm.common.configobject.table.AgentBehaviorLog;
import com.sygate.scm.common.log.AgentBehaviorTestModeDescription;
import com.sygate.scm.common.log.LogActionDescription;
import com.sygate.scm.common.log.LogSeverityDescription;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapterBase;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AgentBehaviorLogAdapter
extends LogAdapterBase<AgentBehaviorLog> {
    private static final String[] columnNames = new String[]{TIME, DESCRIPTION, BLOCKED, DOMAIN_NAME, SITE_NAME, SERVER_NAME, GROUP_NAME, HOST_NAME, SEVERITY, RULE_NAME, VAPI_CLASS_NAME, CALLER_PROCESS_ID, CALLER_PROCESS_NAME, PARAMETER, TEST_MODE};

    public AgentBehaviorLogAdapter(Vector<AgentBehaviorLog> agentBehaviorLogRows) {
        super(columnNames, agentBehaviorLogRows);
    }

    public AgentBehaviorLogAdapter(InputStream inputStream) {
        super(columnNames, columnNames, inputStream);
    }

    protected Icon getLogIcon(AgentBehaviorLog logRow) {
        ImageIcon icon = null;
        Integer actionObj = logRow.getOptAction();
        if (actionObj != null) {
            int actionId = actionObj;
            switch (actionId) {
                case 0: {
                    icon = ConsoleMain.behavAllowIcon;
                    break;
                }
                case 1: {
                    icon = ConsoleMain.behavBlockIcon;
                    break;
                }
                case 2: {
                    icon = ConsoleMain.behavAskIcon;
                    break;
                }
                case 3: {
                    icon = ConsoleMain.behavContinueIcon;
                    break;
                }
                case 4: {
                    icon = ConsoleMain.behavTerminateIcon;
                    break;
                }
            }
        }
        return icon;
    }

    protected ArrayList<Object> initData(AgentBehaviorLog logRow) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(new JLabelData(UIUtilities.formatDate(logRow.getEventTime()), this.getLogIcon(logRow)));
        rowData.add(logRow.getOptDescription());
        rowData.add(LogActionDescription.getDescription((boolean)true, (Integer)logRow.getOptAction()));
        rowData.add(this.getValueForID(logRow.getDomainId()));
        rowData.add(this.getValueForID(logRow.getSiteId()));
        rowData.add(this.getValueForID(logRow.getServerId()));
        rowData.add(this.getValueForID(logRow.getGroupId()));
        rowData.add(logRow.getOptHostName());
        rowData.add(LogSeverityDescription.getDescription((String)"AgentBehaviorLog", (Integer)logRow.getSeverity()));
        rowData.add(logRow.getOptRuleName());
        rowData.add(logRow.getOptVApiName());
        rowData.add(logRow.getOptCallerProcessId());
        rowData.add(logRow.getOptCallerProcessName());
        rowData.add(logRow.getOptParameter());
        rowData.add(AgentBehaviorTestModeDescription.getDescription((Integer)logRow.getOptTestMode()));
        rowData.add(logRow.getOptUserName());
        return rowData;
    }

    @Override
    protected AgentBehaviorLog getLog(String[] input) {
        AgentBehaviorLog log = new AgentBehaviorLog();
        log.setEventId(Integer.valueOf(input[0]));
        log.setEventTime(Long.valueOf(input[1]));
        log.setUSN(Long.valueOf(input[2]));
        log.setDomainId(input[3]);
        log.setSiteId(input[4]);
        log.setServerId(input[5]);
        log.setGroupId(input[6]);
        log.setComputerId(input[7]);
        log.setTimeStamp(Long.valueOf(input[8]));
        log.setSeverity(Integer.valueOf(input[9]));
        log.setOptAgentId(input[10]);
        log.setOptHardwareKey(input[11]);
        log.setOptHostName(input[12]);
        log.setOptAction(Integer.valueOf(input[13]));
        log.setOptTestMode(Integer.valueOf(input[14]));
        log.setOptDescription(input[15]);
        log.setOptVApiName(input[16]);
        log.setOptEncodedApiName(input[17]);
        log.setOptBeginTime(Long.valueOf(input[18]));
        log.setOptEndTime(Long.valueOf(input[19]));
        log.setOptRuleId(input[20]);
        log.setOptRuleName(input[21]);
        log.setOptCallerProcessId(Long.valueOf(input[22]));
        log.setOptCallerProcessName(input[23]);
        log.setOptCallerReturnAddress(Long.valueOf(input[24]));
        log.setOptCallerReturnModuleName(input[25]);
        log.setOptParameter(input[26]);
        log.setOptAlert(Integer.valueOf(input[27]));
        log.setOptSendSnmpTrap(Integer.valueOf(input[28]));
        log.setOptUserName(input[29]);
        log.setOptDomainName(input[30]);
        return log;
    }
}

