/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.location;

import com.sygate.scm.console.ui.monitoring.location.LocationChangeHandler;
import com.sygate.scm.console.util.ConsoleLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;

public class LocationChangeListener
implements ChangeListener<String> {
    private final Worker<Void> loadWorker;
    private final LocationChangeHandler[] handlers;

    public LocationChangeListener(Worker<Void> loadWorker, LocationChangeHandler ... handlers) {
        Objects.requireNonNull(loadWorker, "loadWorker must not be null");
        Objects.requireNonNull(handlers, "handlers must not be null");
        this.loadWorker = loadWorker;
        this.handlers = handlers;
    }

    public void changed(ObservableValue<? extends String> observable, String oldLocation, String newLocation) {
        URL newUrl;
        URL oldUrl;
        ConsoleLogger.log("Browser: Thread[" + Thread.currentThread().getName() + "] location changed! new location: " + newLocation);
        try {
            oldUrl = LocationChangeListener.parseUrl(oldLocation);
            newUrl = LocationChangeListener.parseUrl(newLocation);
        }
        catch (MalformedURLException e) {
            ConsoleLogger.log("skipping handling - could not parse urls: " + e.getMessage());
            return;
        }
        for (LocationChangeHandler handler : this.handlers) {
            if (!handler.canHandle(oldUrl, newUrl)) continue;
            this.loadWorker.cancel();
            handler.handle(oldUrl, newUrl);
            break;
        }
    }

    public static URL parseUrl(String location) throws MalformedURLException {
        return location == null ? null : new URL(location);
    }
}

