/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.location;

import com.sygate.scm.console.ui.monitoring.PopupEngineCallbacks;
import com.sygate.scm.console.ui.monitoring.location.LocationChangeHandler;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Desktop;
import java.awt.Dialog;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javafx.scene.web.WebEngine;

public class ExternalLinkHandler
implements LocationChangeHandler {
    private final String internalPrefix;
    private final String serverHostname;
    private final WebEngine webEngine;
    private final Dialog dialog;

    public ExternalLinkHandler(String internalPrefix, String serverHostname, WebEngine webEngine, Dialog dialog) {
        Objects.requireNonNull(internalPrefix, "internalPrefix must not be null");
        Objects.requireNonNull(serverHostname, "serverHostname must not be null");
        Objects.requireNonNull(webEngine, "webEngine must not be null");
        Objects.requireNonNull(dialog, "dialog must not be null");
        this.internalPrefix = internalPrefix;
        this.serverHostname = serverHostname;
        this.webEngine = webEngine;
        this.dialog = dialog;
    }

    @Override
    public boolean canHandle(URL oldUrl, URL newUrl) {
        return newUrl != null && !PopupEngineCallbacks.isLinkInternalToSEPM(newUrl.toString(), this.internalPrefix, this.serverHostname);
    }

    @Override
    public void handle(URL oldUrl, URL newUrl) {
        try {
            Desktop.getDesktop().browse(newUrl.toURI());
        }
        catch (IOException | URISyntaxException e) {
            ConsoleLogger.log("failed to load external hyperlink " + newUrl + ": " + e.getMessage());
        }
        this.webEngine.loadContent("<div id=\"hideJDialogAfterOpeningUrlInBrowser\" />");
        this.dialog.setVisible(false);
    }
}

