/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.location;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ui.monitoring.PopupEngineCallbacks;
import com.sygate.scm.console.ui.monitoring.location.LocationChangeHandler;
import com.sygate.scm.console.util.ConsoleLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.scene.web.WebEngine;
import javafx.stage.FileChooser;

public class DownloadHandler
implements LocationChangeHandler {
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.monitoring.monitoring");
    private final WebEngine webEngine;

    public DownloadHandler(WebEngine webEngine) {
        Objects.requireNonNull(webEngine, "webEngine must not be null");
        this.webEngine = webEngine;
    }

    @Override
    public boolean canHandle(URL oldUrl, URL newUrl) {
        return newUrl != null && newUrl.getPath().toLowerCase(Locale.ROOT).endsWith("getfile.php");
    }

    @Override
    public void handle(URL oldUrl, URL newUrl) {
        this.getDownloadFilename(newUrl).flatMap(this::promptForLocalSavePath).ifPresent(path -> this.downloadToPath(newUrl, (Path)path));
        if (oldUrl != null && oldUrl.getPath().toLowerCase(Locale.ROOT).endsWith("export_firewall.php") && Optional.ofNullable(oldUrl.getQuery()).orElse("").toLowerCase(Locale.ROOT).contains("logtype=ntp")) {
            this.webEngine.executeScript("try { history.back(); window.close(); } catch (error) {}");
        }
    }

    private Optional<String> getDownloadFilename(URL newUrl) {
        return Optional.ofNullable(newUrl.getQuery()).map(query -> {
            String queryParam = "filename=";
            int idx = query.toLowerCase(Locale.ROOT).indexOf(queryParam);
            return idx == -1 ? null : query.substring(idx + queryParam.length());
        }).filter(Predicate.not(String::isBlank));
    }

    private Optional<Path> promptForLocalSavePath(String filename) {
        FileChooser chooser = new FileChooser();
        chooser.setInitialDirectory(PopupEngineCallbacks.getDefaultExportPath());
        chooser.setInitialFileName(filename);
        ObservableList filters = chooser.getExtensionFilters();
        if (filename.toLowerCase(Locale.ROOT).endsWith(".csv")) {
            filters.add((Object)new FileChooser.ExtensionFilter("CSV (*.csv)", new String[]{"*.csv"}));
        } else if (filename.toLowerCase(Locale.ROOT).endsWith(".zip")) {
            filters.add((Object)new FileChooser.ExtensionFilter("ZIP (*.zip)", new String[]{"*.zip"}));
        }
        filters.add((Object)new FileChooser.ExtensionFilter(MSG_RES.getString("MonitorUtil.FileType.all"), new String[]{"*.*"}));
        File saveFile = chooser.showSaveDialog(null);
        return Optional.ofNullable(saveFile).map(File::toPath);
    }

    private void downloadToPath(URL newUrl, Path localPath) {
        try (InputStream stream = newUrl.openStream();){
            Files.copy(stream, localPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ConsoleLogger.log("failed to download temporary file: " + e.getMessage());
        }
    }
}

