/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.monitoring.dialog.ExportDlg;
import com.sygate.scm.console.ui.util.ResultTableModel;
import java.awt.Component;
import java.io.Writer;
import java.util.Vector;

public class ResultTableExportDlg
extends ExportDlg {
    private static final long serialVersionUID = 1767254351286539796L;
    private ResultTableModel resultTableModel;
    public static final int EXPORT_QUERY_BATCH_NUM = 5000;
    private Vector<TableRow> modelData;
    protected int expStart = 0;
    protected int expCount = 0;

    public ResultTableExportDlg(ResultTableModel resultTableModel) {
        super(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ResultTableExportDlg.titleExportResult"), new String[]{"csv", "txt"});
        this.resultTableModel = resultTableModel;
        this.initialize(resultTableModel == null ? 1 : resultTableModel.getTotalPages());
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean initExportData(int startRow, int toRow) {
        this.expStart = startRow;
        this.expCount = toRow - startRow;
        return this.expCount > 0;
    }

    @Override
    protected int getExportColumnLength() {
        return this.resultTableModel != null ? this.resultTableModel.getColumnCount() : 0;
    }

    @Override
    protected void exportLogColumnNames(Writer writer) throws Exception {
        if (this.resultTableModel != null) {
            writer.write(this.getExportExpression(this.resultTableModel.getColumnNames()));
            writer.flush();
        }
    }

    @Override
    protected void exportLogData(Writer writer) throws Exception {
        int bnum = this.expCount / 5000 + (this.expCount % 5000 == 0 ? 0 : 1);
        for (int i = 0; i < bnum; ++i) {
            int count = i == bnum - 1 ? this.expCount - i * 5000 : 5000;
            this.modelData = this.resultTableModel.getData(this.expStart, count, true);
            this.expStart += count;
            this.exportData(writer);
        }
    }

    private void exportData(Writer writer) throws Exception {
        Object[] data = new Object[this.getExportColumnLength()];
        for (int i = 0; i < this.modelData.size(); ++i) {
            for (int j = 0; j < this.getExportColumnLength(); ++j) {
                data[j] = this.resultTableModel.getValueAt(this.modelData, i, j);
            }
            writer.write(this.getExportExpression(data));
            writer.flush();
        }
    }
}

