/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.client.dlg.ExportFolderChooser;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.monitoring.dialog.LogFileFilter;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.SwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ExportDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String DOWNLOAD_MESSAGE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgExportingPleaseWait");
    private static final String NO_FILE_SELECTED = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgPleaseSelectAFileToExport");
    private static final String NO_VALID_FILE_EXT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgFileExtensionIsNotCorrect");
    private static final String NO_VALID_PAGE_NUMBER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgFromPageNumberCantBeBiggerThanToPageNumber");
    private static final String NO_DATA = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgNoDataToExport");
    private static final String FAILED_EXPORT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgFailedToExport");
    private static final String OVERWRITE_FILE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgWouldYouLikeToOverwriteTheFile");
    private static final String CANT_WRITE_FILE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgFileNotWritable");
    private JTextField jTFFile = new JTextField();
    private JButton jBExport = new JButton(UIText.get(1030));
    private JButton jBCancel = new JButton(UIText.get(512));
    private JButton jBBrowse = new JButton(UIText.get(257));
    private JSpinner jSFrom = new JSpinner();
    private JSpinner jSTo = new JSpinner();
    private JPanel jPagePanel = null;
    private String tempExportFilename = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.defaultExportClientSearchResultFileNamePrefix") + System.currentTimeMillis();
    private static final String CSV = ".csv";
    private String tempExportFilePath = null;
    private String[] extList;
    protected boolean selectPages;

    public ExportDlg(String title, String[] extList) {
        this(title, extList, true);
    }

    public ExportDlg(String title, String[] extList, boolean selectPages) {
        super(Manager.getFrame(), title, true);
        this.extList = extList == null ? null : (String[])extList.clone();
        this.selectPages = selectPages;
    }

    @Override
    protected boolean ok() {
        if (!this.isValidate()) {
            return false;
        }
        this.isOk = true;
        this.commit();
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(this::downloadSingleFile);
        this.dispose();
        return true;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.dispose();
    }

    @Override
    protected void commit() {
        int startPage = ((Number)this.jSFrom.getValue()).intValue();
        int toPage = ((Number)this.jSTo.getValue()).intValue();
        final int startRow = (startPage - 1) * 30;
        final int toRow = toPage * 30;
        SwingWorker worker = new SwingWorker(){
            private SimpleProgressDlg dlg = new SimpleProgressDlg((Frame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.dlgtitleExporting"), DOWNLOAD_MESSAGE, true);
            private String errorMsg;

            public Object construct() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dlg.setCursor(Cursor.getPredefinedCursor(3));
                        dlg.setVisible(true);
                    }
                });
                this.errorMsg = ExportDlg.this.export(startRow, toRow);
                return null;
            }

            public void finished() {
                AjaxSwingCommonUtil.endOperation();
                this.dlg.dispose();
                if (this.errorMsg == null) {
                    AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> {
                        Object[] obj = new Object[]{new File(ExportDlg.this.jTFFile.getText().trim()).getAbsolutePath()};
                        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgDataHasBeenSavedIn");
                        String fm = MessageFormat.format(msg, obj);
                        JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleExportSucceed"), 1);
                    });
                } else {
                    JOptionPane.showMessageDialog(Manager.getFrame(), this.errorMsg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleExportFailed"), 0);
                }
            }
        };
        AjaxSwingCommonUtil.beginOperation();
        worker.start();
    }

    @Override
    protected boolean isValidate() {
        int toPage;
        int startPage = ((Number)this.jSFrom.getValue()).intValue();
        if (startPage > (toPage = ((Number)this.jSTo.getValue()).intValue())) {
            JOptionPane.showMessageDialog(this, NO_VALID_PAGE_NUMBER, MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleError"), 0);
            return false;
        }
        String filePath = null;
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return true;
        }
        filePath = this.jTFFile.getText().trim();
        if (filePath.length() == 0) {
            JOptionPane.showMessageDialog(this, NO_FILE_SELECTED, MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleError"), 0);
            return false;
        }
        if (!this.isValidFileExtension(filePath)) {
            JOptionPane.showMessageDialog(this, NO_VALID_FILE_EXT + this.getAllFileExtensionString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleError"), 0);
            return false;
        }
        File file = new File(filePath);
        if (file.exists()) {
            int retCode = JOptionPane.showConfirmDialog(this, OVERWRITE_FILE, MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleOverwriteFile"), 0);
            if (retCode != 0) {
                return false;
            }
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(this, CANT_WRITE_FILE, MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleFilePermissionError"), 0);
                return false;
            }
        }
        return true;
    }

    protected void initialize(int maxPageCount) {
        this.jSFrom.setModel(new SpinnerNumberModel(1, 1, maxPageCount, 1));
        UIUtilities.enableOnlyValidEdits(this.jSFrom);
        this.jSTo.setModel(new SpinnerNumberModel(maxPageCount, 1, maxPageCount, 1));
        UIUtilities.enableOnlyValidEdits(this.jSTo);
        this.jTFFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ex) {
                ExportDlg.this.jTFFile.setToolTipText(ExportDlg.this.jTFFile.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent ex) {
                ExportDlg.this.jTFFile.setToolTipText(ExportDlg.this.jTFFile.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent ex) {
                ExportDlg.this.jTFFile.setToolTipText(ExportDlg.this.jTFFile.getText());
            }
        });
        this.jBBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                JFileChooser chooser = new JFileChooser();
                LogFileFilter logFileFilter = new LogFileFilter();
                if (ExportDlg.this.extList != null) {
                    for (int i = 0; i < ExportDlg.this.extList.length; ++i) {
                        logFileFilter.addExtension(ExportDlg.this.extList[i]);
                    }
                }
                String chooserDesc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.FileType.text");
                logFileFilter.setDescription(chooserDesc);
                chooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.titleSelectFileNameForExporting"));
                chooser.setFileFilter(logFileFilter);
                int returnVal = chooser.showDialog(Manager.getFrame(), UIText.get(3584));
                if (returnVal == 0) {
                    String path = ExportDlg.this.getFilePath(chooser.getSelectedFile());
                    ExportDlg.this.jTFFile.setText(path);
                    ExportDlg.this.jTFFile.setToolTipText(path);
                }
            }
        });
        this.jBExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                if (ExportDlg.this.jBExport.getText().equalsIgnoreCase(UIText.get(1030))) {
                    ExportDlg.this.ok();
                } else if (ExportDlg.this.jBExport.getText().equalsIgnoreCase(UIText.get(773))) {
                    ExportDlg.this.downloadSingleFile();
                    ExportDlg.this.dispose();
                }
            }
        });
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ExportDlg.this.cancel();
            }
        });
        this.jPagePanel = new JPanel(new GridBagLayout());
        this.jPagePanel.setBorder(BorderFactory.createTitledBorder(""));
        this.jPagePanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.lblFromPage")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.jPagePanel.add((Component)this.jSFrom, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(10, 0, 10, 10), 0, 0));
        this.jPagePanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.lblToPage")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 50, 10, 0), 0, 0));
        this.jPagePanel.add((Component)this.jSTo, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(10, 0, 10, 10), 0, 0));
        JPanel jFilePanel = new JPanel(new GridBagLayout());
        jFilePanel.setBorder(BorderFactory.createTitledBorder(""));
        jFilePanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.lblFilePath")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        jFilePanel.add((Component)this.jTFFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        jFilePanel.add((Component)this.jBBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 10), 0, 0));
        JPanel jButtonPanel = new JPanel();
        UIUtilities.layoutButtonPanel(jButtonPanel, new JButton[]{this.jBExport, this.jBCancel}, 0, 0, true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jPagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jFilePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(30, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jButtonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        if (!this.selectPages) {
            this.jPagePanel.setVisible(false);
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> jFilePanel.setVisible(false));
        this.pack();
        Dimension size = this.getPreferredSize();
        this.setSize((int)((double)size.width * 1.2), size.height);
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBExport);
    }

    protected String getExportExpression(Object[] input) {
        if (input == null || input.length == 0) {
            return "";
        }
        StringBuffer logExp = new StringBuffer();
        for (int i = 0; i < this.getExportColumnLength(); ++i) {
            if (i > 0) {
                logExp.append(",");
            }
            logExp.append(this.getObjectExpression(input[i]));
        }
        logExp.append("\r\n");
        return logExp.toString();
    }

    protected abstract boolean initExportData(int var1, int var2);

    protected abstract int getExportColumnLength();

    protected abstract void exportLogColumnNames(Writer var1) throws Exception;

    protected abstract void exportLogData(Writer var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String export(int startRow, int toRow) {
        if (!this.initExportData(startRow, toRow)) {
            return NO_DATA;
        }
        BufferedWriter out = null;
        try {
            KeepAlive.suspend();
            File file = null;
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                file = File.createTempFile(this.tempExportFilename, CSV);
                this.tempExportFilePath = file.getAbsolutePath();
            } else {
                file = new File(this.jTFFile.getText().trim());
            }
            FileOutputStream fos = new FileOutputStream(file);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            out.write("\ufeff");
            this.exportLogColumnNames(out);
            this.exportLogData(out);
            String string = null;
            return string;
        }
        catch (Exception ex) {
            String msg;
            String string = msg = FAILED_EXPORT + "\n\n" + ex.getMessage();
            return string;
        }
        finally {
            KeepAlive.resume();
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                System.err.println("Export Error: " + ex.getMessage());
            }
        }
    }

    private void downloadSingleFile() {
        File dest;
        File src;
        String targetPath = null;
        targetPath = this.getClientExportFilePath(this.tempExportFilename + CSV);
        if (targetPath != null && !(src = new File(this.tempExportFilePath)).renameTo(dest = new File(targetPath))) {
            System.out.println("Fail to rename download single file");
        }
    }

    private String getClientExportFilePath(String fileName) {
        ExportFolderChooser fc = new ExportFolderChooser();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setDialogType(1);
            fc.setSelectedFile(new File(fileName));
            fc.updateUI();
            if (0 != fc.showSaveDialog(Manager.getFrame())) {
                return null;
            }
        } else if (0 != fc.showOpenDialog(Manager.getFrame())) {
            return null;
        }
        if (fc.getSelectedFile() == null) {
            return null;
        }
        String path = fc.getSelectedFile().getAbsolutePath();
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return path;
    }

    private String getObjectExpression(Object obj) {
        Object rv;
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            boolean escapeTime = false;
            String objStr = obj.toString();
            escapeTime |= objStr.startsWith("=");
            escapeTime |= objStr.startsWith("-");
            escapeTime |= objStr.startsWith("+");
            rv = ((escapeTime |= objStr.startsWith("@")) ? "\"'" : "\"") + obj.toString() + "\"";
        } else {
            rv = obj.toString();
        }
        return rv;
    }

    private String getFilePath(File file) {
        Object filePath = file.getPath();
        if (!this.isValidFileExtension((String)filePath)) {
            filePath = (String)filePath + "." + this.extList[0];
        }
        return filePath;
    }

    private boolean isValidFileExtension(String fileName) {
        if (this.extList == null || this.extList.length == 0) {
            return true;
        }
        String fileExt = this.getFileExtension(fileName);
        for (int i = 0; i < this.extList.length; ++i) {
            if (!fileExt.toLowerCase().equals(this.extList[i])) continue;
            return true;
        }
        return false;
    }

    private String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        return index == -1 ? "" : fileName.substring(index + 1);
    }

    private String getAllFileExtensionString() {
        StringBuffer buf = new StringBuffer();
        if (this.extList != null && this.extList.length > 0) {
            buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "ExportDlg.msgItOnlySupportTheFollowingFileExtension"));
            for (int i = 0; i < this.extList.length; ++i) {
                buf.append("    " + this.extList[i].toString() + "\n");
            }
            buf.append("\n\n");
        }
        return buf.toString();
    }
}

