/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.dataquery;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.QueryTableModel;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.Vector;

public class LearnedAppQueryTableModel
extends QueryTableModel {
    private static final long serialVersionUID = 1L;

    public LearnedAppQueryTableModel() {
        super(false, false);
        this.setIsFixedColumns(false);
    }

    public boolean setQueryString(RpcData rpc) {
        if (rpc.getSqlParameterCount() == 0) {
            this.rowCount = 0;
            return false;
        }
        this.rpc = rpc;
        this.rowCount = this.getRowCount(this.getUnmodifiedRpcData());
        boolean isValidQuery = this.rowCount != -1;
        this.rowCount = this.rowCount < 0 ? 0 : this.rowCount;
        return isValidQuery;
    }

    @Override
    protected int getRowCount(String queryString) {
        return this.getRowCount(this.getUnmodifiedRpcData());
    }

    private int getRowCount(RpcData rpc) {
        try {
            return PolicyHandler.getLearnedApplicationCount(rpc);
        }
        catch (Exception e) {
            System.out.println("LearnedAppQueryTableModel.getRowCount()");
            LoggerUtilities.logException((Throwable)e);
            return 0;
        }
    }

    @Override
    protected void doQuery(int start, int size, boolean isForExport) {
        ArrayList<LearnedApplicationObject> result = null;
        try {
            result = PolicyHandler.getLearnedApplication(701, this.getUnmodifiedRpcData(), start, size);
        }
        catch (Exception e) {
            System.out.println("LearnedAppQueryTableModel.doQuery(): exception=");
            LoggerUtilities.logException((Throwable)e);
        }
        this.setPageData(result, 0, size, isForExport);
    }

    protected void setPageData(ArrayList<LearnedApplicationObject> result) {
        this.setPageData(result, 0, this.getMaxPageRowNumber(), false);
    }

    protected void setPageData(ArrayList<LearnedApplicationObject> result, int start, int size, boolean isForExport) {
        Vector queryData = isForExport ? this.exportData : this.data;
        queryData.clear();
        if (result != null) {
            int count = result.size();
            for (int i = start; i < start + Math.min(count, size); ++i) {
                TableRow obj = result.get(i);
                queryData.add(obj);
            }
        }
    }
}

