/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring.dataquery;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.NumberPlainDocument;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.ComputerInfoObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.monitoring.dataquery.LearnedAppQueryTableModel;
import com.sygate.scm.console.ui.monitoring.dataquery.TableCriteriaList;
import com.sygate.scm.console.ui.policy.common.LearnedAppTakerInt;
import com.sygate.scm.console.ui.policy.common.LearnedAppViewDlg;
import com.sygate.scm.console.ui.policy.common.SelectGroupLocationDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.OSDropdownItemLoader;
import com.sygate.scm.console.ui.util.ObjectComparator;
import com.sygate.scm.console.ui.util.QueryPanelBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.ResultTablePanel;
import com.sygate.scm.console.ui.util.SearchResultPanel;
import com.sygate.scm.console.ui.util.TableColumnMap;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class LearnedAppQueryPanel
extends QueryPanelBase
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final String[] RCOL_NAMES_APP = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnameName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnamePath"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnameDescription"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnameVersion"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnameSize"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnameLastModifiedTime"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.colnameFingerprint")};
    private static ObjectComparator objComparator = new ObjectComparator();
    protected LearnedAppQueryTableModel learnedAppQueryTableModel;
    private JButton browseBtn = new JButton();
    private JLabel filterApplicationLabel = new JLabel();
    private JTextField groupPathField = new JTextField();
    private JCheckBox subGroupChk = new JCheckBox();
    private JRadioButton clientComputerRBtn;
    private JRadioButton applicationRBtn;
    private int mode = 0;
    protected JButton jBViewDetail;
    protected JButton jBSelectAll = new JButton(UIText.get(4614));
    protected JButton jBClearAll = new JButton(UIText.get(5120));
    protected JButton jBAddApp;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem viewAppMenuItem;
    private JMenuItem addAppMenuItem;
    private JTable resultTable;
    private GroupObject group;
    private String domainId;
    private ArrayList<GroupObject> groupList;
    private String locName;
    private int conCount;
    private LearnedAppTakerInt learnedAppTakerInt;
    private Action viewDetailAction;
    private Action addAppAction;
    private JTextArea JTADesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.descLearnedApplicationQuery"));
    private final TableColumnMap[] COMPUTER_CRITERIA = new TableColumnMap[]{new TableColumnMap("COMPUTER", "COMPUTER_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameComputerName")), new TableColumnMap("COMPUTER", "COMPUTER_DOMAIN_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameComputerDomainName")), new TableColumnMap("COMPUTER", "PROCESSOR_TYPE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameProcessorType")), new TableColumnMap("COMPUTER", "PROCESSOR_CLOCK", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameProcessorClock"), 4, new RestrictedPlainDocument(20, true)), new TableColumnMap("COMPUTER", "PROCESSOR_NUM", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameProcessorNumber"), 4, new RestrictedPlainDocument(10, true)), new TableColumnMap("COMPUTER", "MEMORY", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameMemory"), 8, new NumberPlainDocument(Long.MAX_VALUE, true)), new TableColumnMap("COMPUTER", "BIOS_VERSION", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameBiosVersion")), new TableColumnMap("COMPUTER", "TPM_DEVICE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameTPMDevice"), TableCriteriaList.getTpmDeviceDropdown()), new TableColumnMap("COMPUTER", "OS_LANG", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameOsLanguage"), TableCriteriaList.getOsLangDropdown()), new TableColumnMap("COMPUTER", "SERVICE_PACK", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameServicePack")), new TableColumnMap("COMPUTER", "DISK_TOTAL", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameTotalDiskSpace"), 8, new NumberPlainDocument(Long.MAX_VALUE, true)), new TableColumnMap("COMPUTER", "IP_ADDR1", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameIPAddresss"), 31)};
    private final TableColumnMap[] CLIENT_CRITERIA = new TableColumnMap[]{new TableColumnMap("CLIENT", "USER_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameUserName")), new TableColumnMap("CLIENT", "USER_DOMAIN_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameUserDomainName"))};
    private final TableColumnMap[] APP_CRITERIA = new TableColumnMap[]{new TableColumnMap("APP", "APPLICATION_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationName")), new TableColumnMap("APP", "APPLICATION_PATH", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationPath")), new TableColumnMap("APP", "APP_DESCRIPTION", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationDescription")), new TableColumnMap("APP", "FILE_SIZE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationSize"), 8, new NumberPlainDocument(Long.MAX_VALUE, true)), new TableColumnMap("APP", "VERSION", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationVersion")), new TableColumnMap("APP", "CHECKSUM", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationFingerprint.md5")), new TableColumnMap("APP", "SHA2", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameApplicationFingerprint.sha2")), new TableColumnMap("APP", "LAST_MODIFY_TIME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.tcnameLastModifiedTime"), 2)};
    private final TableColumnMap[] AGENT_CRITERIA = new TableColumnMap[]{new TableColumnMap("SEM_AGENT", "R_OS_TYPE", new MessageResourcesFile("com.sygate.scm.console.ui.monitoring.monitoring").getString("TableCriteriaList.tcOperatingSystem"), 14, null, false, OSDropdownItemLoader.getInstance())};

    public LearnedAppQueryPanel() {
        super(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.titleLearnedApplicationQuery"));
        this.initialize();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jBSelectAll.setEnabled(false);
        this.jBClearAll.setEnabled(false);
        this.learnedAppQueryTableModel = this.getTableModel();
        if (this.learnedAppQueryTableModel != null) {
            this.learnedAppQueryTableModel.setColumnNames(RCOL_NAMES_APP);
            this.resultPanel.setTableModel(this.learnedAppQueryTableModel);
            this.learnedAppQueryTableModel.addTableModelListener(this);
        }
        this.resultTable = this.resultPanel.getTable();
        this.resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                Point p = e.getPoint();
                int row = LearnedAppQueryPanel.this.resultTable.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                LearnedAppQueryPanel.this.resultTable.setRowSelectionInterval(row, row);
                TableRow tableRow = LearnedAppQueryPanel.this.learnedAppQueryTableModel.getRow(row);
                if (tableRow == null) {
                    return;
                }
                LearnedAppQueryPanel.this.popup.show(LearnedAppQueryPanel.this.resultTable, e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LearnedAppQueryPanel.this.viewDetail();
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LearnedAppQueryPanel.this.resultSelectionChanged(e);
            }
        });
        this.resultTable.getSelectionModel().setSelectionMode(2);
        this.setQueryTableColumn();
    }

    protected void resultSelectionChanged(ListSelectionEvent le) {
        if (le.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)le.getSource();
        boolean hasSelect = !lsm.isSelectionEmpty();
        this.viewDetailAction.setEnabled(hasSelect);
        this.addAppAction.setEnabled(hasSelect);
    }

    public void showTitle(boolean showTitle) {
        this.jLTitle.setVisible(showTitle);
    }

    @Override
    protected JPanel getTitlePanel() {
        PrivilegeContext context;
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(BorderFactory.createEtchedBorder());
        titlePanel.add((Component)this.JTADesc, "North");
        JPanel groupPanel = new JPanel(new GridBagLayout());
        this.browseBtn.setText(UIText.get(257));
        this.browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LearnedAppQueryPanel.this.browseGroupsAndLocations(e);
            }
        });
        DataobjectManager manager = DataobjectManager.getInstance();
        if (AdminUtils.isLimitedAdmin((SemAdministrator)manager.getCurrentAdministrator()) && (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)(context = DataobjectManager.getInstance().getCurrentPrivilegeContext())) || AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege())) {
            this.groupPathField.setEditable(false);
        }
        this.filterApplicationLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.labelFilterApplicationsIn"));
        this.subGroupChk.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.chkboxSearchSubgroups"));
        this.subGroupChk.setSelected(true);
        groupPanel.add((Component)this.filterApplicationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        groupPanel.add((Component)this.groupPathField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        groupPanel.add((Component)this.browseBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 10), 0, 0));
        groupPanel.add((Component)this.subGroupChk, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        titlePanel.add((Component)groupPanel, "Center");
        return titlePanel;
    }

    @Override
    protected ResultTablePanel getResultTablePanel() {
        SearchResultPanel searchResultPanel = (SearchResultPanel)super.getResultTablePanel();
        JPanel panel = searchResultPanel.getSouthButtonPanel();
        this.setSouthButtonPanel(panel);
        return searchResultPanel;
    }

    private void browseGroupsAndLocations(ActionEvent e) {
        try {
            SelectGroupLocationDlg dlg = new SelectGroupLocationDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleBrowseGroup"), true);
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                return;
            }
            DefaultMutableTreeNode node = dlg.getNode();
            String fullPath = PolicyHandler.getFullPathOfNode(node);
            this.groupPathField.setText(fullPath);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleError"), 0);
        }
    }

    @Override
    protected JPanel getCriteriaPanel() {
        this.initialCriteriaLabelAndSearchButton();
        this.clientComputerRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.rbtnBasedOnClientComputerInfo"), this.mode == 0);
        this.applicationRBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.rbtnBasedOnLearnedApplication"), this.mode == 1);
        ButtonGroup group = new ButtonGroup();
        group.add(this.clientComputerRBtn);
        group.add(this.applicationRBtn);
        this.clientComputerRBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LearnedAppQueryPanel.this.searchCriteriaChanged(0);
            }
        });
        this.applicationRBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LearnedAppQueryPanel.this.searchCriteriaChanged(1);
            }
        });
        JPanel criteriaPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        criteriaPanel.add((Component)this.jLCriteria, c);
        c.gridy = 0;
        c.gridx = 1;
        criteriaPanel.add((Component)this.clientComputerRBtn, c);
        c.gridy = 1;
        c.gridx = 1;
        criteriaPanel.add((Component)this.applicationRBtn, c);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)criteriaPanel, "West");
        panel.add((Component)this.jBSearch, "East");
        return panel;
    }

    protected void searchCriteriaChanged(int mode) {
        this.mode = mode;
        this.setSearchTable();
        this.searchModel.reset();
        this.setQueryTableColumn();
    }

    @Override
    protected void setSearchTable() {
        JComboBox<Object> searchFieldComboBox = this.jTSearch.getSearchFieldComboBox();
        searchFieldComboBox.removeAllItems();
        searchFieldComboBox.putClientProperty("dynamicEventsEnabled", true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("");
        switch (this.mode) {
            case 0: {
                TableColumnMap[] clientList = this.CLIENT_CRITERIA;
                for (int i = 0; i < clientList.length; ++i) {
                    arrayList.add(clientList[i]);
                }
                TableColumnMap[] computerList = this.COMPUTER_CRITERIA;
                for (int i = 0; i < computerList.length; ++i) {
                    arrayList.add(computerList[i]);
                }
                TableColumnMap[] agentList = this.AGENT_CRITERIA;
                for (int i = 0; i < agentList.length; ++i) {
                    arrayList.add(agentList[i]);
                }
                break;
            }
            case 1: {
                TableColumnMap[] appList = this.APP_CRITERIA;
                for (int i = 0; i < appList.length; ++i) {
                    arrayList.add(appList[i]);
                }
                break;
            }
        }
        Object[] list = arrayList.toArray();
        Arrays.sort(list, objComparator);
        this.jTSearch.appendComboBoxItem(searchFieldComboBox, list);
    }

    protected void setQueryTableColumn() {
        this.learnedAppQueryTableModel.setColumnNames(RCOL_NAMES_APP);
        this.resultPanel.resizeTableColumns();
    }

    @Override
    protected void search() {
        super.search();
        SwingWorker worker = new SwingWorker(){
            private boolean isValidSql = false;

            public Object construct() {
                LearnedAppQueryPanel.this.resultPanel.enableProgressPanel();
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                RpcData rpc = LearnedAppQueryPanel.this.getQueryString();
                this.isValidSql = rpc != null && LearnedAppQueryPanel.this.learnedAppQueryTableModel.setQueryString(rpc);
                return null;
            }

            public void finished() {
                if (this.isValidSql) {
                    LearnedAppQueryPanel.this.resultPanel.refresh("", "");
                } else {
                    LearnedAppQueryPanel.this.resultPanel.clear();
                }
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                LearnedAppQueryPanel.this.resultPanel.disableProgressPanel();
            }
        };
        worker.start();
    }

    private boolean isGroupValid() {
        this.group = null;
        String fullPath = this.groupPathField.getText();
        this.locName = PolicyHandler.getLocationNameFromFullPath(fullPath).trim();
        String groupPath = PolicyHandler.getGroupPathFromFullPath(fullPath).trim();
        try {
            this.group = GroupHandler.getGroupByFullPath(groupPath);
        }
        catch (Exception e) {
            this.group = null;
            System.out.println("LearnedAppQueryPanel.getQueryString(): exception = ");
            LoggerUtilities.logException((Throwable)e);
        }
        if (groupPath.length() > 0 && this.group == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.msgTheGroupPathIsNotCorrect"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleError"), 0);
            return false;
        }
        return true;
    }

    private boolean isDomainValid() {
        boolean isValid = false;
        this.domainId = null;
        DataobjectManager dataManager = DataobjectManager.getInstance();
        SemLoginInfo loginInfo = dataManager.getLoginInformation();
        if (loginInfo != null) {
            this.domainId = loginInfo.getOptDomainGUID();
            if (this.domainId != null) {
                isValid = true;
            } else {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.msgNoDomainIDIcantGoOn"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleError"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.msgNoLoginInfoIcantGoOn"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleError"), 0);
        }
        return isValid;
    }

    private ArrayList<GroupObject> getGroupList() {
        this.groupList = null;
        if (this.group != null) {
            try {
                this.groupList = GroupHandler.getAllowedChildGroups(this.group, this.subGroupChk.isSelected());
            }
            catch (Exception e) {
                System.out.println("Failed to get group list");
            }
        }
        return this.groupList;
    }

    private void collectTableAndCondition(Set<String> dbTableSet, Set<String> conditionSet) {
        dbTableSet.add("SEM_APPLICATION APP");
        conditionSet.add("APP.DELETED = 0");
        String domainID = Manager.getCurrentDomainId();
        conditionSet.add("APP.DOMAIN_ID = '" + domainID + "'");
        if (this.mode == 0) {
            dbTableSet.add("SEM_CLIENT CLIENT");
            conditionSet.add("CLIENT.COMPUTER_ID = COMPUTER.COMPUTER_ID");
            conditionSet.add("CLIENT.DELETED = 0");
            conditionSet.add("CLIENT.DOMAIN_ID = '" + domainID + "'");
            dbTableSet.add("SEM_COMPUTER COMPUTER");
            conditionSet.add("COMPUTER.DELETED = 0");
            conditionSet.add("COMPUTER.COMPUTER_ID = CA.COMPUTER_ID");
            conditionSet.add("COMPUTER.DOMAIN_ID = '" + domainID + "'");
            dbTableSet.add("COMPUTER_APPLICATION CA");
            conditionSet.add("CA.APP_HASH = APP.APP_HASH");
            conditionSet.add("CA.DELETED = 0");
            conditionSet.add("CA.DOMAIN_ID = '" + domainID + "'");
            dbTableSet.add("SEM_AGENT SEM_AGENT");
            conditionSet.add("COMPUTER.COMPUTER_ID = SEM_AGENT.COMPUTER_ID");
        } else if (this.groupList != null && this.groupList.size() > 0) {
            dbTableSet.add("COMPUTER_APPLICATION CA");
            conditionSet.add("CA.APP_HASH = APP.APP_HASH");
            conditionSet.add("CA.DELETED = 0");
            conditionSet.add("CA.DOMAIN_ID = '" + domainID + "'");
        }
        if (this.locName.length() > 0) {
            dbTableSet.add("IDENTITY_MAP IDMAP");
            dbTableSet.add("COMPUTER_APPLICATION CA");
            conditionSet.add("IDMAP.ID = CA.LOCATION_ID");
            conditionSet.add("CA.APP_HASH = APP.APP_HASH");
            conditionSet.add("CA.DOMAIN_ID = '" + domainID + "'");
        }
    }

    private void appendTableList(StringBuffer buffer, Set<String> dbTableSet) {
        Iterator<String> it = dbTableSet.iterator();
        int tblCount = 0;
        while (it.hasNext()) {
            String tableName = it.next();
            if (tblCount > 0) {
                buffer.append(",");
            }
            buffer.append(tableName);
            ++tblCount;
        }
    }

    private void appendConditionList(StringBuffer buffer, Set<String> conditionSet) {
        this.conCount = 0;
        if (conditionSet.size() > 0) {
            buffer.append(" WHERE ");
        }
        for (String con : conditionSet) {
            if (this.conCount > 0) {
                buffer.append(" AND ");
            }
            buffer.append(con);
            ++this.conCount;
        }
    }

    private void appendGroupList(StringBuffer buffer) {
        if (this.groupList != null && this.groupList.size() > 0) {
            if (this.conCount > 0) {
                buffer.append(" AND ");
            }
            buffer.append("CA.GROUP_ID IN (");
            Iterator<GroupObject> it = this.groupList.iterator();
            int cnt = 0;
            while (it.hasNext()) {
                GroupObject gObj = it.next();
                if (cnt > 0) {
                    buffer.append(",");
                }
                buffer.append("'" + gObj.getId() + "'");
                ++cnt;
            }
            buffer.append(")");
            ++this.conCount;
        }
        if (this.locName.length() > 0) {
            if (this.conCount > 0) {
                buffer.append(" AND ");
            }
            buffer.append("IDMAP.NAME = '" + this.locName + "'");
            ++this.conCount;
        }
    }

    private String buildQuery(Set<String> dbTableSet, Set<String> conditionSet) {
        StringBuffer buffer = new StringBuffer(" FROM ");
        this.appendTableList(buffer, dbTableSet);
        this.appendConditionList(buffer, conditionSet);
        this.appendGroupList(buffer);
        return buffer.toString();
    }

    protected RpcData getQueryString() {
        if (this.isGroupValid() && this.isDomainValid()) {
            this.groupList = this.getGroupList();
            if (this.groupList == null || this.groupList.size() == 0) {
                return null;
            }
            RpcData rpc = this.jTSearch.getCriteria();
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)Manager.getCurrentDomainId());
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(this.mode));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)this.locName);
            StringBuilder groupIds = new StringBuilder();
            for (int i = 0; i < this.groupList.size(); ++i) {
                GroupObject group = this.groupList.get(i);
                groupIds.append("," + group.getId());
            }
            if (groupIds.length() > 0) {
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)groupIds.substring(1));
            }
            HashSet<String> dbTableSet = new HashSet<String>();
            HashSet<String> conditionSet = new HashSet<String>();
            this.collectTableAndCondition(dbTableSet, conditionSet);
            this.buildQuery(dbTableSet, conditionSet);
            return rpc;
        }
        return null;
    }

    @Override
    protected void updateResultTableModel(String[] columnNames, Vector<TableRow> data) {
        this.learnedAppQueryTableModel.setDataVector(data);
        this.learnedAppQueryTableModel.fireTableDataChanged();
    }

    protected LearnedAppQueryTableModel getTableModel() {
        if (this.learnedAppQueryTableModel == null) {
            this.learnedAppQueryTableModel = new LearnedAppQueryTableModel();
        }
        return this.learnedAppQueryTableModel;
    }

    protected void viewDetail() {
        try {
            LearnedApplicationObject appObj;
            int index = this.resultTable.getSelectedRow();
            if (index != -1 && (appObj = (LearnedApplicationObject)this.learnedAppQueryTableModel.getRow(index)) != null) {
                String appId = appObj.getId();
                ComputerInfoObject[] comObj = PolicyHandler.getAllComputerInfoForLearnedApp(appId, this.groupList);
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleDetailOf");
                LearnedAppViewDlg dlg = new LearnedAppViewDlg(Manager.getFrame(), msg, true);
                dlg.setApplicationInfo(appObj);
                dlg.setComputerInfoTable(comObj);
                dlg.setVisible(true);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleError"), 0);
        }
    }

    protected void selectAll() {
        this.resultTable.selectAll();
    }

    protected void clearAll() {
        this.resultTable.clearSelection();
    }

    protected void addAppToTable() {
        int addedApps;
        int[] selectIndx = this.resultTable.getSelectedRows();
        LearnedApplicationObject[] allApps = new LearnedApplicationObject[selectIndx.length];
        for (int i = 0; i < selectIndx.length; ++i) {
            allApps[i] = (LearnedApplicationObject)this.learnedAppQueryTableModel.getRow(selectIndx[i]);
        }
        if (this.learnedAppTakerInt != null && (addedApps = this.learnedAppTakerInt.addLearnedApplication(allApps)) > 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.msgAppHaveBeenAddedSuccessfully"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleInformation"), 1);
        }
    }

    public void setLearnedAppTaker(LearnedAppTakerInt learnedAppTakerInt) {
        this.learnedAppTakerInt = learnedAppTakerInt;
        this.jBSelectAll.setVisible(true);
        this.jBClearAll.setVisible(true);
        if (this.jBAddApp != null) {
            this.jBAddApp.setVisible(true);
        }
        if (this.addAppMenuItem != null) {
            this.addAppMenuItem.setVisible(true);
        }
    }

    public void setButtonsEnabled(boolean isEnabled) {
        this.jBSelectAll.setEnabled(isEnabled);
        this.jBClearAll.setEnabled(isEnabled);
        this.resultTable.getSelectionModel().setSelectionMode(0);
    }

    protected void setSouthButtonPanel(JPanel panel) {
        if (panel != null) {
            this.jBSelectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LearnedAppQueryPanel.this.selectAll();
                }
            });
            this.jBClearAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LearnedAppQueryPanel.this.clearAll();
                }
            });
            this.viewDetailAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.monitoring.monitoring", "LearnedAppQueryPanel.dlgtitleDetailOf")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    LearnedAppQueryPanel.this.viewDetail();
                }
            };
            this.addAppAction = new AbstractAction(UIText.get(0)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    LearnedAppQueryPanel.this.addAppToTable();
                }
            };
            this.viewDetailAction.setEnabled(false);
            this.jBViewDetail = new JButton(this.viewDetailAction);
            this.viewAppMenuItem = new JMenuItem(this.viewDetailAction);
            this.addAppAction.setEnabled(false);
            this.jBAddApp = new JButton(this.addAppAction);
            this.addAppMenuItem = new JMenuItem(this.addAppAction);
            this.jBSelectAll.setVisible(false);
            this.jBClearAll.setVisible(false);
            this.jBAddApp.setVisible(false);
            this.addAppMenuItem.setVisible(false);
            this.popup.add(this.viewAppMenuItem);
            this.popup.add(this.addAppMenuItem);
            panel.add(this.jBSelectAll);
            panel.add(this.jBClearAll);
            panel.add(this.jBViewDetail);
            panel.add(this.jBAddApp);
            int width = this.jBSelectAll.getPreferredSize().width + this.jBClearAll.getPreferredSize().width + this.jBViewDetail.getPreferredSize().width + this.jBAddApp.getPreferredSize().width;
            if (width + 20 > panel.getPreferredSize().width) {
                panel.setPreferredSize(new Dimension(width + 20, panel.getPreferredSize().height));
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.jBSelectAll.setEnabled(this.learnedAppQueryTableModel.getTotalPages() > 0);
        this.jBClearAll.setEnabled(this.learnedAppQueryTableModel.getTotalPages() > 0);
    }
}

