/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring;

import com.sygate.scm.common.configobject.schema.TdadServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ui.monitoring.BrowserModalDialog;
import com.sygate.scm.console.ui.monitoring.location.DownloadHandler;
import com.sygate.scm.console.ui.monitoring.location.ExternalLinkHandler;
import com.sygate.scm.console.ui.monitoring.location.LocationChangeListener;
import com.sygate.scm.console.ui.monitoring.location.LogoutHandler;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManagerReportingHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.print.PageLayout;
import javafx.print.Paper;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.transform.Translate;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;

public class PopupEngineCallbacks {
    private static MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");

    public static void setCallbacks(final WebView popupView, Callback<PopupFeatures, WebEngine> selfReferentialPopupCallback, String internalPrefix, String sepmServerHostName, final BrowserModalDialog browserModalDialog, final JDialog dialog) {
        final WebEngine popupEngine = popupView.getEngine();
        popupEngine.documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> arg0, Document arg1, Document arg2) {
                try {
                    String html = (String)popupEngine.executeScript("self.document.title");
                    dialog.setTitle(html);
                    JSObject jsobject = (JSObject)popupEngine.executeScript("window");
                    jsobject.setMember("jfx", browserModalDialog);
                    jsobject.setMember("jfx_dialog", dialog);
                }
                catch (Exception e) {
                    ConsoleLogger.log(e);
                }
            }
        });
        LogoutHandler logoutHandler = new LogoutHandler();
        DownloadHandler downloadHandler = new DownloadHandler(popupEngine);
        ExternalLinkHandler linkHandler = new ExternalLinkHandler(internalPrefix, sepmServerHostName, popupEngine, dialog);
        popupEngine.locationProperty().addListener((ChangeListener)new LocationChangeListener((Worker<Void>)popupEngine.getLoadWorker(), logoutHandler, downloadHandler, linkHandler));
        popupEngine.setOnVisibilityChanged((EventHandler)new EventHandler<WebEvent<Boolean>>(){

            public void handle(WebEvent<Boolean> event) {
                if (!((Boolean)event.getData()).booleanValue()) {
                    dialog.setVisible(false);
                }
            }
        });
        popupEngine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> statusEvent) {
                String newStatus = (String)statusEvent.getData();
                if (null == newStatus || newStatus.equals("")) {
                    return;
                }
                if (newStatus.startsWith("Printing")) {
                    PopupEngineCallbacks.printPage(popupEngine, popupView);
                } else if (newStatus.startsWith("Saving")) {
                    PopupEngineCallbacks.savePage(popupEngine, popupView);
                    popupView.requestFocus();
                }
            }
        });
        popupView.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.F5) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            popupEngine.reload();
                        }
                    });
                }
            }
        });
        PopupEngineCallbacks.setConfirmCallbacks(popupEngine, browserModalDialog);
        popupEngine.setCreatePopupHandler(selfReferentialPopupCallback);
    }

    private static void savePage(WebEngine popupEngine, WebView popupView) {
        FileChooser fc = new FileChooser();
        fc.setInitialDirectory(PopupEngineCallbacks.getDefaultExportPath());
        fc.setInitialFileName(MSG_RES.getString("MainPanel.reports.name"));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("HTML (*.html)", new String[]{"*.html"}));
        File saveTo = fc.showSaveDialog(popupView.getScene().getWindow());
        if (null == saveTo) {
            return;
        }
        String reportContent = (String)popupEngine.executeScript("document.ReportSave.ReportContent.value");
        String saveType = (String)popupEngine.executeScript("document.ReportSave.SaveType.value");
        try {
            String html = GUIManagerReportingHelper.getSavedReport(reportContent, saveType);
            try (PrintWriter pw = new PrintWriter(saveTo, StandardCharsets.UTF_8);){
                pw.write(html);
            }
            catch (IOException e) {
                ConsoleLogger.log(e);
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
    }

    public static void setConfirmCallbacks(WebEngine engine, final BrowserModalDialog browserModalDialog) {
        engine.setConfirmHandler((Callback)new Callback<String, Boolean>(){

            public Boolean call(String arg0) {
                return browserModalDialog.modalAlert(MessageResources.getResourceBundle((String)"com.sygate.scm.console.ui.ui").getString("AlertWindow.title.question"), arg0, "question");
            }
        });
        engine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> arg0) {
                String formattedMsg = "";
                if (null != arg0 && null != arg0.getData()) {
                    formattedMsg = ((String)arg0.getData()).replaceAll("(?i)<br */?>", System.lineSeparator());
                }
                String fFormattedMsg = formattedMsg;
                SwingUtilities.invokeLater(() -> browserModalDialog.modalAlert(MessageResources.getResourceBundle((String)"com.sygate.scm.console.ui.ui").getString("AlertWindow.title.information"), fFormattedMsg, "info"));
            }
        });
    }

    public static File getDefaultExportPath() {
        File f = Paths.get(System.getProperty("user.home"), "Downloads").toFile();
        if (!f.isDirectory()) {
            f = Paths.get(System.getProperty("user.home"), new String[0]).toFile();
        }
        return f;
    }

    private static void printPage(WebEngine popupEngine, WebView popupView) {
        final PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null) {
            if (job.showPrintDialog(popupView.getScene().getWindow())) {
                Integer scrollHeight = null;
                try {
                    scrollHeight = (Integer)popupEngine.executeScript("var ht = 0.0; var cnodes = document.body.children; for (var i = 0; i < cnodes.length; ++i) {var c = cnodes[i]; if (c.offsetHeight > 0) {ht = ht + c.offsetHeight;}} ht; ");
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                Paper paper = job.getJobSettings().getPageLayout().getPaper();
                final double py = paper.getHeight() - ((PageLayout)job.getJobSettings().pageLayoutProperty().get()).getBottomMargin() - ((PageLayout)job.getJobSettings().pageLayoutProperty().get()).getTopMargin();
                double px = paper.getWidth() - ((PageLayout)job.getJobSettings().pageLayoutProperty().get()).getLeftMargin() - ((PageLayout)job.getJobSettings().pageLayoutProperty().get()).getRightMargin();
                Stage superSecretPrintStage = new Stage();
                final WebView wv = new WebView();
                final double totalY = null != scrollHeight ? scrollHeight.doubleValue() : py;
                wv.setPrefSize(px, totalY);
                WebEngine we = wv.getEngine();
                double slightAdditionalWidthToSlideScrollbarOffPage = 14.0;
                Scene scene = new Scene((Parent)wv, px + slightAdditionalWidthToSlideScrollbarOffPage, totalY, null);
                superSecretPrintStage.setWidth(px + slightAdditionalWidthToSlideScrollbarOffPage);
                superSecretPrintStage.setHeight(totalY);
                superSecretPrintStage.setScene(scene);
                final Translate translate = new Translate();
                wv.getTransforms().add((Object)translate);
                we.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                        if (Worker.State.SUCCEEDED == newState) {
                            Platform.runLater((Runnable)new PrintThreadContinuation(job, py, totalY, translate, wv));
                        }
                    }
                });
                String html = (String)popupEngine.executeScript("document.documentElement.outerHTML");
                String baseStr = "<head><base href=\"" + popupEngine.getLocation() + "\" />";
                String printContent = html.replaceFirst("(?i)<head>", baseStr);
                we.loadContent(printContent);
            } else {
                job.cancelJob();
            }
            popupView.requestFocus();
        }
    }

    public static boolean isLinkInternalToSEPM(String url, String internalPrefix, String sepmServerHostName) {
        if (url.endsWith("symantec.html") || url.contains("securityLinkRedirect.php") || url.contains("externalurl.php") || url.contains("/sepmhelp/")) {
            return false;
        }
        if (url.toLowerCase().startsWith("http") && !url.toLowerCase().startsWith(internalPrefix.toLowerCase()) && !url.toLowerCase().contains(sepmServerHostName.toLowerCase())) {
            return false;
        }
        return !PopupEngineCallbacks.isTdadLink(url, internalPrefix, sepmServerHostName);
    }

    protected static boolean isTdadLink(String url, String internalPrefix, String sepmServerHostName) {
        try {
            TdadServer tdadServer = DataobjectManager.getInstance().getLocalSite().getOptTdadServer();
            if (null == tdadServer) {
                return false;
            }
            String tdadAddress = tdadServer.getAddress();
            int tdadPort = tdadServer.getPort();
            URI uri = new URI(url);
            if (uri == null || uri.getScheme() == null) {
                ConsoleLogger.log("isTdadLink >> Invalid URL : " + url);
                return false;
            }
            if (!uri.getScheme().equals("https")) {
                return false;
            }
            if (!InetAddress.getByName(tdadAddress).equals(InetAddress.getByName(uri.getHost()))) {
                return false;
            }
            if (uri.getPort() == -1 ? tdadPort != 443 : tdadPort != uri.getPort()) {
                return false;
            }
        }
        catch (Exception exception) {
            ConsoleLogger.log(exception);
            return false;
        }
        return true;
    }

    private static class PrintThreadContinuation
    implements Runnable {
        private PrinterJob job;
        private double py;
        private double newSh;
        private Translate translate;
        private WebView root;

        public PrintThreadContinuation(PrinterJob job, double py, double newSh, Translate translate, WebView root) {
            this.job = job;
            this.py = py;
            this.newSh = newSh;
            this.translate = translate;
            this.root = root;
        }

        @Override
        public void run() {
            this.root.getScene().snapshot(null);
            double pageCt = Math.ceil(this.newSh / this.py);
            int page = 0;
            while ((double)page < pageCt) {
                if (page > 0) {
                    double translateBy = (double)page * -this.py;
                    this.translate.setY(translateBy);
                }
                if (!this.job.printPage((Node)this.root)) {
                    this.job.cancelJob();
                    return;
                }
                ++page;
            }
            this.job.endJob();
        }
    }
}

