/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring;

import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.ui.ReportingAccessDeniedPanel;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.util.PagePanel;
import java.awt.BorderLayout;
import java.awt.Component;

public class MonitorPanel
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private Browser browser = null;
    public static final int DETAIL_REPORT_NODE_INDEX = 1;
    public static final int SELECT_CLOUD_WELCOME = 0;
    public static final int SELECT_CLOUD_STATUS = 1;
    public static final String SELECT_CLOUD_WELCOME_NAME = "WelcomeTab";
    public static final String SELECT_CLOUD_STATUS_NAME = "StatusTab";
    private int panelType;
    private String panelURL = null;
    private int m_nNextURL = 0;
    private String m_strNextURLParams = null;

    public MonitorPanel(int monType) {
        this(monType, null);
    }

    public MonitorPanel(int monType, String monURL) {
        this.panelType = monType;
        this.panelURL = monURL;
    }

    public synchronized void setNextURL(int urlChoice, String strParams) {
        if (this.isInitialized) {
            this.browser.setNextURL(urlChoice, strParams);
        } else {
            this.m_nNextURL = urlChoice;
            this.m_strNextURLParams = strParams;
        }
    }

    public synchronized Object[] getNextURL() {
        Object[] array = new Object[]{this.m_nNextURL, this.m_strNextURLParams};
        return array;
    }

    @Override
    public synchronized void initPanel() {
        if (this.hasInitialized()) {
            return;
        }
        this.browser = this.panelURL != null ? new Browser(this.panelURL) : (this.m_nNextURL != 0 ? new Browser(this.panelType, this.m_nNextURL, this.m_strNextURLParams) : new Browser(this.panelType));
        this.m_nNextURL = 0;
        this.m_strNextURLParams = null;
        this.setLayout(new BorderLayout());
        this.add((Component)this.browser, "Center");
        this.isInitialized = true;
    }

    public void doRefresh() {
        if (this.browser != null) {
            this.browser.doRefresh();
        }
    }

    public void disposeBrowser() {
        if (this.browser != null) {
            this.browser.dispose();
        }
    }

    @Override
    public void refreshTaskBarViews() {
    }

    public int getContextHelpId() {
        return 1000;
    }

    @Override
    public void selectItemIndex(int index) {
        if (this.browser == null) {
            return;
        }
        if (0 == index) {
            this.browser.switchToCloudPage(SELECT_CLOUD_WELCOME_NAME);
        } else if (1 == index) {
            this.browser.switchToCloudPage(SELECT_CLOUD_STATUS_NAME);
        }
    }

    @Override
    public int getItemIndex(int id) {
        int index = -1;
        switch (id) {
            case 0: {
                index = 0;
                break;
            }
            case 1: {
                index = 1;
                break;
            }
        }
        return index;
    }

    @Override
    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.rightComponent, "Center");
    }

    @Override
    public void switchOut() {
        if (this.browser != null) {
            this.browser.stopAutoRefresh();
        }
    }

    @Override
    public void switchIn() {
        if (AdminPrivilegeObject.isCurrentAdminHasReportPrivilege()) {
            this.browser.startAutoRefresh();
        } else {
            ReportingAccessDeniedPanel accessDeniedPanel = new ReportingAccessDeniedPanel();
            accessDeniedPanel.load();
            this.add((Component)accessDeniedPanel, "Center");
        }
    }
}

