/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring;

import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.monitoring.PopupEngineCallbacks;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.StringUtilities;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.net.URI;
import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;

public class BrowserModalDialog {
    private String internalPrefix;
    private String sepmServerHostName;
    private Browser browser;
    private String reportingBaseUrl;

    public BrowserModalDialog(String reportingBaseURL, String internalPrefix, String sepmServerHostName, Browser browser) {
        this.reportingBaseUrl = reportingBaseURL;
        this.internalPrefix = internalPrefix;
        this.sepmServerHostName = sepmServerHostName;
        this.browser = browser;
    }

    private void showDialog(WebView popupWebView, Callback<PopupFeatures, WebEngine> createPopupHandler, int width, int height, int left, int top, boolean modal, String url) {
        JDialog popupDialog = new JDialog(null, "", modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        Browser.updateWindowList(popupDialog);
        JFXPanel panel = new JFXPanel();
        panel.setScene(new Scene((Parent)popupWebView));
        popupDialog.setContentPane((Container)panel);
        popupDialog.setSize(width, height);
        popupDialog.setIconImage(CustomLookAndFeel.TITLE_LOGO_IMAGE);
        if (left != -1 && top != -1) {
            popupDialog.setLocation(left, top);
        } else {
            popupDialog.setLocationRelativeTo(null);
        }
        PopupEngineCallbacks.setCallbacks(popupWebView, createPopupHandler, this.internalPrefix, this.sepmServerHostName, this, popupDialog);
        if (PopupEngineCallbacks.isLinkInternalToSEPM(url, this.internalPrefix, this.sepmServerHostName)) {
            SwingUtilities.invokeLater(() -> {
                popupDialog.setVisible(true);
                popupDialog.toFront();
            });
        } else {
            popupDialog.setVisible(false);
        }
    }

    public JSObject dialog(String url, String title, int width, int height, int left, int top, final JSObject customOnLoadHandler, final JSObject windowOpener, boolean utility) {
        WebView popupWebView = new WebView();
        final WebEngine popupEngine = popupWebView.getEngine();
        final BrowserModalDialog thisReference = this;
        popupEngine.getHistory().setMaxSize(0);
        Callback<PopupFeatures, WebEngine> createPopupHandler = new Callback<PopupFeatures, WebEngine>(){

            public WebEngine call(PopupFeatures config) {
                return Browser.createPopup(this, BrowserModalDialog.this.internalPrefix, thisReference);
            }
        };
        popupEngine.documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> arg0, Document arg1, Document arg2) {
                JSObject windowObject = (JSObject)popupEngine.executeScript("window");
                if (windowOpener != null) {
                    windowObject.setMember("opener", windowOpener);
                }
            }
        });
        popupEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JSObject windowObject = (JSObject)popupEngine.executeScript("window");
                    if (customOnLoadHandler != null) {
                        windowObject.setMember("customOnLoadHandler", customOnLoadHandler);
                        popupEngine.executeScript("window.customOnLoadHandler();");
                    }
                }
            }
        });
        if (url.startsWith("../")) {
            url = url.replaceFirst("\\.\\./", this.reportingBaseUrl);
        }
        popupEngine.load(url);
        this.showDialog(popupWebView, createPopupHandler, width, height, left, top, utility, url);
        JSObject jsobject = (JSObject)popupEngine.executeScript("window");
        return jsobject;
    }

    public void openUrlWithBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex.getMessage());
        }
    }

    protected void registerMouseEnterExitEventsForButton(final Node button, final String enterStyle, final String exitStyle) {
        button.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                button.setStyle(enterStyle);
            }
        });
        button.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                button.setStyle(exitStyle);
            }
        });
    }

    public boolean modalAlert(String title, String msg, String type) {
        try {
            int msgType = 0;
            int optionType = -1;
            String imageSuffix = "";
            if (type.equals("warning")) {
                msgType = 2;
                imageSuffix = "/images/Warn.png";
            } else if (type.equals("error")) {
                msgType = 0;
                imageSuffix = "/images/Error.png";
            } else if (type.equals("info")) {
                msgType = 1;
                imageSuffix = "/images/Info.png";
            } else if (type.equals("question") || type.equals("okcancel")) {
                msgType = 3;
                imageSuffix = "/images/Question.png";
                optionType = 0;
            }
            msg = msg.replaceAll("<br>", System.lineSeparator());
            msg = msg.replaceAll("<.*?>", "");
            msg = StringUtilities.from_html_entities((String)msg);
            String imageUrl = this.reportingBaseUrl + imageSuffix;
            ImageIcon icon = new ImageIcon(new URL(imageUrl));
            JOptionPane pane = new JOptionPane(msg, msgType, optionType, icon, null, 0);
            JDialog dialog = pane.createDialog(Manager.getFrame(), title);
            Browser.updateWindowList(dialog);
            dialog.setVisible(true);
            int response = -1;
            Object responseObj = pane.getValue();
            if (null != responseObj && responseObj instanceof Integer) {
                response = (Integer)responseObj;
            }
            return 0 == response;
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            return false;
        }
    }

    public void refreshMainWindow() {
        this.browser.doRefresh();
    }
}

