/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.monitoring;

import com.creamtec.sepm.ajaxswing.support.WebViewPanel;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.monitoring.BrowserModalDialog;
import com.sygate.scm.console.ui.monitoring.MonitoringMessages;
import com.sygate.scm.console.ui.monitoring.PopupEngineCallbacks;
import com.sygate.scm.console.ui.monitoring.location.DownloadHandler;
import com.sygate.scm.console.ui.monitoring.location.LocationChangeListener;
import com.sygate.scm.console.ui.monitoring.location.LogoutHandler;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.GUIManagerReportingHelper;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.URLUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import netscape.javascript.JSObject;
import org.bouncycastle.jsse.util.URLConnectionUtil;

public class Browser
extends JPanel
implements HierarchyListener {
    static final Set<String> KNOWN_NOT_REFRESHABLE_PAGES = Set.of("export_audit.php", "export_behavior.php", "export_events.php", "export_firewall.php", "export_inventory.php", "export_scans.php", "export_system.php", "export-compliance.php", "getFile.php");
    private static final Object loadStartTimeLock = new Object();
    private static final int MAX_PAGE_LOAD_WAITTIME_SECONDS = 35;
    private String lastUrl = null;
    private String lastRefreshableUrl = null;
    private static final long serialVersionUID = 1L;
    public static final int TYPE_HOMEPAGE = 1;
    public static final int TYPE_MONITORS = 2;
    public static final int TYPE_REPORTS = 3;
    public static final int TYPE_DYNAMIC_PAGE = 5;
    private static boolean isLoginFlowCompleted = false;
    private static boolean isLogOutInProgress = false;
    public static final int CHOICE_MONITORS_NOTILOG = 1;
    public static final int CHOICE_COMMAND_STATUS = 2;
    public static final int CHOICE_SCAN_LOGS = 3;
    public static final int CHOICE_COMPUTER_STATUS = 4;
    public static final int CHOICE_RISK_LOGS = 5;
    public static final int CHOICE_DYNAMIC_PAGE = 6;
    public static final Dimension MIN_DIM = new Dimension(100, 100);
    private static final int LOADING_BAR_TIMEOUT = 10000;
    private ReentrantLock disposingLock = new ReentrantLock();
    private static long loadStartTime = 0L;
    private static final String STATUS_NOTIFICATION = "notification=";
    private static final String REDIRECT_TO_TAG = "redirectto:";
    private static final String REDIRECT_BASE_AV = "monitor_av.php";
    private static final String REDIRECT_FULL_AV = "Reporting/monitors/monitor_av.php";
    private static final String REDIRECT_BASE_FW = "monitor_firewall.php";
    private static final String REDIRECT_FULL_FW = "Reporting/monitors/monitor_firewall.php";
    private static final String REDIRECT_BASE_COMPLIANCE = "monitor_compliance.php";
    private static final String REDIRECT_BASE_DECEPTION = "monitor_deception.php";
    private static final String REDIRECT_FULL_DECEPTION = "Reporting/monitors/monitor_deception.php";
    private static final String REDIRECT_FULL_COMPLIANCE = "Reporting/monitors/monitor_compliance.php";
    private static final String REDIRECT_BASE_STATUS = "monitor_sitestatus.php";
    private static final String REDIRECT_FULL_STATUS = "Reporting/monitors/monitor_sitestatus.php";
    private static final String REDIRECT_BASE_REPORTS = "reports.php";
    private static final String REDIRECT_FULL_REPORTS = "Reporting/reports/reports.php";
    private static final String REDIRECT_BASE_SCHEDULED = "scheduledreports.php";
    private static final String REDIRECT_FULL_SCHEDULED = "Reporting/reports/scheduledreports.php";
    private static final String REDIRECT_BASE_NOTIFICATION_CONDITION = "notification.php";
    private static final String REDIRECT_FULL_NOTIFICATION_CONDITION = "Reporting/Admin/notification.php";
    private static final String REDIRECT_BASE_HOME = "homepage.php";
    private static final String REDIRECT_FULL_HOME = "Reporting/dashboard/homepage.php";
    private static final String REDIRECT_FULL_ERROR = "Reporting/CustomErrors/404.htm";
    private static final String CLOUD_PAGE = "signup/index.html";
    private static final String CONSOLE_URI_PART = "/console/";
    private static final String SEPM_API_SERVER_HOST_KEY = "{SEPM_API_SERVER_HOST}";
    private static final String SEPM_API_SERVER_PORT_KEY = "{SEPM_API_SERVER_PORT}";
    private static final String LOCALE_LANGUAGE_KEY = "{LOCALE_LANGUAGE_KEY}";
    private static final String REPORTING = "/Reporting/";
    private static final String COMMAND_STATUS_PHP_PAGE = "commandstatus.php";
    private JPanel jbrowserpanel = new JPanel();
    private WebViewPanel webPanel;
    private transient BrowserModalDialog browserModalDialog;
    private transient CreatePopupHandler createPopupHandler;
    private transient WebView webView;
    private transient WebEngine webEngine;
    private int m_nType = 1;
    private boolean m_bIsSNACOnlyProduct = false;
    volatile boolean m_bDocumentCompleted = false;
    private transient CountDownLatch loadNextUrlLatch = null;
    private boolean m_bAutoRefresh = true;
    private SimpleProgressDlg progressDlg;
    private int urlChoice = 0;
    private String m_strNextURLParams = null;
    private String dynamicURL = null;
    private static String sepmServerHostName = null;
    private static LinkedList<Window> windowsToCloseOnLogout = new LinkedList();
    private int cloudPageRefreshCounter = 0;
    private long cloudPageRefreshWindowStartTime = 0L;
    private Timer loadingBarTimer = null;

    static boolean isNotRefreshablePage(String url) {
        String testUrl = Optional.ofNullable(url).orElse("");
        return KNOWN_NOT_REFRESHABLE_PAGES.stream().anyMatch(v -> {
            boolean match = testUrl.toLowerCase(Locale.ROOT).contains(v.toLowerCase(Locale.ROOT));
            if (match) {
                ConsoleLogger.log("Browser >> isNotRefreshablePage >> This is a not refreshable page: " + v);
            }
            return match;
        });
    }

    void setLastUrl(String lastUrl) {
        this.lastUrl = lastUrl;
    }

    String getLastRefreshableUrl() {
        return this.lastRefreshableUrl;
    }

    void updateLastRefreshableUrl(String lastUrl) {
        if (Browser.isNotRefreshablePage(lastUrl)) {
            ConsoleLogger.log("Browser >> updateLastRefreshableUrl >> Skip, This is a not refreshable page!");
        } else {
            this.lastRefreshableUrl = lastUrl;
        }
    }

    public Browser(int type) {
        this.initialize(type, 0, null, null);
    }

    public Browser(int type, int alternateURLChoice, String strParams) {
        this.initialize(type, alternateURLChoice, strParams, null);
    }

    public Browser(String url) {
        this.initialize(5, 6, null, url);
    }

    private String getTokenFromDataObjectManager() {
        String token = null;
        SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
        if (loginInfo != null) {
            token = loginInfo.getOptJavaToken();
        }
        return token;
    }

    private void initialize(int type, int alternateUrlChoice, String strParam, String url) {
        try {
            this.m_nType = type;
            this.urlChoice = alternateUrlChoice;
            this.m_strNextURLParams = strParam;
            this.dynamicURL = url;
            this.m_bIsSNACOnlyProduct = LicenseObject.getInstance().isSNACOnlyProduct();
            sepmServerHostName = InetAddress.getLocalHost().getHostName().toLowerCase();
            this.jbInit();
        }
        catch (Throwable th) {
            ConsoleLogger.log(th);
        }
    }

    private URL getWorkingUrl(String pageSpec, String postData, boolean isDynamicPage) throws MalformedURLException {
        if (isDynamicPage) {
            return URLUtility.getComposedURL((String)pageSpec, null);
        }
        return URLUtility.getComposedURL((String)pageSpec, (String)postData);
    }

    public static int checkURLStatus(String urlString) {
        int respCode = 404;
        try {
            URL url = new URL(urlString);
            HttpURLConnection urlConn = (HttpURLConnection)new URLConnectionUtil().openConnection(url);
            urlConn.setReadTimeout(30000);
            urlConn.setConnectTimeout(30000);
            respCode = urlConn.getResponseCode();
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
        return respCode;
    }

    public static String preprocessURL(String urlString) {
        Map<String, String> tokenMap = Browser.getTokenKeyMap();
        for (Map.Entry<String, String> entry : tokenMap.entrySet()) {
            if (!urlString.contains(entry.getKey())) continue;
            urlString = urlString.replace(entry.getKey(), entry.getValue());
        }
        try {
            urlString = URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ConsoleLogger.log(ex);
        }
        return urlString;
    }

    public static WebEngine createPopup(Callback<PopupFeatures, WebEngine> selfReferentialPopupCallback, String internalPrefix, BrowserModalDialog browserModalDialog) {
        final JDialog popupDialog = new JDialog((Window)null, "", Dialog.ModalityType.MODELESS);
        Browser.updateWindowList(popupDialog);
        final WebView popupWebView = new WebView();
        JFXPanel panel = new JFXPanel();
        panel.setScene(new Scene((Parent)popupWebView));
        popupDialog.setContentPane((Container)panel);
        popupDialog.setIconImage(CustomLookAndFeel.TITLE_LOGO_IMAGE);
        popupWebView.getEngine().getHistory().setMaxSize(0);
        PopupEngineCallbacks.setCallbacks(popupWebView, selfReferentialPopupCallback, internalPrefix, sepmServerHostName, browserModalDialog, popupDialog);
        popupWebView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JSObject jsObject = (JSObject)popupWebView.getEngine().executeScript("document.getElementById(\"hideJDialogAfterOpeningUrlInBrowser\")");
                    if (null == jsObject) {
                        popupDialog.pack();
                        UiUtilities.centerComponent((Component)popupDialog);
                        SwingUtilities.invokeLater(() -> {
                            popupDialog.setVisible(true);
                            popupDialog.toFront();
                        });
                    } else {
                        popupDialog.setVisible(false);
                    }
                }
            }
        });
        return popupWebView.getEngine();
    }

    private static Map<String, String> getTokenKeyMap() {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        String sepmApiServerHost = Env.getSEM_SERVER();
        String sepmApiServerPort = Env.getSEPM_WEBSERVICES_PORT();
        keyMap.put(SEPM_API_SERVER_HOST_KEY, sepmApiServerHost);
        keyMap.put(SEPM_API_SERVER_PORT_KEY, sepmApiServerPort);
        keyMap.put(LOCALE_LANGUAGE_KEY, Locale.getDefault().toString());
        return keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jbInit() throws Throwable {
        Object object = loadStartTimeLock;
        synchronized (object) {
            loadStartTime = 0L;
            if (this.webView != null) {
                return;
            }
            if (Browser.isLoginFlowCompleted()) {
                this.displayLoadingBar();
            }
            this.setLayout(new BorderLayout());
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setPreferredSize(new Dimension(screenSize.width * 9 / 10, screenSize.height * 8 / 10));
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            if (Platform.isImplicitExit()) {
                Platform.setImplicitExit((boolean)false);
            }
            ConsoleLogger.log("Browser> jbInit>>: About to create WebBrowser. " + this.hashCode());
            final CountDownLatch initializedLatch = new CountDownLatch(1);
            final URL url = this.getWorkingUrl(this.getPageSpec(), this.m_strNextURLParams, this.m_nType == 5);
            this.webPanel = new WebViewPanel();
            this.createBrowserModalDialog(url);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Browser.this.createWebPanel(initializedLatch);
                        Browser.this.webEngine.load(url.toString());
                    }
                    catch (Throwable th) {
                        initializedLatch.countDown();
                        LoggerUtilities.logException((Throwable)th);
                        Browser.this.showWarning(th.getMessage());
                        ConsoleLogger.log(th);
                    }
                }
            });
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && !initializedLatch.await(35L, TimeUnit.SECONDS)) {
                ConsoleLogger.logError("Browser> jbInit>>: initial web page loading timeout");
            }
        }
        System.out.println("Browser> jbInit>>: WebBrowser created.");
        this.jbrowserpanel.setLayout(new BorderLayout());
        this.add((Component)this.jbrowserpanel, "Center");
        this.addHierarchyListener(this);
        this.disposeLoadingBar();
    }

    private String getBaseUrl(URL url) {
        String urlString = url.toString();
        int reportingUrlStartIndex = urlString.indexOf(REPORTING);
        int cloudUrlStartIndex = urlString.indexOf(CONSOLE_URI_PART);
        if (reportingUrlStartIndex >= 0) {
            return urlString.substring(0, reportingUrlStartIndex + REPORTING.length());
        }
        if (this.m_nType == 5 && cloudUrlStartIndex >= 0) {
            return urlString.substring(0, cloudUrlStartIndex + CONSOLE_URI_PART.length());
        }
        return urlString;
    }

    private void createBrowserModalDialog(URL url) {
        String urlString = url.toString();
        String internalPrefix = this.m_nType == 5 ? urlString : urlString.substring(0, urlString.lastIndexOf(58));
        String baseUrl = this.getBaseUrl(url);
        this.browserModalDialog = new BrowserModalDialog(baseUrl, internalPrefix, sepmServerHostName, this);
        this.createPopupHandler = new CreatePopupHandler(internalPrefix, this.browserModalDialog);
    }

    private void createWebPanel(CountDownLatch initializedLatch) {
        this.webView = new WebView();
        this.setupCookies();
        this.webEngine = this.webView.getEngine();
        this.webEngine.onErrorProperty().set((Object)new ErrorHandler(this.webEngine));
        this.webEngine.setCreatePopupHandler((Callback)this.createPopupHandler);
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new StateChangeListener(this.webEngine, initializedLatch));
        LogoutHandler logoutHandler = new LogoutHandler();
        DownloadHandler downloadHandler = new DownloadHandler(this.webEngine);
        this.webEngine.locationProperty().addListener((ChangeListener)new LocationChangeListener((Worker<Void>)this.webEngine.getLoadWorker(), logoutHandler, downloadHandler));
        this.webEngine.titleProperty().addListener((ChangeListener)new TitleChangeListener());
        PopupEngineCallbacks.setConfirmCallbacks(this.webEngine, this.browserModalDialog);
        Scene webScene = new Scene((Parent)this.webView);
        this.webPanel.setScene(webScene);
        webScene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.F5) {
                    Browser.this.doRefresh();
                }
            }
        });
        this.jbrowserpanel.add((Component)this.webPanel, "Center");
    }

    private String buildUrlForPhpPage(String lastUrl) {
        if (((String)lastUrl).contains(COMMAND_STATUS_PHP_PAGE) && !((String)lastUrl).contains("token=")) {
            lastUrl = ((String)lastUrl).endsWith(".php") ? (String)lastUrl + "?token=" + this.getTokenFromDataObjectManager() : (String)lastUrl + "&token=" + this.getTokenFromDataObjectManager();
        }
        return lastUrl;
    }

    private void displayLoadingBar() {
        if (this.progressDlg == null && this.m_bAutoRefresh) {
            this.progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), MonitoringMessages.getString("Browser.Loading"), "", false);
            this.progressDlg.setCursor(Cursor.getPredefinedCursor(3));
            this.progressDlg.setVisible(true);
        }
        AbstractAction loadingBarForceCloseAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                SwingUtilities.invokeLater(() -> Browser.this.hideLoadingBar());
            }
        };
        this.loadingBarTimer = new Timer(10000, loadingBarForceCloseAction);
        this.loadingBarTimer.setRepeats(false);
        this.loadingBarTimer.start();
    }

    private void hideLoadingBar() {
        try {
            this.disposingLock.lock();
            if (this.progressDlg != null) {
                ConsoleLogger.logError("failed to dispose LoadingBar, hide it");
                this.progressDlg.setCursor(Cursor.getDefaultCursor());
                this.progressDlg.setVisible(false);
                this.progressDlg = null;
            }
        }
        finally {
            this.disposingLock.unlock();
        }
    }

    private void disposeLoadingBarInternal() {
        try {
            this.disposingLock.lock();
            if (this.progressDlg != null) {
                this.progressDlg.setCursor(Cursor.getDefaultCursor());
                this.progressDlg.dispose();
                this.progressDlg = null;
            }
        }
        finally {
            this.disposingLock.unlock();
        }
    }

    private void disposeLoadingBar() {
        SwingUtilities.invokeLater(() -> this.disposeLoadingBarInternal());
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_DIM;
    }

    private boolean isMonitorLogPage(String url) {
        boolean ret = false;
        if (!(StringUtilities.isEmpty((String)url) || url.indexOf("list.php") <= 0 && url.indexOf("log") <= 0 && url.indexOf("results") <= 0 && url.indexOf("events.php") <= 0)) {
            ret = true;
        }
        return ret;
    }

    private boolean isCloudPage(String url) {
        boolean ret = false;
        if (!StringUtilities.isEmpty((String)url) && url.indexOf(CLOUD_PAGE) > 0) {
            ret = true;
        }
        return ret;
    }

    public void doRefresh() {
        if (!this.m_bDocumentCompleted) {
            ConsoleLogger.log("Browser >> Refreshing >> skip since it is still under loading phase!");
            return;
        }
        String oldAddr = Optional.ofNullable(this.getLastRefreshableUrl()).orElse(this.lastUrl);
        if (Browser.isNotRefreshablePage(oldAddr)) {
            ConsoleLogger.log("Browser >> Refreshing >> skip to refresh the page!");
            return;
        }
        if (this.isMonitorLogPage(oldAddr) || oldAddr.contains("alerts.php") || oldAddr.contains(COMMAND_STATUS_PHP_PAGE) || this.isCloudPageAndCanReload(oldAddr)) {
            Platform.runLater((Runnable)new EngineLoadUrl(this.webEngine));
            return;
        }
        if (this.isCloudPage(oldAddr)) {
            ConsoleLogger.log("Browser >> Refreshing >> skip to refresh page: signup/index.html");
            return;
        }
        int reportingIndex = oldAddr.indexOf("Reporting");
        if (reportingIndex > 0) {
            String url = this.getReportRedirectPageUrl(oldAddr);
            Platform.runLater((Runnable)new EngineLoadUrl(url, this.webEngine));
        } else if (this.m_nType == 5) {
            Platform.runLater((Runnable)new EngineLoadUrl(oldAddr, this.webEngine));
        }
    }

    private String getReportRedirectPageUrl(String oldAddr) {
        int reportingIndex = oldAddr.indexOf("Reporting");
        Object redirectPage = oldAddr.substring(reportingIndex);
        int lastQuestionMark = oldAddr.lastIndexOf(63);
        String parameterString = "";
        if (lastQuestionMark > 0 && lastQuestionMark < oldAddr.length()) {
            parameterString = oldAddr.substring(lastQuestionMark);
        }
        if (((String)redirectPage).contains(REDIRECT_BASE_AV)) {
            redirectPage = REDIRECT_FULL_AV;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_FW)) {
            redirectPage = REDIRECT_FULL_FW;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_COMPLIANCE)) {
            redirectPage = REDIRECT_FULL_COMPLIANCE;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_DECEPTION)) {
            redirectPage = REDIRECT_FULL_DECEPTION;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_STATUS)) {
            redirectPage = REDIRECT_FULL_STATUS;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_SCHEDULED)) {
            redirectPage = REDIRECT_FULL_SCHEDULED;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_REPORTS)) {
            redirectPage = REDIRECT_FULL_REPORTS;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_NOTIFICATION_CONDITION)) {
            redirectPage = REDIRECT_FULL_NOTIFICATION_CONDITION;
        } else if (((String)redirectPage).contains(REDIRECT_BASE_HOME)) {
            redirectPage = REDIRECT_FULL_HOME;
        } else {
            Exception ex = new Exception("unrecognized redirect: " + (String)redirectPage);
            redirectPage = REDIRECT_FULL_ERROR;
            ConsoleLogger.log(ex);
        }
        if (!((String)redirectPage).equals(REDIRECT_FULL_ERROR) && !StringUtilities.isEmpty((String)parameterString)) {
            redirectPage = (String)redirectPage + parameterString;
        }
        if (!((String)redirectPage).equals(REDIRECT_FULL_ERROR)) {
            redirectPage = this.appendPostDataIfNecessary((String)redirectPage);
        }
        redirectPage = ((String)redirectPage).replace("?FirstRun=1", "?FirstRun=1&token=" + this.getTokenFromDataObjectManager());
        return GUIManagerReportingHelper.getReportingServer() + "/Reporting/Util/universal-redirect.php?WhereWeWant=" + (String)redirectPage;
    }

    boolean isCloudPageAndCanReload(String oldAddr) {
        if (this.isCloudPage(oldAddr)) {
            if (ScmProperties.getWebServiceRestThrottleEnabled()) {
                long diffMinutes = TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.cloudPageRefreshWindowStartTime);
                int throttleLimit = ScmProperties.getWebServiceRestThrottleThreshold() / 2;
                int throttleWindowSizeMins = ScmProperties.getWebServiceRestThrottleWindowMins();
                if (diffMinutes >= (long)throttleWindowSizeMins) {
                    this.cloudPageRefreshCounter = 0;
                    this.cloudPageRefreshWindowStartTime = System.currentTimeMillis();
                } else if (this.cloudPageRefreshCounter < throttleLimit) {
                    ++this.cloudPageRefreshCounter;
                } else {
                    ConsoleLogger.log("Browser: doRefresh(): Refresh rate limit reached.");
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void switchToCloudPage(final String tabName) {
        if (this.m_nType == 5 && this.lastUrl.contains(CLOUD_PAGE)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Browser.this.webEngine.executeScript("switchTab(\"" + tabName + "\")");
                    }
                    catch (Exception exception) {
                        ConsoleLogger.log(exception);
                    }
                }
            });
        }
    }

    public boolean doLogout() {
        ConsoleLogger.log("Browser >> doLogout begin...");
        Browser.setLogOutInProgress(true);
        if (this.webPanel != null) {
            Platform.runLater(() -> this.webPanel.setScene(null));
        }
        if (this.progressDlg == null) {
            this.progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), MonitoringMessages.getString("Browser.PleaseWait"), MonitoringMessages.getString("Browser.ShuttingDown"), false);
            this.progressDlg.setCursor(Cursor.getPredefinedCursor(3));
            this.progressDlg.setVisible(true);
        }
        String url = GUIManagerReportingHelper.getReportingServer() + "/Reporting/Login/Logout.php?ssc=1&linkActivated=1";
        ConsoleLogger.log("Browser >> doLogout, url: " + url);
        Platform.runLater((Runnable)new EngineLoadUrl(url, this.webEngine));
        ConsoleLogger.log("Browser >> doLogout done!");
        return true;
    }

    public void dispose() {
        ConsoleLogger.log("Disposing Browser " + this.hashCode());
        this.closeAllPopupWindows();
    }

    private void closeAllPopupWindows() {
        for (Window window : windowsToCloseOnLogout) {
            try {
                ConsoleLogger.log("Closing window " + window.hashCode());
                window.dispose();
                if (!(((JDialog)window).getContentPane() instanceof JFXPanel)) continue;
                Platform.runLater(() -> ((JFXPanel)((JDialog)window).getContentPane()).setScene(null));
            }
            catch (Exception ex) {
                ConsoleLogger.log("While closing window " + window.hashCode() + " Error: " + ex.getMessage());
            }
        }
        windowsToCloseOnLogout.clear();
    }

    public void setNextURL(int nextURLChoice, String strParams) {
        this.urlChoice = nextURLChoice;
        this.m_strNextURLParams = strParams;
    }

    public void stopAutoRefresh() {
        this.m_bAutoRefresh = false;
        if (this.m_bDocumentCompleted) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!ScmProperties.isWebdebugEnabled()) {
                            Browser.this.webEngine.executeScript("window.onerror = function() { return true; }");
                        }
                        Browser.this.webEngine.executeScript("try {var head = document.getElementsByTagName('head'); if (head) { head[0].setAttribute('stop', 1); }} catch(error) { }");
                    }
                    catch (Throwable th) {
                        ConsoleLogger.log(th);
                    }
                }
            });
        } else if (this.progressDlg != null) {
            this.progressDlg.setVisible(false);
        }
    }

    public void startAutoRefresh() {
        this.forceLoadNextUrl();
        this.startAutoRefresh(true);
    }

    private void forceLoadNextUrl() {
        if (0 != this.urlChoice || this.m_nType == 5) {
            try {
                URL url = this.getWorkingUrl(this.getPageSpec(), this.m_strNextURLParams, this.m_nType == 5);
                this.setAuthenticateTokenCookie();
                this.loadNextUrlLatch = new CountDownLatch(1);
                Platform.runLater((Runnable)new EngineLoadUrl(url.toString(), this.webEngine));
                if (!this.loadNextUrlLatch.await(5L, TimeUnit.SECONDS)) {
                    ConsoleLogger.log("Timeout when waiting for the tab to be loaded!");
                }
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
            finally {
                this.loadNextUrlLatch = null;
            }
        }
    }

    private void setAuthenticateTokenCookie() throws IOException, URISyntaxException {
        URL url = this.getWorkingUrl(this.getPageSpec(), this.m_strNextURLParams, this.m_nType == 5);
        String accessTokenCookie = "RestApiAccessToken=" + GUIManager.getAccessToken() + "; Path=/sepm; Secure; HttpOnly; SameSite=strict";
        Map<String, List<String>> headers = Map.of("Set-Cookie", List.of(accessTokenCookie));
        CookieHandler.getDefault().put(url.toURI(), headers);
    }

    private void startAutoRefresh(boolean switchIn) {
        this.m_bAutoRefresh = true;
        if (switchIn) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        String urlStr = Browser.this.webEngine.getLocation();
                        if (!StringUtilities.isEmpty((String)urlStr)) {
                            if (urlStr.toLowerCase().indexOf("Reporting/command/commandstatus.php".toLowerCase()) > 0) {
                                Browser.this.webEngine.executeScript("document.auto.submit()");
                            }
                            Browser.this.webEngine.executeScript("try {var head = document.getElementsByTagName('head'); if (head) { head[0].setAttribute('stop', 0); }} catch(error) { }");
                        }
                    }
                    catch (Exception ex) {
                        ConsoleLogger.log(ex);
                    }
                }
            });
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent ev) {
        long ll = ev.getChangeFlags();
        if ((ll & 4L) == 4L) {
            try {
                this.jbInit();
            }
            catch (Throwable e1) {
                ConsoleLogger.log(e1);
            }
            final boolean isShow = this.isShowing();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Browser.this.jbrowserpanel.removeAll();
                    if (isShow) {
                        Browser.this.jbrowserpanel.add((Component)Browser.this.webPanel);
                    }
                    Browser.this.webView.setVisible(isShow);
                    Browser.this.webPanel.setVisible(isShow);
                    Browser.this.jbrowserpanel.setVisible(isShow);
                }
            });
        }
    }

    private String getPageSpec() {
        String baseUrl = GUIManagerReportingHelper.getReportingServer();
        switch (this.m_nType) {
            case 1: {
                return this.m_bIsSNACOnlyProduct ? baseUrl + "/Reporting/monitors/monitor_compliance.php" : baseUrl + "/Reporting/dashboard/homepage.php";
            }
            case 2: {
                if (this.urlChoice == 1) {
                    this.urlChoice = 0;
                    return baseUrl + "/Reporting/alerts/alerts.php?FirstRun=0&DashboardAjax=1&token=" + this.getTokenFromDataObjectManager();
                }
                if (this.urlChoice == 2) {
                    this.urlChoice = 0;
                    return baseUrl + "/Reporting/command/commandstatus.php?token=" + this.getTokenFromDataObjectManager();
                }
                if (this.urlChoice == 3) {
                    this.urlChoice = 0;
                    return baseUrl + "/Reporting/scans/scanlist.php?token=" + this.getTokenFromDataObjectManager() + "&FavoriteFilterName=\"\"";
                }
                if (this.urlChoice == 4) {
                    if (ScmProperties.isDeceptionEnabled()) {
                        return baseUrl + "/Reporting/monitors/monitor_deception.php";
                    }
                    this.urlChoice = 0;
                    return baseUrl + "/Reporting/inventory/inventorylist.php?token=" + this.getTokenFromDataObjectManager() + "&FavoriteFilterName=\"\"";
                }
                if (this.urlChoice == 5) {
                    this.urlChoice = 0;
                    return baseUrl + "/Reporting/events/events.php?token=" + this.getTokenFromDataObjectManager() + "&FavoriteFilterName=\"\"";
                }
                if (ScmProperties.isDeceptionEnabled()) {
                    return baseUrl + "/Reporting/monitors/monitor_deception.php";
                }
                return this.m_bIsSNACOnlyProduct ? baseUrl + "/Reporting/monitors/monitor_sitestatus.php" : baseUrl + "/Reporting/inventory/inventorylist.php?token=" + this.getTokenFromDataObjectManager() + "&FirstRun=1";
            }
            case 3: {
                return baseUrl + "/Reporting/reports/reports.php?token=" + this.getTokenFromDataObjectManager();
            }
            case 5: {
                String processedURL = Browser.preprocessURL(this.dynamicURL);
                String errorPage = baseUrl + "/Reporting/CustomErrors/404.htm";
                Object retUrl = Browser.checkURLStatus(processedURL) == 200 ? processedURL : errorPage;
                this.urlChoice = 0;
                return retUrl;
            }
        }
        return baseUrl + "/Reporting/dashboard/homepage.php";
    }

    private static void appendParameterToURL(StringBuilder url, String parameter) {
        if (url.indexOf(parameter) >= 0) {
            return;
        }
        if (url.indexOf("?") < 0) {
            if (parameter.startsWith("?")) {
                url.append(parameter);
            } else {
                url.append('?').append(parameter);
            }
        } else if (parameter.startsWith("&")) {
            url.append(parameter);
        } else {
            url.append('&').append(parameter);
        }
    }

    private String appendPostDataIfNecessary(String url) {
        StringBuilder newURL = new StringBuilder(url);
        if (this.m_strNextURLParams != null) {
            Browser.appendParameterToURL(newURL, this.m_strNextURLParams);
        }
        if (this.getTokenFromDataObjectManager() != null) {
            Browser.appendParameterToURL(newURL, "token=" + this.getTokenFromDataObjectManager());
        }
        return newURL.toString();
    }

    private void showWarning(Object inputValue) {
        Object[] obj = new Object[]{inputValue};
        String pattern = MonitoringMessages.getString("Browser.InvalieUrlMsg");
        JOptionPane.showMessageDialog(this, MessageFormat.format(pattern, obj), MonitoringMessages.getString("Browser.Warning"), 2);
    }

    protected static void updateWindowList(Window incoming) {
        ConsoleLogger.log("Adding new window " + incoming.hashCode());
        windowsToCloseOnLogout.removeIf(w -> {
            if (!w.isDisplayable() && !w.isVisible()) {
                ConsoleLogger.log("Closing window " + w.hashCode());
                w.dispose();
                Platform.runLater(() -> ((JFXPanel)((JDialog)w).getContentPane()).setScene(null));
                return true;
            }
            return false;
        });
        windowsToCloseOnLogout.add(incoming);
    }

    public static boolean isLoginFlowCompleted() {
        return isLoginFlowCompleted;
    }

    public static void setLoginFlowCompleted(boolean isLoginFlowCompleted) {
        Browser.isLoginFlowCompleted = isLoginFlowCompleted;
    }

    public static boolean isLogOutInProgress() {
        return isLogOutInProgress;
    }

    public static void setLogOutInProgress(boolean isLogOutInProgress) {
        Browser.isLogOutInProgress = isLogOutInProgress;
    }

    private void setupCookies() {
        try {
            if (this.m_nType == 1 || this.m_nType == 2 || this.m_nType == 3) {
                this.setSessionKeyAndIdCookie();
            } else if (0 != this.urlChoice || this.m_nType == 5) {
                this.setAuthenticateTokenCookie();
            }
        }
        catch (IOException | URISyntaxException e) {
            ConsoleLogger.log(e);
        }
    }

    private void setSessionKeyAndIdCookie() throws URISyntaxException, IOException {
        URI uri = new URI(GUIManagerReportingHelper.getReportingServer());
        String sessionKeyAndId = GUIManagerReportingHelper.getSessionKeyAndId();
        String cookieValue = sessionKeyAndId + "; Path=/Reporting; SameSite=Strict; Secure; HttpOnly";
        Map<String, List<String>> headers = Map.of("Set-Cookie", List.of(cookieValue));
        CookieHandler.getDefault().put(uri, headers);
    }

    private static class EngineLoadUrl
    implements Runnable {
        private String url;
        private WebEngine engine;

        EngineLoadUrl(String url, WebEngine engine) {
            this.url = url;
            this.engine = engine;
        }

        EngineLoadUrl(WebEngine engine) {
            this.url = null;
            this.engine = engine;
        }

        @Override
        public void run() {
            this.engine.executeScript("window.stop()");
            this.engine.getLoadWorker().cancel();
            if (this.url == null) {
                this.engine.reload();
            } else {
                this.engine.load(this.url);
            }
        }
    }

    private final class TitleChangeListener
    implements ChangeListener<String> {
        private final JButton doNothingButton = new JButton();

        private TitleChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            try {
                System.out.println("Browser> jbInit>>: Thread[" + Thread.currentThread().getName() + "], webEngine.titleProperty() changed! newValue: " + newValue);
                if (StringUtilities.isEmpty((String)newValue)) {
                    return;
                }
                if (newValue.contains(Browser.REDIRECT_TO_TAG)) {
                    int index = newValue.indexOf(Browser.REDIRECT_TO_TAG);
                    String statusData = newValue.substring(index + Browser.REDIRECT_TO_TAG.length());
                    this.processRedirectPage(statusData);
                }
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
        }

        private void processRedirectPage(String statusData) {
            if (StringUtilities.isEmpty((String)statusData)) {
                return;
            }
            if (Browser.this.m_bAutoRefresh) {
                ActionEvent ev = new ActionEvent(this.doNothingButton, 1001, "php keep alive event");
                EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                eq.postEvent(ev);
            }
            if (statusData.indexOf(Browser.STATUS_NOTIFICATION) >= 0) {
                String parameters = (String)Browser.this.webEngine.executeScript("self.location.hash");
                ConsoleLogger.log("processRedirectPage statusData=" + statusData + " parameters=" + parameters);
                if (!StringUtilities.isEmpty((String)parameters) && parameters.charAt(0) == '#') {
                    parameters = parameters.substring(1);
                }
                String script = "try { self.document.title = ''; } catch(error) { }";
                Browser.this.webEngine.executeScript(script);
                Manager.getFrame().showNotificationLog(parameters);
            }
        }
    }

    private final class StateChangeListener
    implements ChangeListener<Worker.State> {
        private final CountDownLatch initializedLatch;
        private final WebEngine webEngine;

        private StateChangeListener(WebEngine webEngine, CountDownLatch initializedLatch) {
            this.webEngine = webEngine;
            this.initializedLatch = initializedLatch;
        }

        public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
            Browser.this.lastUrl = this.webEngine.getLocation();
            System.out.println("Browser> jbInit>>: Thread[" + Thread.currentThread().getName() + "], newState = " + newState);
            if (Worker.State.SUCCEEDED == newState || Worker.State.FAILED == newState || Worker.State.CANCELLED == newState) {
                System.out.println("Browser> jbInit>>: Thread[" + Thread.currentThread().getName() + "] Total Time to load the page = " + (System.nanoTime() - loadStartTime) + "(ns).");
                Browser.this.m_bDocumentCompleted = true;
                this.initializedLatch.countDown();
                if (null != Browser.this.lastUrl && Browser.this.loadNextUrlLatch != null) {
                    Browser.this.loadNextUrlLatch.countDown();
                }
                Platform.runLater(() -> {
                    try {
                        JSObject jsobject = (JSObject)this.webEngine.executeScript("window");
                        jsobject.setMember("jfx", Browser.this.browserModalDialog);
                    }
                    catch (Exception ex) {
                        ConsoleLogger.log(ex);
                    }
                });
            } else if (Worker.State.RUNNING == newState) {
                loadStartTime = System.nanoTime();
                Browser.this.m_bDocumentCompleted = false;
            }
            if (null != Browser.this.lastUrl && (Browser.this.lastUrl.contains(".php") || Browser.this.m_nType == 5)) {
                Browser.this.lastUrl = Browser.this.buildUrlForPhpPage(Browser.this.lastUrl);
                Browser.this.webPanel.setLastPage(Browser.this.lastUrl);
            }
            Browser.this.updateLastRefreshableUrl(Browser.this.lastUrl);
        }
    }

    private static final class ErrorHandler
    implements EventHandler<WebErrorEvent> {
        private final WebEngine webEngine;

        public ErrorHandler(WebEngine webEngine) {
            this.webEngine = webEngine;
        }

        public void handle(WebErrorEvent event) {
            if (event.getEventType() == WebErrorEvent.USER_DATA_DIRECTORY_ALREADY_IN_USE) {
                try {
                    Path tmpFolderPath = Files.createTempDirectory("localStorage", new FileAttribute[0]);
                    this.webEngine.userDataDirectoryProperty().set((Object)tmpFolderPath.toFile());
                }
                catch (IOException ex) {
                    ConsoleLogger.log("WebEngine user data directory is in use in a different JVM - but failed to set different directory.");
                    ConsoleLogger.log(ex);
                }
            }
        }
    }

    private static final class CreatePopupHandler
    implements Callback<PopupFeatures, WebEngine> {
        private final String internalPrefix;
        private final BrowserModalDialog browserModalDialog;

        private CreatePopupHandler(String internalPrefix, BrowserModalDialog browserModalDialog) {
            this.internalPrefix = internalPrefix;
            this.browserModalDialog = browserModalDialog;
        }

        public WebEngine call(PopupFeatures config) {
            return Browser.createPopup(this, this.internalPrefix, this.browserModalDialog);
        }
    }
}

