/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.dlg;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SimpleProgressDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private boolean isDeterminate;
    private static final int MAX_PROGRESS = 100;
    private JProgressBar progressBar;

    public SimpleProgressDlg(Frame frame, String title, String message, boolean modal) {
        this(frame, title, message, modal, false);
    }

    public SimpleProgressDlg(Frame frame, String title, String message, boolean modal, boolean isDeterminate) {
        super(frame, modal);
        this.isDeterminate = isDeterminate;
        this.setUndecorated(true);
        this.initialize(title, message);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        UiUtilities.centerComponentInMultiGraphicsDevice((Component)this, (Container)frame);
    }

    public void updateProgress(int progress) {
        if (this.progressBar != null) {
            this.progressBar.setValue(progress);
        }
    }

    protected void initialize(String title, String message) {
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(UIFontUtilities.TITLE_FONT);
        titleLabel.setBackground(Color.CYAN);
        DescriptionTextArea txtArea = new DescriptionTextArea("\n" + message, 5, 35);
        this.progressBar = new JProgressBar();
        if (this.isDeterminate) {
            this.progressBar.setMaximum(100);
        } else {
            this.progressBar.setIndeterminate(true);
        }
        JPanel panel = new JPanel(new VerticalFlowLayout(0, 0));
        panel.setBorder(BorderFactory.createCompoundBorder(CustomLookAndFeel.UNDECORATED_DIALOG_BORDER, BorderFactory.createEmptyBorder(10, 30, 30, 30)));
        panel.add(titleLabel);
        panel.add(txtArea);
        panel.add(this.progressBar);
        this.getContentPane().add(panel);
        this.pack();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.getRootPane().setWindowDecorationStyle(0);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            super.setVisible(b);
        } else if (ClientAgent.getCurrentInstance().getUpdateBrowserInterval() > 0) {
            super.setVisible(b);
        }
    }
}

