/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.dlg;

import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.dlg.ICancel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public class ProgressDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL_BUTTON = 1;
    public static final int RUN_IN_BACKGROUND_BUTTON = 2;
    public static final int ALL_BUTTONS = 3;
    private JPanel jPanel = new JPanel(new VerticalFlowLayout());
    private JPanel buttonPanel = new JPanel();
    private JTextArea txtArea = new DescriptionTextArea("", 3, 30);
    private JButton stopBtn = new JButton(UIText.get(4621));
    private JButton runInBackgroundBtn = new JButton(UIText.get(4623));
    private JProgressBar progressBar = new JProgressBar();
    private String message = "";
    private boolean isCancelled = false;
    private ICancel aCancelDlg = null;
    private SwingWorker worker = null;

    public ProgressDlg(Frame frame, ICancel aCancelDlg, SwingWorker worker, String title, String message, boolean modal) {
        this(frame, aCancelDlg, worker, title, message, modal, 1);
    }

    public ProgressDlg(Frame frame, ICancel aCancelDlg, SwingWorker worker, String title, String message, boolean modal, int buttonOptions) {
        super(frame, title, modal);
        this.message = message;
        this.worker = worker;
        this.aCancelDlg = aCancelDlg;
        try {
            this.jbInit(buttonOptions);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit(int buttonOptions) throws Exception {
        this.setDefaultCloseOperation(2);
        this.stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDlg.this.stopBtnActionPerformed(e);
            }
        });
        this.runInBackgroundBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                ProgressDlg.this.setVisible(false);
            }
        });
        this.txtArea.setFont(this.jPanel.getFont());
        this.txtArea.setText(this.message);
        this.txtArea.setEditable(false);
        this.txtArea.setLineWrap(true);
        this.txtArea.setOpaque(false);
        this.txtArea.setBackground(this.progressBar.getBackground());
        this.jPanel.add(this.txtArea);
        this.progressBar.setPreferredSize(new Dimension(300, 21));
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        if (buttonOptions == 3 || buttonOptions == 2) {
            this.buttonPanel.add(this.runInBackgroundBtn);
            UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.runInBackgroundBtn);
        }
        if (buttonOptions == 3 || buttonOptions == 1) {
            this.buttonPanel.add(this.stopBtn);
        }
        this.jPanel.add(this.progressBar);
        this.jPanel.add(this.buttonPanel);
        this.jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 20));
        this.getContentPane().add(this.jPanel);
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        this.dispose();
    }

    public void setBorder(Border border) {
        this.jPanel.setBorder(border);
        this.pack();
    }

    public void setButtonText(String text) {
        this.stopBtn.setText(text);
    }

    private void stopBtnActionPerformed(ActionEvent e) {
        this.isCancelled = true;
        this.aCancelDlg.setCancelSearch(true);
        this.worker.interrupt();
        this.dispose();
    }

    public void addStopActionListener(ActionListener listener) {
        this.stopBtn.addActionListener(listener);
    }
}

