/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.GroupCheckBoxTree;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SylinkdropOptionsPanel
extends ClientInstallationWizard
implements PropertyChangeListener {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final JRadioButton jRBUserMode = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SylinkdropOptionsPanel.userMode"));
    private static final JRadioButton jRBComputerMode = new JRadioButton(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SylinkdropOptionsPanel.computerMode"), true);
    private GroupCheckBoxTree groupTree;
    private DefaultMutableTreeNode node;
    private int activeMode;
    public static final int VIEW_MODE = 0;
    private DescriptionTextArea desc;
    private JPanel modePanel;

    public SylinkdropOptionsPanel(boolean isSMB) {
        super(null, isSMB);
    }

    public SylinkdropOptionsPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "SylinkdropOptionsPanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "SylinkdropOptionsPanel.title");
    }

    public void setAppropriateVisible() {
        if (this.modePanel != null) {
            if (this.getWizard().getWizardTypePanel().isSylinkDropWin()) {
                this.modePanel.setVisible(true);
            } else {
                this.modePanel.setVisible(false);
            }
        }
    }

    private JTextArea getDescription() {
        if (this.desc == null) {
            this.desc = new DescriptionTextArea(MessageResources.getInstance().getString(CLIENTDIALOG, "SylinkdropOptionsPanel.viewGroupDesc"));
        }
        return this.desc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("check".equals(evt.getPropertyName()) && ((GroupCheckBoxTree)evt.getSource()).getSelectionPath() != null) {
            this.node = (DefaultMutableTreeNode)((GroupCheckBoxTree)evt.getSource()).getSelectionPath().getLastPathComponent();
        }
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public GroupObject getSelectedGroup() {
        return (GroupObject)this.node.getUserObject();
    }

    public String getSelectedGroupId() {
        String gpId = null;
        GroupObject group = this.getSelectedGroup();
        if (group != null) {
            gpId = group.getId();
        }
        return gpId;
    }

    public boolean isComputerMode() {
        return jRBComputerMode.isSelected();
    }

    public GroupPolicyObject getGroupObject() {
        GroupPolicyObject gpObj = null;
        try {
            GroupObject group = this.getSelectedGroup();
            if (group == null) {
                return gpObj;
            }
            gpObj = PolicyHandler.getGroupPolicyByGroupFromDB(group);
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        return gpObj;
    }

    public int getAgentMode() {
        int agentMode = this.isComputerMode() ? 1 : 0;
        return agentMode;
    }

    private void selectDefaultGroup() {
        GroupObject group = GroupHandler.getDefaultGroupObject();
        try {
            if (group != null) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.groupTree.getModel().getRoot();
                int count = root.getChildCount();
                for (int i = 0; i < count; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                    if (!group.toString().equals(node.getUserObject().toString())) continue;
                    TreePath path = new TreePath(node.getPath());
                    this.groupTree.setSelectionPath(path);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.groupTree.setSelectionRow(0);
    }

    @Override
    protected JPanel getCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel groupPanel = new JPanel();
        this.groupTree = new GroupCheckBoxTree();
        this.groupTree.addPropertyChangeListener("check", this);
        try {
            this.groupTree.init(Manager.getCurrentDomainId(), true, this.activeMode == 0);
            this.groupTree.setVisibleRowCount(20);
        }
        catch (ConsoleException ce) {
            LoggerUtilities.logException((Throwable)ce);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        this.groupTree.expandAll();
        this.groupTree.setEnabled(true);
        if (this.activeMode == 0) {
            this.groupTree.setSelectionMode(5);
        }
        groupPanel.setLayout(new GridBagLayout());
        groupPanel.add((Component)this.getDescription(), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.1, 18, 2, new Insets(10, 15, 0, 15), 0, 0));
        groupPanel.add((Component)new JScrollPane(this.groupTree), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.1, 18, 2, new Insets(10, 15, 0, 15), 0, 0));
        panel.add((Component)groupPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 2, new Insets(15, 0, 0, 25), 0, 0));
        this.modePanel = new JPanel(new GridBagLayout());
        panel.add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 15, 2, new Insets(10, 15, 0, 30), 0, 0));
        if (!this.isSMB()) {
            ButtonGroup group = new ButtonGroup();
            group.add(jRBUserMode);
            group.add(jRBComputerMode);
            this.modePanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString(CLIENTDIALOG, "SylinkdropOptionsPanel.modeSetting")));
            String modeDesc = MessageResources.getInstance().getString(CLIENTDIALOG, "SylinkdropOptionsPanel.modeDesc");
            this.modePanel.add((Component)new DescriptionTextArea(modeDesc, 2, 30), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel modelRBPanel = new JPanel(new GridBagLayout());
            modelRBPanel.add((Component)jRBComputerMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            modelRBPanel.add((Component)jRBUserMode, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.modePanel.add((Component)modelRBPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.selectDefaultGroup();
        return panel;
    }
}

