/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.ExportFolderChooser;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SavePackagePanel
extends ClientInstallationWizard {
    public static final String DEF_EXPORT_DIR = "";
    public static final int PACKAGE_SINGLE_EXE = 0;
    public static final int PACKAGE_MULTI_FILES = 1;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private JPanel centerPanel;
    public static final String DEF_EXPORT_DIR_SBE = "";
    private JButton browseButton;
    private JTextField pathField;
    private ButtonGroup optionsGroup;
    private JRadioButton jRBSingleExe;
    private JRadioButton jRBMultiFiles;
    private int package_format = 0;
    private JCheckBox chkLegacyPackage;
    private boolean isMac1015;

    public SavePackagePanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected String getTitleDescription() {
        return "";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.optionsGroup = new ButtonGroup();
        this.jRBSingleExe = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.optionSingleExe"), true);
        this.jRBMultiFiles = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.optionSeparateFile"));
        this.package_format = 0;
        this.chkLegacyPackage = new JCheckBox(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.chkExportLegacy"));
        this.chkLegacyPackage.setSelected(false);
    }

    @Override
    protected String getTitle() {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.titleLabelTextWeb");
        }
        return MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.titleLabelText");
    }

    private void setPackageFormatOptions() {
        this.optionsGroup.add(this.jRBSingleExe);
        this.optionsGroup.add(this.jRBMultiFiles);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SavePackagePanel.this.updateOptions();
            }
        };
        this.jRBSingleExe.addActionListener(listener);
        this.jRBMultiFiles.addActionListener(listener);
    }

    protected void updateOptions() {
        if (this.jRBSingleExe.isSelected()) {
            this.setPackage_format(0);
        } else {
            this.setPackage_format(1);
        }
    }

    @Override
    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new GridBagLayout());
            this.setPackageFormatOptions();
            this.browseButton = new JButton(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.browse"));
            this.pathField = new JTextField(20);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(240);
            this.pathField.setDocument(doc);
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.pathField.setText(Utility.getTempDir() + File.separator + Env.getWebConsoleIndex());
            } else {
                this.pathField.setText("");
            }
            this.pathField.getAccessibleContext().setAccessibleName(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.titleLabelText"));
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SavePackagePanel.this.browseActionPerformed();
                }
            });
            int y = 0;
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.centerPanel.add((Component)this.pathField, new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 18, 2, insertToLogo, 0, 0));
                this.centerPanel.add((Component)this.browseButton, new GridBagConstraints(1, y, 1, 1, 0.1, 0.0, 18, 0, new Insets(10, 15, 0, 25), 0, 0));
            }
            this.centerPanel.add((Component)this.jRBSingleExe, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 40, 0, 5), 0, 0));
            this.centerPanel.add((Component)this.jRBMultiFiles, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 40, 0, 0), 0, 0));
            this.centerPanel.add((Component)new JLabel(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 18, 2, new Insets(10, 25, 0, 5), 0, 0));
        }
        return this.centerPanel;
    }

    protected void browseActionPerformed() {
        String strExportDirPath = this.getDirPath();
        ExportFolderChooser fc = new ExportFolderChooser(strExportDirPath);
        if (0 != fc.showOpenDialog(Manager.getFrame())) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        String path = fc.getSelectedFile().getAbsolutePath();
        if (path == null || path.trim().length() == 0) {
            return;
        }
        if (!this.handlePathLength(path)) {
            return;
        }
        this.pathField.setText(path);
    }

    public boolean validatePanel(GroupObject group) {
        String dirName = this.getDirPath();
        boolean isValid = true;
        if (StringUtilities.isEmpty((String)dirName) || PackageWorker.isValidDir(dirName) != 0 && PackageWorker.isValidDir(dirName) != 1) {
            isValid = false;
        }
        if (isValid) {
            int validCode = PackageWorker.isValidDir(PackageWorker.generateExportFullPathForGroup(null, dirName, group, this.isMac1015 ? ConstantValue.getMacExportPath((String)this.getWizard().getSelectedPackage().get(0).getSoftwarePackageObject().getPackageInfo().getVersion()) : ""));
            boolean bl = isValid = validCode == 0 || validCode == 1;
        }
        if (!isValid) {
            JOptionPane.showMessageDialog(this.getWizardStagePanel(), MessageResources.getInstance().getString(CLIENTDIALOG, "SavePackagePanel.exportDirectoryInvalid"), MessageResources.getInstance().getString(CLIENTDIALOG, "ExportPackageDlg.error"), 0);
        }
        return isValid;
    }

    public String getDirPath() {
        return this.pathField.getText().trim();
    }

    private boolean handlePathLength(String path) {
        String str;
        Object[] obj;
        if (path == null) {
            return false;
        }
        String dirName = path;
        boolean isMacPackage = this.getWizard().isMacPackageSelected();
        int maxInputDirLen = ConstantValue.getMaxSelectedDirPathForExport((boolean)isMacPackage);
        int maxTargetDirLen = ConstantValue.getMaxPackageExportPath((boolean)isMacPackage);
        String fullExportPath = path;
        try {
            if (this.getWizard().getSelectedPackage().size() > 0) {
                GroupObject groupObj = this.getWizard().getGroup();
                SoftwarePackageObject packageObj = this.getWizard().getSelectedPackage().get(0).getSoftwarePackageObject();
                fullExportPath = PackageWorker.generateExportFullPathForGroup(packageObj, path, groupObj, this.isMac1015 ? ConstantValue.getMacExportPath((String)packageObj.getPackageInfo().getVersion()) : "");
            }
        }
        catch (Exception e) {
            ConsoleLogger.log("Error converting full export path out of user input path");
            ConsoleLogger.log(e);
        }
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && dirName.length() > maxInputDirLen) {
            obj = new Object[]{Integer.toString(maxInputDirLen), Integer.toString(maxTargetDirLen), fullExportPath};
            str = MessageResources.getInstance().getString(CLIENTDIALOG, "SelectFileTypePanel.pathCharacteresExceed0Msg");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this.getWizardStagePanel(), fm, MessageResources.getInstance().getString(CLIENTDIALOG, "ExportPackageDlg.error"), 0);
            return false;
        }
        if (fullExportPath.length() > maxTargetDirLen) {
            obj = new Object[]{Integer.toString(maxTargetDirLen), fullExportPath};
            str = MessageResources.getInstance().getString(CLIENTDIALOG, "SelectFileTypePanel.pathCharacteresExceed0WarnMsg");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this.getWizardStagePanel(), fm, MessageResources.getInstance().getString(CLIENTDIALOG, "SelectFileTypePanel.warning"), 2);
        }
        return true;
    }

    public void setPackage_format(int package_format) {
        this.package_format = package_format;
    }

    public int getPackage_format() {
        return this.package_format;
    }

    public boolean isSingleFileSelected() {
        return this.package_format == 0;
    }

    public void updateUIForMacOrLinux(boolean isMacOrLinuxPkg, boolean isMac1015) {
        this.isMac1015 = isMac1015;
        this.jRBSingleExe.setEnabled(!isMacOrLinuxPkg);
        if (!isMacOrLinuxPkg) {
            if (this.jRBMultiFiles.getText().equals(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.optionSeparateFile.mac"))) {
                this.jRBSingleExe.setSelected(true);
                this.jRBMultiFiles.setText(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.optionSeparateFile"));
            }
        } else {
            this.jRBMultiFiles.setText(MSGRES.getString(CLIENTDIALOG, "SavePackagePanel.optionSeparateFile.mac"));
            this.jRBMultiFiles.setSelected(true);
        }
        this.updateOptions();
    }

    public void updateUIForCommunicationSettings(boolean isUpdateCommunicationSettings) {
        if (isUpdateCommunicationSettings) {
            this.jRBSingleExe.setVisible(false);
            this.jRBMultiFiles.setVisible(false);
        } else {
            this.jRBSingleExe.setVisible(true);
            this.jRBMultiFiles.setVisible(true);
        }
    }

    public boolean legacyPackageSelected() {
        return this.isSMB() && this.chkLegacyPackage.isSelected();
    }
}

