/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.dlg.ClientInstallationSettingsDlg;
import com.sygate.scm.console.ui.admin.dlg.CustomFeaturesDialog;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallFeaturePoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallPoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.admin.logicobject.CustomClientInstallationFeatureObject;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.client.dlg.PackageContentPanel;
import com.sygate.scm.console.ui.client.dlg.SelectGroupDlg;
import com.sygate.scm.console.ui.client.dlg.UpgradeSettingsPanelMac;
import com.sygate.scm.console.ui.client.wizard.CategoryList;
import com.sygate.scm.console.ui.client.wizard.ClientInstallFeaturePanel;
import com.sygate.scm.console.ui.client.wizard.SelectFeatureDialog;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.ToolTipComboBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PackageOptionsPanel
extends ClientInstallationWizard
implements ActionListener {
    private static Logger logger = Logger.getLogger(PackageOptionsPanel.class.getName());
    private static final String AUTOMATION_PACKAGE_BUILD_SELECTION = "PackageBuildSelection";
    public static final int PACKAGE_FOR_WIN = 0;
    public static final int PACKAGE_FOR_MAC = 1;
    public static final int PACKAGE_FOR_LINUX = 2;
    public static final int INSTALL_UNATTENDED = 1;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private boolean isSNACPackage;
    private GroupObject groupObject;
    private static final int MAX_COMBO_WIDTH = 565;
    private static final int MIN_COMBO_WIDTH = 150;
    private static final int DEFAULT_COMBO_HEIGHT = new JComboBox<E>().getPreferredSize().height;
    private JEditorPane jEPDescTour;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.av.logicobject.avlogicobject");
    private JLabel jLblPackages;
    private JLabel jLblGroup;
    private JLabel jLblProtection;
    private DescriptionTextArea jLblProtectionDisplay;
    private JLabel jLblInstallationStyle;
    private JLabel jLblContentOptions;
    private DescriptionTextArea jLblFeatures;
    private DescriptionTextArea featuresWarning;
    private static final ClientInstallationFeatureObject customSBEFeatureOptions = new CustomClientInstallationFeatureObject();
    public static final String nopackageError = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "PackageOptionsPanel.noAvailablePackagesError");
    public static final String nopackageErrorTitle = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "PackageOptionsPanel.validationError");
    private JComboBox<String> jCbAvailablePackages;
    private DescriptionTextArea packageDesc;
    private JPanel packagesPanel;
    private JComboBox<ClientInstallationFeatureObject> featuresComboBox;
    private JPanel protectionsPanel;
    private JPanel installOptionsPanel;
    private JButton jBReboot;
    private RebootOptions rebootOptions;
    private JComboBox<ClientInstallationSettingObject> settingComboBox;
    private ClientInstallationSettingObject installSettings;
    private ClientInstallationFeatureObject installFeatures;
    private int packageOSType;
    private String packageOSTypeString;
    private List<CurrentPackageObject> selectedPackages;
    private int installStyle;
    private ArrayList<CurrentPackageObject> listUndeployedPackages;
    private Map<String, Icon> osIconMap;
    private JPanel groupPanel;
    private JTextField groupNameField;
    private JButton jBBrowse;
    private JButton jBEdit;
    private ClientInstallFeaturePanel featurePanel;
    private JLabel jLblHelpLink;
    private JLabel packageSecurityFixBuildPanelLbl;
    private JPanel securityFixBuildNumberComboPanel;
    private JComboBox<String> securityFixBuildNumberComboBox;
    private JPanel contentPanel;
    private PackageContentPanel packageContentPanel;
    private String currentPackageVersion;
    private HashMap<Object, CategoryList> packageMap;
    private HashMap<Object, CategoryList> legacyPackages;
    private ClientInstallPoolObject settingsPool;
    private ClientInstallFeaturePoolObject featuresPool;
    private CustomFeaturesDialog dlg = null;
    private UpgradeSettingsPanelMac upgradeSettingsMac;
    private JLabel jLblUpgradeSettingsMac;
    private JLabel osSettingsLbl;
    static final Pattern versionPattern = Pattern.compile("\\d+[.\\s]");

    public PackageOptionsPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        this(wizard, null, isSMB);
    }

    public PackageOptionsPanel(InstallClientWizardDialog wizard, GroupObject group, boolean isSMB) {
        super(wizard, isSMB);
        this.setGroup(this.initGroupObject(group));
        this.groupNameField.setText(this.groupObject == null ? "" : this.groupObject.getFullGroupPath());
    }

    @Override
    protected String getTitleDescription() {
        return "";
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.title2");
    }

    private GroupObject initGroupObject(GroupObject groupObject) {
        if (groupObject != null) {
            return groupObject;
        }
        GroupObject defaultGroup = GroupHandler.getDefaultGroupObject();
        if (defaultGroup == null || !defaultGroup.isFullAccessible()) {
            return GroupHandler.getFirstFullAccessGroup();
        }
        return defaultGroup;
    }

    private void showFeaturePanelHelp() {
        String fmtString = Utility.getCDWTourType((boolean)LicenseObject.getInstance().isSBProduct());
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage(), fmtString};
        String strURL = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "SupportLink.url"), obj);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().openInNewTab(strURL);
            return;
        }
        int urlRet = URLUtility.browseURI((String)strURL);
        String msg = null;
        switch (urlRet) {
            case 1: {
                logger.log(Level.INFO, ">>> showFeaturePanelHelp() browseURI : " + strURL + "  URL is in wrong format or can't convert to URL");
                msg = MSGRES.getString(CLIENTDIALOG, "BrowseURI.error.ErrorURL");
                UIUtilities.showErrorDialog(msg);
                break;
            }
            case 3: {
                logger.log(Level.INFO, ">>> showFeaturePanelHelp() browseURI : " + strURL + "  Can't launch default web browser");
                msg = MSGRES.getString(CLIENTDIALOG, "BrowseURI.error.NeedDefaultBrowser");
                UIUtilities.showErrorDialog(msg);
                break;
            }
            case 2: {
                logger.log(Level.INFO, ">>> showFeaturePanelHelp() browseURI : " + strURL + "  Current OS doesn't support Desktop or BROWSE action");
                msg = MSGRES.getString(CLIENTDIALOG, "BrowseURI.error.OSCannotSupport");
                UIUtilities.showErrorDialog(msg);
                break;
            }
        }
    }

    @Override
    protected void initialize() {
        this.jLblPackages = new JLabel(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.lblPackageforInstall"));
        this.packageDesc = new DescriptionTextArea();
        this.jLblGroup = new JLabel(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.lblGroup"));
        this.isSNACPackage = false;
        this.jLblProtection = new JLabel(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.lblProtection"));
        this.jLblProtectionDisplay = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "ClientInstallFeaturePanel.allFeatureOption"), 20);
        this.jLblInstallationStyle = new JLabel(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.lblInstallationOptions"));
        this.jLblContentOptions = new JLabel(MSGRES.getString(CLIENTDIALOG, "PackageOptionsPanel.lblContentOptions"));
        this.jLblFeatures = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "PackageOptionsPanel.noDescription"));
        this.featuresWarning = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.FeaturesWarning"));
        this.jLblUpgradeSettingsMac = new JLabel(MSGRES.getString(CLIENTDIALOG, "PackageOptionsPanel.upgradeSettingsLabel"));
        this.osSettingsLbl = new JLabel(MSGRES.getString(CLIENTDIALOG, "PackageOptionsPanel.osSettingsLabel"));
        this.jBReboot = new JButton(UIText.get(3585));
        this.packageOSType = 0;
        this.packageOSTypeString = "WIN32BIT".toString();
        this.installStyle = 1;
        this.osIconMap = new HashMap<String, Icon>();
        this.groupNameField = new JTextField();
        this.jBBrowse = new JButton(UIText.get(257));
        this.jBEdit = new JButton(UIText.get(3585));
        this.currentPackageVersion = "";
        this.jLblHelpLink = new HtmlEnabledJLabel(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.descTour.linkText"), true);
        this.jLblHelpLink.setIcon(ConsoleMain.whatsThisIcon);
        this.jLblHelpLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PackageOptionsPanel.this.showFeaturePanelHelp();
            }
        });
        this.featurePanel = this.getFeaturePanel();
    }

    List<String> getAllPackages() {
        List<String> allPackages = null;
        List<Object> retList = new ArrayList();
        try {
            ArrayList<CurrentPackageObject> listUndeployedPackages = SoftwarePackageHandler.getCurrentSoftwarePackages();
            retList = !LicenseObject.getInstance().isSBProduct() ? this.removeSBEPackages(listUndeployedPackages) : listUndeployedPackages;
            retList = SoftwarePackageHandler.removeODCPackages(retList);
            if (retList != null && retList.size() > 0) {
                allPackages = this.combinePackages(retList);
            }
        }
        catch (ConsoleException e1) {
            ConsoleLogger.log(e1);
        }
        return allPackages;
    }

    private List<SoftwarePackageObject> removeLegacyPackages(List<SoftwarePackageObject> allPackages) {
        ArrayList<SoftwarePackageObject> retList = new ArrayList<SoftwarePackageObject>();
        for (int i = allPackages.size() - 1; i >= 0; --i) {
            SoftwarePackageObject pkgObj = allPackages.get(i);
            String pkgVersion = pkgObj.getVersion();
            if (Utility.compareVersion((String)pkgVersion, (String)"12.1.0.0") <= 0) continue;
            retList.add(pkgObj);
        }
        return retList;
    }

    private boolean areCurrentPackagesTdadCompatible() {
        boolean compatible = true;
        for (int i = this.getSelectedPackages().size() - 1; i >= 0; --i) {
            CurrentPackageObject pkgObj = this.getSelectedPackages().get(i);
            String pkgVersion = pkgObj.getSoftwarePackageObject().getVersion(true);
            if (Utility.compareVersion((String)pkgVersion, (String)"14.2.0.1000", (boolean)true) >= 0) continue;
            compatible = false;
            break;
        }
        return compatible;
    }

    private List<CurrentPackageObject> removeSBEPackages(ArrayList<CurrentPackageObject> allPackages) {
        ArrayList<CurrentPackageObject> retList = new ArrayList<CurrentPackageObject>();
        for (int i = allPackages.size() - 1; i >= 0; --i) {
            CurrentPackageObject pkgObj = allPackages.get(i);
            String version = pkgObj.getSoftwarePackageObject().getVersion();
            if (Utility.compareVersion((String)version, (String)"12.0.0.0") >= 0 && Utility.compareVersion((String)version, (String)"12.1.0.0") < 0) continue;
            logger.log(Level.INFO, ">>> PackageOptionspanel::removeSBEPackages() " + pkgObj.getPackageName() + "  is staying. ");
            retList.add(pkgObj);
        }
        Collections.reverse(retList);
        return retList;
    }

    List<String> combinePackages(List<CurrentPackageObject> allPackages) {
        this.packageMap = new HashMap();
        List<SoftwarePackageObject> list = new ArrayList<SoftwarePackageObject>();
        boolean ignoreBuildNumber = false;
        for (int i = 0; i < allPackages.size(); ++i) {
            CurrentPackageObject pkgObj = allPackages.get(i);
            ignoreBuildNumber = false;
            if (PackageUtil.isLinuxStub((String)pkgObj.getPlatformType())) {
                ignoreBuildNumber = true;
            }
            String key = pkgObj.getSoftwarePackageObject().getClientPackageDisplayStringType();
            key = this.formatClientVersion(key, ignoreBuildNumber);
            this.osIconMap.put(key, pkgObj.getPlatformLabelForSwPackage().getIcon());
            if (this.packageMap.containsKey(key)) {
                this.addItemToMap(key, pkgObj);
            } else {
                CategoryList cList = new CategoryList(key, pkgObj);
                this.packageMap.put(key, cList);
                list.add(pkgObj.getSoftwarePackageObject());
            }
            this.findLegacyPackages(key, pkgObj);
        }
        if (LicenseObject.getInstance().isSBProduct()) {
            list = this.removeLegacyPackages(list);
        }
        ArrayList<String> rs = new ArrayList<String>();
        for (SoftwarePackageObject sp : list) {
            rs.add(sp.getClientPackageDisplayStringType());
        }
        return rs;
    }

    private String formatClientVersion(String key, boolean ignoreBuildNumber) {
        Matcher m = versionPattern.matcher(key);
        Object version = "";
        while (m.find()) {
            version = (String)version + m.group();
        }
        String formattedVersion = Utility.getFormattedClientVersion((String)version, (boolean)ignoreBuildNumber);
        if (formattedVersion != null) {
            key = key.replace((CharSequence)version, formattedVersion);
        }
        if (key.contains("Stub ")) {
            key = key.replace("Stub ", "");
        }
        return key;
    }

    private void findLegacyPackages(String key, CurrentPackageObject pkgObj) {
        String newVersion = pkgObj.getSoftwarePackageObject().getVersion();
        if (!this.isSMB() && Utility.compareVersion((String)newVersion, (String)"12.0.0.0") > 0) {
            return;
        }
        if ("WIN64BIT".equals(pkgObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
            return;
        }
        if (this.legacyPackages == null) {
            this.legacyPackages = new HashMap();
            CategoryList cList = new CategoryList(key, pkgObj);
            cList.setCategory(pkgObj.getPackageType());
            this.legacyPackages.put(key, cList);
        } else {
            String existingKey = this.findSameType(this.legacyPackages, pkgObj.getPackageType());
            if (existingKey != null) {
                CategoryList oldList = this.legacyPackages.get(existingKey);
                CurrentPackageObject oldObj = oldList.getItemList().get(0);
                String oldVersion = oldObj.getSoftwarePackageObject().getVersion();
                if (Utility.compareVersion((String)oldVersion, (String)newVersion) < 0) {
                    this.legacyPackages.remove(existingKey);
                    CategoryList newList = new CategoryList(key, pkgObj);
                    this.legacyPackages.put(key, newList);
                }
            } else {
                CategoryList newList = new CategoryList(key, pkgObj);
                newList.setCategory(pkgObj.getPackageType());
                this.legacyPackages.put(key, newList);
            }
        }
    }

    private String findSameType(HashMap<Object, CategoryList> map, int type) {
        String result = null;
        if (map == null || map.isEmpty()) {
            return null;
        }
        Set<Map.Entry<Object, CategoryList>> entrySet = map.entrySet();
        if (entrySet == null || entrySet.size() == 0) {
            return null;
        }
        for (Map.Entry<Object, CategoryList> entry : entrySet) {
            CategoryList value = entry.getValue();
            if (value.getCategory() != type) continue;
            result = value.getKey();
            break;
        }
        return result;
    }

    private void addItemToMap(String key, CurrentPackageObject pkgObj) {
        CategoryList list = this.packageMap.get(key);
        list.addItem(pkgObj);
    }

    JComboBox<String> getAvailablePackagesCombo() {
        if (this.jCbAvailablePackages == null) {
            List<String> packagesList = this.getAllPackages();
            if (packagesList == null || packagesList.isEmpty()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), nopackageError, nopackageErrorTitle, 0);
                this.jCbAvailablePackages = new JComboBox();
                return this.jCbAvailablePackages;
            }
            String[] packages = packagesList.toArray(new String[0]);
            String[] formattedPackages = new String[packages.length];
            int count = 0;
            boolean ignoreBuildNumber = false;
            for (String strTemp : packages) {
                String version;
                ignoreBuildNumber = strTemp.startsWith(MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_stub")) || strTemp.startsWith(MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_ARM64"));
                formattedPackages[count] = version = this.formatClientVersion(strTemp, ignoreBuildNumber);
                ++count;
            }
            this.jCbAvailablePackages = new JComboBox<String>(formattedPackages);
            this.resetComboBoxSize(this.jCbAvailablePackages);
            if (packagesList.size() > 0) {
                this.jCbAvailablePackages.setSelectedIndex(0);
                this.setSelectedPackage(this.jCbAvailablePackages.getSelectedItem().toString(), null);
            }
            this.jCbAvailablePackages.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PackageOptionsPanel.this.setSelectedPackage(PackageOptionsPanel.this.jCbAvailablePackages.getSelectedItem().toString(), null);
                }
            });
        }
        return this.jCbAvailablePackages;
    }

    private void resetComboBoxSize(JComboBox jComboBox) {
        jComboBox.setRenderer(new ToolTipComboBoxRenderer(this.osIconMap));
        int comboHeight = jComboBox.getPreferredSize().height;
        if (jComboBox.getPreferredSize().width > 565) {
            jComboBox.setPreferredSize(new Dimension(565, comboHeight));
        } else if (jComboBox.getPreferredSize().width < 150) {
            jComboBox.setPreferredSize(new Dimension(150, comboHeight));
        }
    }

    private JPanel getPackagesPanel() {
        if (this.packagesPanel == null) {
            this.packagesPanel = new JPanel(new GridBagLayout());
            this.jCbAvailablePackages = this.getAvailablePackagesCombo();
            this.packagesPanel.add(this.jCbAvailablePackages, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 5, 0, 10), 0, 0));
        }
        this.jCbAvailablePackages.setPreferredSize(new Dimension(565, this.jCbAvailablePackages.getPreferredSize().height));
        return this.packagesPanel;
    }

    protected JComboBox<ClientInstallationFeatureObject> getFeaturesComboBox() throws ConsoleException {
        boolean hasItem = false;
        if (this.featuresComboBox == null) {
            if (this.isSMB()) {
                Vector<ClientInstallationFeatureObject> options = this.getSBECDWFeatureSets();
                this.featuresComboBox = new JComboBox<ClientInstallationFeatureObject>(options);
                if (options != null && options.size() > 0) {
                    hasItem = true;
                    this.setInstallFeatures((ClientInstallationFeatureObject)this.featuresComboBox.getSelectedItem());
                }
                this.featuresComboBox.addItem(customSBEFeatureOptions);
            } else {
                this.featuresPool = new ClientInstallFeaturePoolObject();
                Vector<ClientInstallationFeatureObject> allSettings = new Vector<ClientInstallationFeatureObject>(this.featuresPool.getAllObjects());
                this.featuresComboBox = new JComboBox<ClientInstallationFeatureObject>(allSettings);
                if (allSettings != null && allSettings.size() > 0) {
                    hasItem = true;
                    this.setInstallFeatures((ClientInstallationFeatureObject)this.featuresComboBox.getSelectedItem());
                }
            }
            this.featuresComboBox.setRenderer(new ToolTipComboBoxRenderer(this.osIconMap));
            this.featuresComboBox.addActionListener(this);
            if (hasItem) {
                this.featuresComboBox.setSelectedIndex(0);
            }
        }
        this.featuresComboBox.setPreferredSize(new Dimension(360, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        return this.featuresComboBox;
    }

    public static boolean isFeatureSetTdadOnly(ClientInstallationFeatureObject obj) {
        boolean isFeatureSetTdadOnly = true;
        Vector enabledClientFeatures = obj.getClientInstallationFeatures().getEnabledClientFeatures();
        for (int i = 0; i < enabledClientFeatures.size(); ++i) {
            Vector clientFeatures = ((EnabledClientFeatures)enabledClientFeatures.get(i)).getClientFeature();
            for (int j = 0; j < clientFeatures.size(); ++j) {
                String name = ((ClientFeature)clientFeatures.get(j)).getFeatureName();
                if (name.equals("Core") || name.equals("ADDefense")) continue;
                isFeatureSetTdadOnly = false;
            }
        }
        return isFeatureSetTdadOnly;
    }

    protected void showCustomOptions() {
        try {
            CustomClientInstallationFeatureObject settingObj = (CustomClientInstallationFeatureObject)this.featuresComboBox.getSelectedItem();
            if (this.dlg == null) {
                this.dlg = new CustomFeaturesDialog((JFrame)Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "PackageOptionsPanel.createCustomPackageTitle"), true, settingObj);
            }
            this.dlg.setVisible(true);
            if (!this.dlg.isOk()) {
                this.featuresComboBox.setSelectedIndex(0);
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
        }
    }

    private JPanel getProtectionsPanel() throws ConsoleException {
        if (this.protectionsPanel == null) {
            this.jBEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PackageOptionsPanel.this.selectFeature();
                }
            });
            this.protectionsPanel = new JPanel(new GridBagLayout());
            this.featuresComboBox = this.getFeaturesComboBox();
            this.protectionsPanel.add(this.featuresComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(10, 5, 0, 20), 0, 0));
            this.protectionsPanel.add((Component)this.jLblFeatures, new GridBagConstraints(0, 1, 1, 1, 10.0, 0.0, 17, 2, new Insets(0, 5, 0, 20), 0, 0));
            this.protectionsPanel.add((Component)this.featuresWarning, new GridBagConstraints(0, 3, 1, 1, 10.0, 0.0, 17, 2, new Insets(0, 5, 0, 20), 0, 0));
            this.featuresComboBox.setPreferredSize(new Dimension(565, DEFAULT_COMBO_HEIGHT));
        }
        return this.protectionsPanel;
    }

    protected void selectFeature() {
        SelectFeatureDialog featureDlg = new SelectFeatureDialog(this.featurePanel, MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.selectFeatureDlgTitle"), true);
        if (featureDlg.isOk()) {
            this.featurePanel.save();
            this.updateSelectionDisplay();
        }
    }

    private void updateSelectionDisplay() {
        this.jLblProtectionDisplay.setText(this.featurePanel.getEnabledCategories());
    }

    private JPanel getInstallOptionsPanel() {
        if (this.installOptionsPanel == null) {
            this.installOptionsPanel = new JPanel(new GridBagLayout());
            try {
                this.settingComboBox = this.getSettingComboBox();
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
            }
            this.installOptionsPanel.add(this.settingComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.installOptionsPanel.add((Component)this.jBReboot, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.settingComboBox.setPreferredSize(new Dimension(565, DEFAULT_COMBO_HEIGHT));
            this.jBReboot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PackageOptionsPanel.this.editInstallationSetting();
                }
            });
        }
        return this.installOptionsPanel;
    }

    @Override
    protected JPanel getCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.jEPDescTour = new JEditorPane();
        this.jEPDescTour.setContentType("text/html");
        this.jEPDescTour.setEditable(false);
        this.jEPDescTour.setOpaque(false);
        this.jEPDescTour.setText(this.getTourDescText());
        this.jEPDescTour.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String strURL = e.getURL().toString();
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                        ClientAgent.getCurrentInstance().openInNewTab(strURL);
                        return;
                    }
                    int urlRet = URLUtility.browseURI((String)strURL);
                    String msg = null;
                    switch (urlRet) {
                        case 1: {
                            logger.log(Level.INFO, ">>> getCenterPanel() browseURI : " + strURL + "  URL is in wrong format or can't convert to URL");
                            msg = MSGRES.getString(PackageOptionsPanel.CLIENTDIALOG, "BrowseURI.error.ErrorURL");
                            UIUtilities.showErrorDialog(msg);
                            break;
                        }
                        case 3: {
                            logger.log(Level.INFO, ">>> getCenterPanel() browseURI : " + strURL + "  Can't launch default web browser");
                            msg = MSGRES.getString(PackageOptionsPanel.CLIENTDIALOG, "BrowseURI.error.NeedDefaultBrowser");
                            UIUtilities.showErrorDialog(msg);
                            break;
                        }
                        case 2: {
                            logger.log(Level.INFO, ">>> getCenterPanel() browseURI : " + strURL + "  Current OS doesn't support Desktop or BROWSE action");
                            msg = MSGRES.getString(PackageOptionsPanel.CLIENTDIALOG, "BrowseURI.error.OSCannotSupport");
                            UIUtilities.showErrorDialog(msg);
                            break;
                        }
                    }
                }
            }
        });
        int y = 0;
        panel.add((Component)this.jLblPackages, new GridBagConstraints(0, y, 1, 1, 0.0, 1.0, 18, 0, new Insets(20, 25, 10, 0), 0, 0));
        panel.add((Component)this.getPackagesPanel(), new GridBagConstraints(1, y, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.jLblPackages.setLabelFor(this.jCbAvailablePackages);
        panel.add((Component)this.getPackageSecurityFixBuildPanelLbl(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 25, 10, 0), 0, 0));
        panel.add((Component)this.getPackageSecurityFixBuildPanel(), new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.getPackageSecurityFixBuildPanelLbl().setLabelFor(this.getPackageSecurityFixBuildComboBox());
        panel.add((Component)this.packageDesc, new GridBagConstraints(1, ++y, 2, 1, 0.0, 1.0, 18, 2, new Insets(10, 12, 0, 10), 0, 0));
        panel.add((Component)this.jLblGroup, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 25, 0, 0), 0, 0));
        panel.add((Component)this.getGroupPanel(), new GridBagConstraints(1, y, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.jLblGroup.setLabelFor(this.groupNameField);
        panel.add((Component)this.jLblProtection, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 25, 10, 0), 0, 0));
        try {
            panel.add((Component)this.getProtectionsPanel(), new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 10), 0, 0));
        }
        catch (ConsoleException ce) {
            ConsoleLogger.log(ce);
        }
        this.jLblProtection.setLabelFor(this.featuresComboBox);
        panel.add((Component)this.jLblInstallationStyle, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 25, 10, 0), 0, 0));
        panel.add((Component)this.getInstallOptionsPanel(), new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.jLblInstallationStyle.setLabelFor(this.settingComboBox);
        this.jLblInstallationStyle.setVisible(!this.isSMB());
        this.installOptionsPanel.setVisible(!this.isSMB());
        this.contentPanel = this.getPackageContentPanel();
        panel.add((Component)this.jLblContentOptions, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 25, 0, 0), 0, 0));
        panel.add((Component)this.contentPanel, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 2, 0, 10), 0, 0));
        this.upgradeSettingsMac = new UpgradeSettingsPanelMac(true, false);
        panel.add((Component)this.jLblUpgradeSettingsMac, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 25, 30, 0), 0, 0));
        panel.add((Component)this.upgradeSettingsMac, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 11, 2, new Insets(20, -10, 35, 10), 0, 0));
        this.UpdateUIForMacAndLinux();
        this.updateSettingBoxByPackageOSType();
        JPanel outPanel = new JPanel(new BorderLayout());
        outPanel.add((Component)panel, "North");
        return outPanel;
    }

    private ClientInstallFeaturePanel getFeaturePanel() {
        if (this.featurePanel == null) {
            this.featurePanel = new ClientInstallFeaturePanel(this.isSMB(), 1){
                private static final long serialVersionUID = 1L;
            };
            this.featurePanel.setBorder(BorderFactory.createEtchedBorder());
            this.featurePanel.setVisible(true);
        }
        return this.featurePanel;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new GridBagLayout());
            this.packageContentPanel = this.getPackageContentPanel();
            this.contentPanel.add((Component)this.jLblContentOptions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 25, 0, 0), 0, 0));
            this.contentPanel.add((Component)this.packageContentPanel, new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 17, 2, new Insets(20, 25, 0, 0), 0, 0));
        }
        return this.contentPanel;
    }

    protected JLabel getPackageSecurityFixBuildPanelLbl() {
        if (this.packageSecurityFixBuildPanelLbl == null) {
            this.packageSecurityFixBuildPanelLbl = new JLabel(MessageResources.getInstance().getString(CLIENTDIALOG, "ExportPackageDlg.Pickup_securityFixBuildNumber2"));
        }
        return this.packageSecurityFixBuildPanelLbl;
    }

    private JPanel getPackageSecurityFixBuildPanel() {
        if (this.securityFixBuildNumberComboPanel == null) {
            this.securityFixBuildNumberComboPanel = new JPanel(new GridBagLayout());
            this.securityFixBuildNumberComboPanel.add(this.getPackageSecurityFixBuildComboBox(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 5, 0, 10), 0, 0));
        }
        return this.securityFixBuildNumberComboPanel;
    }

    protected JComboBox<String> getPackageSecurityFixBuildComboBox() {
        if (this.securityFixBuildNumberComboBox == null) {
            this.securityFixBuildNumberComboBox = new JComboBox();
            UIUtilities.setName(this.securityFixBuildNumberComboBox, "packageManagement", UIUtilities.ComponentType.COMBOBOX, AUTOMATION_PACKAGE_BUILD_SELECTION);
            this.securityFixBuildNumberComboBox.setPreferredSize(new Dimension(565, this.securityFixBuildNumberComboBox.getPreferredSize().height));
            this.resetComboBoxSize(this.securityFixBuildNumberComboBox);
        }
        return this.securityFixBuildNumberComboBox;
    }

    protected void updateSecurityFixBuildNumberPanel(final String selectedPackage, final List<CurrentPackageObject> selectedList, String defaultSecurityFixBuildNumber) {
        boolean isSecurityFix = true;
        Vector<String> allSecurityFixBuilds = new Vector<String>();
        if (selectedList != null && selectedList.size() > 0) {
            for (CurrentPackageObject currentPackageObj : selectedList) {
                if (!currentPackageObj.getSoftwarePackageObject().isSecurityFixContent()) {
                    isSecurityFix = false;
                    continue;
                }
                Vector<SecurityFixContentInfoObject> allSecurityFixInfoTmp = currentPackageObj.getSoftwarePackageObject().getSecurityFixContentBuildNumbers();
                for (SecurityFixContentInfoObject tmpSecurityFixInfo : allSecurityFixInfoTmp) {
                    if (allSecurityFixBuilds.contains(tmpSecurityFixInfo.getSecurityFixContentInfo().getProductBuildNum())) continue;
                    ConsoleLogger.log("Add this build, it is  from " + currentPackageObj.getPackageName());
                    allSecurityFixBuilds.add(tmpSecurityFixInfo.getSecurityFixContentInfo().getProductBuildNum());
                }
            }
        }
        if (isSecurityFix) {
            this.getPackageSecurityFixBuildPanelLbl().setVisible(true);
            this.getPackageSecurityFixBuildComboBox().setVisible(true);
            this.getPackageSecurityFixBuildComboBox().removeAllItems();
            for (String securityFixBuild : allSecurityFixBuilds) {
                this.getPackageSecurityFixBuildComboBox().addItem(securityFixBuild);
            }
            for (Iterator<CurrentPackageObject> iterator : this.getPackageSecurityFixBuildComboBox().getActionListeners()) {
                this.getPackageSecurityFixBuildComboBox().removeActionListener((ActionListener)((Object)iterator));
            }
            this.getPackageSecurityFixBuildComboBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PackageOptionsPanel.this.packageSecurityFixBuildComboBoxSelectChange(selectedPackage, selectedList);
                }
            });
            this.packageSecurityFixBuildComboBoxDefaut(defaultSecurityFixBuildNumber);
            this.packageSecurityFixBuildComboBoxSelectChange(selectedPackage, selectedList);
        } else {
            this.getPackageSecurityFixBuildPanelLbl().setVisible(false);
            this.getPackageSecurityFixBuildComboBox().setVisible(false);
        }
    }

    private void packageSecurityFixBuildComboBoxDefaut(String defaultSecurityFixBuildNumber) {
        int selectionIndex = 0;
        if (defaultSecurityFixBuildNumber != null) {
            for (int index = 0; index < this.getPackageSecurityFixBuildComboBox().getItemCount(); ++index) {
                if (!defaultSecurityFixBuildNumber.equalsIgnoreCase(this.getPackageSecurityFixBuildComboBox().getItemAt(index))) continue;
                selectionIndex = index;
                ConsoleLogger.log("packageSecurityFixBuildComboBoxDefaut >> Found target SecurityFix build number:  " + defaultSecurityFixBuildNumber + ", index: " + index);
                break;
            }
        }
        ConsoleLogger.log("packageSecurityFixBuildComboBoxDefaut >> Set default selection with index:  " + selectionIndex);
        this.getPackageSecurityFixBuildComboBox().setSelectedIndex(selectionIndex);
    }

    protected void packageSecurityFixBuildComboBoxSelectChange(String selectedPackage, List<CurrentPackageObject> selectedList) {
        ArrayList<CurrentPackageObject> selectedListSecurityFix = new ArrayList<CurrentPackageObject>();
        if (selectedList == null || selectedList.size() <= 0) {
            return;
        }
        String selectedBuild = this.getSelectedSecurityFixBuildNum();
        ConsoleLogger.log("The selected SecurityFix build number is: " + selectedBuild);
        for (CurrentPackageObject currentPackageObj : selectedList) {
            SecurityFixContentInfoObject securityFixInfo = currentPackageObj.getSoftwarePackageObject().getSecurityFixContentInfoObject(selectedBuild);
            if (securityFixInfo == null) continue;
            ConsoleLogger.log("Found SecurityFix build " + securityFixInfo.getSecurityFixContentInfo().getProductBuildNum() + ", package: " + currentPackageObj.getPackageName());
            selectedListSecurityFix.add(currentPackageObj);
            currentPackageObj.getSoftwarePackageObject().getPackageInfo().setOptProductBuildNum(securityFixInfo.getSecurityFixContentInfo().getProductBuildNum());
            currentPackageObj.getSoftwarePackageObject().getPackageInfo().setChecksum(securityFixInfo.getSecurityFixContentInfo().getPackageChecksum());
        }
        this.updatePackageInfoPanel(selectedPackage, selectedList);
        this.setSelectedPackages(selectedListSecurityFix);
    }

    protected String getSelectedSecurityFixBuildNum() {
        return (String)this.getPackageSecurityFixBuildComboBox().getSelectedItem();
    }

    private PackageContentPanel getPackageContentPanel() {
        if (this.packageContentPanel == null) {
            this.packageContentPanel = new PackageContentPanel(1);
        }
        return this.packageContentPanel;
    }

    private JPanel getGroupPanel() {
        if (this.groupPanel == null) {
            this.groupPanel = new JPanel();
            this.groupPanel.setLayout(new GridBagLayout());
            this.groupNameField.setEnabled(false);
            this.groupNameField.setPreferredSize(new Dimension(565, this.groupNameField.getPreferredSize().height));
            this.groupNameField.setMinimumSize(new Dimension(565, this.groupNameField.getPreferredSize().height));
            this.groupPanel.add((Component)this.groupNameField, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            this.groupPanel.add((Component)this.jBBrowse, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.jBBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PackageOptionsPanel.this.browse();
                }
            });
        }
        return this.groupPanel;
    }

    private String getTourDescText() {
        StringBuffer strBuffDesc = new StringBuffer();
        strBuffDesc.append("<HTML><BODY><DIV " + HTMLUtilities.WIZARD_CONTENT_STYLE_STD + "\">");
        strBuffDesc.append(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.descTour"));
        strBuffDesc.append("</DIV>");
        strBuffDesc.append("</BODY></HTML>");
        return strBuffDesc.toString();
    }

    public GroupObject getGroup() {
        return this.groupObject;
    }

    public ClientInstallationFeatures getFeatures() {
        return this.getInstallFeatures().getClientInstallationFeatures();
    }

    public EnabledClientFeatures getEnabledFeatures() {
        String version = "14.3.5000.0";
        version = this.getCurrentPackageVersion();
        return ClientInstallFeatureSetUtility.findEnabledFeaturesByVersion((String)version, (ClientInstallationFeatures)this.getInstallFeatures().getClientInstallationFeatures());
    }

    public void saveFeatures() {
        this.featurePanel.save();
    }

    public boolean validatePanel() throws GUICheckException {
        if (this.getSelectedPackages() == null) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.errorInvalidPackage"));
        }
        String groupName = this.groupNameField.getText();
        if (!this.featurePanel.isValidate()) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.errorFeatures"));
        }
        if (groupName.length() < 1) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.errorGroup"));
        }
        boolean areCurrentPackagesTdadCompatible = this.areCurrentPackagesTdadCompatible();
        boolean isFeatureSetTdadOnly = PackageOptionsPanel.isFeatureSetTdadOnly((ClientInstallationFeatureObject)this.featuresComboBox.getSelectedItem());
        if (!areCurrentPackagesTdadCompatible && isFeatureSetTdadOnly) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.tdadIncompatible"));
        }
        try {
            this.validateGroup(groupName);
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.errorInvalidGroup"));
        }
        catch (GUICheckException ee) {
            throw ee;
        }
        return !PackageUtil.isUnInstallEnabled((InstallationOption)this.installSettings.getInstallationOption()) || this.continueIfCuNotApplicable(this.selectedPackages.get(0).getSoftwarePackageObject());
    }

    private boolean continueIfCuNotApplicable(SoftwarePackageObject pkg) {
        if (!PackageUtil.isCuApplicablePackage((SoftwarePackage)pkg.getSoftwarePackage())) {
            return 0 == MultiLineMsgBox.show(this.getWizard(), MessageResources.getInstance().getString(CLIENTDIALOG, "CompetitiveUninstall.warning"), MessageResources.getInstance().getString(CLIENTDIALOG, "CompetitiveUninstall.notApplicableMsg"), 40, 2, 0);
        }
        return true;
    }

    private void validateGroup(String groupName) throws ConsoleException, GUICheckException {
        GroupObject obj = GroupHandler.getGroupByFullPath(groupName);
        if (obj == null) {
            String parentName = groupName.substring(0, groupName.lastIndexOf(File.separator));
            GroupObject parentGroup = GroupHandler.getGroupByFullPath(parentName);
            String newGroupName = groupName.substring(groupName.lastIndexOf(File.separator) + 1);
            if (parentGroup == null) {
                throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.errorInvalidGroup"));
            }
            GroupObject theGroup = new GroupObject(parentGroup, newGroupName, newGroupName, Manager.getCurrentAdminId());
            GroupHandler.addGroup(theGroup);
            this.checkGroupPermission(theGroup);
            this.setGroup(theGroup);
        } else {
            this.checkGroupPermission(obj);
            this.setGroup(obj);
        }
    }

    private void checkGroupPermission(GroupObject groupObject) throws GUICheckException {
        if (groupObject == null) {
            throw new GUICheckException(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.errorInvalidGroup"));
        }
        if (!groupObject.isFullAccessible()) {
            String errorMsg = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.noPrivilege"), groupObject.getName());
            throw new GUICheckException(errorMsg);
        }
    }

    private void setGroup(GroupObject groupObject) {
        this.groupObject = groupObject;
    }

    private void browse() {
        try {
            GroupHandler.getGroupsRoot(false, Manager.getCurrentDomainId(), true, true, true);
            SelectGroupDlg dlg = new SelectGroupDlg(MessageResources.getInstance().getString(CLIENTDIALOG, "FindObjectDlg.browseGroupTitle"), 0);
            dlg.setDescription(MessageResources.getInstance().getString(CLIENTDIALOG, "FindObjectDlg.browseGroupDesc"));
            dlg.setVisible(true);
            if (dlg.isOk()) {
                ArrayList<GroupObject> newParentGroups = dlg.getListGroupObjs();
                for (GroupObject group : newParentGroups) {
                    this.setGroup(group);
                    String fullPath = GroupHandler.getGroupFullPath(group);
                    this.groupNameField.setText(fullPath);
                }
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString(CLIENTDIALOG, "FindObjectDlg.error"), 0);
        }
    }

    public void setSelectedPackage(String selectedPackage, String defaultSecurityFixBuildNumber) {
        List<CurrentPackageObject> selectedList = this.findPackageByName(selectedPackage);
        this.setSNACPackage(false);
        CurrentPackageObject pkgObj = null;
        if (selectedList == null || selectedList.size() < 1) {
            return;
        }
        pkgObj = selectedList.get(0);
        this.setCurrentPackageVersion(pkgObj.getSoftwarePackageObject().getVersion(true));
        this.setSelectedPackages(selectedList);
        if (pkgObj.getPackagePlatformString().contains("Mac")) {
            this.setPackageOSType(1);
        } else if (ConstantValue.isLinuxPlatform((String)pkgObj.getPackagePlatformString()) || ConstantValue.isLinuxStubPlatform((String)pkgObj.getPackagePlatformString()) || PackageUtil.isLinuxStub((String)pkgObj.getPackagePlatformString())) {
            this.setPackageOSType(2);
        } else if (pkgObj.getPackagePlatformString().contains("WIN32BIT") || pkgObj.getPackagePlatformString().contains("WIN64BIT")) {
            this.setPackageOSType(0);
            if (pkgObj.getPackageType() == 151) {
                this.setSNACPackage(true);
            } else {
                this.setSNACPackage(false);
            }
        } else {
            this.setPackageOSType(0);
        }
        this.updatePackageInfoPanel(selectedPackage, selectedList);
        this.UpdateUIForMacAndLinux();
        this.updateSettingBoxByPackageOSType();
        this.updateSecurityFixBuildNumberPanel(selectedPackage, selectedList, defaultSecurityFixBuildNumber);
    }

    private void updatePackageInfoPanel(String name, List<CurrentPackageObject> selectedList) {
        if (selectedList == null || selectedList.size() < 1) {
            return;
        }
        ArrayList<String> platformString = new ArrayList<String>();
        ArrayList<CallSite> packageDate = new ArrayList<CallSite>();
        for (CurrentPackageObject pkgObject : selectedList) {
            if (pkgObject.getSoftwarePackageObject().isSecurityFixContent()) {
                if (pkgObject.getSoftwarePackageObject().getSecurityFixContentInfoObject(this.getSelectedSecurityFixBuildNum()) == null) continue;
                platformString.add(pkgObject.getPackagePlatformString());
                packageDate.add((CallSite)((Object)("" + pkgObject.getCreatedTime())));
                continue;
            }
            platformString.add(pkgObject.getPackagePlatformString());
            packageDate.add((CallSite)((Object)("" + pkgObject.getCreatedTime())));
        }
        StringBuilder context = new StringBuilder();
        if (platformString.size() < 1) {
            return;
        }
        DateFormat formatter = DateFormat.getDateInstance(3, Locale.getDefault());
        for (int i = 0; i < platformString.size(); ++i) {
            context.append((String)platformString.get(i));
            context.append(": ");
            context.append(name);
            context.append(" (");
            context.append(formatter.format(new Date(Long.parseLong((String)packageDate.get(i)))));
            context.append(")");
            context.append("\n");
        }
        String text = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "PackageOptionsPanel.packageDescriptionText"), context.toString());
        this.packageDesc.setText(text);
    }

    private void UpdateUIForMacAndLinux() {
        boolean macOrLinuxSelected = this.getPackageOSType() == 1 || this.getPackageOSType() == 2;
        boolean macSelected = this.getPackageOSType() == 1;
        this.jLblProtection.setVisible(!macOrLinuxSelected);
        try {
            this.getProtectionsPanel().setVisible(!macOrLinuxSelected);
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        if (this.jLblUpgradeSettingsMac != null) {
            this.jLblUpgradeSettingsMac.setVisible(macSelected);
        }
        if (this.upgradeSettingsMac != null) {
            this.upgradeSettingsMac.setVisible(macSelected);
        }
        if (this.osSettingsLbl != null) {
            this.osSettingsLbl.setVisible(macSelected);
        }
        boolean isSNAC = this.isSNACPackage();
        try {
            this.jLblProtection.setEnabled(!isSNAC);
            this.getFeaturesComboBox().setEnabled(!isSNAC);
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        if (!this.isSMB()) {
            this.jLblInstallationStyle.setVisible(!macOrLinuxSelected);
            this.getInstallOptionsPanel().setVisible(!macOrLinuxSelected);
        }
        if (macOrLinuxSelected) {
            this.getContentPanel().setVisible(false);
            this.jLblContentOptions.setVisible(false);
        } else {
            this.getContentPanel().setVisible(!isSNAC);
            this.jLblContentOptions.setVisible(!isSNAC);
        }
        this.featuresComboBox.setPreferredSize(new Dimension(565, DEFAULT_COMBO_HEIGHT));
    }

    private Vector<ClientInstallationFeatureObject> getSBECDWFeatureSets() {
        Vector<ClientInstallationFeatureObject> options = new Vector<ClientInstallationFeatureObject>();
        List cifs = ClientInstallFeatureSetUtility.getSBECDWFeatureOptions();
        if (cifs != null) {
            for (int i = 0; i < cifs.size(); ++i) {
                ClientInstallationFeatures cif = (ClientInstallationFeatures)cifs.get(i);
                ClientInstallationFeatureObject obj = new ClientInstallationFeatureObject(cif);
                options.add(obj);
            }
        }
        return options;
    }

    private List<CurrentPackageObject> findPackageByName(String name) {
        if (this.packageMap.size() > 0) {
            return this.packageMap.get(name).getItemList();
        }
        return null;
    }

    public String getSelectedPackage(String defaultSecurityFixBuildNumber) {
        if (this.selectedPackages == null && this.listUndeployedPackages == null) {
            return null;
        }
        if (this.jCbAvailablePackages.getSelectedIndex() != -1) {
            this.setSelectedPackage(this.jCbAvailablePackages.getSelectedItem().toString(), defaultSecurityFixBuildNumber);
        }
        return this.getSelectedPackageIds();
    }

    public String getSelectedPackageIds() {
        StringBuilder ids = new StringBuilder();
        if (this.selectedPackages != null && this.selectedPackages.size() > 0) {
            for (int i = 0; i < this.selectedPackages.size(); ++i) {
                CurrentPackageObject obj = this.selectedPackages.get(i);
                if (i == 0) {
                    ids.append(obj.getId());
                    continue;
                }
                ids.append(",");
                ids.append(obj.getId());
            }
        }
        return ids.toString();
    }

    public void setInstallStyle(int installStyle) {
        this.installStyle = installStyle;
    }

    public int getInstallStyle() {
        return this.installStyle;
    }

    public ArrayList<CurrentPackageObject> getListUndeployedPackages() {
        return this.listUndeployedPackages;
    }

    public void setSelectedPackages(List<CurrentPackageObject> selectedList) {
        this.selectedPackages = selectedList;
        Object osType = "";
        if (selectedList != null) {
            for (int i = 0; i < selectedList.size(); ++i) {
                osType = i == 0 ? selectedList.get(0).getSoftwarePackage().getPackageInfo().getOptPlatformType() : (String)osType + ";" + selectedList.get(i).getSoftwarePackage().getPackageInfo().getOptPlatformType();
            }
            if (osType != null) {
                this.setPackageOSTypeString((String)osType);
            }
        }
    }

    public List<CurrentPackageObject> getSelectedPackages() {
        return this.selectedPackages;
    }

    public ClientInstallationFeatures getDeafultFeatures() {
        ClientInstallationFeatures result = new ClientInstallationFeatures();
        result.setId(Utility.getGUIDString());
        result.setAppType("105");
        EnabledClientFeatures cFeature = new EnabledClientFeatures();
        result.addEnabledClientFeatures(cFeature);
        this.addNewFeature("SAVMain", cFeature);
        this.addNewFeature("TruScan", cFeature);
        this.addNewFeature("Download", cFeature);
        this.addNewFeature("EMailTools", cFeature);
        this.addNewFeature("OutlookSnapin", cFeature);
        this.addNewFeature("NTPMain", cFeature);
        this.addNewFeature("ITPMain", cFeature);
        if (!this.isSMB()) {
            this.addNewFeature("DCMain", cFeature);
        }
        return result;
    }

    private void addNewFeature(String feature, EnabledClientFeatures cFeature) {
        ClientFeature f = new ClientFeature();
        f.setFeatureName(feature);
        cFeature.addClientFeature(f);
    }

    public void setPackageOSType(int packagePlatform) {
        this.packageOSType = packagePlatform;
    }

    public int getPackageOSType() {
        return this.packageOSType;
    }

    public void setPackageOSTypeString(String packageOSTypeString) {
        this.packageOSTypeString = packageOSTypeString;
    }

    public String getPackageOSTypeString() {
        return this.packageOSTypeString;
    }

    public boolean is32BitSelected() {
        return this.getPackageOSTypeString().contains("WIN32BIT");
    }

    public boolean is64BitSelected() {
        return this.getPackageOSTypeString().contains("WIN64BIT");
    }

    public boolean isMacSelected() {
        return this.getPackageOSTypeString().contains("Mac");
    }

    public int getContentOption() {
        return this.packageContentPanel.getSelectedOption();
    }

    public void setRebootOptions(RebootOptions rebootOptions) {
        this.rebootOptions = rebootOptions;
        if (rebootOptions != null) {
            this.installSettings.getClientInstallationSettings().setOptRebootOptions(rebootOptions);
        }
    }

    public RebootOptions getRebootOptions() {
        return this.rebootOptions;
    }

    protected JComboBox<ClientInstallationSettingObject> getSettingComboBox() throws ConsoleException {
        if (this.settingComboBox == null) {
            this.settingsPool = new ClientInstallPoolObject();
            Vector<ClientInstallationSettingObject> allSettings = new Vector<ClientInstallationSettingObject>(this.settingsPool.getObjectsByPlatform(this.getSelectedPackagePlatform()));
            this.settingComboBox = new JComboBox<ClientInstallationSettingObject>(allSettings);
            this.resetComboBoxSize(this.settingComboBox);
            if (allSettings != null && allSettings.size() > 0) {
                this.settingComboBox.setSelectedIndex(0);
                this.setSelectedInstallSettings((ClientInstallationSettingObject)this.settingComboBox.getSelectedItem());
            }
            this.settingComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ClientInstallationSettingObject obj = (ClientInstallationSettingObject)PackageOptionsPanel.this.settingComboBox.getSelectedItem();
                    PackageOptionsPanel.this.setSelectedInstallSettings(obj);
                }
            });
        }
        this.settingComboBox.setPreferredSize(new Dimension(360, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        return this.settingComboBox;
    }

    private void updateSettingBoxByPackageOSType() {
        if (this.settingComboBox != null) {
            this.settingComboBox.removeAllItems();
            try {
                for (ClientInstallationSettingObject objItem : this.settingsPool.getObjectsByPlatform(this.getSelectedPackagePlatform())) {
                    this.settingComboBox.addItem(objItem);
                }
            }
            catch (ConsoleException ex) {
                ConsoleLogger.log(ex);
            }
            if (this.settingComboBox.getItemCount() > 0) {
                this.settingComboBox.setSelectedIndex(0);
                this.setSelectedInstallSettings((ClientInstallationSettingObject)this.settingComboBox.getSelectedItem());
            }
        }
    }

    private String getSelectedPackagePlatform() {
        String ret = "WIN32BIT";
        if (this.is64BitSelected()) {
            ret = "WIN64BIT";
        } else if (this.isMacSelected()) {
            ret = "Mac";
        }
        return ret;
    }

    private void setSelectedInstallSettings(ClientInstallationSettingObject selectedItem) {
        if (selectedItem != null) {
            this.installSettings = selectedItem;
        }
    }

    public ClientInstallationSettingObject getSelectedInstallSettings() {
        return this.installSettings;
    }

    public String getSelectedInstallSettingsName() {
        return this.installSettings.getName();
    }

    public String getSelectedInstallSettingsId() {
        return this.installSettings.getId();
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", key);
    }

    private void editInstallationSetting() {
        ClientInstallationSettingObject settingObj;
        int index = this.settingComboBox.getSelectedIndex();
        if (index == -1) {
            return;
        }
        ClientInstallationSettingObject newSettingObj = settingObj = (ClientInstallationSettingObject)this.settingComboBox.getSelectedItem();
        ClientInstallationSettingsDlg dlg = new ClientInstallationSettingsDlg(Manager.getFrame(), PackageOptionsPanel.getString("ClientInstallationSettingsPanel.edit_install"), true, true, true);
        dlg.setObject(newSettingObj, true);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            this.setSelectedInstallSettings(newSettingObj);
        }
    }

    public int getPolicyMode() {
        return 1;
    }

    public List<CurrentPackageObject> getLegacyPackageList() {
        int type;
        String key;
        List<CurrentPackageObject> list = new ArrayList<CurrentPackageObject>();
        if (this.selectedPackages.size() > 1 && (key = this.findSameType(this.legacyPackages, type = this.selectedPackages.get(0).getPackageType())) != null) {
            CategoryList cat = this.legacyPackages.get(key);
            list = cat.getItemList();
        }
        return list;
    }

    public String getMaxLegacyPackageVersion(String curVer) {
        String maxVersion = "12.1";
        List<CurrentPackageObject> legacyPackages = this.getLegacyPackageList();
        if (legacyPackages != null && legacyPackages.size() > 0) {
            for (CurrentPackageObject packageObj : legacyPackages) {
                String pkgVersion = packageObj.getSoftwarePackageObject().getVersion();
                if (Utility.compareVersion((String)maxVersion, (String)pkgVersion) >= 0) continue;
                maxVersion = pkgVersion;
            }
        }
        return maxVersion;
    }

    public void setInstallFeatures(ClientInstallationFeatureObject installFeatures) {
        this.installFeatures = installFeatures;
    }

    public ClientInstallationFeatureObject getInstallFeatures() {
        if (this.installFeatures == null) {
            return new ClientInstallationFeatureObject();
        }
        return this.installFeatures;
    }

    public void setCurrentPackageVersion(String version) {
        if (version == null || version.length() < 1) {
            this.currentPackageVersion = "14.3.5000.0";
        }
        this.currentPackageVersion = version;
    }

    public String getCurrentPackageVersion() {
        return this.currentPackageVersion;
    }

    public void setSNACPackage(boolean isSNACPackage) {
        this.isSNACPackage = isSNACPackage;
    }

    public boolean isSNACPackage() {
        return this.isSNACPackage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.featuresComboBox)) {
            if (this.featuresComboBox.getSelectedItem() instanceof CustomClientInstallationFeatureObject) {
                this.showCustomOptions();
            }
            ClientInstallationFeatureObject obj = (ClientInstallationFeatureObject)this.featuresComboBox.getSelectedItem();
            this.setInstallFeatures(obj);
            String desc = obj.getDescription();
            int length = desc.trim().length();
            if (length == 0) {
                this.jLblFeatures.setText("");
            } else {
                this.jLblFeatures.setText(desc.trim());
            }
            if (this.packageContentPanel != null) {
                boolean isFeatureSetTdadOnly = PackageOptionsPanel.isFeatureSetTdadOnly(obj);
                this.packageContentPanel.toggleAllContent(!isFeatureSetTdadOnly);
            }
        }
    }

    public void setOsIconMap(Map<String, Icon> osIconMap) {
        this.osIconMap = osIconMap;
    }

    public Map<String, Icon> getOsIconMap() {
        return this.osIconMap;
    }

    public boolean isMaintainOldSettingsMac() {
        return this.upgradeSettingsMac != null ? this.upgradeSettingsMac.isMaintainOldSettings() : true;
    }

    public boolean isMac1015OrUp() {
        return this.getPackageOSType() == 1;
    }

    public String getSecurityFixBuildNumber() {
        return this.getSelectedSecurityFixBuildNum();
    }
}

