/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class InstallMethodPanel
extends ClientInstallationWizard {
    public static final int INSTALL_METHOD_NOTIFY = 0;
    public static final int INSTALL_METHOD_PUSH = 1;
    public static final int INSTALL_METHOD_EXPORT = 2;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static String title = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallMethodsPanel.title");
    private JPanel centerPanel;
    private ButtonGroup optionsGroup;
    private JRadioButton jrbNotifyOption;
    private JRadioButton jrbPushOption;
    private JRadioButton jrbCustom;
    private JCheckBox jcbEmailNotice;
    private boolean sendEmailNotice;
    private int installMethod;
    private DescriptionTextArea notifyOptionDesc;
    private JLabel jlblInformation;
    private static final ImageIcon informationIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("yellow_alert_24.png")));
    private DescriptionTextArea notifyWeblinkOptionDesc;
    private DescriptionTextArea pushOptionDesc;
    private DescriptionTextArea customOptionDesc;
    private HtmlEnabledJLabel jlblHelpLink;
    private JCheckBox jcbEnableFingerPrintCheck;
    private DescriptionTextArea jlblFingerPrintFileLabel;
    private DescriptionTextArea jlblFingerPrintFileLblDesc;
    protected JTextField jtfFingerPrintFileLoc;
    private String fingerPrintFilePath = "";
    private JButton jbBrowse;
    private JPanel browsePanel;
    private boolean useHostsFile;
    private String knownHostsPath;
    private String knownHostsFileName;
    private static final long known_file_size_limit = 0xA00000L;
    private static final boolean fingerPrintCheckDefault = true;
    private JPanel topPanel;

    public InstallMethodPanel() {
        this(null, false);
    }

    public InstallMethodPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.optionsGroup = new ButtonGroup();
        this.jrbNotifyOption = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionNotify"), true);
        this.jrbPushOption = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionPush"));
        this.jrbCustom = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.customOption"));
        this.jcbEmailNotice = new JCheckBox(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.chkEnableNotice"), true);
        this.sendEmailNotice = true;
        this.installMethod = 0;
        this.notifyOptionDesc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionNotifyDesc"));
        this.notifyWeblinkOptionDesc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionWeblinkNotifyDesc"));
        this.pushOptionDesc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionPushDesc"));
        this.customOptionDesc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.customDesc"));
        this.jcbEnableFingerPrintCheck = new JCheckBox(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.pushMacFingerPrintMsg"));
        this.jlblFingerPrintFileLabel = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.lblKnownHost"));
        this.jlblFingerPrintFileLblDesc = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.pushMacFingerPrintMsgWhatMsg"));
        this.jbBrowse = new JButton(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.btnKnownHost"));
        this.jtfFingerPrintFileLoc = new JTextField();
        this.jtfFingerPrintFileLoc.setEnabled(!AjaxSwingCommonUtil.isAjaxSwingRunning());
    }

    public boolean isUseHostsFile() {
        return this.useHostsFile;
    }

    public void setUseHostsFile(boolean useHostsFile) {
        this.useHostsFile = useHostsFile;
    }

    public String getKnownHostsFileName() {
        if (this.useHostsFile) {
            return this.knownHostsFileName;
        }
        return null;
    }

    private JPanel getBrowsePanel() {
        if (this.browsePanel == null) {
            this.browsePanel = new JPanel(new GridBagLayout());
            this.browsePanel.add((Component)this.jtfFingerPrintFileLoc, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.browsePanel.add((Component)this.jbBrowse, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.jbBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ex) {
                    InstallMethodPanel.this.btnBrowseActionPerformed();
                }
            });
        }
        return this.browsePanel;
    }

    protected void btnBrowseActionPerformed() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return MSGRES.getString(InstallMethodPanel.CLIENTDIALOG, "InstallMethodPanel.fileDlgType");
            }
        });
        fc.setApproveButtonText(MSGRES.getString(CLIENTDIALOG, "CreateNewSoftwareDlg.browseDialogButtonText"));
        fc.setDialogTitle(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.fileDlgTitle"));
        fc.setFileSelectionMode(0);
        if (0 != fc.showOpenDialog(this.getWizardStagePanel())) {
            return;
        }
        File selectFile = fc.getSelectedFile();
        if (selectFile == null) {
            return;
        }
        if (!selectFile.isFile() || !selectFile.exists()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidFileMsg"), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidFileMsgTitle"), 0);
            return;
        }
        try {
            this.fingerPrintFilePath = selectFile.getCanonicalPath().trim();
            this.jtfFingerPrintFileLoc.setText(AjaxSwingUtil.getDisplayFileName(this.fingerPrintFilePath));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.insuffPrivFileMsg"), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidFileMsgTitle"), 0);
            return;
        }
    }

    public boolean validateInstallMethodPanel() {
        boolean isValid = true;
        boolean uploadSuccess = false;
        this.useHostsFile = false;
        if (this.jrbPushOption.isVisible() && this.jrbPushOption.isEnabled() && this.jrbPushOption.isSelected() && this.jcbEnableFingerPrintCheck.isVisible() && this.jcbEnableFingerPrintCheck.isEnabled() && this.jcbEnableFingerPrintCheck.isSelected()) {
            try {
                this.knownHostsPath = AjaxSwingCommonUtil.isAjaxSwingRunning() ? this.fingerPrintFilePath : this.jtfFingerPrintFileLoc.getText();
                this.useHostsFile = true;
                if (this.knownHostsPath != null) {
                    this.knownHostsPath = this.knownHostsPath.trim();
                }
                if (isValid = this.isValidFilePath(this.knownHostsPath)) {
                    File tmpFile = new File(this.knownHostsPath);
                    this.knownHostsFileName = tmpFile.getName();
                    SimpleProgressDlg dlg = new SimpleProgressDlg((Frame)Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.progressDlgTitle"), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.progressDlgMsg"), true);
                    KnownHostsFileUploader worker = new KnownHostsFileUploader(dlg);
                    worker.execute();
                    dlg.setCursor(Cursor.getPredefinedCursor(3));
                    dlg.setVisible(true);
                    uploadSuccess = (Boolean)worker.get();
                    if (uploadSuccess) {
                        this.getWizard().setCleanUpServerDirRequired(true);
                    }
                }
            }
            catch (InterruptedException ie) {
                uploadSuccess = false;
                ConsoleLogger.log("Interrupted Exception during validation and upload of known_hosts file: ");
                ConsoleLogger.log(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                uploadSuccess = false;
                ConsoleLogger.log("Exception during validation and upload of known_hosts file: ");
                ConsoleLogger.log(ex);
            }
            if (isValid && !uploadSuccess) {
                isValid = uploadSuccess;
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.fileUploadError"), MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidFileMsgTitle"), 0);
            }
        }
        return isValid;
    }

    private boolean isValidFilePath(String path) {
        File knownFile;
        boolean result = false;
        String messageText = MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidFileMsg");
        if (!StringUtilities.isEmpty((String)path) && (knownFile = new File(path)).exists() && knownFile.isFile()) {
            if (knownFile.length() == 0L) {
                messageText = MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidKnownFileMsg");
            } else if (knownFile.length() <= 0xA00000L) {
                result = true;
            } else {
                messageText = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.knownFileSizeError"), 10L);
            }
        }
        if (!result) {
            JOptionPane.showMessageDialog(Manager.getFrame(), messageText, MSGRES.getString(CLIENTDIALOG, "InstallMethodPanel.invalidFileMsgTitle"), 0);
        }
        return result;
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return title;
    }

    private void setInstallMethodOptions() {
        this.optionsGroup.add(this.jrbCustom);
        this.optionsGroup.add(this.jrbPushOption);
        this.optionsGroup.add(this.jrbNotifyOption);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                InstallMethodPanel.this.updateInstallMethod();
            }
        };
        this.jrbNotifyOption.addActionListener(listener);
        this.jrbPushOption.addActionListener(listener);
        this.jrbCustom.addActionListener(listener);
        this.jrbPushOption.setSelected(true);
        this.setInstall_method(2);
    }

    private void updateInstallMethod() {
        boolean enableFingerPrintControls = false;
        if (this.jrbNotifyOption.isSelected()) {
            this.installMethod = 0;
        } else if (this.jrbCustom.isSelected()) {
            this.installMethod = 2;
        } else {
            this.installMethod = 1;
            enableFingerPrintControls = true;
        }
        this.enableFingerPrintCheckControls(enableFingerPrintControls);
        this.jcbEmailNotice.setEnabled(false);
    }

    @Override
    protected JPanel getTopPanel() {
        this.topPanel = UIUtilities.getTopBannerWithLogo(this.getTitle(), this.getTitleDescription());
        return this.topPanel;
    }

    @Override
    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.setInstallMethodOptions();
            this.centerPanel = new JPanel(new BorderLayout());
            this.centerPanel.add((Component)this.initCenterPanel(), "North");
        }
        return this.centerPanel;
    }

    private JPanel initCenterPanel() {
        this.jlblHelpLink = new HtmlEnabledJLabel(MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.linkText"), true);
        this.jlblHelpLink.setIcon((Icon)ConsoleMain.whatsThisIcon);
        this.jlblHelpLink.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        this.jlblHelpLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ex) {
                InstallMethodPanel.this.showRemotePushHelp();
            }
        });
        int y = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jrbCustom, new GridBagConstraints(0, y, 3, 1, 1.0, 0.1, 18, 2, new Insets(10, 25, 0, 0), 0, 0));
        panel.add((Component)this.customOptionDesc, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 2, new Insets(5, 70, 0, 25), 0, 0));
        panel.add((Component)this.jrbPushOption, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 2, new Insets(10, 25, 0, 0), 0, 0));
        panel.add((Component)this.pushOptionDesc, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(5, 70, 0, 25), 0, 0));
        panel.add((Component)this.jcbEnableFingerPrintCheck, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(5, 70, 0, 25), 0, 0));
        panel.add((Component)this.jlblFingerPrintFileLabel, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(5, 90, 0, 75), 0, 0));
        panel.add((Component)this.jlblFingerPrintFileLblDesc, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(5, 90, 0, 75), 0, 0));
        panel.add((Component)this.getBrowsePanel(), new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(5, 90, 0, 75), 0, 0));
        panel.add((Component)this.jlblHelpLink, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(5, 70, 0, 25), 0, 0));
        this.jcbEnableFingerPrintCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ex) {
                boolean isSelected = false;
                if (ex.getStateChange() == 1) {
                    isSelected = true;
                }
                InstallMethodPanel.this.enableKnownHostsFileUploadControls(isSelected);
            }
        });
        this.jcbEnableFingerPrintCheck.setSelected(true);
        panel.add((Component)this.jrbNotifyOption, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 2, insertToLogo, 0, 0));
        panel.add((Component)this.jcbEmailNotice, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 2, new Insets(0, 70, 0, 25), 0, 0));
        panel.add((Component)this.notifyOptionDesc, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 1, new Insets(0, 70, 0, 25), 0, 0));
        this.jlblInformation = new JLabel();
        this.jlblInformation.setIcon(informationIcon);
        panel.add((Component)this.jlblInformation, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.1, 18, 0, new Insets(5, 70, 0, 25), 0, 0));
        panel.add((Component)this.notifyWeblinkOptionDesc, new GridBagConstraints(0, y, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 100, 0, 25), 0, 0));
        this.jcbEmailNotice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                InstallMethodPanel.this.setSendEmailNotice(InstallMethodPanel.this.jcbEmailNotice.isSelected());
            }
        });
        this.jcbEmailNotice.setVisible(false);
        return panel;
    }

    private boolean isDisplayKnownHostsFields(boolean isSylinkDrop, boolean isSylinkDropWin) {
        boolean result = false;
        Integer deploymentType = this.getWizard().getWizardTypePanel().getWizardType();
        boolean isMacSelected = this.getWizard().isMacPackageSelected();
        if (deploymentType == 0 && isMacSelected && this.jrbPushOption.isVisible() || isSylinkDrop && !isSylinkDropWin || this.getWizard().isDeployExistingPackageForMac()) {
            result = true;
        }
        return result;
    }

    public void setInstall_method(int installMethod) {
        this.installMethod = installMethod;
        if (0 == installMethod) {
            this.jrbNotifyOption.setSelected(true);
        } else if (2 == installMethod) {
            this.jrbCustom.setSelected(true);
        } else {
            this.jrbPushOption.setSelected(true);
            this.installMethod = 1;
        }
    }

    public void setInstallOptionEnable(boolean enableEmailInstallOption, boolean enableRemotePushOption, boolean enableSavePackageOption) {
        this.jrbNotifyOption.setEnabled(enableEmailInstallOption);
        this.notifyOptionDesc.setEnabled(enableEmailInstallOption);
        this.notifyWeblinkOptionDesc.setEnabled(enableEmailInstallOption);
        this.jrbPushOption.setEnabled(enableRemotePushOption);
        this.pushOptionDesc.setEnabled(enableRemotePushOption);
        this.jrbCustom.setEnabled(enableSavePackageOption);
        this.customOptionDesc.setEnabled(enableSavePackageOption);
    }

    public void setInstallOptionVisible(boolean viewEmailInstallOption, boolean viewRemotePushOption, boolean viewSavePackageOption) {
        this.jrbNotifyOption.setVisible(viewEmailInstallOption);
        this.notifyOptionDesc.setVisible(viewEmailInstallOption);
        this.jlblInformation.setVisible(viewEmailInstallOption);
        this.notifyWeblinkOptionDesc.setVisible(viewEmailInstallOption);
        this.jrbPushOption.setVisible(viewRemotePushOption);
        this.jlblHelpLink.setVisible(viewRemotePushOption);
        this.pushOptionDesc.setVisible(viewRemotePushOption);
        this.jrbCustom.setVisible(viewSavePackageOption);
        this.customOptionDesc.setVisible(viewSavePackageOption);
    }

    public int getInstall_method() {
        return this.installMethod;
    }

    public boolean isEmailSelected() {
        return this.installMethod == 0;
    }

    public boolean isRemoteSelected() {
        return this.installMethod == 1;
    }

    public boolean isCustomSelected() {
        return this.installMethod == 2;
    }

    public void setControlsVisibility(List<CurrentPackageObject> selectedPkgs, boolean isSylinkDrop, boolean isSylinkDropWin) {
        if (!isSylinkDrop && selectedPkgs != null && selectedPkgs.size() > 0) {
            boolean isRemoteInstallable = PackageUtil.isPackageRemoteInstallable((SoftwarePackage)selectedPkgs.get(0).getSoftwarePackage());
            this.viewRemotePushOption(isRemoteInstallable);
        }
        this.updateUIForCommunicationSetting(isSylinkDrop);
        this.setVisibilityForFingerPrintCheck(this.isDisplayKnownHostsFields(isSylinkDrop, isSylinkDropWin));
        this.updateInstallMethod();
    }

    public void viewRemotePushOption(boolean visible) {
        this.jrbPushOption.setVisible(visible);
        this.pushOptionDesc.setVisible(visible);
        this.jlblHelpLink.setVisible(visible);
        if (!visible && this.jrbPushOption.isSelected()) {
            this.jrbPushOption.setSelected(visible);
            this.jrbNotifyOption.setSelected(true);
        }
        this.updateInstallMethod();
    }

    private void shiftTitle(String oldTitle, String newTitle) {
        Component firstComp = this.topPanel.getComponents()[0];
        if (firstComp instanceof JPanel) {
            JPanel titlePanel = (JPanel)this.topPanel.getComponents()[0];
            Component[] components = titlePanel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                JLabel label;
                if (!(components[i] instanceof JPanel) || (label = (JLabel)components[i]).getText() == null || !label.getText().equals(oldTitle)) continue;
                label.setText(newTitle);
            }
        }
    }

    public void updateUIForCommunicationSetting(boolean isCommSetting) {
        if (isCommSetting) {
            this.jrbNotifyOption.setVisible(false);
            this.notifyOptionDesc.setVisible(false);
            this.jlblInformation.setVisible(false);
            this.notifyWeblinkOptionDesc.setVisible(false);
            if (this.jrbNotifyOption.isSelected()) {
                this.jrbNotifyOption.setSelected(false);
                this.jrbPushOption.setSelected(true);
            }
            if (!this.jrbPushOption.isVisible()) {
                this.jrbPushOption.setVisible(true);
                this.pushOptionDesc.setVisible(true);
            }
            String oldTitle = title;
            InstallMethodPanel.setTitle(MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.titleComm"));
            this.shiftTitle(oldTitle, title);
            this.jlblHelpLink.setVisible(true);
            this.pushOptionDesc.setText(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionPushDescComm"));
            this.customOptionDesc.setText(MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.customDescComm"));
        } else {
            this.jrbNotifyOption.setVisible(true);
            this.notifyOptionDesc.setVisible(true);
            this.jlblInformation.setVisible(true);
            this.notifyWeblinkOptionDesc.setVisible(true);
            String oldTitle = title;
            InstallMethodPanel.setTitle(MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.title"));
            this.shiftTitle(oldTitle, title);
            if (this.jrbPushOption.isVisible()) {
                this.jlblHelpLink.setVisible(true);
            }
            this.pushOptionDesc.setText(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.optionPushDesc"));
            this.customOptionDesc.setText(MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.customDesc"));
        }
        this.updateInstallMethod();
    }

    private static void setTitle(String strTitle) {
        title = strTitle;
    }

    private void setVisibilityForFingerPrintCheck(boolean isVisible) {
        this.jcbEnableFingerPrintCheck.setVisible(isVisible);
        this.browsePanel.setVisible(isVisible);
        this.jlblFingerPrintFileLabel.setVisible(isVisible);
        this.jlblFingerPrintFileLblDesc.setVisible(isVisible);
    }

    private void enableKnownHostsFileUploadControls(boolean isEnable) {
        this.jbBrowse.setEnabled(isEnable);
        this.jtfFingerPrintFileLoc.setEnabled(isEnable && !AjaxSwingCommonUtil.isAjaxSwingRunning());
    }

    private void enableFingerPrintCheckControls(boolean isEnable) {
        this.jcbEnableFingerPrintCheck.setEnabled(isEnable);
        this.enableKnownHostsFileUploadControls(isEnable && this.jcbEnableFingerPrintCheck.isSelected());
    }

    public void setSendEmailNotice(boolean sendEmailNotice) {
        this.sendEmailNotice = sendEmailNotice;
        if (sendEmailNotice != this.jcbEmailNotice.isSelected()) {
            this.jcbEmailNotice.setSelected(sendEmailNotice);
        }
    }

    public boolean isSendEmailNotice() {
        return this.sendEmailNotice;
    }

    private void showRemotePushHelp() {
        try {
            HelpUtil.showRemotePushHelp();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.errorURL"), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
        }
    }

    private class KnownHostsFileUploader
    extends SwingWorker<Boolean, Void> {
        private SimpleProgressDlg dlg;

        public KnownHostsFileUploader(SimpleProgressDlg dlg) {
            this.dlg = dlg;
        }

        @Override
        public Boolean doInBackground() {
            return this.uploadHostFile();
        }

        private boolean uploadHostFile() {
            boolean result = false;
            try {
                File knownHostsFile = new File(InstallMethodPanel.this.knownHostsPath);
                GUIManager.uploadBinaryFileToDir(InstallMethodPanel.this.knownHostsPath, knownHostsFile.getName(), "knownhostsdir", false);
                result = true;
            }
            catch (ConsoleException ex) {
                ConsoleLogger.log("Exception while uploading the known_hosts file to server");
                ConsoleLogger.log(ex);
            }
            return result;
        }

        @Override
        public void done() {
            if (this.dlg != null) {
                this.dlg.setCursor(Cursor.getDefaultCursor());
                this.dlg.dispose();
            }
        }
    }
}

