/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FeatureDescriptionPanel
extends JPanel {
    private static final long serialVersionUID = -4906069854826080578L;
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private JPanel descriptionPanel = null;
    private JPanel dependencyPanel = null;
    private String featureName = null;
    private JLabel titleLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FeatureDescriptionPanel.featureDescLabelText"));
    private DescriptionTextArea descriptionText = new DescriptionTextArea("");
    private JLabel linkLabel = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FeatureDescriptionPanel.featureLinkLabelText"));
    private JPanel linkItemPanel = null;
    private DescriptionTextArea autoLinkText = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "FeatureDescriptionPanel.autoReminderText"), 20);
    private String feature = null;
    private List<Object> linkList = null;
    static final Map<String, String> featureDescMap = new HashMap<String, String>();

    public FeatureDescriptionPanel(String featureName) {
        this.featureName = featureName;
        this.initialize();
    }

    private void initialize() {
        this.initFeatureDescriptionMap();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getDependencyPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(20, 0, 20, 0), 0, 0));
    }

    private void initFeatureDescriptionMap() {
        featureDescMap.clear();
        featureDescMap.put("SAVMain", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescSAVText"));
        featureDescMap.put("Download", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescDownloadText"));
        featureDescMap.put("EMailTools", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescEmailText"));
        featureDescMap.put("OutlookSnapin", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescOutlookText"));
        featureDescMap.put("NotesSnapin", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescLotusNotesText"));
        featureDescMap.put("Pop3Smtp", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescSMTPPOP3Text"));
        featureDescMap.put("PTPMain", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescPTPMainText"));
        featureDescMap.put("TruScan", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescSonarTruScanText"));
        featureDescMap.put("COHMain", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescSonarTruScanText"));
        featureDescMap.put("DCMain", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescADCText"));
        featureDescMap.put("NTPMain", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescNTPMainText"));
        featureDescMap.put("Firewall", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescFWText"));
        featureDescMap.put("ITPMain", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescIPSText"));
        featureDescMap.put("Saep", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescSAEPText"));
        featureDescMap.put("ADDefense", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescADDefenseText"));
        featureDescMap.put("NTR", MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescNTRText"));
    }

    public JPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new JPanel(new VerticalFlowLayout());
            this.descriptionPanel.add(this.titleLabel);
            if (MSGRES.getString("com.sygate.scm.util.template.template", "$$I18N.DomainObjTemplate.LaptopsProtection$$").equals(this.featureName)) {
                this.descriptionText = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.readOnlyfeatureDescSAEPText"));
            }
            this.descriptionPanel.add(this.descriptionText);
        }
        return this.descriptionPanel;
    }

    public JPanel getDependencyPanel() {
        if (this.dependencyPanel == null) {
            this.dependencyPanel = new JPanel(new GridBagLayout());
            this.dependencyPanel.add((Component)this.linkLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.dependencyPanel.add((Component)this.getLinkItemPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.dependencyPanel.add((Component)this.autoLinkText, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        }
        return this.dependencyPanel;
    }

    private JPanel getLinkItemPanel() {
        if (this.linkItemPanel == null) {
            this.linkItemPanel = new JPanel();
            Dimension originalSize = this.linkItemPanel.getPreferredSize();
            this.linkItemPanel.setPreferredSize(new Dimension((int)originalSize.getWidth() + 400, (int)originalSize.getHeight() + 90));
        }
        return this.linkItemPanel;
    }

    private JPanel addItem(String item) {
        JCheckBox chkItem = new JCheckBox(item, true);
        JPanel entry = new JPanel();
        entry.setLayout(new BorderLayout());
        entry.add((Component)chkItem, "West");
        UIUtilities.setContainerStatus(entry, false);
        return entry;
    }

    private void checkDependencies() {
        List<Object> list = this.getLinkList();
        this.getLinkItemPanel().removeAll();
        if (list == null || list.isEmpty()) {
            this.updateUI();
            return;
        }
        if (list.size() > 0) {
            this.getLinkItemPanel().setLayout(new GridBagLayout());
            for (int i = 0; i < list.size(); ++i) {
                String feature = list.get(i).toString();
                JPanel entry = this.addItem(feature);
                this.getLinkItemPanel().add((Component)entry, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            }
            this.updateUI();
        }
    }

    public void setFeature(String feature, String version) {
        this.feature = feature;
        String desc = this.getFeatureDescription(feature, version);
        this.descriptionText.setText(desc);
        this.getDescriptionPanel().revalidate();
    }

    private String getFeatureDescription(String feature2, String version) {
        String displayName = featureDescMap.get(feature2);
        if (displayName == null) {
            displayName = "";
        }
        if (feature2.compareToIgnoreCase("Firewall") == 0 && Utility.compareVersion((String)version, (String)"12.1.0.0") < 0) {
            displayName = MSGRES.getString(CLIENTDIALOG, "FeatureDescriptionPanel.featureDescFWIPSText");
        }
        return displayName;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setLinkList(List<Object> list) {
        this.linkList = list;
        this.refresh();
    }

    public void refresh() {
        this.checkDependencies();
    }

    public List<Object> getLinkList() {
        return this.linkList;
    }
}

