/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.DescriptionHTMLLabel;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.JOptionPaneUtil;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LinuxPackageFormatHelper;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.MacPackageFormatHelper;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;

public class DeploymentTypePanel
extends ClientInstallationWizard {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    public static final int NEW_DEPLOYMENT = 0;
    public static final int EXISTING_PACKAGE = 1;
    public static final long IMPORT_PACKAGE_UPPER_BOUND = Integer.MIN_VALUE;
    private static final int SYLINKDROP_PACKAGE = 2;
    private static final int SYLINKDROP_PACKAGE_MAC = 3;
    public static final String SETAID_FILE = "setaid.ini";
    public static final String SETUP_FILE = "setup.ini";
    public static final String SYLINK_FILE = "sylink.xml";
    private JEditorPane jEPDescTour;
    private JRadioButton newDeploymentOption;
    private JRadioButton existingPackageOption;
    private JRadioButton updateCommunicationOption;
    private JRadioButton updateCommunicationOptionMac;
    private Map<JRadioButton, Integer> ButtonWizardMap;
    private DescriptionTextArea descNew;
    private DescriptionTextArea descExisting;
    private DescriptionTextArea descSylinkdrop;
    private JLabel jlblSylinkDrop;
    private JTextField jTFLocation;
    private String selectedFilePath = "";
    private JButton jBBrowse;
    private JPanel browsePanel;
    private String filePath;
    private String fileName;
    private boolean usingPackageFolder;
    private String fullFolder;
    private HtmlEnabledJLabel jLblHelpLink;
    private JLabel jLbl_ExistingPackageMissingWarningLink;
    private JLabel jLblTitle;
    private int wizardType;
    private boolean isMacPackageSelected = false;

    public DeploymentTypePanel(boolean isSMB) {
        super(null, isSMB);
    }

    public DeploymentTypePanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected void initialize() {
        this.jEPDescTour = new JEditorPane();
        this.descNew = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.descNewDeployment"));
        this.descExisting = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.descExistingPackage"));
        this.descSylinkdrop = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.descSylinkdropPackage"));
        this.jTFLocation = new JTextField();
        this.jBBrowse = new JButton(UIText.get(257));
        this.usingPackageFolder = false;
        this.jLblTitle = new JLabel();
        this.wizardType = 0;
        String strURL = Utility.getCDWTourType((boolean)LicenseObject.getInstance().isSBProduct());
        String language = Utility.getLanguage();
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, language, strURL};
        String fmtString = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.descTour.linkText"), obj);
        this.jLblHelpLink = new HtmlEnabledJLabel(fmtString, true);
        this.jLblHelpLink.setIcon((Icon)ConsoleMain.whatsThisIcon);
        this.jLblHelpLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeploymentTypePanel.this.showFeaturePanelHelp();
            }
        });
        String missingPlatformString = this.getMissingPlatformStr();
        if (!StringUtilities.isEmpty((String)missingPlatformString)) {
            Object[] obj2 = new Object[]{ServerVersion.CURRENT_CED_VERSION, language};
            String strUrl = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.packageMissingMsg.url"), obj2);
            this.jLbl_ExistingPackageMissingWarningLink = new DescriptionHTMLLabel(MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.packageMissingMsg.prefix"), missingPlatformString), MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.packageMissingMsg.urlText"), MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.packageMissingMsg.suffix"), strUrl, 85);
            this.jLbl_ExistingPackageMissingWarningLink.setIcon(ConsoleMain.warningIcon16);
            this.jLbl_ExistingPackageMissingWarningLink.setHorizontalTextPosition(11);
            this.jLbl_ExistingPackageMissingWarningLink.setVerticalTextPosition(1);
        }
    }

    private String getMissingPlatformStr() {
        List<String> missingPkgType;
        int size;
        Object platformString = null;
        if (this.isSMB() && (size = (missingPkgType = this.getMissingPackages()).size()) > 0) {
            platformString = MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel." + missingPkgType.get(0));
            for (int index = 1; index < size; ++index) {
                if (index == size - 1) {
                    platformString = (String)platformString + " " + MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.and");
                }
                platformString = (String)platformString + " " + MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel." + missingPkgType.get(index));
            }
        }
        return platformString;
    }

    private List<String> getMissingPackages() {
        ArrayList<String> platforms = new ArrayList<String>();
        for (int i = 0; i < ConstantValue.getPlatformsForInstallPackages().length; ++i) {
            platforms.add(ConstantValue.getPlatformsForInstallPackagesByIndex((int)i));
        }
        try {
            List<CurrentPackageObject> allPackages = SoftwarePackageHandler.removeODCPackages(SoftwarePackageHandler.getCurrentSoftwarePackages());
            for (CurrentPackageObject curPkgObj : allPackages) {
                if (!platforms.isEmpty()) {
                    SoftwarePackageObject pkgObj = curPkgObj.getSoftwarePackageObject();
                    String platformType = pkgObj.getPackageInfo().getOptPlatformType();
                    if (!platforms.contains(platformType)) continue;
                    platforms.remove(platformType);
                    continue;
                }
                break;
            }
        }
        catch (ConsoleException ce) {
            LoggerUtilities.logException((Throwable)ce);
        }
        return platforms;
    }

    @Override
    protected String getTitleDescription() {
        return "";
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.title");
    }

    void setWizardType(Map<JRadioButton, Integer> map, Object key) {
        if (map.containsKey(key)) {
            this.setWizardType(map.get(key));
        }
    }

    void setButtons() {
        boolean inExistingPackageWizard = this.getWizardType() == 1;
        boolean inAjaxMode = AjaxSwingCommonUtil.isAjaxSwingRunning();
        this.jBBrowse.setEnabled(inExistingPackageWizard);
        this.jTFLocation.setEnabled(inExistingPackageWizard && !inAjaxMode);
    }

    void handleActionEvent(ActionEvent ae) {
        this.setWizardType(this.ButtonWizardMap, ae.getSource());
        this.setButtons();
    }

    @Override
    protected JPanel getCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.jEPDescTour.setContentType("text/html");
        this.jEPDescTour.setEditable(false);
        this.jEPDescTour.setOpaque(false);
        this.jEPDescTour.setText(this.getTourDescText());
        this.jEPDescTour.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, MSGRES.getString(DeploymentTypePanel.CLIENTDIALOG, "SelectGroupPackagePanel.errorURL"), MSGRES.getString(DeploymentTypePanel.CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
                    }
                }
            }
        });
        this.jlblSylinkDrop = new JLabel(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.lblSylinkdropPackage"));
        this.newDeploymentOption = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.lblNewDeployment"));
        this.existingPackageOption = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.lblExistingPackage"));
        this.updateCommunicationOption = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.lblSylinkdropPackageWin"));
        this.updateCommunicationOptionMac = new JRadioButton(MSGRES.getString(CLIENTDIALOG, "DeploymentTypePanel.lblSylinkdropPackageMac"));
        this.ButtonWizardMap = Map.of(this.newDeploymentOption, 0, this.existingPackageOption, 1, this.updateCommunicationOption, 2, this.updateCommunicationOptionMac, 3);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.newDeploymentOption);
        bg.add(this.existingPackageOption);
        bg.add(this.updateCommunicationOption);
        bg.add(this.updateCommunicationOptionMac);
        this.newDeploymentOption.setSelected(true);
        this.setWizardType(0);
        ActionListener listener = this::handleActionEvent;
        this.newDeploymentOption.addActionListener(listener);
        this.existingPackageOption.addActionListener(listener);
        this.updateCommunicationOption.addActionListener(listener);
        this.updateCommunicationOptionMac.addActionListener(listener);
        int x = 0;
        int y = 0;
        int tab = 25;
        panel.add((Component)this.getTitleLabel(), new GridBagConstraints(x, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 22, 0, 0), 0, 0));
        panel.add((Component)this.jEPDescTour, new GridBagConstraints(x, ++y, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 22, 0, 0), 0, 0));
        panel.add((Component)this.jLblHelpLink, new GridBagConstraints(x, ++y, 1, 0, 0.0, 0.0, 18, 2, new Insets(0, 25, 0, 30), 0, 0));
        panel.add((Component)this.newDeploymentOption, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(40, tab + 25, 0, 0), 0, 0));
        panel.add((Component)this.descNew, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, tab + 50, 0, 0), 0, 0));
        if (this.jLbl_ExistingPackageMissingWarningLink != null) {
            panel.add((Component)this.jLbl_ExistingPackageMissingWarningLink, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, tab + 50, 0, 0), 0, 0));
        }
        panel.add((Component)this.existingPackageOption, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, tab + 25, 0, 10), 0, 0));
        panel.add((Component)this.descExisting, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, tab + 50, 0, 10), 0, 0));
        panel.add((Component)this.getBrowsePanel(), new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, tab + 50, 0, 10), 0, 0));
        panel.add((Component)this.jlblSylinkDrop, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, tab + 35, 0, 10), 0, 0));
        panel.add((Component)this.descSylinkdrop, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, tab + 50, 0, 30), 0, 0));
        panel.add((Component)UIUtilities.appendOSIcon(this.updateCommunicationOption, true, false), new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, tab + 50, 0, 10), 0, 0));
        panel.add((Component)UIUtilities.appendOSIcon(this.updateCommunicationOptionMac, false, true), new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, tab + 50, 0, 10), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        return panel;
    }

    private JPanel getBrowsePanel() {
        if (this.browsePanel == null) {
            this.browsePanel = new JPanel(new GridBagLayout());
            this.browsePanel.add((Component)this.jTFLocation, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.browsePanel.add((Component)this.jBBrowse, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 18, 0, new Insets(8, 10, 0, 0), 0, 0));
            this.jBBrowse.addActionListener(actionEvent -> this.btnBrowseActionPerformed());
            this.jBBrowse.setEnabled(false);
            this.jTFLocation.setEnabled(false);
        }
        return this.browsePanel;
    }

    private JLabel getTitleLabel() {
        StringBuffer strBuff = new StringBuffer("<HTML><BODY><span ");
        strBuff.append(HTMLUtilities.HTML_TITLE_FONT_STYLE);
        strBuff.append("\">");
        strBuff.append(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.title"));
        strBuff.append("</span>");
        strBuff.append("</BODY></HTML>");
        this.jLblTitle.setText(strBuff.toString());
        this.jLblTitle.setOpaque(false);
        return this.jLblTitle;
    }

    private void showFeaturePanelHelp() {
        String fmtString = Utility.getCDWTourType((boolean)LicenseObject.getInstance().isSBProduct());
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage(), fmtString};
        String strURL = MessageFormat.format(MSGRES.getString(CLIENTDIALOG, "SupportLink.url"), obj);
        try {
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                ClientAgent.getCurrentInstance().openInNewTab(strURL);
                return;
            }
            URLUtility.showURL((String)strURL);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, MSGRES.getString(CLIENTDIALOG, "InstallMethodsPanel.errorURL"), MSGRES.getString(CLIENTDIALOG, "InstallClientWizardDialog.error"), 0);
        }
    }

    private String getTourDescText() {
        StringBuffer strBuffDesc = new StringBuffer();
        strBuffDesc.append("<HTML><BODY><DIV " + HTMLUtilities.HTML_FONT_STYLE + "\">");
        strBuffDesc.append(MSGRES.getString(CLIENTDIALOG, "SelectGroupPackagePanel.descTour"));
        strBuffDesc.append("</DIV>");
        strBuffDesc.append("</BODY></HTML>");
        return strBuffDesc.toString();
    }

    private void setWizardType(int wizardType) {
        this.wizardType = wizardType;
    }

    public int getWizardType() {
        return this.wizardType;
    }

    public boolean isSylinkDrop() {
        boolean result = false;
        if (this.wizardType == 2 || this.wizardType == 3) {
            result = true;
        }
        return result;
    }

    public boolean isSylinkDropWin() {
        boolean result = false;
        if (this.wizardType == 2) {
            result = true;
        }
        return result;
    }

    public boolean isSylinkDropMac() {
        boolean result = false;
        if (this.wizardType == 3) {
            result = true;
        }
        return result;
    }

    public boolean useExistingPackage() {
        return this.existingPackageOption.isSelected();
    }

    public boolean updateCommunicationSettings() {
        return this.updateCommunicationOption.isSelected();
    }

    protected void btnBrowseActionPerformed() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || SoftwarePackageHandler.isPackageOfCorrectFileType(f.getName().toLowerCase()) || f.getName().equalsIgnoreCase("setup.exe");
            }

            @Override
            public String getDescription() {
                return MessageResources.getInstance().getString(DeploymentTypePanel.CLIENTDIALOG, "DeploymentTypePanel.infoFileDesc");
            }
        });
        fc.setApproveButtonText(MessageResources.getInstance().getString(CLIENTDIALOG, "CreateNewSoftwareDlg.browseDialogButtonText"));
        fc.setDialogTitle(MessageResources.getInstance().getString(CLIENTDIALOG, "CreateNewSoftwareDlg.browseDialogTitle"));
        fc.setFileSelectionMode(2);
        if (0 != fc.showOpenDialog(this.getWizardStagePanel())) {
            return;
        }
        File selectFile = fc.getSelectedFile();
        if (selectFile == null) {
            return;
        }
        String[] files = selectFile.list();
        if (selectFile.isDirectory() && files != null && files.length < 1 && selectFile.length() > Integer.MIN_VALUE) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.validationError"), 0);
            return;
        }
        this.selectedFilePath = selectFile.getAbsolutePath();
        this.jTFLocation.setText(AjaxSwingUtil.getDisplayFileName(selectFile));
    }

    protected String getExistingFilePath() {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return this.selectedFilePath.trim();
        }
        return this.jTFLocation.getText().trim();
    }

    public boolean validatePanel() {
        Object path = "";
        String name = "";
        boolean succeeded = true;
        if (this.useExistingPackage()) {
            String file = this.getExistingFilePath();
            if (file == null || file.length() < 1) {
                JOptionPaneUtil.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.validationError"), 0);
                return false;
            }
            File selectedFile = new File(file);
            if (!selectedFile.exists()) {
                JOptionPaneUtil.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage_not_exist"), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.validationError"), 0);
                return false;
            }
            this.isMacPackageSelected = this.isMacPackage(selectedFile);
            if (this.isLinuxPackage(selectedFile)) {
                JOptionPaneUtil.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importLinuxNotAllowed"), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.validationError"), 0);
                return false;
            }
            if (selectedFile.isDirectory()) {
                String[] names = selectedFile.list();
                if (names == null || names.length < 1) {
                    JOptionPaneUtil.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.validationError"), 0);
                    return false;
                }
                boolean found = false;
                for (int i = 0; i < names.length; ++i) {
                    String fileName = names[i].toLowerCase();
                    if (!fileName.endsWith(SETAID_FILE) && !fileName.endsWith(SETUP_FILE) && !fileName.endsWith(SYLINK_FILE)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    JOptionPaneUtil.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.validationError"), 0);
                    return false;
                }
                this.setUsingPackageFolder(true);
                this.fullFolder = selectedFile.getAbsolutePath();
                path = selectedFile.getParent() + File.separatorChar + "Setup.exe";
                name = "Setup.exe";
                this.setPackagePath((String)path, name);
            } else {
                this.setUsingPackageFolder(false);
                name = file.substring(file.lastIndexOf(File.separator) + 1);
                this.setPackagePath(file, name);
            }
        }
        return succeeded;
    }

    private boolean isMacPackage(File selectedFile) {
        boolean isMacPackage = false;
        try {
            SoftwarePackage sp;
            if (selectedFile == null || !selectedFile.isFile()) {
                return isMacPackage;
            }
            Object filePath = selectedFile.getAbsolutePath();
            String fileExt = ((String)filePath).substring(((String)filePath).lastIndexOf("."));
            if (ConstantValue.getSupportedpackagefiletypesByIndex((int)1).equals(fileExt)) {
                MacPackageFormatHelper pkgFmtHelper = new MacPackageFormatHelper((String)filePath);
                isMacPackage = pkgFmtHelper.isMacZipPackage();
                return isMacPackage;
            }
            if (ConstantValue.getSupportedpackagefiletypesByIndex((int)2).equals(fileExt)) {
                filePath = ((String)filePath).substring(0, ((String)filePath).lastIndexOf(".")) + ConstantValue.getSupportedpackagefiletypesByIndex((int)0);
                fileExt = ConstantValue.getSupportedpackagefiletypesByIndex((int)0);
            }
            if (ConstantValue.getSupportedpackagefiletypesByIndex((int)0).equals(fileExt) && "Mac".equals((sp = PackageUtil.readSoftwarePackage((String)filePath)).getPackageInfo().getOptPlatformType())) {
                isMacPackage = true;
            }
        }
        catch (Exception e) {
            System.out.println("Exception while reading the package to check if its a Mac package");
            LoggerUtilities.logException((Throwable)e);
        }
        return isMacPackage;
    }

    private boolean isLinuxPackage(File selectedFile) {
        boolean isLinuxPackage = false;
        try {
            if (selectedFile == null) {
                return isLinuxPackage;
            }
            if (selectedFile.isFile()) {
                SoftwarePackage sp;
                Object filePath = selectedFile.getAbsolutePath();
                String fileExt = ((String)filePath).substring(((String)filePath).lastIndexOf("."));
                if (ConstantValue.getSupportedpackagefiletypesByIndex((int)1).equals(fileExt)) {
                    LinuxPackageFormatHelper pkgFmtHelper = new LinuxPackageFormatHelper((String)filePath);
                    isLinuxPackage = pkgFmtHelper.isLinuxPackage();
                    return isLinuxPackage;
                }
                if (ConstantValue.getSupportedpackagefiletypesByIndex((int)2).equals(fileExt)) {
                    filePath = ((String)filePath).substring(0, ((String)filePath).lastIndexOf(".")) + ConstantValue.getSupportedpackagefiletypesByIndex((int)0);
                    fileExt = ConstantValue.getSupportedpackagefiletypesByIndex((int)0);
                }
                if (ConstantValue.getSupportedpackagefiletypesByIndex((int)0).equals(fileExt) && ConstantValue.isLinuxPlatform((String)(sp = PackageUtil.readSoftwarePackage((String)filePath)).getPackageInfo().getOptPlatformType())) {
                    isLinuxPackage = true;
                }
            } else {
                isLinuxPackage = LinuxPackageFormatHelper.isDirLinuxPackage((String)selectedFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println("Exception while reading the package to check if its a Linux package");
            LoggerUtilities.logException((Throwable)e);
        }
        return isLinuxPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSingleExefromFolder() {
        String path = this.fullFolder;
        String zipDir = this.fullFolder.substring(0, this.fullFolder.lastIndexOf(File.separator));
        String zipFilePath = zipDir + File.separator + "FULL.ZIP";
        String exeDir = zipDir;
        String targetExe = exeDir + File.separator + "Setup.exe";
        try {
            NativeCommandUtilities.extractSsawrapper(path);
            ZipUtil.zipData((String)path, (String)zipFilePath);
            String toolDir = NativeCommandUtilities.buildConsoleExe("MakeSFX.exe");
            if (toolDir == null || toolDir.length() < 1) {
                System.out.println("DeploymentTypePanel>> createSingleExe: Warning-> no exe dir for MakeSFX.exe!");
                boolean bl = false;
                return bl;
            }
            File sourceZip = new File(zipFilePath);
            if (!sourceZip.exists()) {
                ConsoleLogger.log("DeploymentTypePanel>> createSingleExe: Warning-> no source ZIP in temp folder!");
                boolean bl = false;
                return bl;
            }
            boolean result = false;
            try {
                result = PackageUtil.runMakeSFX((String)toolDir, (String)targetExe, (String)zipFilePath);
            }
            catch (Throwable ex) {
                System.out.println("DeploymentTypePanel>> createSingleExe: Error-> Failed to run MakeSFX...");
                LoggerUtilities.logException((Throwable)ex);
                boolean bl = false;
                Utility.delete((String)zipFilePath);
                return bl;
            }
            if (!result) {
                System.out.println("DeploymentTypePanel>> createSingleExe: Error-> Failed to create a single exe: zip=" + zipFilePath + ", target exe=" + targetExe);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            boolean bl = false;
            return bl;
        }
        finally {
            Utility.delete((String)zipFilePath);
        }
        return true;
    }

    private void setPackagePath(String path, String name) {
        this.filePath = path;
        this.fileName = name;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setUsingPackageFolder(boolean usingPackageFolder) {
        this.usingPackageFolder = usingPackageFolder;
    }

    public boolean isUsingPackageFolder() {
        return this.usingPackageFolder;
    }

    public boolean isMacPackage() {
        return this.isMacPackageSelected;
    }
}

