/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerTableModel;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DeployStatusTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static ImageIcon notStartedIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("notStarted.gif")));
    private static ImageIcon progressIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("started.gif")));
    private static ImageIcon failureIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("failedErrorIcon.gif")));
    private static ImageIcon successIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("completedIcon.gif")));
    private static ImageIcon unsupportedIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("unsupportedUnavailable.gif")));

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableColumnModel tblColModel = table.getColumnModel();
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int colProgress = tblColModel.getColumnIndex(RemotePushComputerTableModel.PROGRESS);
        if (value == null) {
            value = 0;
        }
        if (column == colProgress) {
            int status = (Integer)value;
            switch (status) {
                case 0: {
                    renderer.setIcon(notStartedIcon);
                    break;
                }
                case -1: {
                    renderer.setIcon(failureIcon);
                    break;
                }
                case -2: {
                    renderer.setIcon(unsupportedIcon);
                    break;
                }
                case 100: {
                    renderer.setIcon(successIcon);
                    break;
                }
                default: {
                    renderer.setIcon(progressIcon);
                }
            }
        }
        renderer.setText(value.toString());
        renderer.setHorizontalAlignment(2);
        return renderer;
    }

    public void setDisplay(String text) {
        this.setText(text);
    }
}

