/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CheckBoxNode;
import com.sygate.scm.common.ui.CheckBoxNodeEditor;
import com.sygate.scm.common.ui.CheckBoxNodeRenderer;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import com.sygate.scm.common.ui.FeatureChangeEvent;
import com.sygate.scm.common.ui.FeatureChangeListener;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ui.client.wizard.FeatureDescriptionPanel;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClientInstallFeaturePanel
extends JPanel
implements FeatureChangeListener {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private static final String COMMONUI = "com.sygate.scm.common.ui.ui";
    public static final int VIEW_MODE = 0;
    public static final int EDIT_MODE = 1;
    static final String[] ALL_CATEGORIES = new String[]{"SAVMain", "PTPMain", "NTPMain"};
    public static final String ALL_FEATURE = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.allFeatureOption");
    public static final String CORE_ROOT = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.coreFiles");
    public static final String CAT_SAV = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.savFeatureOption");
    public static final String CAT_NTP = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.ntpFeatureOption");
    public static final String CAT_PTP = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.ptpFeatureCategory");
    public static final String CAT_TRUSCAN = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.ptpFeatureOption");
    public static final String CAT_TRUSCAN11 = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.truscanFeatureOption");
    public static final String CAT_DOWNLOAD = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.downloadFeatureOption");
    public static final String CAT_EMAIL = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.emailFeatureOption");
    public static final String CAT_OUTLOOK = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallationSAVFeatureDlg.OutlookChkBox");
    public static final String CAT_NOTES = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallationSAVFeatureDlg.NotesChkBox");
    public static final String CAT_POP3 = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallationSAVFeatureDlg.Pop3ChkBox");
    public static final String CAT_SONAR = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.ptpFeatureOption");
    public static final String CAT_ADC = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.adcFeatureOption");
    public static final String CAT_FIREWALL = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.firewallFeature");
    public static final String CAT_SAEP = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.saepFeatureOption");
    public static final String CAT_ADDEFENSE = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.adDefenseFeatureOption");
    public static final String CAT_NTR = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.ntrFeatureOption");
    public static final String CAT_FIREWALL_IDS = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.ntpFeatureOption");
    public static final String CAT_IPS = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.itpFeatureOption");
    public static final String CAT_BASIC = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.SBEBasicOption");
    public static final String CAT_STANDARD = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.SBEStandardOption");
    public static final String REDUCE_PROTECTION_WARNING = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.reduceLevelWarning");
    public static final String REDUCE_PROTECTION_WARNING_TITLE = MSGRES.getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientInstallFeaturePanel.reduceLevelWarningTitle");
    private boolean warned = false;
    private JTree tree = null;
    private JPanel headerPanel = null;
    private JPanel centerPanel = null;
    private int treeMode = 1;
    private ClientInstallationFeatures features;
    private boolean isSBProduct = false;
    private String currentVersion = "14.3.5000.0";
    private Map<String, String> featureMap = new HashMap<String, String>();
    private DefaultMutableTreeNode rootNode = null;
    private JPanel featureTreePanel = null;
    private FeatureDescriptionPanel descritpionPanel = null;
    protected List<ClientInstallFeaturePanelListener> listenerList = new ArrayList<ClientInstallFeaturePanelListener>();

    public ClientInstallFeaturePanel(boolean isSBE, int mode) {
        this.setSBProduct(isSBE);
        this.treeMode = mode;
        this.features = this.createNewFeatures();
        this.initialize(this.treeMode);
    }

    public ClientInstallFeaturePanel(boolean isSBE, int mode, ClientInstallationFeatures fs) {
        this.setSBProduct(isSBE);
        this.treeMode = mode;
        this.features = fs;
        this.initialize(this.treeMode);
    }

    public ClientInstallFeaturePanel() {
        this(false, 1);
    }

    public ClientInstallFeaturePanel(ClientInstallationFeatures cif, String ver) {
        this.setSBProduct(false);
        this.treeMode = 1;
        this.features = cif;
        this.setCurrentVersion(ver);
        this.initialize(this.treeMode);
    }

    private void initialize(int treeMode) {
        this.initFeatureMap();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    public static void expandAllNodesInTree(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        ClientInstallFeaturePanel.expandNodeAndChildrenInTree(tree, node);
    }

    public static void expandNodeAndChildrenInTree(JTree tree, DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        tree.expandPath(path);
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            ClientInstallFeaturePanel.expandNodeAndChildrenInTree(tree, nodeChild);
        }
    }

    protected void updateSelections() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.updateParentAndChildNodes(node);
        Enumeration en = (Enumeration)Cast.cast(node.breadthFirstEnumeration());
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode)) continue;
            this.updateDependency(childNode);
        }
        this.fireFeatureTreeSelectionChangeEvent();
        this.tree.repaint();
    }

    private void updateParentAndChildNodes(DefaultMutableTreeNode node) {
        Object userObj = node.getUserObject();
        if (userObj instanceof CheckBoxNode) {
            CheckBoxNode cb;
            TreeNode parent;
            boolean isSelected = ((CheckBoxNode)userObj).isSelected();
            if (isSelected && (parent = node.getParent()) != null && parent instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
                userObj = parentNode.getUserObject();
                if (userObj instanceof CheckBoxNode && !(cb = (CheckBoxNode)userObj).isSelected()) {
                    cb.setSelected(true);
                }
                parent = parent.getParent();
            }
            Enumeration en = (Enumeration)Cast.cast(node.breadthFirstEnumeration());
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
                userObj = childNode.getUserObject();
                if (!(userObj instanceof CheckBoxNode) || !((cb = (CheckBoxNode)userObj).isSelected() ^ isSelected)) continue;
                cb.setSelected(isSelected);
            }
        }
    }

    private void updateDependency(DefaultMutableTreeNode node) {
        Object userObj = node.getUserObject();
        if (userObj instanceof CheckBoxNode) {
            CheckBoxNode check = (CheckBoxNode)userObj;
            String text = check.getText();
            String name = this.getFeatureName(text);
            boolean checked = check.isSelected();
            List dependencyList = ClientInstallFeatureSetUtility.getDependingFeatureList((String)name, (String)this.getCurrentVersion());
            List dependantList = ClientInstallFeatureSetUtility.getDependantFeatureList((String)name, (String)this.getCurrentVersion());
            if (checked) {
                this.turnOnUIDependency(dependencyList, this.getCurrentVersion(), checked);
            } else {
                this.turnOnUIDependency(dependantList, this.getCurrentVersion(), checked);
                if (!this.isWarned()) {
                    this.setWarned(true);
                    AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(ClientInstallFeaturePanel.this, REDUCE_PROTECTION_WARNING, REDUCE_PROTECTION_WARNING_TITLE, 2);
                        }
                    }), () -> JOptionPane.showMessageDialog(this, REDUCE_PROTECTION_WARNING, REDUCE_PROTECTION_WARNING_TITLE, 2));
                }
            }
        }
    }

    public boolean isAllFeatureUnchecked(DefaultMutableTreeNode parent) {
        Enumeration en = (Enumeration)Cast.cast(parent.breadthFirstEnumeration());
        boolean allUnchecked = true;
        while (en.hasMoreElements()) {
            CheckBoxNode node;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode) || !(node = (CheckBoxNode)userObj).isSelected()) continue;
            allUnchecked = false;
            break;
        }
        return allUnchecked;
    }

    private void turnOnUIDependency(List<Object> dependencyList, String currentVersion2, boolean onoff) {
        if (dependencyList.isEmpty()) {
            return;
        }
        for (int i = 0; i < dependencyList.size(); ++i) {
            String feature = dependencyList.get(i).toString();
            this.flipFeatureNode(feature, onoff);
            System.out.println("Depending feature - " + feature + " is turned " + (onoff ? "on." : "off."));
        }
    }

    private void flipFeatureNode(String feature, boolean onoff) {
        if (feature == null || feature.isEmpty()) {
            return;
        }
        Enumeration en = (Enumeration)Cast.cast(this.rootNode.breadthFirstEnumeration());
        while (en.hasMoreElements()) {
            CheckBoxNode node;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode) || (node = (CheckBoxNode)userObj).getText().compareToIgnoreCase(this.getFeatureDisplayName(feature)) != 0) continue;
            node.setSelected(onoff);
            break;
        }
    }

    private List<Object> getDisplayList(List<Object> dependencyList) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (dependencyList != null && !dependencyList.isEmpty()) {
            for (int i = 0; i < dependencyList.size(); ++i) {
                String feature = dependencyList.get(i).toString();
                if (feature == null || feature.isEmpty()) continue;
                String text = this.getFeatureDisplayName(feature);
                retList.add(text);
            }
        }
        return retList;
    }

    protected void updateDescriptions() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.updateDescriptions(node);
    }

    private void updateDescriptions(DefaultMutableTreeNode node) {
        Object userObj = node.getUserObject();
        if (userObj instanceof CheckBoxNode) {
            CheckBoxNode check = (CheckBoxNode)userObj;
            String text = check.getText();
            String name = this.getFeatureName(text);
            List dependencyList = ClientInstallFeatureSetUtility.getDependingFeatureList((String)name, (String)this.getCurrentVersion());
            List<Object> displayList = this.getDisplayList(dependencyList);
            this.updateDescriptions(name, displayList);
        }
    }

    private void updateDescriptions(String name, List<Object> dependencyList) {
        this.descritpionPanel.setFeature(name, this.getCurrentVersion());
        this.descritpionPanel.setLinkList(dependencyList);
    }

    private void initFeatureMap() {
        this.featureMap.clear();
        if (this.getCurrentVersion().compareToIgnoreCase("14.2.1000.0") >= 0) {
            this.featureMap.put("Core", CORE_ROOT);
            this.featureMap.put("SAVMain", CAT_SAV);
            this.featureMap.put("Download", CAT_DOWNLOAD);
            this.featureMap.put("EMailTools", CAT_EMAIL);
            this.featureMap.put("OutlookSnapin", CAT_OUTLOOK);
            this.featureMap.put("PTPMain", CAT_PTP);
            this.featureMap.put("TruScan", CAT_TRUSCAN);
            this.featureMap.put("DCMain", CAT_ADC);
            this.featureMap.put("NTPMain", CAT_NTP);
            this.featureMap.put("Firewall", CAT_FIREWALL);
            this.featureMap.put("ITPMain", CAT_IPS);
            this.featureMap.put("Saep", CAT_SAEP);
            this.featureMap.put("ADDefense", CAT_ADDEFENSE);
            this.featureMap.put("NTR", CAT_NTR);
        } else if (this.getCurrentVersion().compareToIgnoreCase("14.2.0000.0") >= 0) {
            this.featureMap.put("Core", CORE_ROOT);
            this.featureMap.put("SAVMain", CAT_SAV);
            this.featureMap.put("Download", CAT_DOWNLOAD);
            this.featureMap.put("EMailTools", CAT_EMAIL);
            this.featureMap.put("OutlookSnapin", CAT_OUTLOOK);
            this.featureMap.put("NotesSnapin", CAT_NOTES);
            this.featureMap.put("Pop3Smtp", CAT_POP3);
            this.featureMap.put("PTPMain", CAT_PTP);
            this.featureMap.put("TruScan", CAT_TRUSCAN);
            this.featureMap.put("DCMain", CAT_ADC);
            this.featureMap.put("NTPMain", CAT_NTP);
            this.featureMap.put("Firewall", CAT_FIREWALL);
            this.featureMap.put("ITPMain", CAT_IPS);
            this.featureMap.put("Saep", CAT_SAEP);
        } else if (this.getCurrentVersion().compareToIgnoreCase("12.1.2000.0") >= 0) {
            this.featureMap.put("Core", CORE_ROOT);
            this.featureMap.put("SAVMain", CAT_SAV);
            this.featureMap.put("Download", CAT_DOWNLOAD);
            this.featureMap.put("EMailTools", CAT_EMAIL);
            this.featureMap.put("OutlookSnapin", CAT_OUTLOOK);
            this.featureMap.put("NotesSnapin", CAT_NOTES);
            this.featureMap.put("Pop3Smtp", CAT_POP3);
            this.featureMap.put("PTPMain", CAT_PTP);
            this.featureMap.put("TruScan", CAT_TRUSCAN);
            this.featureMap.put("DCMain", CAT_ADC);
            this.featureMap.put("NTPMain", CAT_NTP);
            this.featureMap.put("Firewall", CAT_FIREWALL);
            this.featureMap.put("ITPMain", CAT_IPS);
        } else if (this.getCurrentVersion().compareToIgnoreCase("12.1.0.0") >= 0) {
            this.featureMap.put("Core", CORE_ROOT);
            this.featureMap.put("SAVMain", CAT_SAV);
            this.featureMap.put("Download", CAT_DOWNLOAD);
            this.featureMap.put("EMailTools", CAT_EMAIL);
            this.featureMap.put("OutlookSnapin", CAT_OUTLOOK);
            this.featureMap.put("NotesSnapin", CAT_NOTES);
            this.featureMap.put("Pop3Smtp", CAT_POP3);
            this.featureMap.put("PTPMain", CAT_PTP);
            this.featureMap.put("TruScan", CAT_TRUSCAN);
            this.featureMap.put("DCMain", CAT_ADC);
            this.featureMap.put("NTPMain", CAT_NTP);
            this.featureMap.put("Firewall", CAT_FIREWALL);
            this.featureMap.put("ITPMain", CAT_IPS);
        } else {
            this.featureMap.put("SAVMain", CAT_SAV);
            this.featureMap.put("EMailTools", CAT_EMAIL);
            this.featureMap.put("OutlookSnapin", CAT_OUTLOOK);
            this.featureMap.put("NotesSnapin", CAT_NOTES);
            this.featureMap.put("Pop3Smtp", CAT_POP3);
            this.featureMap.put("PTPMain", CAT_PTP);
            this.featureMap.put("COHMain", CAT_TRUSCAN11);
            this.featureMap.put("DCMain", CAT_ADC);
            this.featureMap.put("ITPMain", CAT_NTP);
            this.featureMap.put("Firewall", CAT_FIREWALL_IDS);
        }
    }

    private String getFeatureDisplayName(String feature) {
        String displayName = this.featureMap.get(feature);
        if (displayName == null) {
            displayName = feature;
        }
        return displayName;
    }

    private String getFeatureName(String displayName) {
        String feature = "";
        Set<Map.Entry<String, String>> entrys = this.featureMap.entrySet();
        for (Map.Entry<String, String> ent : entrys) {
            if (!ent.getValue().equals(displayName)) continue;
            feature = ent.getKey().toString();
            break;
        }
        return feature;
    }

    private DefaultMutableTreeNode getFeatureTreeForVersion(ClientInstallationFeatures cif, String version) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Root");
        EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)version, (ClientInstallationFeatures)cif, (boolean)false);
        if (this.isSBProduct()) {
            if (Utility.compareVersion((String)version, (String)"12.1.0.0") < 0) {
                DefaultMutableTreeNode savNode = new DefaultMutableTreeNode(new CheckBoxNode(CAT_SAV, "SAVMain", true));
                DefaultMutableTreeNode ntpNode = new DefaultMutableTreeNode(new CheckBoxNode(CAT_NTP, "ITPMain", true));
                DefaultMutableTreeNode emailNode = new DefaultMutableTreeNode(new CheckBoxNode(CAT_EMAIL, "EMailTools", false));
                rootNode.add(savNode);
                rootNode.add(ntpNode);
                savNode.add(emailNode);
            } else {
                DefaultMutableTreeNode basicNode = new DefaultMutableTreeNode(new CheckBoxNode(CAT_BASIC, true));
                DefaultMutableTreeNode stdNode = new DefaultMutableTreeNode(new CheckBoxNode(CAT_STANDARD, true));
                DefaultMutableTreeNode emailNode = new DefaultMutableTreeNode(new CheckBoxNode(CAT_EMAIL, true));
                DefaultMutableTreeNode emailNode2 = new DefaultMutableTreeNode(new CheckBoxNode(CAT_EMAIL, true));
                rootNode.add(basicNode);
                rootNode.add(stdNode);
                basicNode.add(emailNode);
                stdNode.add(emailNode2);
            }
        } else {
            DefaultMutableTreeNode savNode = null;
            DefaultMutableTreeNode ptpNode = null;
            DefaultMutableTreeNode ntpNode = null;
            DefaultMutableTreeNode saepNode = null;
            DefaultMutableTreeNode tdadNode = null;
            DefaultMutableTreeNode ntrNode = null;
            if (Utility.compareVersion((String)version, (String)"12.1.0.0") < 0) {
                for (ClientFeature cf : ecf.getClientFeature()) {
                    DefaultMutableTreeNode theNode;
                    if ("SAVMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        savNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(savNode);
                        continue;
                    }
                    if ("PTPMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ptpNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ptpNode);
                        continue;
                    }
                    if ("ITPMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ntpNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ntpNode);
                        continue;
                    }
                    if (ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"SAVMain").contains(cf.getFeatureName())) {
                        theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        savNode.add(theNode);
                        continue;
                    }
                    if (ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"PTPMain").contains(cf.getFeatureName())) {
                        theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        ptpNode.add(theNode);
                        continue;
                    }
                    if (!ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"Firewall").contains(cf.getFeatureName())) continue;
                    theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                    ntpNode.add(theNode);
                }
            } else if (Utility.compareVersion((String)version, (String)"12.1.0.0") == 0) {
                for (ClientFeature cf : ecf.getClientFeature()) {
                    DefaultMutableTreeNode theNode;
                    if (cf.getFeatureName().compareToIgnoreCase("Core") == 0) continue;
                    if ("SAVMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        savNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(savNode);
                        continue;
                    }
                    if ("PTPMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ptpNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ptpNode);
                        continue;
                    }
                    if ("NTPMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ntpNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ntpNode);
                        continue;
                    }
                    if (ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"SAVMain").contains(cf.getFeatureName())) {
                        theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        if (savNode == null) continue;
                        savNode.add(theNode);
                        continue;
                    }
                    if (ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"PTPMain").contains(cf.getFeatureName())) {
                        theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        if (ptpNode == null) continue;
                        ptpNode.add(theNode);
                        continue;
                    }
                    if (!ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"NTPMain").contains(cf.getFeatureName())) continue;
                    theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                    if (ntpNode == null) continue;
                    ntpNode.add(theNode);
                }
            } else {
                for (ClientFeature cf : ecf.getClientFeature()) {
                    DefaultMutableTreeNode theNode;
                    if (cf.getFeatureName().compareToIgnoreCase("Core") == 0) continue;
                    if ("SAVMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        savNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(savNode);
                        continue;
                    }
                    if ("PTPMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ptpNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ptpNode);
                        continue;
                    }
                    if ("NTPMain".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ntpNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ntpNode);
                        continue;
                    }
                    if ("Saep".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        saepNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(saepNode);
                        continue;
                    }
                    if ("ADDefense".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        tdadNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(tdadNode);
                        continue;
                    }
                    if ("NTR".compareToIgnoreCase(cf.getFeatureName()) == 0) {
                        ntrNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        rootNode.add(ntrNode);
                        continue;
                    }
                    if (ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"SAVMain").contains(cf.getFeatureName())) {
                        theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        savNode.add(theNode);
                        continue;
                    }
                    if (ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"PTPMain").contains(cf.getFeatureName())) {
                        theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                        ptpNode.add(theNode);
                        continue;
                    }
                    if (!ClientInstallFeatureSetUtility.getDefaultSecondLevelFeatureList((String)version, (String)"NTPMain").contains(cf.getFeatureName())) continue;
                    theNode = new DefaultMutableTreeNode(new CheckBoxNode(this.getFeatureDisplayName(cf.getFeatureName()), cf.getFeatureName(), cf.getOptEnabled().booleanValue()));
                    ntpNode.add(theNode);
                }
            }
        }
        return rootNode;
    }

    private ClientInstallationFeatures createNewFeatures() {
        ClientInstallationFeatures result = ClientInstallFeatureSetUtility.createNewFeatureSet();
        return result;
    }

    public ClientInstallationFeatures getObject() {
        return this.features;
    }

    private void addFeature(ClientFeature feature, String version) {
        EnabledClientFeatures enabledFeature = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)version, (ClientInstallationFeatures)this.features, (boolean)false);
        enabledFeature.addClientFeature(feature);
    }

    private void setFeature(String type, boolean enabled, String version) {
        ClientFeature feature = ClientInstallFeatureSetUtility.findFeature((String)type, (String)version, (ClientInstallationFeatures)this.features);
        if (feature == null) {
            feature = new ClientFeature();
            feature.setFeatureName(type);
            feature.setOptEnabled(Boolean.valueOf(enabled));
            this.addFeature(feature, version);
        } else {
            feature.setOptEnabled(Boolean.valueOf(enabled));
        }
    }

    private boolean isFeatureEnabled(String type, String version) {
        ClientFeature feature = ClientInstallFeatureSetUtility.findFeature((String)type, (String)version, (ClientInstallationFeatures)this.features);
        if (feature != null) {
            Boolean enabled = feature.getOptEnabled();
            if (enabled == null) {
                enabled = false;
            }
            return enabled;
        }
        return false;
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
        }
        return this.headerPanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane(this.getFeatureTreePanel());
            this.centerPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 30, 0), 0, 0));
            this.centerPanel.add((Component)this.getDescritpionPanel(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 30, 20), 0, 0));
            this.centerPanel.revalidate();
        }
        return this.centerPanel;
    }

    private JPanel getFeatureTreePanel() {
        if (this.featureTreePanel == null) {
            this.featureTreePanel = new JPanel();
            this.rootNode = this.getFeatureTreeForVersion(this.features, this.getCurrentVersion());
            this.tree = new JTree(this.rootNode);
            this.tree.setToggleClickCount(1);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setExpandsSelectedPaths(true);
            this.tree.setVisibleRowCount(10);
            this.tree.getSelectionModel().setSelectionMode(1);
            CheckBoxNodeRenderer render = new CheckBoxNodeRenderer();
            this.tree.setCellRenderer((TreeCellRenderer)render);
            CheckBoxNodeEditor editor = new CheckBoxNodeEditor(this.tree);
            this.tree.setCellEditor((TreeCellEditor)editor);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent evt) {
                    System.out.println("Event caught: " + evt.getClass().getName());
                    ClientInstallFeaturePanel.this.updateDescriptions();
                }
            });
            editor.addFeatureChangeEventListener((FeatureChangeListener)this);
            this.tree.setEditable(this.treeMode == 1);
        }
        this.featureTreePanel.add((Component)this.tree, "Center");
        this.featureTreePanel.setOpaque(false);
        ClientInstallFeaturePanel.expandAllNodesInTree(this.tree);
        return this.featureTreePanel;
    }

    private JPanel getDescritpionPanel() {
        if (this.descritpionPanel == null) {
            this.descritpionPanel = new FeatureDescriptionPanel(this.features.getName());
        }
        return this.descritpionPanel;
    }

    public void setProtectionTechTree(JTree protectionTechTree) {
        this.tree = protectionTechTree;
    }

    public JTree getProtectionTechTree() {
        return this.tree;
    }

    public boolean isValidate() {
        return !this.isAllFeatureUnchecked(this.rootNode);
    }

    public void handleAutoConvert(EnabledClientFeatures ecf, String toVersion) {
        this.refreshFeatureTree(ecf, toVersion);
    }

    private void refreshFeatureTree(EnabledClientFeatures ecf, String toVersion) {
        this.setCurrentVersion(toVersion);
        Vector vEnabled = ecf.getClientFeature();
        Enumeration en = (Enumeration)Cast.cast(this.rootNode.breadthFirstEnumeration());
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode)) continue;
            CheckBoxNode node = (CheckBoxNode)userObj;
            boolean hasFeature = this.containsFeature(node.getText(), vEnabled);
            node.setSelected(hasFeature);
        }
        this.tree.repaint();
        if (ecf.getOptEditable() != null && !ecf.getOptEditable().booleanValue()) {
            this.setMode(0);
        }
        this.getFeatureTreePanel().revalidate();
    }

    public void save() {
        String version = this.getCurrentVersion();
        List availableFeatures = ClientInstallFeatureSetUtility.getFeaturesListByVersion((String)version);
        boolean emailEnabled = false;
        Enumeration en = (Enumeration)Cast.cast(this.rootNode.breadthFirstEnumeration());
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode)) continue;
            CheckBoxNode node = (CheckBoxNode)userObj;
            boolean enabled = node.isSelected();
            String feature = this.getFeatureName(node.getText());
            if (!availableFeatures.contains(feature)) continue;
            this.setFeature(feature, enabled, version);
            if (Utility.compareVersion((String)version, (String)"12.1.0.0") >= 0) continue;
            if ((feature.compareToIgnoreCase("Pop3Smtp") == 0 || feature.compareToIgnoreCase("OutlookSnapin") == 0 || feature.compareToIgnoreCase("NotesSnapin") == 0) && enabled) {
                emailEnabled = true;
            }
            if (feature.compareToIgnoreCase("Firewall") != 0 && feature.compareToIgnoreCase("ITPMain") != 0) continue;
            this.setFeature("ITPMain", enabled, version);
            this.setFeature("Firewall", enabled, version);
        }
        if (Utility.compareVersion((String)this.getCurrentVersion(), (String)"12.1.0.0") >= 0) {
            this.setFeature("Core", true, version);
        } else {
            this.doEmailToolsCheck(emailEnabled, version);
        }
    }

    private void doEmailToolsCheck(boolean on, String version) {
        if (Utility.compareVersion((String)version, (String)"12.1.0.0") < 0) {
            this.setFeature("EMailTools", on, version);
        }
    }

    public List<ClientFeature> getSelectedFeatureList() {
        ArrayList<ClientFeature> fList = new ArrayList<ClientFeature>();
        Enumeration en = (Enumeration)Cast.cast(this.rootNode.breadthFirstEnumeration());
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode)) continue;
            CheckBoxNode node = (CheckBoxNode)userObj;
            boolean enabled = node.isSelected();
            String feature = null;
            feature = node.getFeature() == null || node.getFeature().isEmpty() ? this.getFeatureName(node.getText()) : node.getFeature();
            ClientFeature cf = new ClientFeature();
            cf.setFeatureName(feature);
            cf.setOptEnabled(Boolean.valueOf(enabled));
            fList.add(cf);
        }
        return fList;
    }

    public String getEnabledCategories() {
        String catString = "";
        StringBuilder catBuilder = new StringBuilder();
        int count = 0;
        for (int i = 0; i < ALL_CATEGORIES.length; ++i) {
            String feature = ALL_CATEGORIES[i];
            if (!this.isFeatureEnabled(feature, this.getCurrentVersion())) continue;
            ++count;
            catBuilder.append(this.getFeatureDisplayName(feature));
            if (i == ALL_CATEGORIES.length - 1) continue;
            catBuilder.append("/");
        }
        catString = catBuilder.toString();
        if (catString.endsWith("/")) {
            catString = catString.substring(0, catString.length() - 1);
        }
        if (count == ALL_CATEGORIES.length) {
            catString = ALL_FEATURE;
        }
        return catString;
    }

    public List<String> getEnabledFeatureDisplayList() {
        ArrayList<String> nameList = new ArrayList<String>();
        Enumeration en = (Enumeration)Cast.cast(this.rootNode.breadthFirstEnumeration());
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof CheckBoxNode)) continue;
            CheckBoxNode node = (CheckBoxNode)userObj;
            String feature = this.getFeatureName(node.getText());
            nameList.add(feature);
        }
        return nameList;
    }

    public void setSBProduct(boolean isSBProduct) {
        this.isSBProduct = isSBProduct;
    }

    public boolean isSBProduct() {
        return this.isSBProduct;
    }

    public void setObject(ClientInstallationFeatures clientInstallationFeatures, String version) {
        this.features = clientInstallationFeatures;
        this.setCurrentVersion(version);
        this.refreshFeatureTree(this.features, version);
    }

    private void refreshFeatureTree(ClientInstallationFeatures cf, String version) {
        if (cf == null) {
            return;
        }
        EnabledClientFeatures ef = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)version, (ClientInstallationFeatures)this.features, (boolean)false);
        this.refreshFeatureTree(ef, version);
    }

    private boolean containsFeature(String sname, Vector<ClientFeature> set) {
        boolean hasElement = false;
        if (set == null || set.size() < 1) {
            return false;
        }
        if (sname.compareToIgnoreCase(CORE_ROOT) == 0) {
            return true;
        }
        for (ClientFeature feature : set) {
            if (feature == null) continue;
            boolean isEnabled = false;
            isEnabled = feature.getOptEnabled() == null ? false : feature.getOptEnabled();
            String displayName = this.getFeatureDisplayName(feature.getFeatureName());
            if (!isEnabled || displayName.compareToIgnoreCase(sname) != 0) continue;
            hasElement = true;
            break;
        }
        System.out.println("Contains feature: " + sname + " ? - " + hasElement);
        return hasElement;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public int getMode() {
        return this.treeMode;
    }

    public void setMode(int mode) {
        this.treeMode = mode;
        this.tree.setEnabled(this.treeMode == 1);
    }

    public void featureChanged(FeatureChangeEvent evt) {
        System.out.println("Feature change event caught....!!!!!!!!!");
        this.updateSelections();
    }

    public void setWarned(boolean warned) {
        this.warned = warned;
    }

    public boolean isWarned() {
        return this.warned;
    }

    public void addClientInstallFeaturePanelListener(ClientInstallFeaturePanelListener listener) {
        this.listenerList.add(listener);
    }

    public void removeClientInstallFeaturePanelListener(ClientInstallFeaturePanelListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireFeatureTreeSelectionChangeEvent() {
        for (ClientInstallFeaturePanelListener listener : this.listenerList) {
            listener.featureTreeSelectionChanged(this);
        }
    }

    public static interface ClientInstallFeaturePanelListener {
        public void featureTreeSelectionChanged(ClientInstallFeaturePanel var1);
    }
}

