/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.wizard;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.client.dlg.ClientInstallationWizard;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class AddPackageProgressPanel
extends ClientInstallationWizard
implements PropertyChangeListener {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENTDIALOG = "com.sygate.scm.console.ui.client.dlg.clientdialog";
    private JProgressBar progress;
    private PackageReader task;
    private DescriptionTextArea progressLabel;
    private boolean imported;
    private String filePath;
    private String fileName;

    public AddPackageProgressPanel(InstallClientWizardDialog wizard, boolean isSMB) {
        super(wizard, isSMB);
    }

    @Override
    protected String getTitleDescription() {
        return MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.titleDesc");
    }

    @Override
    protected String getTitle() {
        return MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.title");
    }

    @Override
    protected void initialize() {
        this.progressLabel = new DescriptionTextArea(MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.progressLabelText"));
        this.progress = new JProgressBar(0, 100);
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
        this.progress.addPropertyChangeListener(this);
        this.imported = false;
    }

    @Override
    protected JPanel getCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        int tab = 25;
        panel.add((Component)this.progressLabel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 18, 2, insertToLogo, 0, 0));
        panel.add((Component)this.progress, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 22 + tab, 0, 50), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.2, 18, 0, new Insets(10, 22 + tab, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            Integer value = (Integer)evt.getNewValue();
            this.progress.setIndeterminate(false);
            this.progress.setValue(value);
        }
    }

    public void setPackagePath(String path, String name) {
        this.filePath = path;
        this.fileName = name;
        if (!this.uploadPackage()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"));
            this.task.cancel(true);
        }
    }

    public boolean copyPackage() throws ConsoleException {
        boolean tf = true;
        if (this.getWizard().isUsingPackageFolder()) {
            if (!this.getWizard().createSingleExeFromFolder()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"));
                return false;
            }
        } else if (this.filePath == null || this.fileName == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENTDIALOG, "SelectExistingPackagePanel.importFailedMessage"));
            return false;
        }
        try {
            GUIManager.uploadPackageExeFile(this.filePath, this.fileName);
            this.getWizard().setCleanUpServerDirRequired(true);
        }
        catch (ConsoleException e) {
            tf = false;
        }
        return tf;
    }

    public void savePackagePath() {
        if (this.getWizard().isUsingPackageFolder()) {
            Utility.deleteFile((String)this.filePath);
        }
        this.getWizard().enableNetxButton(true);
        this.getWizard().doNextClicked();
    }

    public String getSavedFilePath() {
        return this.filePath;
    }

    public String getSavedFileName() {
        return this.fileName;
    }

    public boolean uploadPackage() {
        this.getWizard().enableNetxButton(false);
        this.progress.setIndeterminate(true);
        this.task = new PackageReader();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        return true;
    }

    public boolean isValidated() {
        return true;
    }

    public CurrentPackageObject getSelectedPackageObject() {
        return null;
    }

    class PackageReader
    extends SwingWorker<Boolean, Void> {
        PackageReader() {
        }

        @Override
        public Boolean doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            try {
                AddPackageProgressPanel.this.copyPackage();
                Thread.sleep(500 + random.nextInt(1000));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ConsoleException e) {
                return false;
            }
            while (progress < 100 && !AddPackageProgressPanel.this.imported) {
                try {
                    Thread.sleep(random.nextInt(500));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setProgress(Math.min(progress += random.nextInt(5), 100));
            }
            return true;
        }

        @Override
        public void done() {
            AddPackageProgressPanel.this.imported = true;
            AddPackageProgressPanel.this.savePackagePath();
        }
    }
}

