/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit.parser;

import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditComputerNode;
import com.sygate.scm.console.ui.client.networkaudit.parser.Domain;
import com.sygate.scm.console.ui.client.networkaudit.parser.Network;
import com.sygate.scm.console.ui.client.networkaudit.parser.NetworkBrowseException;
import com.sygate.scm.console.ui.client.networkaudit.parser.NetworkNode;
import com.sygate.scm.console.ui.client.networkaudit.parser.WorkGroup;
import com.sygate.scm.util.LoggerUtilities;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NetworkParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder documentBuilder = null;
    private static final String NETWORK_NODE = "Network";
    private static final String ERROR_NODE = "Error";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String IP_ADDRESS = "ip_addr";
    private static final String DOMAIN_NODE = "Domain";
    private static final String WORKGROUP_NODE = "WorkGroup";
    private static final String SERVER_NODE = "Server";
    private static NetworkParser instance;
    private static Object monitor;

    private NetworkParser() {
    }

    public static synchronized void initialize() {
        try {
            if (documentBuilder == null) {
                FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
                FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                documentBuilder = FACTORY.newDocumentBuilder();
            }
        }
        catch (ParserConfigurationException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkParser getInstance() {
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                instance = new NetworkParser();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Network> parse(String networkDataTobeParse) throws NetworkBrowseException {
        ArrayList<Network> networkList = null;
        try {
            NetworkParser.initialize();
            DataInputStream myInput = new DataInputStream(new ByteArrayInputStream(networkDataTobeParse.getBytes("UTF8")));
            Object object = monitor;
            synchronized (object) {
                Document doc = documentBuilder.parse(myInput);
                this.parseNetworkBrowseErrors(doc);
                networkList = this.parseNetworks(doc);
            }
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        catch (SAXException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return networkList;
    }

    private void parseNetworkBrowseErrors(Document doc) throws NetworkBrowseException {
        NodeList errorList = doc.getElementsByTagName(ERROR_NODE);
        if (errorList.getLength() != 0) {
            String errorMessage = errorList.item(0).getChildNodes().item(0).getTextContent();
            throw new NetworkBrowseException(errorMessage);
        }
    }

    private ArrayList<Network> parseNetworks(Document doc) {
        ArrayList<Network> networks = new ArrayList<Network>();
        NodeList networkList = doc.getElementsByTagName(NETWORK_NODE);
        for (int i = 0; i < networkList.getLength(); ++i) {
            Node networkNode = networkList.item(i);
            Network network = this.parseNetwork(networkNode);
            networks.add(network);
        }
        return networks;
    }

    private Network parseNetwork(Node networkNode) {
        Network network = new Network();
        String networkName = ((Element)networkNode).getAttribute(NAME_ATTRIBUTE);
        network.setName(networkName);
        NodeList networkSubNodeList = networkNode.getChildNodes();
        for (int i = 0; i < networkSubNodeList.getLength(); ++i) {
            Node node = networkSubNodeList.item(i);
            if (node.getNodeName().equals(DOMAIN_NODE)) {
                NetworkNode domain = new Domain();
                domain = this.parseNetworkNode(node, domain);
                network.addNetWorkNode(domain);
                continue;
            }
            if (!node.getNodeName().equals(WORKGROUP_NODE)) continue;
            NetworkNode workGroup = new WorkGroup();
            workGroup = this.parseNetworkNode(node, workGroup);
            network.addNetWorkNode(workGroup);
        }
        return network;
    }

    private NetworkNode parseNetworkNode(Node domainNode, NetworkNode node) {
        int size = node.getDomainList().size();
        NetworkNode temp_domain = size > 0 ? (NetworkNode)node.getDomainList().get(size - 1) : node;
        String name = ((Element)domainNode).getAttribute(NAME_ATTRIBUTE);
        temp_domain.setName(name);
        NodeList childList = domainNode.getChildNodes();
        ArrayList<NetworkAuditComputerNode> servers = new ArrayList<NetworkAuditComputerNode>();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node serverNode = childList.item(i);
            if (serverNode.getNodeName().equals(DOMAIN_NODE)) {
                Domain newDomain = new Domain();
                temp_domain.addDomain(newDomain);
                this.parseNetworkNode(serverNode, newDomain);
                continue;
            }
            if (!serverNode.getNodeName().equals(SERVER_NODE)) continue;
            NetworkAuditComputerNode server = this.parseServer(serverNode);
            servers.add(server);
        }
        temp_domain.setServerList(servers);
        return node;
    }

    private NetworkAuditComputerNode parseServer(Node serverNode) {
        String name = ((Element)serverNode).getAttribute(NAME_ATTRIBUTE);
        String ipAddress = ((Element)serverNode).getAttribute(IP_ADDRESS);
        int indexOfModuleChar = ipAddress.indexOf("%");
        if (indexOfModuleChar != -1) {
            ipAddress = ipAddress.substring(0, indexOfModuleChar);
        }
        NetworkAuditComputerNode server = new NetworkAuditComputerNode(ipAddress, name);
        return server;
    }

    static {
        monitor = new Object();
    }
}

