/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.client.networkaudit.ScanOptionObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScanOptionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private JTextField jTFTimeout = new JTextField(10);
    private JCheckBox jChkContinueAudit = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.client.client", "ScanOptionDialog.checkbox.continueAudit"));
    private JCheckBox jChkNameResolution = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.client.client", "ScanOptionDialog.checkbox.nameResolution"));
    private ScanOptionObject scanObj;

    public ScanOptionDialog(JFrame owner, ScanOptionObject scanObj) {
        super(owner, MSGRES.getString(CLIENT, "ScanOptionDialog.title"), true);
        this.initialize();
        this.setObject(scanObj);
        Point parentLoc = owner.getLocation();
        Dimension parent = owner.getSize();
        Dimension dlgSize = this.getSize();
        this.setLocation(parentLoc.x + (parent.width - dlgSize.width) / 2, parentLoc.y + (parent.height - dlgSize.height) / 2);
        this.setVisible(true);
    }

    public ScanOptionDialog(JFrame owner, ScanOptionObject scanObj, boolean needCenter) {
        super(owner, MSGRES.getString(CLIENT, "ScanOptionDialog.title"), true);
        this.initialize();
        this.setObject(scanObj);
        if (needCenter) {
            UiUtilities.centerComponent((Component)this);
        }
        this.setVisible(true);
    }

    @Override
    protected boolean isValidate() {
        String timeout = this.jTFTimeout.getText();
        boolean timeoutValid = false;
        if (timeout != null && timeout.trim().length() > 0) {
            try {
                int intValue = Integer.parseInt(timeout);
                if (intValue >= 500) {
                    timeoutValid = true;
                }
            }
            catch (NumberFormatException e) {
                timeoutValid = false;
            }
        }
        if (!timeoutValid) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(CLIENT, "ScanOptionDialog.error.timeout"), MSGRES.getString(CLIENT, "ScanOptionDialog.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.scanObj.setIcmpTimeout(this.jTFTimeout.getText().trim());
        this.scanObj.setContinueAudit(this.jChkContinueAudit.isSelected());
        this.scanObj.setNamedResolution(this.jChkNameResolution.isSelected());
    }

    private void initialize() {
        DescriptionTextArea desc = new DescriptionTextArea(MSGRES.getString(CLIENT, "ScanOptionDialog.label.desc"));
        desc.setColumns(40);
        desc.setSize(desc.getPreferredSize());
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)desc, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getPingOptionPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.pack();
    }

    private JPanel getPingOptionPanel() {
        this.jTFTimeout.setDocument(new NumberPlainDocument(Integer.MAX_VALUE, true));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MSGRES.getString(CLIENT, "ScanOptionDialog.label.timeout")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFTimeout, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JLabel timeLabel = new JLabel(MSGRES.getString(CLIENT, "ScanOptionDialog.label.milliseconds"));
        timeLabel.setHorizontalAlignment(2);
        panel.add((Component)timeLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jChkContinueAudit, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 10), 0, 0));
        return panel;
    }

    private void setObject(ScanOptionObject scanObj) {
        this.scanObj = scanObj;
        this.jTFTimeout.setText(scanObj.getIcmpTimeout());
        this.jChkContinueAudit.setSelected(scanObj.isContinueAudit());
        this.jChkNameResolution.setSelected(scanObj.isNamedResolution());
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_client_dialog_computers_users_network_audit_options";
    }
}

