/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallPoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.RemoteDeploymentHelper;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditSearchListener;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.commons.validator.routines.InetAddressValidator;

public class RemotePushInstallClientThread
extends Thread {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private List<CurrentPackageObject> selectedPackage;
    private int status;
    private boolean isCommunicating;
    private BufferedReader reader;
    private final Vector<RemotePushComputerObject> selComputers;
    private String strGroupId = "";
    private String strFeaturesXML;
    private int contentOption = 0;
    private boolean keepPreviousSettingsMac = true;
    private boolean isMac1015OrUp = false;
    private final NetworkAuditSearchListener listener;
    private Map<String, CurrentPackageObject> mLatestPackages = null;
    private List<CurrentPackageObject> legacyPackages = new ArrayList<CurrentPackageObject>();
    public static final int INITIAL = 0;
    public static final int START = 1;
    public static final int PUSH_COMPLETE = 4;
    public static final int FINISHED = 2;
    public static final int CANCELED = 3;
    public static final int COMMUNICATION_UPDATE_COMPLETE = 5;
    private boolean isSBProduct = true;
    private int agentMode;
    private String filePath = null;
    private String fileName = null;
    private String settingsName = null;
    private BufferedWriter writer;
    private static String pushLogPath = "c:" + File.separator + "temp" + File.separator;
    private static String pushLogFile = pushLogPath + File.separator + "push.log";
    private boolean begeinSection = false;
    private static final String beginString = "<-----";
    private static final String endString = "----->";
    private boolean foundIP = false;
    private boolean foundValue = false;
    public boolean debug = false;
    private boolean compUninstall = false;
    private boolean bsepCommunicationUpdater = false;
    private boolean isMacCommunicationUpdate = false;
    private String knownHostsFileName = null;
    private boolean reducedSize = false;
    private boolean darkNetwork = false;
    private boolean lowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();

    public RemotePushInstallClientThread(String pkgId, Vector<RemotePushComputerObject> selComputers, String strGroupId, String strFeaturesXML, NetworkAuditSearchListener listener, Map<String, CurrentPackageObject> mPackages, List<CurrentPackageObject> currentPackageObject, int contentOption, String savedFilePath, String savedFileName, String installSettings, int policyMode, boolean keepPreviousSettingsMac, boolean isMac1015OrUp, String knownHostsFileName, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled) {
        this.selComputers = selComputers;
        this.strGroupId = strGroupId;
        this.strFeaturesXML = strFeaturesXML;
        this.listener = listener;
        this.mLatestPackages = mPackages;
        this.selectedPackage = new ArrayList<CurrentPackageObject>();
        this.filePath = savedFilePath;
        this.fileName = savedFileName;
        this.setSelectedPackage(currentPackageObject);
        this.contentOption = contentOption;
        this.settingsName = installSettings;
        this.agentMode = policyMode;
        this.keepPreviousSettingsMac = keepPreviousSettingsMac;
        this.isMac1015OrUp = isMac1015OrUp;
        this.knownHostsFileName = knownHostsFileName;
        this.reducedSize = reducedSize;
        this.darkNetwork = darkNetwork;
        this.lowBandwidthEnabled = lowBandwidthEnabled;
        this.setSBProduct(false);
    }

    public RemotePushInstallClientThread(Vector<RemotePushComputerObject> selComputers, String strGroupId, int agentMode, NetworkAuditSearchListener listener, boolean isMac, String knownHostsFileName) {
        this.selComputers = selComputers;
        this.bsepCommunicationUpdater = true;
        this.strGroupId = strGroupId;
        this.agentMode = agentMode;
        this.listener = listener;
        this.isMacCommunicationUpdate = isMac;
        this.knownHostsFileName = knownHostsFileName;
    }

    @Override
    public void run() {
        System.out.println("RemotePushInstallClientThread>> REMOTE PUSH STARTED");
        this.isCommunicating = false;
        this.status = 1;
        RpcData data = this.getInstallData();
        if (data == null) {
            System.out.println("RemotePushInstallClientThread>> Packaging parameters are not correctly set, REMOTE PUSH FAILED.");
            return;
        }
        if (this.listener != null) {
            this.listener.stateChanged(1);
        }
        try {
            this.isCommunicating = true;
            if (this.status == 2) {
                this.finished();
                return;
            }
            this.reader = new BufferedReader(new InputStreamReader(GUIManager.getInputStreamForAction(data, this.getRequestHandlerName()), Charset.defaultCharset()));
            this.isCommunicating = false;
            if (this.status == 3 || this.status == 2) {
                this.finished();
                return;
            }
            if (this.debug) {
                File logFile = new File(pushLogPath);
                if (!logFile.exists() && !logFile.mkdirs()) {
                    System.out.println("RemotePushInstallClientThread>> Can not create folder: " + logFile.getPath() + ", REMOTE PUSH FAILED.");
                    return;
                }
                FileOutputStream fos = new FileOutputStream(pushLogFile, true);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                this.writer = new BufferedWriter(osw);
            }
            int progress = 0;
            String computerName = "";
            InetAddressValidator ipValidator = InetAddressValidator.getInstance();
            if (this.reader.ready()) {
                String line;
                while ((line = this.reader.readLine()) != null && this.status != 3 && this.status != 2) {
                    int status;
                    String[] result;
                    if (!this.isRealResponse(line)) continue;
                    if (this.debug) {
                        this.writer.write(line);
                        this.writer.newLine();
                        this.writer.flush();
                    }
                    if ((result = line.split("\\t", -1)).length == 4) {
                        if (!ipValidator.isValid(result[0]) || !Utility.isValidNumber((String)result[1]) || !Utility.isValidNumber((String)result[2])) continue;
                        computerName = result[0];
                        status = Integer.parseInt(result[1]);
                        if (status == 3) {
                            int CommunicationStatus = Integer.parseInt(result[2]);
                            String CommStatusdesc = result[3];
                            this.updateCommunicationStatus(computerName, CommunicationStatus, CommStatusdesc);
                            this.updateProgressForKnownHostsErrors(computerName, CommunicationStatus, false);
                        }
                    } else if (result.length == 2) {
                        if (!ipValidator.isValid(result[0]) || !Utility.isValidNumber((String)result[1])) continue;
                        computerName = result[0];
                        status = Integer.parseInt(result[1]);
                        this.updateStatus(computerName, status);
                        this.updateProgressForKnownHostsErrors(computerName, status, true);
                        if (status == 1) {
                            this.updateProgress(computerName, 100);
                        }
                        if (this.listener != null) {
                            this.listener.stateChanged(4);
                        }
                    } else {
                        if (result[0].indexOf(beginString) > -1) {
                            this.begeinSection = true;
                            computerName = "";
                            progress = 0;
                            continue;
                        }
                        if (result[0].indexOf(endString) > -1) {
                            this.begeinSection = false;
                            this.foundIP = false;
                            this.foundValue = false;
                            continue;
                        }
                    }
                    if (!this.begeinSection) continue;
                    if (!this.foundIP && result[0].indexOf("m_strClient:") > 0) {
                        computerName = result[0].replace("m_strClient:", "").trim();
                        this.foundIP = true;
                        continue;
                    }
                    if (!this.foundIP || this.foundValue || result[0].indexOf("m_nProgressPercent:") <= 0) continue;
                    this.foundValue = true;
                    progress = Integer.parseInt(result[0].replace("m_nProgressPercent:", "").trim());
                    this.updateProgress(computerName, progress);
                    this.begeinSection = false;
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            String[] args = new String[]{ex.getMessage()};
            String msg = MSGRES.getString(CLIENT, "NetworkAuditFrame.error.console1");
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(msg, args), MSGRES.getString(CLIENT, "NetworkAuditFrame.error"), 1);
        }
        catch (IOException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENT, "NetworkAuditFrame.error.io1"), MSGRES.getString(CLIENT, "NetworkAuditFrame.error"), 1);
        }
        this.finished();
    }

    private void updateProgressForKnownHostsErrors(String computerName, int status, boolean isUpdateProgress) {
        switch (status) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                ConsoleLogger.log("Found a known_hosts verification related error while deploying to host: " + computerName);
                if (!isUpdateProgress) break;
                this.updateProgress(computerName, 100);
                break;
            }
        }
    }

    private RpcData getInstallData() {
        if (this.bsepCommunicationUpdater) {
            return this.createCommunicationpdaterData();
        }
        if (this.isSBProduct()) {
            return this.createInstallData();
        }
        return this.createInstallDataEE();
    }

    private void updateStatus(String strIP, int status) {
        for (RemotePushComputerObject entry : this.selComputers) {
            if (!entry.getComputerNode().getIP().equals(strIP)) continue;
            entry.setInstallStatus(status);
        }
    }

    private void updateCommunicationStatus(String strIP, int status, String desc) {
        for (RemotePushComputerObject entry : this.selComputers) {
            if (!entry.getComputerNode().getIP().equals(strIP)) continue;
            entry.setUpdateCommunicationStatus(status);
            entry.setCommunicationStatusDesc(desc);
        }
    }

    private void updateProgress(String strIP, int status) {
        for (RemotePushComputerObject entry : this.selComputers) {
            if (!entry.getComputerNode().getIP().equals(strIP) && !entry.getComputerNode().getHostName().equals(strIP)) continue;
            if (status > 100) {
                status = 100;
            }
            entry.setProgress(status);
        }
    }

    private RpcData createInstallDataEE() {
        RpcData data = new RpcData();
        ClientInstallationSettingObject settings = null;
        CurrentPackageObject currPkg32BitObj = null;
        SoftwarePackageObject softPkg32BitObj = null;
        CurrentPackageObject currPkg64BitObj = null;
        SoftwarePackageObject softPkg64BitObj = null;
        CurrentPackageObject currPkgMacBitObj = null;
        SoftwarePackageObject softPkgMacBitObj = null;
        try {
            for (int i = 0; i < this.getSelectedPackage().size(); ++i) {
                CurrentPackageObject packageObj = this.getSelectedPackage().get(i);
                if ("WIN32BIT".equals(packageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                    currPkg32BitObj = packageObj;
                    softPkg32BitObj = currPkg32BitObj.getSoftwarePackageObject();
                    continue;
                }
                if ("WIN64BIT".equals(packageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                    currPkg64BitObj = packageObj;
                    softPkg64BitObj = currPkg64BitObj.getSoftwarePackageObject();
                    continue;
                }
                if ("Mac".equals(packageObj.getSoftwarePackage().getPackageInfo().getOptPlatformType())) {
                    currPkgMacBitObj = packageObj;
                    softPkgMacBitObj = currPkgMacBitObj.getSoftwarePackageObject();
                    continue;
                }
                return null;
            }
            ClientInstallPoolObject poolSettings = new ClientInstallPoolObject();
            List<ClientInstallationSettingObject> listInstall = poolSettings.getAllObjects();
            settings = this.findCorrectSettings(listInstall);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (currPkg32BitObj != null) {
            data.addNameValuePair(this.createNameValuePair("PackageId_32", currPkg32BitObj.getId()));
            data.addNameValuePair(this.createNameValuePair("PackageChecksum_32", softPkg32BitObj.getCheckSum()));
            data.addNameValuePair(this.createNameValuePair("PackageBuildNum_32", softPkg32BitObj.getBuildNumber()));
        }
        if (currPkg64BitObj != null) {
            data.addNameValuePair(this.createNameValuePair("PackageId_64", currPkg64BitObj.getId()));
            data.addNameValuePair(this.createNameValuePair("PackageChecksum_64", softPkg64BitObj.getCheckSum()));
            data.addNameValuePair(this.createNameValuePair("PackageBuildNum_64", softPkg64BitObj.getBuildNumber()));
        }
        boolean isMacPkg = false;
        if (currPkgMacBitObj != null) {
            isMacPkg = true;
            data.addNameValuePair(this.createNameValuePair("PackageId_Mac", currPkgMacBitObj.getId()));
            data.addNameValuePair(this.createNameValuePair("PackageChecksum_Mac", softPkgMacBitObj.getCheckSum()));
            data.addNameValuePair(this.createNameValuePair("PackageBuildNum_Mac", softPkgMacBitObj.getBuildNumber()));
        }
        this.addKnownHostsData(data, isMacPkg);
        int index = 0;
        for (RemotePushComputerObject entry : this.selComputers) {
            data.addNameValuePair(this.createNameValuePair("Username_" + index, entry.getUserName()));
            data.addNameValuePair(this.createNameValuePair("Password_" + index, entry.getPassword()));
            if (entry.getDomain().length() > 0) {
                data.addNameValuePair(this.createNameValuePair("Domain_" + index, entry.getDomain()));
            }
            if (entry.getComputerNode().getIP() != null && entry.getComputerNode().getIP().trim().length() > 0) {
                data.addNameValuePair(this.createNameValuePair("HostIP_" + index, entry.getComputerNode().getIP()));
            } else {
                data.addNameValuePair(this.createNameValuePair("HostIP_" + index, entry.getComputerNode().getHostName()));
            }
            data.addNameValuePair(this.createNameValuePair("BitType_" + index, String.valueOf(entry.getPlatformType())));
            ++index;
        }
        if (settings != null) {
            data.addNameValuePair(this.createNameValuePair("ClientInstallationSettingsID", settings.getId()));
        }
        data.addNameValuePair(this.createNameValuePair("EnabledClientInstallationFeatures", this.strFeaturesXML));
        data.addNameValuePair(this.createNameValuePair("PreferredMode", "" + this.agentMode));
        data.addNameValuePair(this.createNameValuePair("Group", this.strGroupId));
        data.addNameValuePair(this.createNameValuePair("ContentOption", String.valueOf(this.contentOption)));
        data.addNameValuePair(this.createNameValuePair("KeepPreviousSetting", String.valueOf(this.keepPreviousSettingsMac)));
        data.addNameValuePair(this.createNameValuePair("IS_10_15_OR_UP_MAC", String.valueOf(this.isMac1015OrUp)));
        if (this.filePath != null && this.fileName != null) {
            data.addNameValuePair(this.createNameValuePair("ExistingPackagePath", this.filePath));
            data.addNameValuePair(this.createNameValuePair("ExistingPackageName", this.fileName));
        }
        data.addNameValuePair(this.createNameValuePair("reducedSize", String.valueOf(this.reducedSize)));
        data.addNameValuePair(this.createNameValuePair("darkNetwork", String.valueOf(this.darkNetwork)));
        data.addNameValuePair(this.createNameValuePair("lowBandwidth", String.valueOf(this.lowBandwidthEnabled)));
        return data;
    }

    private RpcData createCommunicationpdaterData() {
        RpcData data = new RpcData();
        int index = 0;
        for (RemotePushComputerObject entry : this.selComputers) {
            data.addNameValuePair(this.createNameValuePair("Username_" + index, entry.getUserName()));
            data.addNameValuePair(this.createNameValuePair("Password_" + index, entry.getPassword()));
            if (entry.getDomain().length() > 0) {
                data.addNameValuePair(this.createNameValuePair("Domain_" + index, entry.getDomain()));
            }
            data.addNameValuePair(this.createNameValuePair("HostIP_" + index, entry.getComputerNode().getIP()));
            data.addNameValuePair(this.createNameValuePair("BitType_" + index, String.valueOf(entry.getPlatformType())));
            ++index;
        }
        data.addNameValuePair(this.createNameValuePair("PreferredMode", "" + this.agentMode));
        data.addNameValuePair(this.createNameValuePair("Group", this.strGroupId));
        if (!this.isMacCommunicationUpdate) {
            data.addNameValuePair(this.createNameValuePair("SepCommunicationUpdater", "SepCommunicationUpdater"));
        } else {
            data.addNameValuePair(this.createNameValuePair("SepCommunicationUpdater", "SepCommunicationUpdaterMac"));
        }
        this.addKnownHostsData(data, this.isMacCommunicationUpdate);
        return data;
    }

    private void addKnownHostsData(RpcData data, boolean isMac) {
        if (isMac && this.knownHostsFileName != null) {
            data.addNameValuePair(this.createNameValuePair("KNOWN_HOSTS", this.knownHostsFileName));
        }
    }

    private RpcData createInstallData() {
        RpcData data = new RpcData();
        ClientInstallationSettingObject settings = null;
        CurrentPackageObject currPkg32BitObj = null;
        SoftwarePackageObject softPkg32BitObj = null;
        CurrentPackageObject currPkg64BitObj = null;
        SoftwarePackageObject softPkg64BitObj = null;
        CurrentPackageObject currPkgMacBitObj = null;
        SoftwarePackageObject softPkgMacBitObj = null;
        CurrentPackageObject legacyPkg32BitObj = null;
        SoftwarePackageObject legacysSoftPkg32BitObj = null;
        try {
            currPkg32BitObj = this.mLatestPackages.get("WIN32BIT");
            currPkg64BitObj = this.mLatestPackages.get("WIN64BIT");
            currPkgMacBitObj = this.mLatestPackages.get("Mac");
            if (this.legacyPackages.size() > 0) {
                legacyPkg32BitObj = this.legacyPackages.get(0);
                legacysSoftPkg32BitObj = legacyPkg32BitObj.getSoftwarePackageObject();
            }
            ClientInstallPoolObject poolSettings = new ClientInstallPoolObject();
            List<ClientInstallationSettingObject> listInstall = poolSettings.getAllObjects();
            settings = this.findCorrectSettings(listInstall);
            if (currPkg32BitObj != null) {
                softPkg32BitObj = currPkg32BitObj.getSoftwarePackageObject();
                data.addNameValuePair(this.createNameValuePair("PackageId_32", currPkg32BitObj.getId()));
                data.addNameValuePair(this.createNameValuePair("PackageChecksum_32", softPkg32BitObj.getCheckSum()));
                data.addNameValuePair(this.createNameValuePair("PackageBuildNum_32", softPkg32BitObj.getBuildNumber()));
            }
            if (currPkg64BitObj != null) {
                softPkg64BitObj = currPkg64BitObj.getSoftwarePackageObject();
                data.addNameValuePair(this.createNameValuePair("PackageId_64", currPkg64BitObj.getId()));
                data.addNameValuePair(this.createNameValuePair("PackageChecksum_64", softPkg64BitObj.getCheckSum()));
                data.addNameValuePair(this.createNameValuePair("PackageBuildNum_64", softPkg64BitObj.getBuildNumber()));
            }
            boolean isMacPkg = false;
            if (currPkgMacBitObj != null) {
                isMacPkg = true;
                softPkgMacBitObj = currPkgMacBitObj.getSoftwarePackageObject();
                data.addNameValuePair(this.createNameValuePair("PackageId_Mac", currPkgMacBitObj.getId()));
                data.addNameValuePair(this.createNameValuePair("PackageChecksum_Mac", softPkgMacBitObj.getCheckSum()));
                data.addNameValuePair(this.createNameValuePair("PackageBuildNum_Mac", softPkgMacBitObj.getBuildNumber()));
            }
            this.addKnownHostsData(data, isMacPkg);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            ConsoleLogger.log("Inside class: RemotePushInstallClientThread; method: createInstallData >> ");
            ConsoleLogger.log(ex);
        }
        if (currPkg32BitObj == null && currPkg64BitObj == null && currPkgMacBitObj == null && legacyPkg32BitObj == null) {
            ConsoleLogger.log("Inside class: RemotePushInstallClientThread; method: createInstallData >> ERROR: All packages are NULL");
        }
        if (this.legacyPackages.size() > 0) {
            data.addNameValuePair(this.createNameValuePair("Legacy_PackageId_32", legacyPkg32BitObj.getId()));
            data.addNameValuePair(this.createNameValuePair("Legacy_PackageChecksum_32", legacysSoftPkg32BitObj.getCheckSum()));
            data.addNameValuePair(this.createNameValuePair("Legacy_PackageBuildNum_32", legacysSoftPkg32BitObj.getBuildNumber()));
        }
        int index = 0;
        for (RemotePushComputerObject entry : this.selComputers) {
            data.addNameValuePair(this.createNameValuePair("Username_" + index, entry.getUserName()));
            data.addNameValuePair(this.createNameValuePair("Password_" + index, entry.getPassword()));
            if (entry.getDomain().length() > 0) {
                data.addNameValuePair(this.createNameValuePair("Domain_" + index, entry.getDomain()));
            }
            data.addNameValuePair(this.createNameValuePair("HostIP_" + index, entry.getComputerNode().getIP()));
            data.addNameValuePair(this.createNameValuePair("BitType_" + index, String.valueOf(entry.getPlatformType())));
            boolean islegacy = RemoteDeploymentHelper.isLegacyOS(entry, currPkg32BitObj.getPackageVersion());
            if (this.legacyPackages.size() > 0) {
                data.addNameValuePair(this.createNameValuePair("IsLegacy_" + index, String.valueOf(islegacy)));
            }
            ++index;
        }
        if (settings != null) {
            data.addNameValuePair(this.createNameValuePair("ClientInstallationSettingsID", settings.getId()));
        }
        data.addNameValuePair(this.createNameValuePair("EnabledClientInstallationFeatures", this.strFeaturesXML));
        data.addNameValuePair(this.createNameValuePair("PreferredMode", "1"));
        data.addNameValuePair(this.createNameValuePair("Group", this.strGroupId));
        data.addNameValuePair(this.createNameValuePair("ContentOption", String.valueOf(this.contentOption)));
        data.addNameValuePair(this.createNameValuePair("KeepPreviousSetting", String.valueOf(this.keepPreviousSettingsMac)));
        data.addNameValuePair(this.createNameValuePair("IS_10_15_OR_UP_MAC", String.valueOf(this.isMac1015OrUp)));
        data.addNameValuePair(this.createNameValuePair("CompetitiveUninstall", String.valueOf(this.compUninstall)));
        if (this.filePath != null && this.fileName != null) {
            data.addNameValuePair(this.createNameValuePair("ExistingPackagePath", this.filePath));
            data.addNameValuePair(this.createNameValuePair("ExistingPackageName", this.fileName));
        }
        return data;
    }

    private ClientInstallationSettingObject findCorrectSettings(List<ClientInstallationSettingObject> listInstall) {
        ClientInstallationSettingObject retVal = null;
        if (listInstall == null || listInstall.size() < 1) {
            return null;
        }
        if (this.settingsName == null || this.settingsName.length() < 1) {
            return listInstall.get(0);
        }
        for (int i = 0; i < listInstall.size(); ++i) {
            ClientInstallationSettingObject obj = listInstall.get(i);
            if (!obj.getName().equalsIgnoreCase(this.settingsName)) continue;
            retVal = obj;
            break;
        }
        return retVal;
    }

    public void cancel() {
        if (this.isCommunicating) {
            this.status = 3;
        } else {
            this.finished();
        }
    }

    public void finished() {
        this.status = this.bsepCommunicationUpdater ? 5 : 2;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.listener != null) {
            this.listener.stateChanged(this.status);
        }
        System.out.println("RemotePushInstallClientThread>> REMOTE PUSH FINISHED");
    }

    public Vector<RemotePushComputerObject> getData() {
        return this.selComputers;
    }

    private boolean isRealResponse(String line) {
        return (line = line.trim()).length() != 0;
    }

    private NameValuePair createNameValuePair(String name, String value) {
        NameValuePair pair = new NameValuePair();
        pair.setName(name);
        pair.setOptValue(value);
        return pair;
    }

    public void setSBProduct(boolean isSBProduct) {
        this.isSBProduct = isSBProduct;
    }

    public boolean isSBProduct() {
        return this.isSBProduct;
    }

    public void setSelectedPackage(List<CurrentPackageObject> selectedPackage) {
        this.selectedPackage.clear();
        this.selectedPackage.addAll(selectedPackage);
    }

    public List<CurrentPackageObject> getSelectedPackage() {
        return this.selectedPackage;
    }

    private String getRequestHandlerName() {
        String platform = this.selComputers.elementAt(0).getPlatformType();
        if ("MAC".equalsIgnoreCase(platform)) {
            return "RemotePushInstallClientMac";
        }
        return "RemotePushInstallClientWin";
    }
}

