/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.util.Utility;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class RemotePushComputerTableModel
extends SortableTableModel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    public static final String HOST_NAME = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.name");
    public static final String COMPUTER_HOST_NAME = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.host_name");
    public static final String IP_ADDR = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.ip_addr");
    public static final String OS_DESC = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.osDesc");
    public static final String BIT_TYPE = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.bitType");
    public static final String DEP_STATUS = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.status");
    public static final String PROTECTION = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.protection");
    public static final String PROGRESS = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.progress");
    public static final String UPD_STATUS = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerTableModel.title.updateStatus");
    protected String[] colHeaders = new String[]{HOST_NAME, COMPUTER_HOST_NAME, IP_ADDR, OS_DESC, BIT_TYPE, DEP_STATUS, PROTECTION, PROGRESS, UPD_STATUS};

    public RemotePushComputerTableModel() {
        this(true);
    }

    public RemotePushComputerTableModel(boolean isEditable) {
        this(isEditable, false);
    }

    public RemotePushComputerTableModel(boolean isEditable, boolean isCaseSensitive) {
        super(isCaseSensitive);
        this.setEditMode(isEditable);
        this.setColumnNames(this.colHeaders);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        if (this.getEditMode()) {
            super.setValueAt(value, rowIndex, colIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowindex, int colindex) {
        return false;
    }

    public void deleteRow(int index) {
        this.removeRow(index);
        this.fireTableDataChanged();
    }

    public void deleteMarkedRows() {
        Vector<TableRow> data = this.getDataVector();
        int rowCount = data.size();
        boolean entryDeleted = false;
        int index = 0;
        while (index < rowCount) {
            entryDeleted = false;
            RemotePushComputerObject row = (RemotePushComputerObject)data.get(index);
            if (row != null && row.isSelected()) {
                data.remove(index);
                entryDeleted = true;
                this.fireTableDataChanged();
                rowCount = data.size();
            }
            if (entryDeleted) continue;
            ++index;
        }
    }

    public Vector<RemotePushComputerObject> getData() {
        return (Vector)Cast.cast(this.getDataVector());
    }

    public void setData(Vector<RemotePushComputerObject> data) {
        this.setDataVector((Vector)Cast.cast(data));
        this.fireTableDataChanged();
    }

    @Override
    public void sortTable(int column, boolean isAscending) {
        if (column == 2) {
            this.isAscending = isAscending;
            this.sortedColumn = column;
            Vector<RemotePushComputerObject> data = this.getData();
            Collections.sort(data, new IPComparator(isAscending));
            this.setData(data);
            this.fireTableDataChanged();
        } else {
            super.sortTable(column, isAscending);
        }
    }

    private static class IPComparator
    implements Comparator<RemotePushComputerObject>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean isAscending;

        public IPComparator(boolean isAscending) {
            this.isAscending = isAscending;
        }

        @Override
        public int compare(RemotePushComputerObject o1, RemotePushComputerObject o2) {
            String strIP1 = (String)o1.getValueAt(2);
            String strIP2 = (String)o2.getValueAt(2);
            int ret = Utility.compareIpStrings((String)strIP1, (String)strIP2);
            if (!this.isAscending) {
                ret = -ret;
            }
            return ret;
        }
    }
}

