/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.networkaudit.NetworkAuditComputerNode;
import com.sygate.scm.util.StringUtilities;

public class RemotePushComputerObject
implements TableRow {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    public static final int NOT_INSTALL = 0;
    public static final int SUCCESS_INSTALL = 1;
    public static final int FAIL_INSTALL = 2;
    public static final int STARTED_INSTALL = 3;
    public static final int UNSUPPORTED_INSTALL = 4;
    public static final int COMMUNICATION_UPDATE_STATUS = 3;
    public static final int COMMUNICATION_UPDATE_SUCCESS = 0;
    public static final int COL_HOST_IDX = 0;
    public static final int COL_COMPUTER_HOSTNAME_IDX = 1;
    public static final int COL_IP_ADDR_IDX = 2;
    public static final int COL_DESC_IDX = 3;
    public static final int COL_BIT_TYPE_IDX = 4;
    public static final int COL_STATUS_IDX = 5;
    public static final int COL_PROTECTION_IDX = 6;
    public static final int COL_PROGRESS_IDX = 7;
    public static final int COL_UPDATESTATUS_IDX = 8;
    public static final String STR_TYPE_32_BIT = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerObject.type32bit");
    public static final String STR_TYPE_64_BIT = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerObject.type64bit");
    public static final String STR_TYPE_MAC = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerObject.typeMac");
    public static final String STR_TYPE_DONT_KNOW = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerObject.typeDontKnow");
    public static final String OS_UNKNOWN = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerObject.OSUnknown");
    public static final String UNPROTECTED = MSGRES.getString("com.sygate.scm.console.ui.client.client", "RemotePushComputerObject.unprotectedText");
    public static final String[] ARR_BIT_TYPES = new String[]{STR_TYPE_32_BIT, STR_TYPE_64_BIT, STR_TYPE_DONT_KNOW};
    private String strBitType = "";
    private NetworkAuditComputerNode searchEntry = null;
    private String strUserName = "";
    private String strPassword = "";
    private String strDomain = "";
    private String osDesc = "";
    private String strProtection = "";
    private int progress = 0;
    private String osVersion = "";
    private String servicePack = "";
    private String platformType = "";
    private boolean isUnsupported = false;
    private String maxSEPVersion = "12.1";
    private boolean isSelected;
    private int installStatus;
    private int updateCommunicationStatus = -1;
    private String communicationStatusDesc = null;
    private String sepVersion = null;
    private boolean isSEPInstalled = false;

    public RemotePushComputerObject(String platformTypeFromNST, NetworkAuditComputerNode entry, String userName, String password, String domain, String osDesc, int status) {
        this.searchEntry = entry;
        this.strUserName = userName;
        this.strPassword = password;
        this.strDomain = domain;
        this.osDesc = osDesc;
        this.installStatus = status;
        this.platformType = RemotePushComputerObject.calculatePlatformType(platformTypeFromNST, this.osDesc);
        this.strBitType = RemotePushComputerObject.getBitTypeDisplayStr(this.platformType);
    }

    public RemotePushComputerObject(String platformTypeFromNST, NetworkAuditComputerNode entry, String userName, String password, String domain, String osDesc) {
        this(platformTypeFromNST, entry, userName, password, domain, osDesc, 0);
    }

    public boolean is32Bit() {
        return "WIN32".equalsIgnoreCase(this.platformType);
    }

    public boolean isLegacy() {
        return "UNKNOWN".equalsIgnoreCase(this.platformType);
    }

    public void setBitType(String bitType) {
        if (STR_TYPE_64_BIT.equalsIgnoreCase(bitType)) {
            this.strBitType = STR_TYPE_64_BIT;
            this.platformType = "WIN64";
        } else if (STR_TYPE_32_BIT.equalsIgnoreCase(bitType)) {
            this.strBitType = STR_TYPE_32_BIT;
            this.platformType = "WIN32";
        } else if (STR_TYPE_DONT_KNOW.equalsIgnoreCase(bitType)) {
            this.strBitType = STR_TYPE_DONT_KNOW;
            this.platformType = "UNKNOWN";
        } else if (STR_TYPE_MAC.equalsIgnoreCase(bitType)) {
            this.strBitType = STR_TYPE_MAC;
            this.platformType = "MAC";
        }
    }

    public String getBitType() {
        return this.strBitType;
    }

    public String getDomain() {
        return this.strDomain;
    }

    public String getPassword() {
        return this.strPassword;
    }

    public NetworkAuditComputerNode getComputerNode() {
        return this.searchEntry;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public int getInstallStatus() {
        return this.installStatus;
    }

    public void setInstallStatus(int installStatus) {
        this.installStatus = installStatus;
    }

    public int getUpdateCommunicationStatus() {
        return this.updateCommunicationStatus;
    }

    public void setUpdateCommunicationStatus(int updateCommunicationStatus) {
        this.updateCommunicationStatus = updateCommunicationStatus;
    }

    public String getCommunicationStatusDesc() {
        return this.communicationStatusDesc;
    }

    public void setCommunicationStatusDesc(String communicationStatusDesc) {
        this.communicationStatusDesc = communicationStatusDesc;
    }

    public String getDescription() {
        if ("Unknown".equals(this.osDesc)) {
            this.osDesc = OS_UNKNOWN;
        }
        return this.osDesc;
    }

    @Override
    public Object getValueAt(int colIndex) {
        switch (colIndex) {
            case 0: {
                return this.getComputerNode().getHostName() + " (" + this.getComputerNode().getIP() + ")";
            }
            case 1: {
                return this.getComputerNode().getHostName();
            }
            case 2: {
                return this.getComputerNode().getIP();
            }
            case 3: {
                return this.getDescription();
            }
            case 4: {
                return this.getBitType();
            }
            case 5: {
                return this.getInstallStatus();
            }
            case 6: {
                return this.getProtection();
            }
            case 7: {
                return this.getProgress();
            }
            case 8: {
                return this.getUpdateCommunicationStatus();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int colIndex) {
        switch (colIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return String.class;
            }
            case 5: 
            case 8: {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int colIndex) {
        switch (colIndex) {
            case 4: {
                this.setBitType((String)value);
                break;
            }
            case 6: {
                this.setProtection((String)value);
                break;
            }
            case 7: {
                this.setProgress((Integer)value);
                break;
            }
        }
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setUnsupported(boolean isUnsupported) {
        this.isUnsupported = isUnsupported;
    }

    public boolean isUnsupported() {
        return this.isUnsupported;
    }

    public void setMaxSEPVersion(String maxSEPVersion) {
        this.maxSEPVersion = maxSEPVersion;
    }

    public String getMaxSEPVersion() {
        return this.maxSEPVersion;
    }

    public void setProtection(String strProtection) {
        this.strProtection = strProtection;
    }

    public String getProtection() {
        return StringUtilities.isEmpty((String)this.strProtection) ? UNPROTECTED : this.strProtection;
    }

    public void setServicePack(String servicePack) {
        int index;
        this.servicePack = servicePack != null && servicePack.length() > 0 ? ((index = servicePack.indexOf(",")) > 0 ? servicePack.substring(0, index) : servicePack) : "";
    }

    public String getServicePack() {
        return this.servicePack;
    }

    public void setPlatformType(String platformTypeFromNst) {
        this.platformType = RemotePushComputerObject.calculatePlatformType(this.platformType, this.osDesc);
        this.strBitType = RemotePushComputerObject.getBitTypeDisplayStr(this.platformType);
    }

    public String getPlatformType() {
        return this.platformType;
    }

    private static String calculatePlatformType(String platformTypeFromNst, String osName) {
        String platformType = "UNKNOWN";
        if (platformTypeFromNst != null) {
            platformType = platformTypeFromNst;
        }
        if ("UNKNOWN".equals(platformType) && osName != null) {
            if ((osName = osName.toUpperCase()).indexOf("WIN32") >= 0) {
                platformType = "WIN32";
            } else if (osName.indexOf("WIN64") >= 0) {
                platformType = "WIN64";
            } else if (osName.indexOf("MAC") >= 0) {
                platformType = "MAC";
            }
        }
        return platformType;
    }

    private static String getBitTypeDisplayStr(String platformType) {
        if ("WIN32".equalsIgnoreCase(platformType)) {
            return STR_TYPE_32_BIT;
        }
        if ("WIN64".equalsIgnoreCase(platformType)) {
            return STR_TYPE_64_BIT;
        }
        if ("MAC".equalsIgnoreCase(platformType)) {
            return STR_TYPE_MAC;
        }
        return STR_TYPE_DONT_KNOW;
    }

    public String getSepVersion() {
        return this.sepVersion;
    }

    public void setSepVersion(String sepVersion) {
        this.sepVersion = sepVersion;
    }

    public boolean isSEPInstalled() {
        return this.isSEPInstalled;
    }

    public void setSEPInstalled(boolean isSEP) {
        this.isSEPInstalled = isSEP;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RemotePushComputerObject compareToObj = (RemotePushComputerObject)obj;
        boolean isEqual = false;
        isEqual = compareToObj.getComputerNode().getIP().isEmpty() ? compareToObj.getComputerNode().getHostName().equals(this.getComputerNode().getHostName()) : compareToObj.getComputerNode().getIP().equals(this.getComputerNode().getIP());
        return isEqual;
    }

    public int hashCode() {
        if (!this.getComputerNode().getIP().isEmpty()) {
            return this.getComputerNode().getIP().hashCode();
        }
        return this.getComputerNode().getHostName().hashCode();
    }
}

