/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client.networkaudit;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class NetworkAuditObject
implements TableRow {
    public static final int NOT_INSTALL = 0;
    public static final int SUCCESS_INSTALL = 1;
    public static final int FAIL_INSTALL = 2;
    public static final int CATEGORY_TYPE_UNKNOWN = 0;
    public static final int CATEGORY_TYPE_UNMANAGED = 1;
    public static final int CATEGORY_TYPE_MANAGED_LOGIN_SUCCESS = 2;
    public static final int CATEGORY_TYPE_MANAGED_LOGIN_FAIL = 3;
    private static final Icon iconNotInstall = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("user.png")));
    private static final Icon iconSuccessInstall = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("behav_allow.gif")));
    private static final Icon iconFailInstall = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("Block.gif")));
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private int categoryType;
    private String ip_hostName;
    private String osName;
    private String securitySoftware;
    private boolean isSEPInstalled = false;
    private String sepVersion = null;
    private String servicePack = "";
    private String platformType = "";
    private boolean isSelected;
    private int installStatus = 0;
    private boolean managed = false;

    public NetworkAuditObject(String line) {
        this.initialize(line);
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String getComputerName() {
        int index = this.ip_hostName.indexOf("(");
        if (index != -1) {
            return this.ip_hostName.substring(0, index);
        }
        return this.ip_hostName;
    }

    public String getIpHostName() {
        return this.ip_hostName;
    }

    public String getHostName() {
        String strHostName = this.ip_hostName;
        int startIndex = this.ip_hostName.indexOf("(");
        int endIndex = this.ip_hostName.indexOf(")");
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            strHostName = strHostName.substring(startIndex + 1, endIndex);
        }
        return strHostName;
    }

    public boolean isUnManagedComputer() {
        return !this.managed;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public String getDescription() {
        return this.osName;
    }

    public String getInstallStatusMessage() {
        switch (this.installStatus) {
            case 1: {
                return MSGRES.getString(CLIENT, "NetworkAuditObject.successInstall");
            }
            case 2: {
                return MSGRES.getString(CLIENT, "NetworkAuditObject.failedInstall");
            }
        }
        return MSGRES.getString(CLIENT, "NetworkAuditObject.notInstall");
    }

    public void setInstallStatus(int installStatus) {
        this.installStatus = installStatus;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return new JCheckBox(this.ip_hostName, this.isSelected){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString() {
                        return NetworkAuditObject.this.ip_hostName;
                    }
                };
            }
            case 1: {
                return this.osName;
            }
            case 2: {
                if (this.isUnManagedComputer()) {
                    return this.getSecuritySoftware();
                }
                return new JLabelData(this.getInstallStatusText(), this.getInstallStatusIcon());
            }
        }
        return new JLabelData(this.getInstallStatusText(), this.getInstallStatusIcon());
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return JCheckBox.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                if (this.isUnManagedComputer()) {
                    return String.class;
                }
                return JLabelData.class;
            }
        }
        return JLabelData.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                this.isSelected = ((JCheckBox)value).isSelected();
                break;
            }
        }
    }

    public String toString() {
        return this.isSelected + "  " + this.ip_hostName;
    }

    public boolean isLoginSuccess() {
        return this.categoryType == 7;
    }

    public boolean isSEPMManaged() {
        return this.managed;
    }

    public int getCategoryType() {
        return this.categoryType;
    }

    private void initialize(String line) {
        String[] result = line.split("\\t", -1);
        try {
            this.categoryType = Integer.parseInt(result[1]);
        }
        catch (NumberFormatException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.ip_hostName = result[2];
        this.osName = result[3];
        this.setSecuritySoftware(result[4]);
        if (result.length >= 6 && result[5] != null && result[5].length() > 0) {
            this.setServicePack(result[5]);
        }
        if (result.length >= 7 && result[6] != null && result[6].length() > 0) {
            this.setPlatformType(result[6]);
        }
        if (result.length >= 8 && result[7] != null && result[7].length() > 0) {
            this.managed = Boolean.valueOf(result[7]);
        }
        this.verifyIfSEPMac(this.getSecuritySoftware(), this.getPlatformType());
    }

    private Icon getInstallStatusIcon() {
        switch (this.installStatus) {
            case 1: {
                return iconSuccessInstall;
            }
            case 2: {
                return iconFailInstall;
            }
        }
        return iconNotInstall;
    }

    private String getInstallStatusText() {
        switch (this.installStatus) {
            case 1: {
                return MSGRES.getString(CLIENT, "NetworkAuditObject.successDownloadText");
            }
            case 2: {
                return MSGRES.getString(CLIENT, "NetworkAuditObject.failedInstallText");
            }
        }
        return MSGRES.getString(CLIENT, "NetworkAuditObject.notInstallText");
    }

    public void setSecuritySoftware(String securitySoftware) {
        this.securitySoftware = securitySoftware;
    }

    public String getSecuritySoftware() {
        return this.securitySoftware;
    }

    private void verifyIfSEPMac(String securitySw, String platformType) {
        try {
            if (platformType == null || platformType.length() == 0 || !"MAC".equals(platformType.toUpperCase().trim())) {
                return;
            }
            if (securitySw != null && securitySw.length() > 0 && securitySw.contains("Symantec Endpoint Protection")) {
                this.isSEPInstalled = true;
                this.sepVersion = securitySw.substring("Symantec Endpoint Protection".length()).trim();
                ConsoleLogger.log("isSEPInstalled: " + this.isSEPInstalled + " this.versionSEP: " + this.sepVersion);
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(this.getClass().getName() + ": verifyIfSEPMac. Exception while parsing version of SEP for Mac: " + securitySw);
            ConsoleLogger.log(e);
        }
    }

    public boolean isSEPInstalled() {
        return this.isSEPInstalled;
    }

    public String getSepVersion() {
        return this.sepVersion;
    }

    public void setServicePack(String servicePack) {
        this.servicePack = servicePack;
    }

    public String getServicePack() {
        return this.servicePack;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformType() {
        return this.platformType;
    }
}

